/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.survival.life_tables;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.survival.life_tables.LifeTablesDlg;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LifeTablesDefineEvent
extends BaseSubDialog
implements ItemListener,
FocusListener,
DocumentListener {
    private static final double MIN_VALUE = -999.0;
    private static final double MAX_VALUE = 9999.0;
    private static final int PRECISION_VALUE = 3;
    private JRadioButton mSingleValueRadio;
    private FloatTextField mSingleValueTxt;
    private JRadioButton mRangeValueRadio;
    private FloatTextField mRangeValueTxt;
    private FloatTextField mThroughTxt;
    private SpssButtonGroup mEventButtonGrp;
    private GridBagConstraints mGridConstraints;

    public LifeTablesDefineEvent(LifeTablesDlg lifeTablesDlg) {
        super(lifeTablesDlg, lifeTablesDlg.getResString("IDS_LIFE_TABLES_DEFINE_EVENT_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_surv_def_evnt";
    }

    @Override
    public boolean continuePressed() {
        if (this.mRangeValueRadio.isSelected() && Float.parseFloat(this.mRangeValueTxt.getText().toString()) >= Float.parseFloat(this.mThroughTxt.getText())) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("IDS_LIFE_TABLES_DEFINE_EVENT_ERRMSG_SMALLER_VALUE_IN_ASSOCIATED_TEXT_BOX"), VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mSingleValueRadio && this.mSingleValueRadio.isSelected()) {
            this.mSingleValueTxt.setOpaque(true);
            this.mSingleValueTxt.setEnabled(true);
            this.mRangeValueTxt.setEnabled(false);
            this.mRangeValueTxt.setOpaque(false);
            this.mThroughTxt.setEnabled(false);
            this.mThroughTxt.setOpaque(false);
            if (this.mSingleValueTxt.getText().length() > 0) {
                this.enableContinue(true);
            } else {
                this.enableContinue(false);
            }
        } else if (object == this.mRangeValueRadio && this.mRangeValueRadio.isSelected()) {
            this.mSingleValueTxt.setEnabled(false);
            this.mSingleValueTxt.setOpaque(false);
            this.mRangeValueTxt.setEnabled(true);
            this.mRangeValueTxt.setOpaque(true);
            this.mThroughTxt.setEnabled(true);
            this.mThroughTxt.setOpaque(true);
            if (this.mRangeValueTxt.getText().length() > 0 && this.mThroughTxt.getText().length() > 0) {
                this.enableContinue(true);
            } else {
                this.enableContinue(false);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mSingleValueTxt)) {
            this.mSingleValueTxt.selectAll();
        } else if (focusEvent.getSource().equals(this.mRangeValueTxt)) {
            this.mRangeValueTxt.selectAll();
        } else if (focusEvent.getSource().equals(this.mThroughTxt)) {
            this.mThroughTxt.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mSingleValueRadio.isSelected() && this.mSingleValueTxt.getText().length() > 0) {
            this.enableContinue(true);
        } else if (this.mRangeValueRadio.isSelected() && this.mRangeValueTxt.getText().length() > 0 && this.mThroughTxt.getText().length() > 0) {
            this.enableContinue(true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mSingleValueRadio.isSelected() && this.mSingleValueTxt.getText().length() == 0) {
            this.enableContinue(false);
        } else if (this.mRangeValueRadio.isSelected() && (this.mRangeValueTxt.getText().length() == 0 || this.mThroughTxt.getText().length() == 0)) {
            this.enableContinue(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        int n = 21;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n3 = DialogUtil.getComponentGroupGap();
        JLabel jLabel = new JLabel(this.getResString("IDS_LIFE_TABLES_DEFINE_EVENT_INDICATING_EVENT_OCCURRED"));
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_LIFE_TABLES_DEFINE_EVENT_THROUGH");
        jLabel2.setLabelFor((Component)this.mThroughTxt);
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, this.mGridConstraints, 0, 0, 4, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.mSingleValueRadio, this.mGridConstraints, 0, 1, 1, 1, n, insets);
        n = 23;
        this.mGridConstraints.weightx = 1.0;
        Insets insets2 = new Insets(insets.left, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mSingleValueTxt, this.mGridConstraints, 1, 1, 1, 1, n, insets2);
        n = 23;
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.weighty = 1.0;
        insets2.set(insets.left, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mRangeValueRadio, this.mGridConstraints, 0, 2, 1, 1, n, insets2);
        this.mGridConstraints.weightx = 1.0;
        insets2.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mRangeValueTxt, this.mGridConstraints, 1, 2, 1, 1, n, insets2);
        this.mGridConstraints.weightx = 0.0;
        insets2.set(n2 + insets.bottom * 2, n3, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, this.mGridConstraints, 2, 2, 1, 1, n, insets2);
        this.mGridConstraints.weightx = 1.0;
        insets2.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mThroughTxt, this.mGridConstraints, 3, 2, 1, 1, n, insets2);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setFocusTraversalPolicy(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private void initVars() {
        this.mSingleValueTxt = new FloatTextField(-999.0, 9999.0, 3, false);
        this.mSingleValueTxt.setColumns(6);
        ControlAction controlAction = new ToggleButtonAction(this.mParentDlg, "IDS_LIFE_TABLES_DEFINE_EVENT_SINGLE_VALUE");
        this.mSingleValueRadio = new JRadioButton(controlAction);
        controlAction = new TextFieldAction(this, "IDS_LIFE_TABLES_DEFINE_EVENT_SINGLE_VALUE");
        this.mSingleValueTxt.setAction((Action)controlAction);
        this.mSingleValueTxt.getDocument().addDocumentListener(this);
        this.mSingleValueTxt.addFocusListener((FocusListener)this);
        this.mRangeValueTxt = new FloatTextField(-999.0, 9999.0, 3, false);
        this.mRangeValueTxt.setColumns(6);
        controlAction = new ToggleButtonAction(this.mParentDlg, "IDS_LIFE_TABLES_DEFINE_EVENT_RANGE_VALUE");
        this.mRangeValueRadio = new JRadioButton(controlAction);
        controlAction = new TextFieldAction(this, "IDS_LIFE_TABLES_DEFINE_EVENT_RANGE_VALUE");
        this.mRangeValueTxt.setAction((Action)controlAction);
        this.mRangeValueTxt.getDocument().addDocumentListener(this);
        this.mRangeValueTxt.addFocusListener((FocusListener)this);
        this.mThroughTxt = new FloatTextField(-999.0, 9999.0, 3, false);
        this.mThroughTxt.setColumns(6);
        controlAction = new TextFieldAction(this, "IDS_LIFE_TABLES_DEFINE_EVENT_THROUGH");
        this.mThroughTxt.setAction((Action)controlAction);
        this.mThroughTxt.getDocument().addDocumentListener(this);
        this.mThroughTxt.addFocusListener((FocusListener)this);
        this.mEventButtonGrp = new SpssButtonGroup();
        this.mEventButtonGrp.add(this.mSingleValueRadio);
        this.mEventButtonGrp.add(this.mRangeValueRadio);
        this.mGridConstraints = new GridBagConstraints();
        this.mSingleValueTxt.setEnabled(true);
        this.mSingleValueTxt.setOpaque(true);
        this.mRangeValueTxt.setEnabled(false);
        this.mRangeValueTxt.setOpaque(false);
        this.mThroughTxt.setEnabled(false);
        this.mThroughTxt.setOpaque(false);
        this.mSingleValueRadio.addItemListener(this);
        this.mRangeValueRadio.addItemListener(this);
        this.mSingleValueRadio.setSelected(true);
    }

    private Vector<Object> setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mEventButtonGrp);
        vector.add(this.mSingleValueTxt);
        vector.add(this.mRangeValueTxt);
        vector.add(this.mThroughTxt);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            if (!(this.mCmdButtonPanel.getComponent(i) instanceof JButton)) continue;
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }
}

