/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.scale.reliability_analysis;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ReliabilityStatistics
extends BaseSubDialog
implements ItemListener,
DocumentListener,
PropertyChangeListener {
    public static final String MEAN_KEY = "IDS_MEANS";
    public static final String VARIANCE_KEY = "IDS_VARIANCE";
    public static final String COV_KEY = "IDS_COVARIANCE";
    public static final String CORR_KEY = "IDS_CORRELATIONS";
    public static final String TOTAL_KEY = "IDS_SCALE_DEL";
    public static final String DESCRIPTIVE_KEY = "DESCRIPTIVE";
    public static final String SCALE_KEY = "IDS_SCALE";
    public static final String FRIEDMAN_KEY = "IDS_FRIEDMAN";
    public static final String COCHRAN_KEY = "IDS_COCHRAN";
    public static final String ANOVA_KEY = "IDS_FTEST";
    public static final String ITEM_KEY = "IDS_ITEM";
    public static final String SCALE_DEL_KEY = "IDS_SCALE_DEL";
    public static final String HOTELLING_KEY = "IDS_HOTELLING";
    public static final String TUKEY_KEY = "IDS_TUKEY";
    public static final String COV1_KEY = "IDS_SCOVARIANCE";
    public static final String CORR1_KEY = "IDS_SCORRELATIONS";
    public static final String INTERCLASS_KEY = "IDS_INTRA_CLASS";
    public static final String CONFIDENCE_KEY = "IDS_CONFIDENCE_KEY123";
    public static final String TESTVALUE_KEY = "IDS_TEST_KEY123";
    public static final String MODEL_COMBO_KEY = "MODEL_COMBO_KEY";
    public static final String TYPE_COMBO_KEY = "TYPE_COMBO_KEY";
    public static final String FLEISS_KAPPA_KEY = "IDS_FLEISS_KAPPA";
    public static final String DISP_CATEGORIES = "IDS_AGREEMENT";
    public static final String IGNORE_CASE = "IDS_IGNORE_CASE";
    public static final String LABEL_UPPERCASE = "IDS_DISP_UPPERCASE";
    public static final String ASYMPT_SIG = "ASYMTP_SIG";
    public static final String EXCLUDE_MISSING = "IDS_EXCLUDE_MISSING";
    public static final String USER_MISSING_VALID = "IDS_USER_MISSING_VALID";
    private static final String TEST_DEFAULT_VALUE = "0";
    private static final String CONFIDENCE_DEFAULT_VALUE = "95";
    private JCheckBox mIntraClassCheckBox;
    private JCheckBox mTukeyCheckBox;
    private JLabel mModelLabel;
    private JLabel mTypeLabel;
    private JLabel mConfidenceLabel;
    private JLabel mTestValueLabel;
    private JLabel mPercentageLabel;
    private JComboBox mModelComboBox;
    private JComboBox mTypeComboBox;
    private FloatTextField mConfidenceField;
    private FloatTextField mAsySigField;
    private FloatTextField mTestValueField;
    private JPanel mDescriptiveForPanel;
    private JPanel mInterItemPanel;
    private JPanel mSummariesPanel;
    private JPanel mAnovaTablePanel;
    private JPanel mInterAgreePanel;
    private JPanel mMissingPanel;
    private JPanel mHotellingPanel;
    private JPanel mModelComboPanel;
    private SpssButtonGroup mradioGroup;
    private SpssButtonGroup mMissingradioGroup;
    private SpssButtonGroup mHotellingradioGroup;
    private SpssButtonGroup mInterraterCheckGroup;
    private JCheckBox mAgreeCheckBox;
    private JCheckBox mIgnoreCaseCheckBox;
    private JCheckBox mUppercaseCheckBox;
    private JLabel mAsySigLabel;

    public ReliabilityStatistics(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.setLocationRelativeTo(this.getParent());
    }

    public static Map<Integer, String> getModelMap() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, "MIXED");
        hashMap.put(1, "RANDOM");
        hashMap.put(2, "ONEWAY");
        return hashMap;
    }

    public static Map<Integer, String> getTypeMap() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, "CONSISTENCY");
        hashMap.put(1, "ABSOLUTE");
        return hashMap;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_reli_sta";
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        ISpssVariable[] iSpssVariableArray = this.mParentDlg.getDialogDataModel().getVarArray("IDS_RATINGS_LIST_KEY");
        int n = iSpssVariableArray.length;
        if (n < 2) {
            this.mAgreeCheckBox.setSelected(false);
            this.mAgreeCheckBox.setEnabled(false);
            this.mIgnoreCaseCheckBox.setSelected(false);
            this.mIgnoreCaseCheckBox.setEnabled(false);
            this.mUppercaseCheckBox.setEnabled(false);
            this.mUppercaseCheckBox.setSelected(true);
            this.mAsySigLabel.setEnabled(false);
            this.mAsySigField.setEnabled(false);
            this.mAsySigField.setText(CONFIDENCE_DEFAULT_VALUE);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mIntraClassCheckBox)) {
            this.componentEnable(((JCheckBox)itemEvent.getSource()).isSelected());
        }
        if (itemEvent.getSource().equals(this.mIgnoreCaseCheckBox)) {
            this.mUppercaseCheckBox.setEnabled(((JCheckBox)itemEvent.getSource()).isSelected());
        }
        if (itemEvent.getSource().equals(this.mModelComboBox)) {
            String string = ((JComboBox)itemEvent.getSource()).getSelectedItem().toString();
            if (string.equals(this.getResString("IDS_ONE_WAY_RANDOM"))) {
                this.mTypeComboBox.setEnabled(false);
            } else {
                this.mTypeComboBox.setEnabled(true);
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        this.setUpUI(jPanel);
        this.componentEnable(false);
        this.setTabTraversal();
        this.pack();
    }

    private void setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        int n2 = this.mDescriptiveForPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            vector.add(this.mDescriptiveForPanel.getComponent(n));
        }
        n2 = this.mSummariesPanel.getComponentCount();
        for (n = 0; n < this.mSummariesPanel.getComponentCount(); ++n) {
            vector.add(this.mSummariesPanel.getComponent(n));
        }
        n2 = this.mInterItemPanel.getComponentCount();
        for (n = 0; n < this.mInterItemPanel.getComponentCount(); ++n) {
            vector.add(this.mInterItemPanel.getComponent(n));
        }
        vector.add(this.mradioGroup);
        for (n = 0; n < this.mInterAgreePanel.getComponentCount(); ++n) {
            vector.add(this.mInterAgreePanel.getComponent(n));
        }
        vector.add(this.mAsySigField);
        vector.add(this.mMissingradioGroup);
        vector.add(this.mHotellingPanel.getComponent(0));
        vector.add(this.mTukeyCheckBox);
        vector.add(this.mHotellingPanel.getComponent(1));
        vector.add(this.mModelComboBox);
        vector.add(this.mTypeComboBox);
        vector.add(this.mConfidenceField);
        vector.add(this.mTestValueField);
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private JPanel setUpModelComboPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 10;
        Insets insets = new Insets(0, DialogUtil.getComponentGroupGap() + 15, DialogUtil.getComponentGroupGap(), 0);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mModelLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets = new Insets(0, 73, DialogUtil.getComponentGroupGap(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mModelComboBox, gridBagConstraints, 0, 0, 3, 1, n, insets);
        n = 10;
        insets = new Insets(0, 20, DialogUtil.getComponentGroupGap(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mTypeLabel, gridBagConstraints, 3, 0, 1, 1, n, insets);
        insets = new Insets(0, 61, DialogUtil.getComponentGroupGap(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mTypeComboBox, gridBagConstraints, 3, 0, 3, 1, n, insets);
        insets = new Insets(0, DialogUtil.getComponentGroupGap() + 15, 3, 0);
        n = 10;
        DialogUtil.addUsingGBL(jPanel, this.setupConfiIntervalPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        insets = new Insets(0, 18, 3, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupTestValuePanel(), gridBagConstraints, 3, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setUpHotellingCheckBoxPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JCheckBox jCheckBox = new JCheckBox(new ToggleButtonAction(this, HOTELLING_KEY));
        this.mHotellingradioGroup.add(jCheckBox);
        this.mHotellingradioGroup.add(this.mTukeyCheckBox);
        this.mHotellingradioGroup.add(this.mIntraClassCheckBox);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jCheckBox, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mIntraClassCheckBox, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setUpAnovaTablePanelRadioButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_ANOVA_PANEL")));
        JRadioButton jRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_NONE"));
        JRadioButton jRadioButton2 = new JRadioButton(new ToggleButtonAction(this, ANOVA_KEY));
        JRadioButton jRadioButton3 = new JRadioButton(new ToggleButtonAction(this, FRIEDMAN_KEY));
        JRadioButton jRadioButton4 = new JRadioButton(new ToggleButtonAction(this, COCHRAN_KEY));
        this.mradioGroup.add(jRadioButton);
        this.mradioGroup.add(jRadioButton2);
        this.mradioGroup.add(jRadioButton3);
        this.mradioGroup.add(jRadioButton4);
        jRadioButton.setSelected(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jRadioButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jRadioButton2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jRadioButton3, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jRadioButton4, gridBagConstraints, 0, 3, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setUpMissingPanelRadioButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_MISSING")));
        JRadioButton jRadioButton = new JRadioButton(new ToggleButtonAction(this, EXCLUDE_MISSING));
        JRadioButton jRadioButton2 = new JRadioButton(new ToggleButtonAction(this, USER_MISSING_VALID));
        this.mMissingradioGroup.add(jRadioButton);
        this.mMissingradioGroup.add(jRadioButton2);
        jRadioButton.setSelected(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jRadioButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jRadioButton2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setUpSummariesCheckBoxPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_SUMM_PANEL")));
        JCheckBox jCheckBox = new JCheckBox(new ToggleButtonAction(this, MEAN_KEY));
        JCheckBox jCheckBox2 = new JCheckBox(new ToggleButtonAction(this, VARIANCE_KEY));
        JCheckBox jCheckBox3 = new JCheckBox(new ToggleButtonAction(this, COV1_KEY));
        JCheckBox jCheckBox4 = new JCheckBox(new ToggleButtonAction(this, CORR1_KEY));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jCheckBox, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jCheckBox2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jCheckBox3, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jCheckBox4, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setUpInterItemPanelCheckBoxPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_INTER_PANEL")));
        JCheckBox jCheckBox = new JCheckBox(new ToggleButtonAction(this, CORR_KEY));
        JCheckBox jCheckBox2 = new JCheckBox(new ToggleButtonAction(this, COV_KEY));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jCheckBox, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jCheckBox2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setUpDesForCheckBoxPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_DESC_PANEL")));
        JCheckBox jCheckBox = new JCheckBox(new ToggleButtonAction(this, ITEM_KEY));
        JCheckBox jCheckBox2 = new JCheckBox(new ToggleButtonAction(this, SCALE_KEY));
        JCheckBox jCheckBox3 = new JCheckBox(new ToggleButtonAction(this, "IDS_SCALE_DEL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jCheckBox, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jCheckBox2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jCheckBox3, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setUpInterreaterAgreementPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_INTERRATER_AGREEMENT")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, insets.left * 13, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mAgreeCheckBox, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mIgnoreCaseCheckBox, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mInterraterCheckGroup.add(this.mAgreeCheckBox);
        this.mInterraterCheckGroup.add(this.mUppercaseCheckBox);
        DialogUtil.addUsingGBL(jPanel, this.mUppercaseCheckBox, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.setupAsySignificancePanel(), gridBagConstraints, 0, 3, 1, 1, n, insets);
        return jPanel;
    }

    private void setUpUI(JPanel jPanel) {
        this.mDescriptiveForPanel = this.setUpDesForCheckBoxPanel();
        this.mSummariesPanel = this.setUpSummariesCheckBoxPanel();
        this.mInterItemPanel = this.setUpInterItemPanelCheckBoxPanel();
        this.mAnovaTablePanel = this.setUpAnovaTablePanelRadioButtonPanel();
        this.mInterAgreePanel = this.setUpInterreaterAgreementPanel();
        this.mMissingPanel = this.setUpMissingPanelRadioButtonPanel();
        this.mHotellingPanel = this.setUpHotellingCheckBoxPanel();
        this.mModelComboPanel = this.setUpModelComboPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        Insets insets = new Insets(0, 0, DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, this.mDescriptiveForPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets = new Insets(0, 0, DialogUtil.getComponentGroupGap(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mInterItemPanel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets = new Insets(0, 0, DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, this.mSummariesPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets = new Insets(0, 0, DialogUtil.getComponentGroupGap(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mAnovaTablePanel, gridBagConstraints, 1, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mInterAgreePanel, gridBagConstraints, 0, 2, 2, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.mMissingPanel, gridBagConstraints, 0, 3, 2, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets = new Insets(0, 0, DialogUtil.getComponentGroupGap(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mHotellingPanel, gridBagConstraints, 0, 4, 1, 1, n, insets);
        insets = new Insets(0, 0, DialogUtil.getComponentGroupGap(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mTukeyCheckBox, gridBagConstraints, 1, 4, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mModelComboPanel, gridBagConstraints, 0, 5, 2, 1, n, null);
    }

    private JPanel setupConfiIntervalPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 0;
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.top = 2;
        insets.bottom = 0;
        DialogUtil.addUsingGBL(jPanel, this.mConfidenceLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.top = 1;
        insets.bottom = 1;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mConfidenceField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mPercentageLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupAsySignificancePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.mAsySigLabel.setLabelFor((Component)this.mAsySigField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 0;
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.top = 2;
        insets.bottom = 0;
        DialogUtil.addUsingGBL(jPanel, this.mAsySigLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.top = 1;
        insets.bottom = 1;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mAsySigField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupTestValuePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        gridBagConstraints.fill = 0;
        insets.top = 2;
        insets.bottom = 0;
        DialogUtil.addUsingGBL(jPanel, this.mTestValueLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.top = 1;
        insets.bottom = 1;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTestValueField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void initVars() {
        String[] stringArray = this.getResStringArray("IDS_MODEL_COMBO_ITEMS");
        String[] stringArray2 = this.getResStringArray("IDS_TYPE_COMBO_ITEMS");
        this.mModelComboBox = new JComboBox<String>(stringArray);
        this.mTypeComboBox = new JComboBox<String>(stringArray2);
        this.mIntraClassCheckBox = new JCheckBox(new ToggleButtonAction(this, INTERCLASS_KEY));
        this.mTukeyCheckBox = new JCheckBox(new ToggleButtonAction(this, TUKEY_KEY));
        this.mIntraClassCheckBox.addItemListener(this);
        this.mModelComboBox.addItemListener(this);
        this.mTypeComboBox.addItemListener(this);
        this.mModelLabel = DialogUtil.createLabel(this, "IDS_MODEL");
        this.mTypeLabel = DialogUtil.createLabel(this, "IDS_TYPE");
        this.mConfidenceLabel = DialogUtil.createLabel(this, "IDS_CONFIDENCE");
        this.mTestValueLabel = DialogUtil.createLabel(this, "IDS_TEST_VALUE");
        this.mPercentageLabel = new JLabel(this.getResString("IDS_PERCENTAGE"));
        this.mModelLabel.setLabelFor(this.mModelComboBox);
        this.mTypeLabel.setLabelFor(this.mTypeComboBox);
        this.mradioGroup = new SpssButtonGroup();
        this.mMissingradioGroup = new SpssButtonGroup();
        this.mHotellingradioGroup = new SpssButtonGroup();
        this.mConfidenceField = new FloatTextField(50.0, 99.9999, 5, true);
        this.mAsySigField = new FloatTextField(0.0, 100.0, 5, true);
        this.mTestValueField = new FloatTextField(0.0, 0.9999999, 7, true);
        this.mConfidenceLabel.setLabelFor((Component)this.mConfidenceField);
        this.mTestValueLabel.setLabelFor((Component)this.mTestValueField);
        this.mInterraterCheckGroup = new SpssButtonGroup();
        this.mAgreeCheckBox = new JCheckBox(new ToggleButtonAction(this, DISP_CATEGORIES));
        this.mAgreeCheckBox.addItemListener(this);
        this.mIgnoreCaseCheckBox = new JCheckBox(new ToggleButtonAction(this, IGNORE_CASE));
        this.mIgnoreCaseCheckBox.addItemListener(this);
        this.mUppercaseCheckBox = new JCheckBox(new ToggleButtonAction(this, LABEL_UPPERCASE));
        this.mUppercaseCheckBox.addItemListener(this);
        this.mAsySigLabel = new JLabel(this.getResString("IDS_ASY_SIGNIFICANCE"));
        this.mConfidenceField.setAction((Action)new TextFieldAction(this.mParentDlg, CONFIDENCE_KEY));
        this.mTestValueField.setAction((Action)new TextFieldAction(this.mParentDlg, TESTVALUE_KEY));
        this.mAsySigField.setAction((Action)new TextFieldAction(this.mParentDlg, ASYMPT_SIG));
        this.mModelComboBox.setAction(new ComboboxAction(this.mParentDlg, MODEL_COMBO_KEY));
        this.mTypeComboBox.setAction(new ComboboxAction(this.mParentDlg, TYPE_COMBO_KEY));
        this.mConfidenceField.getDocument().addDocumentListener(this);
        this.mTestValueField.getDocument().addDocumentListener(this);
        this.mAsySigField.getDocument().addDocumentListener(this);
        this.mTestValueField.addPropertyChangeListener((PropertyChangeListener)this);
        this.mConfidenceField.addPropertyChangeListener((PropertyChangeListener)this);
        this.mAsySigField.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("enabled")) {
            this.updateContinueButton();
        }
    }

    private void setDefaults() {
        this.mTestValueField.setText(TEST_DEFAULT_VALUE);
        this.mConfidenceField.setText(CONFIDENCE_DEFAULT_VALUE);
        this.mAsySigLabel.setEnabled(false);
        this.mAsySigField.setEnabled(false);
        this.mAsySigField.setText(CONFIDENCE_DEFAULT_VALUE);
        this.mAgreeCheckBox.setEnabled(false);
        this.mIgnoreCaseCheckBox.setSelected(false);
        this.mIgnoreCaseCheckBox.setEnabled(false);
        if (this.mParentDlg.getDialogDataModel().getVarArray("IDS_RATINGS_LIST_KEY").length > 1) {
            this.mAgreeCheckBox.setEnabled(true);
            this.mIgnoreCaseCheckBox.setEnabled(true);
            this.mAsySigLabel.setEnabled(true);
            this.mAsySigField.setEnabled(true);
        }
        this.mUppercaseCheckBox.setEnabled(this.mIgnoreCaseCheckBox.isSelected());
        this.mUppercaseCheckBox.setSelected(true);
    }

    private void componentEnable(Boolean bl) {
        this.mModelLabel.setEnabled(bl);
        this.mTypeLabel.setEnabled(bl);
        this.mConfidenceLabel.setEnabled(bl);
        this.mTestValueLabel.setEnabled(bl);
        this.mPercentageLabel.setEnabled(bl);
        this.mModelComboBox.setEnabled(bl);
        this.mTypeComboBox.setEnabled(bl);
        this.mConfidenceField.setEnabled(bl.booleanValue());
        this.mConfidenceField.setOpaque(bl.booleanValue());
        this.mTestValueField.setEnabled(bl.booleanValue());
        this.mTestValueField.setOpaque(bl.booleanValue());
    }

    private void updateContinueButton() {
        boolean bl = true;
        if (this.isEnabledAndEmpty((JTextField)this.mTestValueField)) {
            bl = false;
        }
        if (this.isEnabledAndEmpty((JTextField)this.mConfidenceField)) {
            bl = false;
        }
        if (this.isEnabledAndEmpty((JTextField)this.mAsySigField)) {
            bl = false;
        }
        this.enableContinue(bl);
    }

    private boolean isEnabledAndEmpty(JTextField jTextField) {
        return jTextField.isEnabled() && jTextField.getText().length() == 0;
    }
}

