/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.scale.reliability_analysis;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.base.analyze.scale.reliability_analysis.ReliabilityStatistics;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ReliabilityAnalysisDlg
extends BaseProcedureDialog
implements ListDataListener {
    private static final String TARGET_LIST_KEY = "IDS_TARGET_LIST_KEY";
    private static final String RATINGS_LIST_KEY = "IDS_RATINGS_LIST_KEY";
    private static final String MODEL_KEY = "IDS_MODEL_KEY12";
    private static final int TARGET_MAX_LIMIT_VALUE = 10000;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList;
    private TargetVariableList mRatingsVarList;
    private JScrollPane mRatingsScrollPane;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mTargetScrollPane;
    private ArrowButton mArrowButton;
    private ArrowButton mArrowButton2;
    private JButton mStasticsButton;
    private JComboBox mModelCombo;
    private StringTextField mScaleField;

    public ReliabilityAnalysisDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle.getDefaultResourceBundleName(), AnalyzeResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_RELIABILITY_ANALYSIS"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetVarList.removeAll();
        this.mRatingsVarList.removeAll();
        this.setDefaults();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_reli";
    }

    @Override
    public String generateSyntax() {
        Object object;
        String string;
        String string2;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        if (this.mTargetVarList.getModel().getSize() > 1) {
            stringBuffer.append(SyntaxUtil.getMainCommand("RELIABILITY"));
            stringBuffer.append("\n");
            string2 = this.mTargetVarList.getVariablesStringList();
            string = SyntaxUtil.getSubCommand("/VARIABLES=") + string2.trim() + "\n";
            stringBuffer.append(string);
            if (this.mScaleField.getText().trim().length() == 0) {
                stringBuffer.append(SyntaxUtil.getSubCommand("/SCALE("));
                stringBuffer.append(CharacterUtil.smartQuote((String)"ALL VARIABLES"));
                stringBuffer.append(")");
            } else {
                string = SyntaxUtil.getSubCommand("/SCALE(").toString() + CharacterUtil.smartQuote((String)this.mScaleField.getText().trim()) + ")";
                stringBuffer.append(string);
            }
            int n = dialogDataModel.getInteger(MODEL_KEY);
            object = ReliabilityAnalysisDlg.getModelMap();
            String string3 = object.get(n).toString();
            if (n >= 0) {
                stringBuffer.append(" ALL\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/MODEL=" + string3));
            } else {
                stringBuffer.append(" ALL\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/MODEL=ALPHA"));
            }
            Boolean bl = dialogDataModel.getBoolean("IDS_ITEM");
            Boolean bl2 = dialogDataModel.getBoolean("IDS_SCALE");
            Boolean bl3 = dialogDataModel.getBoolean("IDS_FTEST");
            Boolean bl4 = dialogDataModel.getBoolean("IDS_COCHRAN");
            Boolean bl5 = dialogDataModel.getBoolean("IDS_FRIEDMAN");
            Boolean bl6 = dialogDataModel.getBoolean("IDS_CORRELATIONS");
            Boolean bl7 = dialogDataModel.getBoolean("IDS_COVARIANCE");
            Boolean bl8 = dialogDataModel.getBoolean("IDS_HOTELLING");
            Boolean bl9 = dialogDataModel.getBoolean("IDS_SCALE_DEL");
            Boolean bl10 = dialogDataModel.getBoolean("IDS_MEANS");
            Boolean bl11 = dialogDataModel.getBoolean("IDS_VARIANCE");
            Boolean bl12 = dialogDataModel.getBoolean("IDS_SCOVARIANCE");
            Boolean bl13 = dialogDataModel.getBoolean("IDS_SCORRELATIONS");
            Boolean bl14 = dialogDataModel.getBoolean("IDS_TUKEY");
            Boolean bl15 = dialogDataModel.getBoolean("IDS_INTRA_CLASS");
            if (bl != null && bl != false || bl8 != null && bl8 != false || bl6 != null && bl6 != false || bl7 != null && bl7 != false || bl4 != null && bl4 != false || bl3 != null && bl3 != false || bl5 != null && bl5 != false || bl14 != null && bl14 != false || bl2 != null && bl2.booleanValue()) {
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/STATISTICS="));
            }
            if (bl != null && bl.booleanValue()) {
                stringBuffer.append("DESCRIPTIVE ");
            }
            if (bl2 != null && bl2.booleanValue()) {
                stringBuffer.append("SCALE ");
            }
            if (bl8 != null && bl8.booleanValue()) {
                stringBuffer.append("HOTELLING ");
            }
            if (bl6 != null && bl6.booleanValue()) {
                stringBuffer.append("CORR ");
            }
            if (bl7 != null && bl7.booleanValue()) {
                stringBuffer.append("COV ");
            }
            if (bl3 != null && bl3.booleanValue()) {
                stringBuffer.append("ANOVA ");
            }
            if (bl4 != null && bl4.booleanValue()) {
                stringBuffer.append("ANOVA COCHRAN ");
            }
            if (bl5 != null && bl5.booleanValue()) {
                stringBuffer.append("ANOVA FRIEDMAN ");
            }
            if (bl14 != null && bl14.booleanValue()) {
                stringBuffer.append("TUKEY");
            }
            if (stringBuffer.toString().endsWith(" ")) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            if (bl9 != null && bl9 != false || bl10 != null && bl10 != false || bl11 != null && bl11 != false || bl12 != null && bl12 != false || bl13 != null && bl13.booleanValue()) {
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/SUMMARY="));
            }
            if (bl9 != null && bl9.booleanValue()) {
                stringBuffer.append("TOTAL ");
            }
            if (bl10 != null && bl10.booleanValue()) {
                stringBuffer.append("MEANS ");
            }
            if (bl11 != null && bl11.booleanValue()) {
                stringBuffer.append("VARIANCE ");
            }
            if (bl12 != null && bl12.booleanValue()) {
                stringBuffer.append("COV ");
            }
            if (bl13 != null && bl13.booleanValue()) {
                stringBuffer.append("CORR");
            }
            if (stringBuffer.toString().endsWith(" ")) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            if (bl15 != null && bl15.booleanValue()) {
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/ICC="));
                n = dialogDataModel.getInteger("MODEL_COMBO_KEY");
                Map<Integer, String> map = ReliabilityStatistics.getModelMap();
                String string4 = map.get(n).toString();
                stringBuffer.append("MODEL(" + string4 + ")");
                if (n == 0 || n == 1) {
                    int n2 = dialogDataModel.getInteger("TYPE_COMBO_KEY");
                    map = ReliabilityStatistics.getTypeMap();
                    string4 = map.get(n2).toString();
                    string = " TYPE(" + string4 + ")";
                    stringBuffer.append(string);
                }
                string = " CIN=" + dialogDataModel.getString("IDS_CONFIDENCE_KEY123");
                stringBuffer.append(string);
                string = " TESTVAL=" + dialogDataModel.getString("IDS_TEST_KEY123");
                stringBuffer.append(string);
            }
            if (stringBuffer.toString().endsWith(" ")) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if (this.mRatingsVarList.getModel().getSize() > 1) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getMainCommand("FLEISS MULTIRATER KAPPA"));
            string2 = this.mRatingsVarList.getVariablesStringList();
            string = SyntaxUtil.getSubCommand(string2.trim()) + "\n";
            stringBuffer.append(string);
            stringBuffer.append(SyntaxUtil.getSubCommand("/CRITERIA"));
            stringBuffer.append(SyntaxUtil.getSubCommand("IGNORE_CASE="));
            Boolean bl = dialogDataModel.getBoolean("IDS_IGNORE_CASE") != null ? dialogDataModel.getBoolean("IDS_IGNORE_CASE") : false;
            if (bl.booleanValue()) {
                stringBuffer.append("TRUE");
            } else {
                stringBuffer.append("FALSE");
            }
            stringBuffer.append("\n");
            object = dialogDataModel.getString("ASYMTP_SIG") != null ? dialogDataModel.getString("ASYMTP_SIG") : "95";
            string = SyntaxUtil.getSubCommand("ASYMPTOTIC_CILEVEL=") + (String)object + "\n";
            stringBuffer.append(string);
            if (dialogDataModel.getBoolean("IDS_IGNORE_CASE") != null && dialogDataModel.getBoolean("IDS_AGREEMENT") != null && dialogDataModel.getBoolean("IDS_DISP_UPPERCASE") != null && (dialogDataModel.getBoolean("IDS_AGREEMENT").booleanValue() || dialogDataModel.getBoolean("IDS_IGNORE_CASE").booleanValue())) {
                stringBuffer.append(SyntaxUtil.getSubCommand("/PRINT"));
                if (dialogDataModel.getBoolean("IDS_AGREEMENT").booleanValue()) {
                    stringBuffer.append(SyntaxUtil.getSubCommand("CATEGORY"));
                }
                if (dialogDataModel.getBoolean("IDS_IGNORE_CASE").booleanValue()) {
                    if (dialogDataModel.getBoolean("IDS_DISP_UPPERCASE").booleanValue()) {
                        stringBuffer.append(SyntaxUtil.getSubCommand("CASE(UPPER)"));
                    } else {
                        stringBuffer.append(SyntaxUtil.getSubCommand("CASE(LOWER)"));
                    }
                }
                stringBuffer.append("\n");
            }
            stringBuffer.append(SyntaxUtil.getSubCommand("/MISSING"));
            stringBuffer.append(SyntaxUtil.getSubCommand("CLASSMISSING="));
            if (dialogDataModel.getBoolean("IDS_EXCLUDE_MISSING") != null) {
                if (dialogDataModel.getBoolean("IDS_EXCLUDE_MISSING").booleanValue()) {
                    stringBuffer.append("EXCLUDE");
                } else {
                    stringBuffer.append("INCLUDE");
                }
            } else {
                stringBuffer.append("EXCLUDE");
            }
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return "analyze_scale_rel_analysis";
    }

    private boolean validation() {
        boolean bl = false;
        boolean bl2 = true;
        if (this.mRatingsVarList.getModel().getSize() > 0) {
            boolean bl3 = bl = this.mRatingsVarList.getModel().getSize() > 1;
            if (bl) {
                VarListModel varListModel = this.mRatingsVarList.getModel();
                int n = varListModel.getSize();
                ISpssVariable iSpssVariable = varListModel.getElementAt(0);
                if (iSpssVariable.getType() == 0) {
                    for (int i = 1; i < n; ++i) {
                        ISpssVariable iSpssVariable2 = varListModel.getElementAt(i);
                        if (iSpssVariable2.getType() == 0) continue;
                        bl2 = false;
                        break;
                    }
                } else {
                    for (int i = 1; i < n; ++i) {
                        ISpssVariable iSpssVariable3 = varListModel.getElementAt(i);
                        if (iSpssVariable3.getType() != 0) continue;
                        bl2 = false;
                        break;
                    }
                }
                if (!bl2) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_RATINGS_TYPE"), VersionInfo.getAppVersionString());
                    return false;
                }
            } else {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_RATINGS_INVALID"), VersionInfo.getAppVersionString());
                return false;
            }
        }
        if (this.mTargetVarList.getModel().getSize() == 1) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_ITEMS_INVALID"), VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    @Override
    protected boolean okPastePressed() {
        if (this.validation()) {
            this.setVisible(false);
            return true;
        }
        return false;
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 1 || this.mRatingsVarList.getModel().getSize() > 1);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 1 || this.mRatingsVarList.getModel().getSize() > 1);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 1);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupComponents(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        this.mScaleField.setCaretPosition(0);
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_STATS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReliabilityAnalysisDlg.this.runOptionsSubDialog();
            }
        };
        this.mStasticsButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mStasticsButton);
        return jPanel;
    }

    private static Map<Integer, String> getModelMap() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, "ALPHA");
        hashMap.put(1, "SPLIT");
        hashMap.put(2, "GUTTMAN");
        hashMap.put(3, "PARALLEL");
        hashMap.put(4, "STRICTPARALLEL");
        return hashMap;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mArrowButton2);
        vector.add(this.mRatingsVarList);
        vector.add(this.mModelCombo);
        vector.add(this.mScaleField);
        vector.add(this.mStasticsButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mTargetVarList.setIdentifier(TARGET_LIST_KEY);
        this.mTargetVarList.setMaxLimitOfList(10000);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 6 + 2));
        this.mTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetScrollPane = new JScrollPane(this.mTargetVarList);
        this.mTargetScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mRatingsVarList = new TargetVariableList();
        this.mRatingsVarList.setDragType(VariableList.VarMoveType.eKeepOriginal);
        this.mRatingsVarList.getModel().addListDataListener(this);
        this.mRatingsVarList.setIdentifier(RATINGS_LIST_KEY);
        this.mRatingsVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mRatingsVarList.getFixedCellHeight() * 6 + 2));
        this.mArrowButton2 = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton2.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton2.registerVariableList(this.mRatingsVarList, SpssArrowButton.ButtonOrientation.left);
        this.mRatingsScrollPane = new JScrollPane(this.mRatingsVarList);
        this.mRatingsScrollPane.setPreferredSize(this.mRatingsVarList.getMinimumSize());
        String[] stringArray = this.getResStringArray("IDS_MODEL_COMBO_VALUES");
        this.mModelCombo = new JComboBox<String>(stringArray);
        this.mScaleField = new StringTextField();
        this.mScaleField.setAction(new TextFieldAction(this, "SCALE_TEXT_KEY"));
        this.mScaleField.setDocument(new FixedLengthDocument(254));
        Dimension dimension = new Dimension(350, this.mScaleField.getPreferredSize().height);
        this.mScaleField.setPreferredSize(dimension);
        this.mModelCombo.setAction(new ComboboxAction(this, MODEL_KEY));
    }

    private void setupComponents(JPanel jPanel) {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_ITEM_COLON");
        jLabel.setLabelFor(this.mTargetVarList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_RELIABILITY_ANALYSIS_SOURCE_LABEL");
        jLabel2.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 3, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton2, gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 2;
        Insets insets2 = new Insets(0, 0, 0, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mTargetScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets2);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_RATINGS");
        jLabel3.setLabelFor(this.mRatingsVarList);
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 2;
        insets2 = new Insets(0, 0, 0, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 2, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mRatingsScrollPane, gridBagConstraints, 2, 3, 1, 1, n, insets2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.setUpModelScalePanel(), gridBagConstraints, 0, 4, 3, 1, n, insets2);
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mScaleField.setText("");
        this.mModelCombo.setSelectedIndex(0);
        this.enableOkPaste(false);
    }

    private void runOptionsSubDialog() {
        this.runSubDialog(new ReliabilityStatistics(this, this.getResString("IDS_REL_STAT"), true));
    }

    private JPanel setUpModelScalePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(this.getResString("IDS_SCALE_LABEL"), 10);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_MODEL_COLON");
        jLabel2.setLabelFor(this.mModelCombo);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 21;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        n = 23;
        insets.left = 20;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mModelCombo, gridBagConstraints, 1, 0, 2, 1, n, insets);
        insets.left = 0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.left = 20;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mScaleField), gridBagConstraints, 1, 1, 4, 1, n, insets);
        return jPanel;
    }
}

