/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.scale.alscal;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.scale.alscal.MultidimensionalScalingDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class MultidimensionalShape
extends BaseSubDialog
implements ItemListener {
    public static final String SQUARE_SYMMETRIC_KEY = "IDS_ALSCAL_SYMMETRIC";
    public static final String SQUARE_ASYMMETRIC_KEY = "IDS_ALSCAL_ASYMMETRIC";
    public static final String RECTANGLE_KEY = "IDS_ALSCAL_RECTANGLE";
    public static final String NUMBER_OF_ROWS_KEY = "IDS_NO_OF_ROWS_KEY";
    private JRadioButton mSymmetricRadio;
    private JRadioButton mAsymmetricRadio;
    private JRadioButton mRectangleRadio;
    private JLabel mRowsLabel;
    private IntTextField mRowsField;
    private SpssButtonGroup mShapeGroup;

    public MultidimensionalShape(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_alsc_sha";
    }

    @Override
    public boolean continuePressed() {
        String string = null;
        if (this.mSymmetricRadio.isSelected()) {
            string = this.mSymmetricRadio.getText();
        } else if (this.mAsymmetricRadio.isSelected()) {
            string = this.mAsymmetricRadio.getText();
        } else if (this.mRectangleRadio.isSelected()) {
            string = this.mRectangleRadio.getText();
            String string2 = this.mRowsField.getText();
            if (string2.length() > 0) {
                try {
                    int n = Integer.parseInt(string2);
                    if (n < 4 || n > 999) {
                        String string3 = MessageFormat.format(UIToolResUtil.getString((String)"ERR_WARNING_MESSAGE"), Integer.toString(4), Integer.toString(999));
                        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string3, VersionInfo.getAppVersionString());
                        this.setSelectionText((JTextField)this.mRowsField, 0);
                        return false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        ((MultidimensionalScalingDlg)this.mParentDlg).setRowState(this.mSymmetricRadio.isSelected());
        ((MultidimensionalScalingDlg)this.mParentDlg).setShapeLabel(string);
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mRowsLabel.setEnabled(this.mRectangleRadio.isSelected());
        this.mRowsField.setEnabled(this.mRectangleRadio.isSelected());
        this.mRowsField.setOpaque(this.mRectangleRadio.isSelected());
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        this.setUpUI(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mShapeGroup);
        vector.add(this.mRowsField);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setDefaults() {
        this.mSymmetricRadio.setSelected(true);
        this.mRowsLabel.setEnabled(false);
        this.mRowsField.setEnabled(false);
        this.mRowsField.setOpaque(false);
        this.mSymmetricRadio.setEnabled(!((MultidimensionalScalingDlg)this.mParentDlg).getSymmeticState());
    }

    private void setUpUI(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mSymmetricRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mAsymmetricRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mRectangleRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        Insets insets2 = new Insets(insets.top, DialogUtil.getComponentGroupGap() + 8, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mShapeGroup = DialogUtil.createButtonGroup(jPanel);
        DialogUtil.addUsingGBL(jPanel, this.setUpRowPanel(), gridBagConstraints, 0, 3, 2, 1, n, insets2);
    }

    private JPanel setUpRowPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mRowsLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        Insets insets = new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mRowsField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void initVars() {
        FocusListener[] focusListenerArray;
        this.mSymmetricRadio = new JRadioButton(new ToggleButtonAction(this, SQUARE_SYMMETRIC_KEY));
        this.mRectangleRadio = new JRadioButton(new ToggleButtonAction(this, RECTANGLE_KEY));
        this.mAsymmetricRadio = new JRadioButton(new ToggleButtonAction(this, SQUARE_ASYMMETRIC_KEY));
        this.mRowsLabel = DialogUtil.createLabel(this, "IDS_ALSCAL_ROWS");
        this.mRowsField = new IntTextField(4, 999, true);
        this.mRowsField.setColumns(3);
        this.mRowsField.setAction((Action)new TextFieldAction(this, NUMBER_OF_ROWS_KEY));
        for (FocusListener focusListener : focusListenerArray = this.mRowsField.getFocusListeners()) {
            if (!(focusListener instanceof IntTextField)) continue;
            this.mRowsField.removeFocusListener(focusListener);
            break;
        }
        this.mRowsLabel.setLabelFor((Component)this.mRowsField);
        this.mRectangleRadio.addItemListener(this);
    }

    private void setSelectionText(final JTextField jTextField, int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jTextField.requestFocusInWindow();
            }
        });
        jTextField.setSelectionStart(n);
        jTextField.setSelectionEnd(jTextField.getText().length());
    }
}

