/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.scale.alscal;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.UtilityProxy;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.base.analyze.scale.alscal.MultidimensionalMeasure;
import com.spss.java_client.ui.dialogs.base.analyze.scale.alscal.MultidimensionalModel;
import com.spss.java_client.ui.dialogs.base.analyze.scale.alscal.MultidimensionalOptions;
import com.spss.java_client.ui.dialogs.base.analyze.scale.alscal.MultidimensionalShape;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class MultidimensionalScalingDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener,
ActionListener,
FocusListener {
    private static final String TARGET_VAR_LIST_KEY = "IDS_ALSCAL_TARGET_VAR_LIST_KEY";
    private static final String TARGET_MATRICES_LIST_KEY = "IDS_ALSCAL_MATRICES_LIST_KEY23";
    private static final String MEASURE_LABEL_KEY = "IDS_ALSCAL_MEASURE_LABEL_KEY";
    private static final String SHAPE_LABEL_KEY = "IDS_ALSCAL_SHAPE_LABEL_KEY";
    private static final int TARGET_MAX_LIMIT_VALUE = 100;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList;
    private TargetVariableList mMatricesTargetVarList;
    private ArrowButton mArrowButton;
    private ArrowButton mMatricesArrowButton;
    private JRadioButton mDataRadioButton;
    private JRadioButton mCreateRadioButton;
    private JButton mMeasureButton;
    private JButton mShapeButton;
    private StringTextField mShapeLabel;
    private StringTextField mMeasureLabel;
    private JLabel mMatricesLabel;
    private SpssButtonGroup mDistanceGroup;
    private boolean mRowState;
    private boolean mSymmetricState;
    private boolean mBetweenCasesState;

    public MultidimensionalScalingDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_ALSCAL_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_alsc";
    }

    @Override
    public String generateSyntax() {
        Boolean bl;
        String string;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        if (this.mCreateRadioButton.isSelected()) {
            String string2;
            Map<Integer, String> map;
            int n;
            if (this.mMatricesTargetVarList.getModel().getSize() == 1) {
                string = ((SpssVariable)this.mMatricesTargetVarList.getModel().getElementAt(0)).getName();
                stringBuffer.append(SyntaxUtil.getMainCommand("SORT CASES BY "));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters(string));
                stringBuffer.append(SyntaxUtil.terminateSyntax());
                stringBuffer.append(SyntaxUtil.getMainCommand("SPLIT FILE BY "));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters(string));
                stringBuffer.append(SyntaxUtil.terminateSyntax());
            }
            string = "";
            for (int i = 0; i < this.mTargetVarList.getModel().getSize(); ++i) {
                string = string + " " + ((SpssVariable)this.mTargetVarList.getModel().getElementAt(i)).getName();
            }
            stringBuffer.append(SyntaxUtil.getMainCommand("PROXIMITIES"));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters(string));
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/PRINT NONE"));
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/MATRIX"));
            stringBuffer.append(" OUT(" + CharacterUtil.smartQuote((String)this.getTemporaryFileName()) + ")");
            String string3 = "EUCLID";
            bl = dialogDataModel.getBoolean("IDS_ALSCAL_INTERVAL_DOT");
            if (bl != null && bl.booleanValue()) {
                n = dialogDataModel.getInteger("INTERVAL_ALSCAL_KEy");
                map = MultidimensionalMeasure.getIntervalMap();
                string3 = string2 = map.get(n).toString().trim();
                int n2 = dialogDataModel.getInteger("POWER_ALSCAL_KEY");
                int n3 = dialogDataModel.getInteger("ROOT_ALSCAL_KEY");
                if (n == 5) {
                    string3 = string2 + "(" + (n2 + 1) + "," + (n3 + 1) + ")";
                }
                if (n == 4) {
                    string3 = string2 + "(" + (n2 + 1) + ")";
                }
            }
            if ((bl = dialogDataModel.getBoolean("IDS_ALSCAL_COUNTS")) != null && bl.booleanValue()) {
                n = dialogDataModel.getInteger("COUNT_ALSCAL_KEY");
                map = MultidimensionalMeasure.getCountMap();
                string3 = map.get(n).toString().trim();
            }
            if ((bl = dialogDataModel.getBoolean("IDS_ALSCAL_BINARY")) != null && bl.booleanValue()) {
                n = dialogDataModel.getInteger("BINARY_ALSCAL_KEY");
                map = MultidimensionalMeasure.getBinMap();
                string2 = map.get(n).toString().trim();
                string3 = string2 + " (" + dialogDataModel.getString("IDS_ALSCAL_PRESENT1661") + "," + dialogDataModel.getString("IDS_ALSCAL_ABESNT2266") + ")";
            }
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/MEASURE=") + string3);
            Boolean bl2 = dialogDataModel.getBoolean("IDS_ALSCAL_INTERVAL_DOT");
            Boolean bl3 = dialogDataModel.getBoolean("IDS_ALSCAL_BINARY");
            Boolean bl4 = dialogDataModel.getBoolean("IDS_ALSCAL_COUNTS");
            if (bl2 != null && bl2.booleanValue() || bl4 != null && bl4.booleanValue()) {
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/STANDARDIZE="));
                bl = dialogDataModel.getBoolean("IDS_ALSCAL_BY_CASE");
                String string4 = "";
                if (bl != null && bl.booleanValue()) {
                    string4 = "CASE";
                }
                if ((bl = dialogDataModel.getBoolean("IDS_ALSCAL_BY_VARIABLE")) != null && bl.booleanValue()) {
                    string4 = "VARIABLE";
                }
                n = dialogDataModel.getInteger("STD_ALSCAL_KEY");
                map = MultidimensionalMeasure.getStdMap();
                String string5 = map.get(n).toString();
                if (!string5.trim().equals("NONE")) {
                    stringBuffer.append(string4 + string5);
                } else {
                    stringBuffer.append(string5);
                }
            } else if (bl3 == null || !bl3.booleanValue()) {
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/STANDARDIZE=NONE"));
            }
            bl = dialogDataModel.getBoolean("IDS_ALSCAL_BETWEEN_VAR");
            if (bl == null || bl.booleanValue()) {
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/VIEW=VARIABLE"));
            }
            if ((bl = dialogDataModel.getBoolean("IDS_ALSCAL_BETWEEN_CASES")) != null && bl.booleanValue()) {
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/VIEW=CASE"));
            }
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            stringBuffer.append(SyntaxUtil.getMainCommand("ALSCAL"));
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/MATRIX=IN(") + CharacterUtil.smartQuote((String)this.getTemporaryFileName()) + ")");
            stringBuffer.append(this.getALSCALSyntax());
            if (this.mMatricesTargetVarList.getModel().getSize() == 1) {
                stringBuffer.append(SyntaxUtil.getMainCommand("SPLIT FILE"));
                stringBuffer.append(SyntaxUtil.getMainCommandParamters("OFF"));
                stringBuffer.append(SyntaxUtil.terminateSyntax());
            }
            stringBuffer.append(SyntaxUtil.getMainCommand("ERASE "));
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("FILE=") + CharacterUtil.smartQuote((String)this.getTemporaryFileName()));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if (this.mDataRadioButton.isSelected()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("ALSCAL"));
            string = "";
            for (int i = 0; i < this.mTargetVarList.getModel().getSize(); ++i) {
                string = string + " " + ((SpssVariable)this.mTargetVarList.getModel().getElementAt(i)).getName();
            }
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("VARIABLES=") + string.trim());
            bl = dialogDataModel.getBoolean("IDS_ALSCAL_SYMMETRIC");
            if (bl == null || bl.booleanValue()) {
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/SHAPE=SYMMETRIC"));
            }
            if ((bl = dialogDataModel.getBoolean("IDS_ALSCAL_ASYMMETRIC")) != null && bl.booleanValue()) {
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/SHAPE=ASYMMETRIC"));
            }
            if ((bl = dialogDataModel.getBoolean("IDS_ALSCAL_RECTANGLE")) != null && bl.booleanValue()) {
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/SHAPE=RECTANGULAR"));
                String string6 = dialogDataModel.getString("IDS_NO_OF_ROWS_KEY");
                if (string6.length() != 0) {
                    stringBuffer.append(SyntaxUtil.getSubCommand("/INPUT ROWS(") + string6 + ")");
                }
            }
            stringBuffer.append(this.getALSCALSyntax());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return "analyze_scale_mult_alscal";
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetVarList.removeAll();
        this.mMatricesTargetVarList.removeAll();
        this.setDefaults();
    }

    @Override
    public boolean okPastePressed() {
        int n;
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        return iSpssDataSrc.getNSplitVars() <= 0 || this.mMatricesTargetVarList.getModel().getSize() != 1 || !this.mCreateRadioButton.isSelected() || (n = this.showMessage(this.getResString("ERR_ALSCAL_SPLIT_FILE_MSG"))) == 0;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mMeasureLabel.setEnabled(this.mCreateRadioButton.isSelected());
        this.mMeasureButton.setEnabled(this.mCreateRadioButton.isSelected());
        this.mShapeLabel.setEnabled(this.mDataRadioButton.isSelected());
        this.mShapeLabel.setBackground(this.getBackground());
        this.mMeasureLabel.setBackground(this.getBackground());
        this.mShapeButton.setEnabled(this.mDataRadioButton.isSelected());
        this.mMatricesTargetVarList.setEnabled(this.mCreateRadioButton.isSelected());
        this.mMatricesTargetVarList.setOpaque(this.mCreateRadioButton.isSelected());
        this.mMatricesLabel.setEnabled(this.mCreateRadioButton.isSelected());
        this.mMatricesArrowButton.setEnabled(this.mCreateRadioButton.isSelected());
        this.updateOkPasteButton();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.mShapeButton) && this.mDataRadioButton.isSelected()) {
            this.runSubDialog(new MultidimensionalShape(this, this.getResString("IDS_ALSCAL_SHAPE_TITLE"), true));
        } else if (actionEvent.getSource().equals(this.mMeasureButton) && this.mCreateRadioButton.isSelected()) {
            this.runSubDialog(new MultidimensionalMeasure(this, this.getResString("IDS_ALSCAL_MEASURE_TITLE"), true));
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateOkPasteButton();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateOkPasteButton();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateOkPasteButton();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mMatricesTargetVarList) && this.mMatricesTargetVarList.getModel().getSize() == 1) {
            this.mMatricesArrowButton.setEnabled(true);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    public void updateOkPasteButton() {
        if (this.getBetweenCasesState() && this.mCreateRadioButton.isSelected()) {
            this.enableOkPaste(this.mTargetVarList.getModel().getSize() >= 1);
        } else {
            this.enableOkPaste(this.mTargetVarList.getModel().getSize() >= 4);
        }
    }

    public void setSymmetricState(boolean bl) {
        this.mSymmetricState = bl;
    }

    public void setCreateDistanceRadioState(boolean bl) {
        this.mCreateRadioButton.setEnabled(bl);
    }

    public boolean getCreateFromDistanceState() {
        return this.mCreateRadioButton.isSelected();
    }

    public boolean getSymmeticState() {
        return this.mSymmetricState;
    }

    public void setRowState(boolean bl) {
        this.mRowState = bl;
    }

    public boolean getRowState() {
        return this.mRowState;
    }

    public void setBetweenCasesState(boolean bl) {
        this.mBetweenCasesState = bl;
    }

    public boolean getBetweenCasesState() {
        return this.mBetweenCasesState;
    }

    public void setMeasureLabel(String string) {
        this.mMeasureLabel.setText(string);
    }

    public void setShapeLabel(String string) {
        this.mShapeLabel.setText(string);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupComponents(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultidimensionalScalingDlg.this.runOptionsSubDialog();
            }
        };
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction("IDS_COMMON_MODEL_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultidimensionalScalingDlg.this.runModelSubDialog();
            }
        };
        JButton jButton = new JButton(toggleButtonAction2);
        JButton jButton2 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        this.addOptionsPanelButton(jPanel, jButton2);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mMatricesArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mMatricesTargetVarList);
        vector.add(this.mDistanceGroup);
        vector.add(this.mShapeButton);
        vector.add(this.mMeasureButton);
        for (n = 0; n < this.mOptionButtonPanel.getComponentCount(); ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private int showMessage(String string) {
        int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eInformation, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
        return n;
    }

    private void runOptionsSubDialog() {
        this.runSubDialog(new MultidimensionalOptions(this, this.getResString("IDS_ALSCAL_OPTIONS_TITLE"), true));
    }

    private void runModelSubDialog() {
        this.runSubDialog(new MultidimensionalModel(this, this.getResString("IDS_ALSCAL_MODEL_TITLE"), true));
    }

    private String getALSCALSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_ALSCAL_ORDINAL");
        if (bl == null || bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/LEVEL=ORDINAL"));
            bl = dialogDataModel.getBoolean("IDS_ALSCAL_OBSERVATIONS");
            if (bl != null && bl.booleanValue()) {
                stringBuffer.append(" (UNTIE)");
            }
        }
        if ((bl = dialogDataModel.getBoolean("IDS_ALSCAL_INTERVAL")) != null && bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/LEVEL=INTERVAL"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_ALSCAL_RATIO")) != null && bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/LEVEL=RATIO"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_ALSCAL_MATRIX")) == null || bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/CONDITION=MATRIX"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_ALSCAL_ROW")) != null && bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/CONDITION=ROW"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_ALSCAL_UNCONDITIONAL")) != null && bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/CONDITION=UNCONDITIONAL"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_ALSCAL_EUCLIDEAN_DIS")) == null || bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/MODEL=EUCLID"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_ALSCAL_INDIVIDUAL_DIFF")) != null && bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/MODEL=INDSCAL"));
        }
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/CRITERIA="));
        bl = dialogDataModel.getBoolean("IDS_ALSCAL_ALLOW_NEG");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("NEGATIVE ");
        }
        String string = "0.001";
        if (dialogDataModel.getString("IDS_ALSCAL_SYMMETRIC") != null) {
            string = dialogDataModel.getString("IDS_ALSCAL_SYMMETRIC");
        }
        stringBuffer.append("CONVERGE(" + string + ")");
        string = "0.005";
        if (dialogDataModel.getString("IDS_ALSCAL_ASYMMETRIC") != null) {
            string = dialogDataModel.getString("IDS_ALSCAL_ASYMMETRIC");
        }
        stringBuffer.append(" STRESSMIN(" + string + ")");
        string = "30";
        if (dialogDataModel.getString("IDS_ALSCAL_RECTANGLE") != null) {
            string = dialogDataModel.getString("IDS_ALSCAL_RECTANGLE");
        }
        stringBuffer.append(" ITER(" + string + ")");
        string = "0";
        if (dialogDataModel.getString("IDS_ALSCAL_DIS_KEY") != null) {
            string = dialogDataModel.getString("IDS_ALSCAL_DIS_KEY");
        }
        stringBuffer.append(" CUTOFF(" + string + ")");
        String string2 = "2";
        String string3 = "2";
        if (dialogDataModel.getString("IDS_ALSCAL_MINIMUM") != null) {
            string2 = dialogDataModel.getString("IDS_ALSCAL_MINIMUM");
        }
        if (dialogDataModel.getString("IDS_ALSCAL_MAXIMUM") != null) {
            string3 = dialogDataModel.getString("IDS_ALSCAL_MAXIMUM");
        }
        stringBuffer.append(" DIMENS(" + string2 + "," + string3 + ")");
        string = "";
        bl = dialogDataModel.getBoolean("IDS_ALSCAL_GROUP_PLOTS");
        if (bl != null && bl.booleanValue()) {
            string = "DEFAULT";
        }
        if ((bl = dialogDataModel.getBoolean("IDS_ALSCAL_INDIVIDUAL_SUB")) != null && bl.booleanValue()) {
            string = string + " ALL";
        }
        if (string.length() != 0) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/PLOT=") + string.trim());
        }
        string = "";
        bl = dialogDataModel.getBoolean("IDS_ALSCAL_DATA_MATRIX");
        if (bl != null && bl.booleanValue()) {
            string = "DATA";
        }
        if ((bl = dialogDataModel.getBoolean("IDS_ALSCAL_MODELNOPTION")) != null && bl.booleanValue()) {
            string = string + " HEADER";
        }
        if (string.length() != 0) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/PRINT=") + string.trim());
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    private String getTemporaryFileName() {
        UtilityProxy utilityProxy = UtilityProxy.getUtilProxy();
        String string = utilityProxy.getServerTemporaryPath() + "spssalsc.tmp";
        return string;
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mDataRadioButton.setSelected(true);
        this.mMeasureButton.setEnabled(false);
        this.mMeasureLabel.setEnabled(false);
        this.mMatricesTargetVarList.setEnabled(false);
        this.mMatricesTargetVarList.setOpaque(false);
        this.enableOkPaste(false);
        this.mRowState = true;
        this.mSymmetricState = false;
        this.mBetweenCasesState = false;
        this.mCreateRadioButton.setEnabled(true);
        this.mShapeLabel.setText(this.getResString("IDS_ALSCAL_SHAPE_VALUE"));
        this.mMeasureLabel.setText(this.getResString("IDS_ALSCAL_MEASURE_VALUE"));
    }

    private void setupComponents(JPanel jPanel) {
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        JScrollPane jScrollPane2 = new JScrollPane(this.mTargetVarList);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 4 + 2));
        jScrollPane2.setPreferredSize(this.mTargetVarList.getMinimumSize());
        JScrollPane jScrollPane3 = new JScrollPane(this.mMatricesTargetVarList);
        jScrollPane3.setPreferredSize(this.mMatricesTargetVarList.getMinimumSize());
        jScrollPane3.setHorizontalScrollBarPolicy(31);
        jScrollPane3.setVerticalScrollBarPolicy(21);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_ALSCAL_VARIABLES");
        jLabel.setLabelFor(this.mTargetVarList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_ALSCAL_SOURCE_LABEL");
        jLabel2.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 3, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        Insets insets2 = new Insets(0, 0, n2, 0);
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 20;
        Insets insets3 = new Insets(0, DialogUtil.getArrowButtonInsets().left, 0, DialogUtil.getArrowButtonInsets().right);
        DialogUtil.addUsingGBL(jPanel, this.mMatricesArrowButton, gridBagConstraints, 1, 2, 1, 2, n, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mMatricesLabel, gridBagConstraints, 2, 2, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jScrollPane3, gridBagConstraints, 2, 3, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        insets2.set(n2, 0, 0, n2 + 70);
        DialogUtil.addUsingGBL(jPanel, this.setUpDistanesPanel(), gridBagConstraints, 0, 4, 3, 1, n, insets2);
    }

    private JPanel setUpDistanesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_ALSCAL_COMPUTE_DISTANCE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mDataRadioButton, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        Insets insets2 = new Insets(0, n2 + 6, n2 - 4, n2 - 3);
        DialogUtil.addUsingGBL(jPanel, this.mShapeButton, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        int n3 = 4;
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            n3 = 6;
        }
        insets2.set(n3, 0, n2 - 4, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mShapeLabel), gridBagConstraints, 1, 1, 1, 1, n, insets2);
        insets2.set(4, 0, n2 - 4, 0);
        DialogUtil.addUsingGBL(jPanel, this.mCreateRadioButton, gridBagConstraints, 0, 2, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets2.set(0, n2 + 6, n2, n2 - 3);
        DialogUtil.addUsingGBL(jPanel, this.mMeasureButton, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.set(n3, 0, n2, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mMeasureLabel), gridBagConstraints, 1, 3, 1, 1, n, insets2);
        this.mDistanceGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetVarList.setMaxLimitOfList(100);
        this.mMatricesTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mMatricesTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mMatricesLabel = DialogUtil.createLabel(this, "IDS_ALSCAL_MATRICES");
        this.mMatricesLabel.setLabelFor(this.mMatricesTargetVarList);
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mMatricesArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mMatricesArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mMatricesArrowButton.registerVariableList(this.mMatricesTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mDataRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_ALSCAL_DATA"));
        this.mCreateRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_ALSCAL_CREATE"));
        this.mMeasureButton = new JButton(new ToggleButtonAction(this, "IDS_ALSCAL_MEASURES"));
        this.mShapeButton = new JButton(new ToggleButtonAction(this, "IDS_ALSCAL_SHAPE"));
        this.mShapeLabel = new StringTextField(this.getResString("IDS_ALSCAL_SHAPE_VALUE"));
        this.mShapeLabel.setBorder(BorderFactory.createEmptyBorder());
        this.mShapeLabel.setOpaque(false);
        this.mShapeLabel.setAction(new TextFieldAction(this, SHAPE_LABEL_KEY));
        this.mShapeLabel.setBackground(this.getBackground());
        this.mMeasureLabel = new StringTextField(this.getResString("IDS_ALSCAL_MEASURE_VALUE"));
        this.mMeasureLabel.setBorder(BorderFactory.createEmptyBorder());
        this.mMeasureLabel.setOpaque(false);
        this.mMeasureLabel.setBackground(this.getBackground());
        this.mMeasureLabel.setAction(new TextFieldAction(this, MEASURE_LABEL_KEY));
        this.mDataRadioButton.addItemListener(this);
        this.mCreateRadioButton.addItemListener(this);
        this.mShapeButton.addActionListener(this);
        this.mMeasureButton.addActionListener(this);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mSrcVarList.getModel().addListDataListener(this);
        this.mMatricesTargetVarList.setIdentifier(TARGET_MATRICES_LIST_KEY);
        this.mTargetVarList.setIdentifier(TARGET_VAR_LIST_KEY);
        this.mMatricesTargetVarList.addFocusListener(this);
    }
}

