/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.scale.alscal;

import com.spss.java_client.ui.dialogs.base.analyze.scale.alscal.MultidimensionalScalingDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MultidimensionalOptions
extends BaseSubDialog
implements DocumentListener {
    static final String GROUP_PLOTS_KEY = "IDS_ALSCAL_GROUP_PLOTS";
    static final String INDIVIDUAL_PLOTS_KEY = "IDS_ALSCAL_INDIVIDUAL_SUB";
    static final String DATA_MATRIX_KEY = "IDS_ALSCAL_DATA_MATRIX";
    static final String MODEL_N_OPTIONS_KEY = "IDS_ALSCAL_MODELNOPTION";
    static final String STRESS_CONV_KEY = "IDS_ALSCAL_SYMMETRIC";
    static final String MIN_STRESS_KEY = "IDS_ALSCAL_ASYMMETRIC";
    static final String MAX_ITER_KEY = "IDS_ALSCAL_RECTANGLE";
    static final String DISTANCE_KEY = "IDS_ALSCAL_DIS_KEY";
    private static final String sSTRESS_DEAFULT_VALUE = "0.001";
    private static final String sMINIMUM_STRESS_DEAFULT_VALUE = "0.005";
    private static final String sMAX_ITERATIONS_DEAFULT_VALUE = "30";
    private static final String sDISTANCE_DEAFULT_VALUE = "0";
    private FloatTextField mStressField;
    private FloatTextField mMinimumField;
    private IntTextField mMaximumField;
    private FloatTextField mDistanceField;
    private JCheckBox mIndividualSubjectPlots;
    private JPanel mDisplayPanel;

    public MultidimensionalOptions(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_alsc_opt";
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        this.setUpUI(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        int n2 = this.mDisplayPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            vector.add(this.mDisplayPanel.getComponent(n));
        }
        vector.add(this.mStressField);
        vector.add(this.mMinimumField);
        vector.add(this.mMaximumField);
        vector.add(this.mDistanceField);
        n2 = this.mCmdButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void updateContinueButton() {
        this.enableContinue(this.mStressField.getText().length() > 0 && this.mMinimumField.getText().length() > 0 && this.mMaximumField.getText().length() > 0 && this.mDistanceField.getText().length() > 0);
    }

    private void setDefaults() {
        this.mDistanceField.setText(sDISTANCE_DEAFULT_VALUE);
        this.mStressField.setText(sSTRESS_DEAFULT_VALUE);
        this.mMinimumField.setText(sMINIMUM_STRESS_DEAFULT_VALUE);
        this.mMaximumField.setText(sMAX_ITERATIONS_DEAFULT_VALUE);
        this.mIndividualSubjectPlots.setEnabled(!((MultidimensionalScalingDlg)this.mParentDlg).getSymmeticState());
    }

    private void setUpUI(JPanel jPanel) {
        this.mDisplayPanel = this.setUpDisplayPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, n2, n2 + 20);
        DialogUtil.addUsingGBL(jPanel, this.mDisplayPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.setUpCriteriaPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.setUpDistancePanel(), gridBagConstraints, 0, 2, 2, 1, n, null);
    }

    private JPanel setUpDisplayPanel() {
        JCheckBox jCheckBox = new JCheckBox(new ToggleButtonAction(this, GROUP_PLOTS_KEY));
        JCheckBox jCheckBox2 = new JCheckBox(new ToggleButtonAction(this, DATA_MATRIX_KEY));
        JCheckBox jCheckBox3 = new JCheckBox(new ToggleButtonAction(this, MODEL_N_OPTIONS_KEY));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_ALSCAL_DISPLAY")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jCheckBox, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mIndividualSubjectPlots, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jCheckBox2, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jCheckBox3, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setUpCriteriaPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_ALSCAL_CRITERIA")));
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_ALSCAL_S_STRESS");
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_ALSCAL_MINIMUM_STRESS");
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_ALSCAL_MAXIMUM_ITER");
        jLabel.setLabelFor((Component)this.mStressField);
        jLabel2.setLabelFor((Component)this.mMinimumField);
        jLabel3.setLabelFor((Component)this.mMaximumField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mStressField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.set(n2, n2, 0, 0);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMinimumField, gridBagConstraints, 1, 1, 1, 1, n, insets);
        insets.set(n2, n2, n2, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaximumField, gridBagConstraints, 1, 2, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setUpDistancePanel() {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_ALSCAL_TREAT_DIS");
        jLabel.setLabelFor((Component)this.mDistanceField);
        JLabel jLabel2 = new JLabel(this.getResString("IDS_ALSCAL_MISSING"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mDistanceField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(0, 4, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void initVars() {
        this.mStressField = new FloatTextField(0.0, 99999.0, 4, true);
        this.mMinimumField = new FloatTextField(0.0, 1.0, 4, true);
        this.mMaximumField = new IntTextField(1, 999, true);
        this.mDistanceField = new FloatTextField(-999.0, 9999.0, 4, false);
        this.mDistanceField.setColumns(4);
        this.mMaximumField.setColumns(4);
        this.mMinimumField.getDocument().addDocumentListener(this);
        this.mMaximumField.getDocument().addDocumentListener(this);
        this.mDistanceField.getDocument().addDocumentListener(this);
        this.mStressField.getDocument().addDocumentListener(this);
        this.mMinimumField.setAction((Action)new TextFieldAction(this, MIN_STRESS_KEY));
        this.mMaximumField.setAction((Action)new TextFieldAction(this, MAX_ITER_KEY));
        this.mStressField.setAction((Action)new TextFieldAction(this, STRESS_CONV_KEY));
        this.mDistanceField.setAction((Action)new TextFieldAction(this, DISTANCE_KEY));
        this.mIndividualSubjectPlots = new JCheckBox(new ToggleButtonAction(this, INDIVIDUAL_PLOTS_KEY));
    }
}

