/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.scale.alscal;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.scale.alscal.MultidimensionalScalingDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MultidimensionalModel
extends BaseSubDialog
implements DocumentListener,
ItemListener {
    static final String ORDINAL_KEY = "IDS_ALSCAL_ORDINAL";
    static final String INTERVAL_KEY = "IDS_ALSCAL_INTERVAL";
    static final String RATIO_KEY = "IDS_ALSCAL_RATIO";
    static final String MATRIX_KEY = "IDS_ALSCAL_MATRIX";
    static final String ROW_KEY = "IDS_ALSCAL_ROW";
    static final String UNCONDITIONAL_KEY = "IDS_ALSCAL_UNCONDITIONAL";
    static final String MINIMUM_KEY = "IDS_ALSCAL_MINIMUM";
    static final String MAXIMUM_KEY = "IDS_ALSCAL_MAXIMUM";
    static final String UNITE_KEY = "IDS_ALSCAL_OBSERVATIONS";
    static final String EUCLIDEAN_DIS_KEY = "IDS_ALSCAL_EUCLIDEAN_DIS";
    static final String INDIVIDUAL_KEY = "IDS_ALSCAL_INDIVIDUAL_DIFF";
    static final String ALLOW_NEG_KEY = "IDS_ALSCAL_ALLOW_NEG";
    private static final String MINIMUM_DEAFULT_VALUE = "2";
    private static final String MAXIMUM_DEAFULT_VALUE = "2";
    private JRadioButton mOrdinalRadio;
    private JRadioButton mMatrixRadio;
    private JRadioButton mRowRadio;
    private JRadioButton mEuclideanRadio;
    private JRadioButton mIndividualDiffRadio;
    private JCheckBox mUniteCheck;
    private JCheckBox mAllowNegCheck;
    private IntTextField mMinimumField;
    private IntTextField mMaximumField;
    private SpssButtonGroup mMeasurementGroup;
    private SpssButtonGroup mScalingGroup;
    private SpssButtonGroup mConditionalityGroup;

    public MultidimensionalModel(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_alsc_mod";
    }

    @Override
    public boolean continuePressed() {
        int n;
        int n2 = Integer.parseInt(this.mMinimumField.getText());
        if (n2 > (n = Integer.parseInt(this.mMaximumField.getText()))) {
            this.showDialog(this.getResString("ERR_ALSCAL_WARN_MSG"));
            this.mMinimumField.requestFocus();
            this.mMinimumField.setSelectionStart(0);
            this.mMinimumField.setSelectionEnd(this.mMinimumField.getText().length());
            return false;
        }
        ((MultidimensionalScalingDlg)this.mParentDlg).setSymmetricState(this.mRowRadio.isSelected());
        ((MultidimensionalScalingDlg)this.mParentDlg).setCreateDistanceRadioState(!this.mRowRadio.isSelected());
        return true;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mUniteCheck.setEnabled(this.mOrdinalRadio.isSelected());
        this.mAllowNegCheck.setEnabled(this.mIndividualDiffRadio.isSelected());
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        this.setUpUI(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mMeasurementGroup);
        vector.add(this.mUniteCheck);
        vector.add(this.mConditionalityGroup);
        vector.add(this.mMinimumField);
        vector.add(this.mMaximumField);
        vector.add(this.mScalingGroup);
        vector.add(this.mAllowNegCheck);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void updateContinueButton() {
        this.enableContinue(this.mMinimumField.getText().length() > 0 && this.mMaximumField.getText().length() > 0);
    }

    private void showDialog(String string) {
        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
    }

    private JPanel setUpMeasurementPanel() {
        JRadioButton jRadioButton = new JRadioButton(new ToggleButtonAction(this, INTERVAL_KEY));
        JRadioButton jRadioButton2 = new JRadioButton(new ToggleButtonAction(this, RATIO_KEY));
        this.mMeasurementGroup.add(this.mOrdinalRadio);
        this.mMeasurementGroup.add(jRadioButton);
        this.mMeasurementGroup.add(jRadioButton2);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_ALSCAL_MEASURMENT")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mOrdinalRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        Insets insets2 = new Insets(0, DialogUtil.getComponentGroupGap() + 5, 0, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, this.mUniteCheck, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, jRadioButton, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jRadioButton2, gridBagConstraints, 0, 3, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setUpConditionalityPanel() {
        JRadioButton jRadioButton = new JRadioButton(new ToggleButtonAction(this, UNCONDITIONAL_KEY));
        this.mConditionalityGroup.add(this.mMatrixRadio);
        this.mConditionalityGroup.add(this.mRowRadio);
        this.mConditionalityGroup.add(jRadioButton);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_ALSCAL_CONDITIONALITY")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mMatrixRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mRowRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jRadioButton, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setUpScalingModelPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_ALSCAL_SCALING_MODEL")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mEuclideanRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mIndividualDiffRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        Insets insets2 = new Insets(0, DialogUtil.getComponentGroupGap() + 5, DialogUtil.getComponentGroupGap(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mAllowNegCheck, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setUpDimensionsPanel() {
        JLabel jLabel = DialogUtil.createLabel(this, MINIMUM_KEY);
        JLabel jLabel2 = DialogUtil.createLabel(this, MAXIMUM_KEY);
        jLabel.setLabelFor((Component)this.mMinimumField);
        jLabel2.setLabelFor((Component)this.mMaximumField);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_ALSCAL_DIMENSIONS")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(0, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMinimumField, gridBagConstraints, 1, 0, 1, 1, n2, null);
        insets.set(0, n, n, n);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(0, 0, n, n);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaximumField, gridBagConstraints, 3, 0, 1, 1, n2, insets);
        return jPanel;
    }

    private void setDefaults() {
        this.mOrdinalRadio.setSelected(true);
        this.mMatrixRadio.setSelected(true);
        this.mEuclideanRadio.setSelected(true);
        this.mAllowNegCheck.setEnabled(false);
        this.mRowRadio.setEnabled(!((MultidimensionalScalingDlg)this.mParentDlg).getRowState() && !((MultidimensionalScalingDlg)this.mParentDlg).getCreateFromDistanceState());
        this.mMinimumField.setText("2");
        this.mMaximumField.setText("2");
    }

    private void setUpUI(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.setUpMeasurementPanel(), gridBagConstraints, 0, 0, 1, 2, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.setUpConditionalityPanel(), gridBagConstraints, 1, 0, 1, 1, n, null);
        insets.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setUpDimensionsPanel(), gridBagConstraints, 1, 1, 1, 1, n, insets);
        insets.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setUpScalingModelPanel(), gridBagConstraints, 0, 2, 2, 1, n, insets);
    }

    private void initVars() {
        this.mOrdinalRadio = new JRadioButton(new ToggleButtonAction(this, ORDINAL_KEY));
        this.mMatrixRadio = new JRadioButton(new ToggleButtonAction(this, MATRIX_KEY));
        this.mRowRadio = new JRadioButton(new ToggleButtonAction(this, ROW_KEY));
        this.mEuclideanRadio = new JRadioButton(new ToggleButtonAction(this, EUCLIDEAN_DIS_KEY));
        this.mIndividualDiffRadio = new JRadioButton(new ToggleButtonAction(this, INDIVIDUAL_KEY));
        this.mUniteCheck = new JCheckBox(new ToggleButtonAction(this, UNITE_KEY));
        this.mAllowNegCheck = new JCheckBox(new ToggleButtonAction(this, ALLOW_NEG_KEY));
        this.mMinimumField = new IntTextField(1, 6, true);
        this.mMaximumField = new IntTextField(1, 6, true);
        this.mMinimumField.setColumns(3);
        this.mMaximumField.setColumns(3);
        this.mMeasurementGroup = new SpssButtonGroup();
        this.mScalingGroup = new SpssButtonGroup();
        this.mConditionalityGroup = new SpssButtonGroup();
        this.mScalingGroup.add(this.mEuclideanRadio);
        this.mScalingGroup.add(this.mIndividualDiffRadio);
        this.mOrdinalRadio.addItemListener(this);
        this.mIndividualDiffRadio.addItemListener(this);
        this.mMinimumField.getDocument().addDocumentListener(this);
        this.mMaximumField.getDocument().addDocumentListener(this);
        this.mMinimumField.setAction((Action)new TextFieldAction(this, MINIMUM_KEY));
        this.mMaximumField.setAction((Action)new TextFieldAction(this, MAXIMUM_KEY));
    }
}

