/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.roc_curve;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class RocCurveOptions
extends BaseSubDialog {
    public static final String INC_CUTOFF_RADIO_KEY = "IDS_INC_CUTOFF_RADIO";
    public static final String EXC_CUTOFF_RADIO_KEY = "IDS_EXC_CUTOFF_RADIO";
    public static final String LARGER_TEST_RADIO_KEY = "IDS_LARGER_TEST_RADIO";
    public static final String SMALLER_TEST_RADIO_KEY = "IDS_SMALLER_TEST_RADIO";
    public static final String EXCLUDE_MIS_VAL_RADIO_KEY = "IDS_EXCLUDE_MIS_VAL_RADIO";
    public static final String VALID_MIS_VAL_RADIO_KEY = "IDS_VALID_MIS_VAL_RADIO";
    public static final String DIST_ASSUM_COMBO_KEY = "IDS_DIST_ASSUM_COMBO";
    public static final String CONF_LEVEL_EDIT_KEY = "IDS_CONF_LEVEL_EDIT";
    static final int CONF_LEVEL_DEFAULT = 95;
    private FloatTextField mConfLevelEdit;
    private JComboBox mDistAssumCombo;
    private JLabel mDistAssumLabel;
    private String mHelpId = "IDH_GROC_OPTIONS";
    private Vector<Object> mComponentsVector;

    public RocCurveOptions(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_ROC_CURVE_OPTIONS_TITLE"), true);
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    public RocCurveOptions(BaseProcedureDialog baseProcedureDialog, String string) {
        super(baseProcedureDialog, string, true);
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return this.mHelpId;
    }

    public void setupForROCAnalysis(boolean bl) {
        this.mDistAssumCombo.setEnabled(!bl);
        this.mDistAssumLabel.setEnabled(!bl);
        this.mConfLevelEdit.setMinVal(0.0);
        this.mHelpId = "idh_roc_options";
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupClassificationPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.setupTestDirectionPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.setupParameterPanel(), gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.setupMissingValuesPanel(), gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.setTabTraversalOrder();
        this.pack();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        boolean bl;
        super.loadState(dialogDataModel);
        boolean bl2 = bl = dialogDataModel.getBoolean("IDS_PAIRED_SAMPLE_CHECK") != null ? dialogDataModel.getBoolean("IDS_PAIRED_SAMPLE_CHECK") : false;
        if (bl && this.mDistAssumCombo.getSelectedIndex() != 0) {
            this.mDistAssumCombo.setSelectedIndex(0);
        }
    }

    private void initVars() {
        this.mConfLevelEdit = new FloatTextField(50.0, 100.0, 1, true);
        this.mConfLevelEdit.setAllowMinMax(false, false);
        this.mConfLevelEdit.setColumns(4);
        this.mConfLevelEdit.setText(Integer.toString(95));
        this.mConfLevelEdit.setAction((Action)new TextFieldAction(this.mParentDlg, CONF_LEVEL_EDIT_KEY));
        this.mComponentsVector = new Vector();
    }

    private JPanel setupClassificationPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_CLASSIFICATION"));
        jPanel.setBorder(titledBorder);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, INC_CUTOFF_RADIO_KEY);
        JRadioButton jRadioButton = new JRadioButton(toggleButtonAction);
        spssButtonGroup.add(jRadioButton);
        jRadioButton.setSelected(true);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, EXC_CUTOFF_RADIO_KEY);
        JRadioButton jRadioButton2 = new JRadioButton(toggleButtonAction);
        spssButtonGroup.add(jRadioButton2);
        this.mComponentsVector.add(spssButtonGroup);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jRadioButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jRadioButton2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupTestDirectionPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_TEST_DIRECTION"));
        jPanel.setBorder(titledBorder);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, LARGER_TEST_RADIO_KEY);
        JRadioButton jRadioButton = new JRadioButton(toggleButtonAction);
        spssButtonGroup.add(jRadioButton);
        jRadioButton.setSelected(true);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, SMALLER_TEST_RADIO_KEY);
        JRadioButton jRadioButton2 = new JRadioButton(toggleButtonAction);
        spssButtonGroup.add(jRadioButton2);
        this.mComponentsVector.add(spssButtonGroup);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jRadioButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jRadioButton2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupParameterPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_PARAMETERS"));
        jPanel.setBorder(titledBorder);
        int n = 23;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.setupDistAssumptionPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = DialogUtil.getStandardControlInsets();
        insets = new Insets(n2, insets2.left, insets2.bottom, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.setupConfLevelPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupDistAssumptionPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        this.mDistAssumLabel = DialogUtil.createLabel(this, "IDS_DIST_ASSUM_LABEL");
        String[] stringArray = new String[]{this.getResString("IDS_NONPARAM"), this.getResString("IDS_BI_NEG_EXP")};
        this.mDistAssumCombo = new JComboBox<String>(stringArray);
        this.mDistAssumCombo.setPreferredSize(this.mDistAssumCombo.getPreferredSize());
        this.mDistAssumCombo.setAction(new ComboboxAction(this.mParentDlg, DIST_ASSUM_COMBO_KEY));
        this.mDistAssumLabel.setLabelFor(this.mDistAssumCombo);
        this.mComponentsVector.add(this.mDistAssumCombo);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDistAssumLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        insets2 = new Insets(insets.top, 4, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mDistAssumCombo, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupConfLevelPanel() {
        this.mComponentsVector.add(this.mConfLevelEdit);
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_CONF_LEVEL_LABEL");
        jLabel.setLabelFor((Component)this.mConfLevelEdit);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_PERCENTAGE");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        insets2 = new Insets(insets.top, 4, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mConfLevelEdit, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupMissingValuesPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_MISSING_VALUES"));
        jPanel.setBorder(titledBorder);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, EXCLUDE_MIS_VAL_RADIO_KEY);
        JRadioButton jRadioButton = new JRadioButton(toggleButtonAction);
        spssButtonGroup.add(jRadioButton);
        jRadioButton.setSelected(true);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, VALID_MIS_VAL_RADIO_KEY);
        JRadioButton jRadioButton2 = new JRadioButton(toggleButtonAction);
        spssButtonGroup.add(jRadioButton2);
        this.mComponentsVector.add(spssButtonGroup);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jRadioButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jRadioButton2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void setTabTraversalOrder() {
        Component[] componentArray = this.mCmdButtonPanel.getComponents();
        this.mComponentsVector.addAll(Arrays.asList(componentArray));
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mComponentsVector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }
}

