/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.roc_curve;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.base.analyze.roc_curve.RocCurveOptions;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class RocCurveDlg
extends BaseProcedureDialog
implements ListDataListener,
DocumentListener,
ItemListener {
    static final String COORD_PT_KEY = "IDS_COORD_POINT_CHECK";
    static final String DIAGONAL_REF_KEY = "IDS_DIALOG_REF_CHECK";
    static final String ROC_CURVE_KEY = "IDS_ROC_CURVE_CHECK";
    static final String STATE_VAR_VAL_EDIT_KEY = "IDS_STATE_VAR_VAL_EDIT_KEY";
    static final String STD_ERROR_INTERVAL_KEY = "IDS_STD_ERROR_CHECK";
    private JCheckBox mCoordPtCheck;
    JCheckBox mDiagRefCheck;
    private JCheckBox mErrIntervalCheck;
    JCheckBox mRocCurveCheck;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mStateTargetVariableList;
    private StringTextField mStateVarValEdit;
    private TargetVariableList mTestTargetVariableList;
    private ArrowButton mTestVarArrowButton;
    private ArrowButton mStateVarArrow;
    private JButton mOptionsButton;

    public RocCurveDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_ROC_CURVE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_GROC";
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.mStateVarValEdit.setEnabled(this.mStateTargetVariableList.getModel().getSize() > 0);
        this.enableButtons();
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("ROC"));
        String string = this.mTestTargetVariableList.getVariablesStringList();
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(string));
        stringBuffer.append(" BY ");
        String string2 = this.mStateTargetVariableList.getVariablesStringList();
        stringBuffer.append(string2);
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string3 = dialogDataModel.getString(STATE_VAR_VAL_EDIT_KEY);
        boolean bl = false;
        try {
            Double.parseDouble(string3);
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            ComponentState.trace1((String)numberFormatException.getMessage(), (int)15);
        }
        if (bl) {
            stringBuffer.append(" (" + string3 + ")\n");
        } else {
            stringBuffer.append(" (" + CharacterUtil.smartQuote((String)dialogDataModel.getString(STATE_VAR_VAL_EDIT_KEY)) + ")\n");
        }
        Boolean bl2 = dialogDataModel.getBoolean(ROC_CURVE_KEY);
        if (bl2 != null && bl2.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/PLOT=CURVE"));
            bl2 = dialogDataModel.getBoolean(DIAGONAL_REF_KEY);
            if (bl2 != null && bl2.booleanValue()) {
                stringBuffer.append("(REFERENCE)");
            }
            stringBuffer.append("\n");
        } else {
            stringBuffer.append(SyntaxUtil.getSubCommand("/PLOT=NONE"));
            stringBuffer.append("\n");
        }
        bl2 = dialogDataModel.getBoolean(STD_ERROR_INTERVAL_KEY);
        StringBuffer stringBuffer2 = new StringBuffer();
        if (bl2 != null && bl2.booleanValue()) {
            stringBuffer2.append("SE");
        }
        if ((bl2 = dialogDataModel.getBoolean(COORD_PT_KEY)) != null && bl2.booleanValue()) {
            stringBuffer2.append(" COORDINATES");
        }
        if (stringBuffer2 != null && stringBuffer2.length() > 0) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/PRINT="));
            stringBuffer.append(stringBuffer2.toString() + "\n");
        }
        StringBuffer stringBuffer3 = new StringBuffer("CUTOFF");
        bl2 = dialogDataModel.getBoolean("IDS_EXC_CUTOFF_RADIO");
        if (bl2 != null && bl2.booleanValue()) {
            stringBuffer3.append("(EXCLUDE)");
        } else {
            stringBuffer3.append("(INCLUDE)");
        }
        stringBuffer3.append(" TESTPOS");
        bl2 = dialogDataModel.getBoolean("IDS_SMALLER_TEST_RADIO");
        if (bl2 != null && bl2.booleanValue()) {
            stringBuffer3.append("(SMALL)");
        } else {
            stringBuffer3.append("(LARGE)");
        }
        stringBuffer3.append(" DISTRIBUTION");
        Integer n = dialogDataModel.getInteger("IDS_DIST_ASSUM_COMBO");
        if (n != null && n == 1) {
            stringBuffer3.append("(NEGEXPO)");
        } else {
            stringBuffer3.append("(FREE)");
        }
        stringBuffer3.append(" CI");
        String string4 = dialogDataModel.getString("IDS_CONF_LEVEL_EDIT");
        if (string4 != null && string4.length() > 0) {
            stringBuffer3.append("(" + string4 + ")");
        } else {
            stringBuffer3.append("(95)");
        }
        stringBuffer.append(SyntaxUtil.getSubCommand("/CRITERIA="));
        stringBuffer.append(stringBuffer3.toString() + "\n");
        bl2 = dialogDataModel.getBoolean("IDS_VALID_MIS_VAL_RADIO");
        stringBuffer.append(SyntaxUtil.getSubCommand("/MISSING="));
        if (bl2 != null && bl2.booleanValue()) {
            stringBuffer.append("INCLUDE");
        } else {
            stringBuffer.append("EXCLUDE");
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public final String getIActionKey() {
        return "analyze_roc_curve";
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.mStateVarValEdit.setEnabled(this.mStateTargetVariableList.getModel().getSize() > 0);
        this.enableButtons();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.mStateVarValEdit.setEnabled(this.mStateTargetVariableList.getModel().getSize() > 0);
        this.enableButtons();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mRocCurveCheck) {
            this.mDiagRefCheck.setEnabled(this.mRocCurveCheck.isSelected());
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.mStateVarValEdit.setText("");
        this.mStateVarValEdit.setEnabled(false);
        this.mRocCurveCheck.setSelected(true);
        this.mDiagRefCheck.setEnabled(true);
        this.mDiagRefCheck.setSelected(false);
        this.mErrIntervalCheck.setSelected(false);
        this.mCoordPtCheck.setSelected(false);
        this.mTestTargetVariableList.removeAll();
        this.mStateTargetVariableList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mTestVarArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mStateVarArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
    }

    void runOptionsSubDialog() {
        this.runSubDialog(new RocCurveOptions(this));
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setupLists(jPanel);
        JPanel jPanel2 = this.setupStateValuePanel();
        JPanel jPanel3 = this.setupDisplayPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 10;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 4, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 10;
        n2 = DialogUtil.getComponentGroupGap();
        insets = new Insets(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 5, 3, 1, n, insets);
        this.setTabTraversalOrder();
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RocCurveDlg.this.runOptionsSubDialog();
            }
        };
        this.mOptionsButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mOptionsButton);
        return jPanel;
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mTestVarArrowButton);
        vector.add(this.mTestTargetVariableList);
        vector.add(this.mStateVarArrow);
        vector.add(this.mStateTargetVariableList);
        vector.add(this.mStateVarValEdit);
        vector.add(this.mRocCurveCheck);
        vector.add(this.mDiagRefCheck);
        vector.add(this.mErrIntervalCheck);
        vector.add(this.mCoordPtCheck);
        vector.add(this.mOptionsButton);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.setIdentifier("RocCurveTestVarList");
        this.mSrcVarList.loadFromActiveDataset();
        this.mStateTargetVariableList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mStateTargetVariableList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mStateTargetVariableList.setIdentifier("RocCurveStateTargetVarList");
        this.mTestTargetVariableList = new TargetVariableList();
        this.mTestTargetVariableList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTestTargetVariableList.addVarFilter(new SpssVarFilter(8, false));
        this.mTestTargetVariableList.setIdentifier("RocCurveTestTargetVarList");
        this.mTestVarArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mStateVarArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mStateVarArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mStateVarArrow.registerVariableList(this.mStateTargetVariableList, SpssArrowButton.ButtonOrientation.left);
        this.mTestVarArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mTestVarArrowButton.registerVariableList(this.mTestTargetVariableList, SpssArrowButton.ButtonOrientation.left);
        this.mStateVarValEdit = new StringTextField();
        this.mStateVarValEdit.setDocument(new FixedLengthDocument(29));
        this.mStateVarValEdit.setAction(new TextFieldAction(this, STATE_VAR_VAL_EDIT_KEY));
        this.mStateVarValEdit.setPreferredSize((Dimension)this.mStateVarValEdit.getPreferredSize().clone());
        this.mStateVarValEdit.setEnabled(false);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, ROC_CURVE_KEY);
        this.mRocCurveCheck = new JCheckBox(toggleButtonAction);
        this.mRocCurveCheck.setSelected(true);
        this.mRocCurveCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, DIAGONAL_REF_KEY);
        this.mDiagRefCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, STD_ERROR_INTERVAL_KEY);
        this.mErrIntervalCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, COORD_PT_KEY);
        this.mCoordPtCheck = new JCheckBox(toggleButtonAction);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mRocCurveCheck);
        spssButtonGroup.add(this.mDiagRefCheck);
        spssButtonGroup.add(this.mErrIntervalCheck);
        spssButtonGroup.add(this.mCoordPtCheck);
        this.mDiagRefCheck.setEnabled(this.mRocCurveCheck.isSelected());
        this.mSrcVarList.setSelectedIndex(0);
    }

    private void enableButtons() {
        String string = this.mStateVarValEdit.getText();
        this.enableOkPaste(string != null && string.length() > 0 && this.mTestTargetVariableList.getModel().getSize() > 0 && this.mStateTargetVariableList.getModel().getSize() > 0);
    }

    private JPanel setupDisplayPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_DISPLAY")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mRocCurveCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        Insets insets2 = new Insets(insets.top, insets.left + 20, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mDiagRefCheck, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mErrIntervalCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mCoordPtCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
        return jPanel;
    }

    private void setupLists(JPanel jPanel) {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_TEST_VARIABLE_COLON");
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_STATE_VARIABLE_COLON");
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_ROC_CURVE_SOURCE_LIST_LABEL");
        jLabel3.setLabelFor(this.mSrcVarList);
        jLabel.setLabelFor(this.mTestTargetVariableList);
        jLabel2.setLabelFor(this.mStateTargetVariableList);
        this.mTestTargetVariableList.getModel().addListDataListener(this);
        this.mStateTargetVariableList.getModel().addListDataListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 5, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mTestVarArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        jScrollPane = new JScrollPane(this.mTestTargetVariableList);
        this.mTestTargetVariableList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTestTargetVariableList.getFixedCellHeight() * 4 + 2));
        jScrollPane.setPreferredSize(this.mTestTargetVariableList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 1, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        n = 21;
        gridBagConstraints.fill = 2;
        Insets insets2 = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 2, 1, 1, n, insets2);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets2 = new Insets(0, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mStateVarArrow, gridBagConstraints, 1, 2, 1, 2, n, insets2);
        n = 20;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        jScrollPane = new JScrollPane(this.mStateTargetVariableList);
        jScrollPane.setPreferredSize(this.mStateTargetVariableList.getMinimumSize());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 3, 1, 1, n, null);
    }

    private JPanel setupStateValuePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        final JLabel jLabel = DialogUtil.createLabel(this, "IDS_VALUE_STATE_VARIABLE_COLON");
        jLabel.setLabelFor((Component)((Object)this.mStateVarValEdit));
        jLabel.setEnabled(false);
        this.mStateVarValEdit.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                    jLabel.setEnabled((Boolean)propertyChangeEvent.getNewValue());
                }
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mStateVarValEdit), gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mStateVarValEdit.getDocument().addDocumentListener(this);
        return jPanel;
    }
}

