/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.reports.report_summaries_in_column;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.base.analyze.reports.report_summaries_in_column.ReportSummariesInColumnsDlg;
import com.spss.java_client.ui.dialogs.base.analyze.reports.report_summaries_in_column.SummaryVarFormatter;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ReportColumnsDataTotalSummary
extends BaseSubDialog
implements ListDataListener {
    private TargetVariableList mSrcList;
    private JScrollPane mSrcScroll;
    private ArrowButton mArrowButton;
    private TargetVariableList mTargetVarList;
    private JScrollPane mTargetScroll;
    private JLabel mSummaryFunctionLabel;
    private JComboBox mSummaryFunctionCombobox;

    public ReportColumnsDataTotalSummary(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_REPORT_COLUMN_TOTAL_TITLE"), true);
    }

    @Override
    public boolean continuePressed() {
        TargetVariableList targetVariableList = ((ReportSummariesInColumnsDlg)this.mParentDlg).getDataTargetList();
        ReportSummariesInColumnsDlg.DataColsListVariable dataColsListVariable = (ReportSummariesInColumnsDlg.DataColsListVariable)((Object)targetVariableList.getSelectedValue());
        dataColsListVariable.setSummary(this.getFunctionValue());
        int n = targetVariableList.getSelectedIndex();
        targetVariableList.getModel().removeElementAt(n);
        targetVariableList.getModel().insertElementAt((ISpssVariable)dataColsListVariable, n);
        targetVariableList.setSelectedIndex(n);
        if ((this.mSummaryFunctionCombobox.getSelectedItem().equals(this.getResString("IDS_SUBTRACT_COLUMNS")) || this.mSummaryFunctionCombobox.getSelectedItem().equals(this.getResString("IDS_DIVIDE_COLUMNS")) || this.mSummaryFunctionCombobox.getSelectedItem().equals(this.getResString("IDS_REMAINDER_OF_COLUMNS"))) && this.mTargetVarList.getModel().getSize() > 2) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mParentDlg), this.getResString("ERR_SUMMARY_FUNCTION_WARNING"), VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.changeStateOfComboBox((VarListModel)listDataEvent.getSource());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.changeStateOfComboBox((VarListModel)listDataEvent.getSource());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.changeStateOfComboBox((VarListModel)listDataEvent.getSource());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_rptc_totsummary";
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        TargetVariableList targetVariableList = ((ReportSummariesInColumnsDlg)this.mParentDlg).getDataTargetList();
        ReportSummariesInColumnsDlg.DataColsListVariable dataColsListVariable = (ReportSummariesInColumnsDlg.DataColsListVariable)((Object)targetVariableList.getSelectedValue());
        if (dataColsListVariable.isSummaryDialogStateSaved()) {
            this.mSummaryFunctionCombobox.setSelectedIndex(dataColsListVariable.getSummaryFunctionIndex());
            this.mSummaryFunctionCombobox.setEnabled(dataColsListVariable.isSummaryFunctionEnabled());
            this.mSummaryFunctionLabel.setEnabled(dataColsListVariable.isSummaryFunctionEnabled());
            this.mTargetVarList.setModel(dataColsListVariable.getSummaryListModel());
            this.mTargetVarList.getModel().addListDataListener(this);
            VarListModel varListModel = this.mSrcList.getModel();
            VarListModel varListModel2 = targetVariableList.getModel();
            varListModel.removeAll();
            for (int i = 0; i < varListModel2.getSize(); ++i) {
                ReportSummariesInColumnsDlg.DataColsListVariable dataColsListVariable2 = (ReportSummariesInColumnsDlg.DataColsListVariable)varListModel2.getElementAt(i);
                boolean bl = false;
                if (dataColsListVariable2.getName().equals(this.getResString("IDS_COLUMN_DATA_TOTAL")) || this.mTargetVarList.getModel() == null) continue;
                for (int j = 0; j < this.mTargetVarList.getModel().getSize(); ++j) {
                    if (!this.mTargetVarList.getModel().getElementAt(j).equals((ISpssVariable)dataColsListVariable2)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                varListModel.addElement((ISpssVariable)dataColsListVariable2);
            }
        }
        this.populateSourceList();
        this.mSrcList.requestFocusInWindow();
        this.mSrcList.setSelectedIndex(0);
        this.mArrowButton.setEnabled(this.mSrcList.getSelectedIndex() > -1);
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        TargetVariableList targetVariableList = ((ReportSummariesInColumnsDlg)this.mParentDlg).getDataTargetList();
        ReportSummariesInColumnsDlg.DataColsListVariable dataColsListVariable = (ReportSummariesInColumnsDlg.DataColsListVariable)((Object)targetVariableList.getSelectedValue());
        dataColsListVariable.setSummaryFunctionIndex(this.mSummaryFunctionCombobox.getSelectedIndex());
        dataColsListVariable.setSummaryListModel(this.mTargetVarList.getModel());
        dataColsListVariable.setSummaryFunctionEnabled(this.mSummaryFunctionCombobox.isEnabled());
        dataColsListVariable.setSummaryDialogStateSaved(true);
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        JPanel jPanel = this.getViewPanel();
        this.setUpUI(jPanel);
        this.pack();
    }

    private void initVars() {
        this.mSrcList = new TargetVariableList();
        this.mSrcList.setIdentifier("SRC_LIST");
        this.mSrcList.setCellRenderer(new CustomVarListCellRenderer(new SummaryVarFormatter(this.mTargetVarList)));
        this.mSrcList.setAllowDuplicates(true);
        this.mSrcScroll = new JScrollPane(this.mSrcList);
        this.mSrcScroll.setPreferredSize(this.mSrcList.getMinimumSize());
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.setCellRenderer(new CustomVarListCellRenderer(new SummaryVarFormatter(this.mTargetVarList)));
        this.mTargetVarList.setAllowDuplicates(true);
        this.mTargetVarList.setIdentifier("TARGET_LIST");
        this.mTargetScroll = new JScrollPane(this.mTargetVarList);
        this.mTargetScroll.setPreferredSize(this.mTargetVarList.getMinimumSize());
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mArrowButton = new ArrowButton();
        this.mArrowButton.registerVariableList(this.mSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        String[] stringArray = new String[]{this.getResString("IDS_SUM_OF_COLUMNS"), this.getResString("IDS_MEAN_OF_COLUMNS"), this.getResString("IDS_MINIMUM_OF_COLUMNS"), this.getResString("IDS_MAXIMUM_OF_COLUMNS"), this.getResString("IDS_SUBTRACT_COLUMNS"), this.getResString("IDS_DIVIDE_COLUMNS"), this.getResString("IDS_REMAINDER_OF_COLUMNS"), this.getResString("IDS_MULTIPLY_COLUMNS")};
        this.mSummaryFunctionLabel = DialogUtil.createLabel(this, "IDS_TOTAL_SUMMARY_FUNCTION");
        this.mSummaryFunctionCombobox = new JComboBox<String>(stringArray);
        this.mSummaryFunctionCombobox.setAction(new ComboboxAction(this, this.getResString("IDS_TOTAL_SUMMARY_FUNCTION")));
        this.mSummaryFunctionLabel.setEnabled(false);
        this.mSummaryFunctionLabel.setLabelFor(this.mSummaryFunctionCombobox);
        this.mSummaryFunctionCombobox.setEnabled(false);
        this.mArrowButton.setEnabled(this.mSrcList.getModel().getSize() > 0);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mSummaryFunctionCombobox);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void setUpUI(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_TOTAL_DATA_COLUMNS");
        jLabel.setLabelFor(this.mSrcList);
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, 23, insets);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_TOTAL_SUMMARY_COLUMN");
        jLabel2.setLabelFor(this.mTargetVarList);
        Insets insets2 = DialogUtil.getStandardControlInsets();
        insets = new Insets(n, insets2.left, 0, n);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel2, jLabel2, gridBagConstraints, 2, 0, 1, 1, 23, insets);
        insets = new Insets(insets2.top, n, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel2, this.mSrcScroll, gridBagConstraints, 0, 1, 1, 1, 23, insets);
        insets = DialogUtil.getArrowButtonInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, 10, insets);
        insets = new Insets(insets2.top, insets2.left, 0, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel2, this.mTargetScroll, gridBagConstraints, 2, 1, 1, 1, 23, insets);
        int n2 = DialogUtil.getComponentGroupGap();
        insets = new Insets(n2, n, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, this.mSummaryFunctionLabel, gridBagConstraints, 0, 2, 1, 1, 23, insets);
        insets = new Insets(n2, insets2.left, 0, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel2, this.mSummaryFunctionCombobox, gridBagConstraints, 1, 2, 2, 1, 23, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, 23, null);
    }

    private String getFunctionValue() {
        String[] stringArray = this.getResStringArray("IDS_REPORT_CLOUMN_DATA_TOTAL_SUMMARY_FUNCTIONS");
        if (this.mSummaryFunctionCombobox.getSelectedItem().equals(this.getResString("IDS_SUM_OF_COLUMNS"))) {
            return stringArray[0];
        }
        if (this.mSummaryFunctionCombobox.getSelectedItem().equals(this.getResString("IDS_MEAN_OF_COLUMNS"))) {
            return stringArray[1];
        }
        if (this.mSummaryFunctionCombobox.getSelectedItem().equals(this.getResString("IDS_MINIMUM_OF_COLUMNS"))) {
            return stringArray[2];
        }
        if (this.mSummaryFunctionCombobox.getSelectedItem().equals(this.getResString("IDS_MAXIMUM_OF_COLUMNS"))) {
            return stringArray[3];
        }
        if (this.mSummaryFunctionCombobox.getSelectedItem().equals(this.getResString("IDS_SUBTRACT_COLUMNS"))) {
            return stringArray[4];
        }
        if (this.mSummaryFunctionCombobox.getSelectedItem().equals(this.getResString("IDS_DIVIDE_COLUMNS"))) {
            return stringArray[5];
        }
        if (this.mSummaryFunctionCombobox.getSelectedItem().equals(this.getResString("IDS_REMAINDER_OF_COLUMNS"))) {
            return stringArray[6];
        }
        if (this.mSummaryFunctionCombobox.getSelectedItem().equals(this.getResString("IDS_MULTIPLY_COLUMNS"))) {
            return stringArray[7];
        }
        return stringArray[0];
    }

    private void populateSourceList() {
        int n = 0;
        VarListModel varListModel = this.mSrcList.getModel();
        varListModel.removeAll();
        VarListModel varListModel2 = ((ReportSummariesInColumnsDlg)this.mParentDlg).getDataTargetList().getModel();
        for (int i = 0; i < varListModel2.getSize(); ++i) {
            ReportSummariesInColumnsDlg.DataColsListVariable dataColsListVariable = (ReportSummariesInColumnsDlg.DataColsListVariable)varListModel2.getElementAt(i);
            if (!dataColsListVariable.getName().equals(this.getResString("IDS_COLUMN_DATA_TOTAL"))) {
                varListModel.addElement((ISpssVariable)dataColsListVariable);
                continue;
            }
            ++n;
        }
        if (n + varListModel.getSize() + this.mTargetVarList.getModel().getSize() > varListModel2.getSize()) {
            VarListModel varListModel3 = this.mTargetVarList.getModel();
            for (int i = 0; i < varListModel3.getSize(); ++i) {
                ReportSummariesInColumnsDlg.DataColsListVariable dataColsListVariable = (ReportSummariesInColumnsDlg.DataColsListVariable)varListModel3.getElementAt(i);
                varListModel.removeElement((ISpssVariable)dataColsListVariable);
            }
        }
    }

    private void changeStateOfComboBox(VarListModel varListModel) {
        if (varListModel.getSize() < 2) {
            this.mSummaryFunctionLabel.setEnabled(false);
            this.mSummaryFunctionCombobox.setEnabled(false);
        } else {
            this.mSummaryFunctionLabel.setEnabled(true);
            this.mSummaryFunctionCombobox.setEnabled(true);
        }
    }
}

