/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.reports.report_summaries_in_column;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.dialogs.base.analyze.reports.report_summaries_in_column.ReportSummariesInColumnsDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.SPSSTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ReportColumnsDataSummary
extends BaseSubDialog
implements ItemListener,
DocumentListener {
    static final String SUM_OF_VALUES = "IDS_REPORT_COLUMN_BREAK_SUM";
    static final String MEAN_OF_VALUES = "IDS_REPORT_COLUMN_BREAK_MEAN";
    static final String MINIMUM_VALUES = "IDS_REPORT_COLUMN_BREAK_MINIMUM";
    static final String MAXIMUM_VALUES = "IDS_REPORT_COLUMN_BREAK_MAXIMUM";
    static final String NUMBER_OF_CASES = "IDS_REPORT_COLUMN_BREAK_CASES";
    static final String PERCENTAGE_ABOVE = "IDS_REPORT_COLUMN_BREAK_PERCENTAGEABOVE";
    static final String PERCENTAGE_BELOW = "IDS_REPORT_COLUMN_BREAK_PERCENTAGEBELOW";
    static final String PERCENTAGE_INSIDE = "IDS_REPORT_COLUMN_BREAK_PERCENTAGEINSIDE";
    static final String STANDARD_DEVIATION = "IDS_REPORT_COLUMN_BREAK_DEVIATION";
    static final String KURTOSIS = "IDS_REPORT_COLUMN_BREAK_KURTOSIS";
    static final String VARIANCE = "IDS_REPORT_COLUMN_BREAK_VARIANCE";
    static final String SKEWNESS = "IDS_REPORT_COLUMN_BREAK_SKEWNESS";
    static final String PERCENTAGE_ABOVE_VALUE_TEXT = "IDS_REPORT_COLUMN_PERCINS_ABOVE_TEXT";
    static final String PERCENTAGE_BELOW_VALUE_TEXT = "IDS_REPORT_COLUMN_PERCINS_BELOW_TEXT";
    static final String PERCENTAGE_INSIDE_LOW_TEXT = "IDS_REPORT_COLUMN_PERCINS_LOW_TEXT";
    static final String PERCENTAGE_INSIDE_HIGH_TEXT = "IDS_REPORT_COLUMN_PERCINS_HIGH_TEXT";
    private JPanel mValuesPanel;
    private JPanel mPercentageValue;
    private JPanel mPercentageLowHighPanel;
    private JRadioButton mSumOfvalues;
    private JRadioButton mMeanOfValues;
    private JRadioButton mMinimumValues;
    private JRadioButton mMaximumValues;
    private JRadioButton mNumberOfCases;
    private JRadioButton mStandardDeviation;
    private JRadioButton mKurtosis;
    private JRadioButton mVariance;
    private JRadioButton mSkewness;
    private JRadioButton mPercentageAbove;
    private JRadioButton mPercentageBelow;
    private JRadioButton mPercentageInside;
    private SpssButtonGroup mSummaryButtonGroup;
    private JLabel mPercentageAboveValue;
    private JLabel mPercentageInsideLow;
    private JLabel mPercentageInsideHigh;
    private FloatTextField mPercentageAboveText;
    private FloatTextField mPercentageInsideLowText;
    private FloatTextField mPercentageInsideHighText;

    public ReportColumnsDataSummary(BaseProcedureDialog baseProcedureDialog, String string) {
        super(baseProcedureDialog, String.format(baseProcedureDialog.getResString("IDS_REPORT_COLUMN_BREAK_SUMMARIES"), string), true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        Object object = itemEvent.getItem();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (object == this.mPercentageAbove) {
            this.mPercentageAboveText.setEnabled(bl);
            this.mPercentageAboveValue.setEnabled(bl);
            this.mPercentageAboveText.setOpaque(bl);
            this.updateContinueButton();
        } else if (object == this.mPercentageBelow) {
            this.mPercentageAboveText.setEnabled(bl);
            this.mPercentageAboveValue.setEnabled(bl);
            this.mPercentageAboveText.setOpaque(bl);
            this.updateContinueButton();
        } else if (object == this.mPercentageInside) {
            this.mPercentageInsideLowText.setEnabled(bl);
            this.mPercentageInsideLow.setEnabled(bl);
            this.mPercentageInsideHighText.setEnabled(bl);
            this.mPercentageInsideHigh.setEnabled(bl);
            this.mPercentageInsideLowText.setOpaque(bl);
            this.mPercentageInsideHighText.setOpaque(bl);
            this.updateContinueButton();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public boolean continuePressed() {
        TargetVariableList targetVariableList = ((ReportSummariesInColumnsDlg)this.mParentDlg).getDataTargetList();
        ReportSummariesInColumnsDlg.DataColsListVariable dataColsListVariable = (ReportSummariesInColumnsDlg.DataColsListVariable)((Object)targetVariableList.getSelectedValue());
        dataColsListVariable.setSummary(this.getSummaryValue());
        int n = targetVariableList.getSelectedIndex();
        targetVariableList.getModel().removeElementAt(n);
        targetVariableList.getModel().insertElementAt((ISpssVariable)dataColsListVariable, n);
        targetVariableList.setSelectedIndex(n);
        if (this.mPercentageInside.isSelected() && !this.mPercentageInsideLowText.getText().equals("") && !this.mPercentageInsideHighText.getText().equals("") && Float.valueOf(this.mPercentageInsideLowText.getText()).floatValue() > Float.valueOf(this.mPercentageInsideHighText.getText()).floatValue()) {
            SPSSTextField.showWarningDialog((JComponent)this.mPercentageInsideLowText, (String)this.getResString("ERR_REPORT_COMPARE_WARNING"), (String)ResUtil.getString("IDS_WARNING_TITLE"));
            this.mPercentageInsideLowText.setSelectionStart(0);
            this.mPercentageInsideLowText.setSelectionEnd(this.mPercentageInsideLowText.getText().length());
            this.mPercentageInsideLowText.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_rptc_sumfunct";
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        String[] stringArray;
        TargetVariableList targetVariableList = ((ReportSummariesInColumnsDlg)this.mParentDlg).getDataTargetList();
        ReportSummariesInColumnsDlg.DataColsListVariable dataColsListVariable = (ReportSummariesInColumnsDlg.DataColsListVariable)((Object)targetVariableList.getSelectedValue());
        String string = dataColsListVariable.getSummaryCheckValue();
        if (string.equals("Sum")) {
            this.mSumOfvalues.setSelected(true);
        }
        if (string.equals("Mean")) {
            this.mMeanOfValues.setSelected(true);
        }
        if (string.equals("Minimum")) {
            this.mMinimumValues.setSelected(true);
        }
        if (string.equals("Maximum")) {
            this.mMaximumValues.setSelected(true);
        }
        if (string.equals("N")) {
            this.mNumberOfCases.setSelected(true);
        }
        if (string.equals("StdDev")) {
            this.mStandardDeviation.setSelected(true);
        }
        if (string.equals("Variance")) {
            this.mVariance.setSelected(true);
        }
        if (string.equals("Kurtosis")) {
            this.mKurtosis.setSelected(true);
        }
        if (string.equals("Skewness")) {
            this.mSkewness.setSelected(true);
        }
        if (string.equals("Above")) {
            this.mPercentageAbove.setSelected(true);
            stringArray = dataColsListVariable.getPercentValues();
            this.mPercentageAboveText.setText(stringArray[0]);
        }
        if (string.equals("Below")) {
            this.mPercentageBelow.setSelected(true);
            stringArray = dataColsListVariable.getPercentValues();
            this.mPercentageAboveText.setText(stringArray[0]);
        }
        if (string.equals("Inside")) {
            this.mPercentageInside.setSelected(true);
            stringArray = dataColsListVariable.getPercentValues();
            this.mPercentageInsideLowText.setText(stringArray[0]);
            this.mPercentageInsideHighText.setText(stringArray[1]);
        }
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        TargetVariableList targetVariableList = ((ReportSummariesInColumnsDlg)this.mParentDlg).getDataTargetList();
        ReportSummariesInColumnsDlg.DataColsListVariable dataColsListVariable = (ReportSummariesInColumnsDlg.DataColsListVariable)((Object)targetVariableList.getSelectedValue());
        if (this.mSumOfvalues.isSelected()) {
            dataColsListVariable.setSummaryCheckValue("Sum");
        }
        if (this.mMeanOfValues.isSelected()) {
            dataColsListVariable.setSummaryCheckValue("Mean");
        }
        if (this.mMinimumValues.isSelected()) {
            dataColsListVariable.setSummaryCheckValue("Minimum");
        }
        if (this.mMaximumValues.isSelected()) {
            dataColsListVariable.setSummaryCheckValue("Maximum");
        }
        if (this.mNumberOfCases.isSelected()) {
            dataColsListVariable.setSummaryCheckValue("N");
        }
        if (this.mStandardDeviation.isSelected()) {
            dataColsListVariable.setSummaryCheckValue("StdDev");
        }
        if (this.mVariance.isSelected()) {
            dataColsListVariable.setSummaryCheckValue("Variance");
        }
        if (this.mKurtosis.isSelected()) {
            dataColsListVariable.setSummaryCheckValue("Kurtosis");
        }
        if (this.mSkewness.isSelected()) {
            dataColsListVariable.setSummaryCheckValue("Skewness");
        }
        if (this.mPercentageAbove.isSelected()) {
            dataColsListVariable.setSummaryCheckValue("Above");
            dataColsListVariable.setPercentValues(this.mPercentageAboveText.getText(), "");
        }
        if (this.mPercentageBelow.isSelected()) {
            dataColsListVariable.setSummaryCheckValue("Below");
            dataColsListVariable.setPercentValues(this.mPercentageAboveText.getText(), "");
        }
        if (this.mPercentageInside.isSelected()) {
            dataColsListVariable.setSummaryCheckValue("Inside");
            dataColsListVariable.setPercentValues(this.mPercentageInsideLowText.getText(), this.mPercentageInsideHighText.getText());
        }
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        JPanel jPanel = this.getViewPanel();
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, DialogUtil.getComponentGroupGap(), 0);
        int n = 23;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mValuesPanel = this.setUpValuesPanel();
        this.mPercentageValue = this.setUpPercentageValuePanel();
        this.mPercentageLowHighPanel = this.setUpPercentageLowHighPanel();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mValuesPanel, gridBagConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.mPercentageValue, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mPercentageLowHighPanel, gridBagConstraints, 0, 2, 1, 1, n, null);
        this.pack();
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, SUM_OF_VALUES);
        this.mSumOfvalues = new JRadioButton(toggleButtonAction);
        this.mSumOfvalues.setSelected(true);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, MEAN_OF_VALUES);
        this.mMeanOfValues = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, MINIMUM_VALUES);
        this.mMinimumValues = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, MAXIMUM_VALUES);
        this.mMaximumValues = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, NUMBER_OF_CASES);
        this.mNumberOfCases = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, STANDARD_DEVIATION);
        this.mStandardDeviation = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, KURTOSIS);
        this.mKurtosis = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, VARIANCE);
        this.mVariance = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, SKEWNESS);
        this.mSkewness = new JRadioButton(toggleButtonAction);
        this.mPercentageAboveValue = DialogUtil.createLabel(this, "IDS_REPORT_COLUMN_BREAK_PERCABOVE_VAL");
        this.mPercentageAboveValue.setEnabled(false);
        this.mPercentageAboveText = new FloatTextField(-9999999.0, 9.9999999E7, 15, false);
        this.mPercentageAboveText.setColumns(5);
        this.mPercentageAboveText.setAction((Action)new TextFieldAction(this.mParentDlg, PERCENTAGE_ABOVE_VALUE_TEXT));
        this.mPercentageAboveText.setEnabled(false);
        this.mPercentageAboveText.setOpaque(false);
        this.mPercentageAboveText.getDocument().addDocumentListener(this);
        this.mPercentageAboveValue.setLabelFor((Component)this.mPercentageAboveText);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, PERCENTAGE_ABOVE);
        this.mPercentageAbove = new JRadioButton(toggleButtonAction);
        this.mPercentageAbove.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, PERCENTAGE_BELOW);
        this.mPercentageBelow = new JRadioButton(toggleButtonAction);
        this.mPercentageBelow.addItemListener(this);
        this.mPercentageInsideLow = DialogUtil.createLabel(this, "IDS_REPORT_COLUMN_BREAK_PERCINS_LOW");
        this.mPercentageInsideLow.setEnabled(false);
        this.mPercentageInsideLowText = new FloatTextField(-9999999.0, 9.9999999E7, 15, false);
        this.mPercentageInsideLowText.setColumns(5);
        this.mPercentageInsideLowText.setAction((Action)new TextFieldAction(this.mParentDlg, PERCENTAGE_INSIDE_LOW_TEXT));
        this.mPercentageInsideLowText.setEnabled(false);
        this.mPercentageInsideLowText.setOpaque(false);
        this.mPercentageInsideLowText.getDocument().addDocumentListener(this);
        this.mPercentageInsideLow.setLabelFor((Component)this.mPercentageInsideLowText);
        this.mPercentageInsideHigh = DialogUtil.createLabel(this, "IDS_REPORT_COLUMN_BREAK_PERCINS_HIGH");
        this.mPercentageInsideHigh.setEnabled(false);
        this.mPercentageInsideHighText = new FloatTextField(-9999999.0, 9.9999999E7, 15, false);
        this.mPercentageInsideHighText.setColumns(5);
        this.mPercentageInsideHighText.setAction((Action)new TextFieldAction(this.mParentDlg, PERCENTAGE_INSIDE_HIGH_TEXT));
        this.mPercentageInsideHighText.setEnabled(false);
        this.mPercentageInsideHighText.setOpaque(false);
        this.mPercentageInsideHighText.getDocument().addDocumentListener(this);
        this.mPercentageInsideHigh.setLabelFor((Component)this.mPercentageInsideHighText);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, PERCENTAGE_INSIDE);
        this.mPercentageInside = new JRadioButton(toggleButtonAction);
        this.mPercentageInside.addItemListener(this);
        this.mSummaryButtonGroup = new SpssButtonGroup();
        this.mSummaryButtonGroup.add(this.mSumOfvalues);
        this.mSummaryButtonGroup.add(this.mMeanOfValues);
        this.mSummaryButtonGroup.add(this.mMinimumValues);
        this.mSummaryButtonGroup.add(this.mMaximumValues);
        this.mSummaryButtonGroup.add(this.mNumberOfCases);
        this.mSummaryButtonGroup.add(this.mStandardDeviation);
        this.mSummaryButtonGroup.add(this.mVariance);
        this.mSummaryButtonGroup.add(this.mKurtosis);
        this.mSummaryButtonGroup.add(this.mSkewness);
        this.mSummaryButtonGroup.add(this.mPercentageAbove);
        this.mSummaryButtonGroup.add(this.mPercentageBelow);
        this.mSummaryButtonGroup.add(this.mPercentageInside);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSummaryButtonGroup);
        vector.add(this.mPercentageAboveText);
        vector.add(this.mPercentageInsideLowText);
        vector.add(this.mPercentageInsideHighText);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private JPanel setUpValuesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        int n = 23;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mSumOfvalues, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mMeanOfValues, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mMinimumValues, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mMaximumValues, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mNumberOfCases, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mStandardDeviation, gridBagConstraints, 2, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mVariance, gridBagConstraints, 2, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mKurtosis, gridBagConstraints, 2, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSkewness, gridBagConstraints, 2, 3, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setUpPercentageValuePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        int n = 24;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(DialogUtil.getGroupBoxInnerMargin(), 0, 0, DialogUtil.getGroupBoxInnerMargin());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mPercentageAboveValue, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        n = 23;
        gridBagConstraints.weightx = 1.0;
        insets2 = new Insets(DialogUtil.getGroupBoxInnerMargin(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mPercentageAboveText, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mPercentageAbove, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mPercentageBelow, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setUpPercentageLowHighPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        int n = 23;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(DialogUtil.getGroupBoxInnerMargin(), 0, 0, 0);
        Insets insets3 = new Insets(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), 0, DialogUtil.getGroupBoxInnerMargin());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 24;
        DialogUtil.addUsingGBL(jPanel, this.mPercentageInsideLow, gridBagConstraints, 0, 0, 1, 1, n, insets3);
        n = 23;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mPercentageInsideLowText, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        n = 24;
        DialogUtil.addUsingGBL(jPanel, this.mPercentageInsideHigh, gridBagConstraints, 2, 0, 1, 1, n, insets3);
        n = 23;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mPercentageInsideHighText, gridBagConstraints, 3, 0, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mPercentageInside, gridBagConstraints, 0, 1, 4, 1, n, insets);
        return jPanel;
    }

    private void updateContinueButton() {
        boolean bl = true;
        if (this.mPercentageAbove.isSelected()) {
            boolean bl2 = bl = this.mPercentageAboveText.getText().length() > 0;
        }
        if (this.mPercentageBelow.isSelected()) {
            boolean bl3 = bl = this.mPercentageAboveText.getText().length() > 0;
        }
        if (this.mPercentageInside.isSelected()) {
            boolean bl4 = bl = this.mPercentageInsideLowText.getText().length() > 0;
            if (bl) {
                bl = this.mPercentageInsideHighText.getText().length() > 0;
            }
        }
        this.enableContinue(bl);
    }

    private String getSummaryValue() {
        String[] stringArray = this.getResStringArray("IDS_REPORT_COLUMN_DATA_SUMMARY_FUNCTIONS");
        if (this.mSumOfvalues.isSelected()) {
            return stringArray[0];
        }
        if (this.mMeanOfValues.isSelected()) {
            return stringArray[1];
        }
        if (this.mMinimumValues.isSelected()) {
            return stringArray[2];
        }
        if (this.mMaximumValues.isSelected()) {
            return stringArray[3];
        }
        if (this.mNumberOfCases.isSelected()) {
            return stringArray[4];
        }
        if (this.mStandardDeviation.isSelected()) {
            return stringArray[5];
        }
        if (this.mVariance.isSelected()) {
            return stringArray[6];
        }
        if (this.mKurtosis.isSelected()) {
            return stringArray[7];
        }
        if (this.mSkewness.isSelected()) {
            return stringArray[8];
        }
        if (this.mPercentageAbove.isSelected()) {
            return stringArray[9] + ">";
        }
        if (this.mPercentageBelow.isSelected()) {
            return stringArray[9] + "<";
        }
        if (this.mPercentageInside.isSelected()) {
            return stringArray[9] + "<>";
        }
        return null;
    }
}

