/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.reports.olap_cubes;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.PlainListArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.drag_drop.PlainListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PlainListDropListener;
import com.spss.java_client.ui.dialogs.base.analyze.reports.olap_cubes.OlapCubesDlg;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IPlainListVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class OlapCubesStatistics
extends BaseSubDialog
implements ListDataListener,
FocusListener,
ActionListener,
IPlainListVarMoveHandler {
    static final String PERCENT_OF_N_STR = "IDS_OC_PERCENT_OF_N_IN";
    static final String PERCENT_OF_SUM_STR = "IDS_OC_PERCENT_OF_SUM_IN";
    static final String SOURCE_KEY = "sourceCmdKey";
    static final String TARGET_KEY = "targetCmdKey";
    private PlainList mSourceList;
    private JScrollPane mSourceScroll;
    private JScrollPane mTargetScroll;
    private PlainList mTargetList;
    private PlainListArrowButton mArrowButton;
    private JLabel mStatisticsLabel;
    private JLabel mCellStatisticsLabel;
    private int mSelectedItems = 0;

    public OlapCubesStatistics(OlapCubesDlg olapCubesDlg) {
        super(olapCubesDlg, olapCubesDlg.getResString("IDS_OC_STATS_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_repo_statistics";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray;
        if (this.mArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.right) {
            Object[] objectArray2 = this.mSourceList.getSelectedValues();
            if (objectArray2.length > 0) {
                String string;
                Object object;
                int n = 0;
                int n2 = 0;
                Object[] objectArray3 = objectArray2;
                int n3 = objectArray3.length;
                for (int i = 0; i < n3; ++i) {
                    object = objectArray3[i];
                    string = object.toString();
                    if (string.contains(this.getResString(PERCENT_OF_SUM_STR))) {
                        if (++n <= 1) continue;
                        SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_OC_DUPLICATE_PERCENT_OF_SUM_WARN_MSG"), VersionInfo.getAppVersionString());
                        break;
                    }
                    if (!string.contains(this.getResString(PERCENT_OF_N_STR)) || ++n2 <= 1) continue;
                    SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_OC_DUPLICATE_PERCENT_OF_N_WARN_MSG"), VersionInfo.getAppVersionString());
                    break;
                }
                if (n < 2 && n2 < 2) {
                    if (n == 1 || n2 == 1) {
                        boolean bl = false;
                        for (n3 = 0; n3 < this.mTargetList.getModel().getSize(); ++n3) {
                            String string2 = (String)this.mTargetList.getModel().getElementAt(n3);
                            if (!string2.contains(this.getResString(PERCENT_OF_SUM_STR)) && !string2.contains(this.getResString(PERCENT_OF_N_STR))) continue;
                            bl = true;
                            object = null;
                            if (n == 1 && n2 == 1) {
                                String string3 = string = objectArray2.length > 0 ? objectArray2[0] : null;
                                if (string != null) {
                                    String string4 = string.toString();
                                    String string5 = string4.substring(11, 12);
                                    object = string5.equalsIgnoreCase("N") ? this.getResString("ERR_OC_DUPLICATE_PERCENT_OF_N_WARN_MSG") : this.getResString("ERR_OC_DUPLICATE_PERCENT_OF_SUM_WARN_MSG");
                                }
                            } else if (n == 1 && n2 == 0) {
                                if (string2.contains(this.getResString(PERCENT_OF_SUM_STR))) {
                                    object = this.getResString("ERR_OC_DUPLICATE_PERCENT_OF_SUM_WARN_MSG");
                                } else {
                                    bl = false;
                                }
                            } else if (n == 0) {
                                if (string2.contains(this.getResString(PERCENT_OF_N_STR))) {
                                    object = this.getResString("ERR_OC_DUPLICATE_PERCENT_OF_N_WARN_MSG");
                                } else {
                                    bl = false;
                                }
                            }
                            if (object == null) continue;
                            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), (String)object, VersionInfo.getAppVersionString());
                            break;
                        }
                        if (!bl) {
                            this.moveToTargetList(objectArray2);
                        }
                    } else {
                        this.moveToTargetList(objectArray2);
                    }
                }
            }
        } else if (this.mArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.left && (objectArray = this.mTargetList.getSelectedValues()).length > 0) {
            this.moveToSourceList(objectArray);
        }
        this.enableContinue(this.mTargetList.getModel().getSize() > 0);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.mTargetList.getModel())) {
            this.enableContinue(this.mTargetList.getModel().getSize() > 0);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.mTargetList.getModel())) {
            this.enableContinue(this.mTargetList.getModel().getSize() > 0);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mSourceList)) {
            this.mTargetList.clearSelection();
            if (this.mSelectedItems > 0) {
                this.mSourceList.setSelectionInterval(this.mSourceList.getModel().getSize() - this.mSelectedItems, this.mSourceList.getModel().getSize() - 1);
                this.mSelectedItems = 0;
            }
        } else if (focusEvent.getSource().equals(this.mTargetList)) {
            this.mSourceList.clearSelection();
            this.mTargetList.requestFocusInWindow();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public boolean isDragAllowed(JList jList, JList jList2, Object[] objectArray) {
        return true;
    }

    @Override
    public Object[] getModifiedData(Object[] objectArray, JList jList, PlainList plainList) {
        return null;
    }

    @Override
    public boolean preMoveVariables(Object[] objectArray, PlainList plainList) {
        Object[] objectArray2;
        if (plainList.equals(this.mTargetList) && (objectArray2 = this.mSourceList.getSelectedValues()).length > 0) {
            String string;
            int n = 0;
            int n2 = 0;
            for (Object object : objectArray2) {
                string = object.toString();
                if (string.contains(this.getResString(PERCENT_OF_SUM_STR))) {
                    if (++n <= 1) continue;
                    SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_OC_DUPLICATE_PERCENT_OF_SUM_WARN_MSG"), VersionInfo.getAppVersionString());
                    return false;
                }
                if (!string.contains(this.getResString(PERCENT_OF_N_STR)) || ++n2 <= 1) continue;
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_OC_DUPLICATE_PERCENT_OF_N_WARN_MSG"), VersionInfo.getAppVersionString());
                return false;
            }
            if (n < 2 && n2 < 2 && (n == 1 || n2 == 1)) {
                for (int i = 0; i < this.mTargetList.getModel().getSize(); ++i) {
                    String string2 = (String)this.mTargetList.getModel().getElementAt(i);
                    if (!string2.contains(this.getResString(PERCENT_OF_SUM_STR)) && !string2.contains(this.getResString(PERCENT_OF_N_STR))) continue;
                    String string3 = null;
                    if (n == 1 && n2 == 1) {
                        Object object;
                        Object object2 = object = objectArray2.length > 0 ? objectArray2[0] : null;
                        if (object != null) {
                            string = object.toString();
                            String string4 = string.substring(11, 12);
                            string3 = string4.equalsIgnoreCase("N") ? this.getResString("ERR_OC_DUPLICATE_PERCENT_OF_N_WARN_MSG") : this.getResString("ERR_OC_DUPLICATE_PERCENT_OF_SUM_WARN_MSG");
                        }
                    } else if (n == 1 && n2 == 0) {
                        if (string2.contains(this.getResString(PERCENT_OF_SUM_STR))) {
                            string3 = this.getResString("ERR_OC_DUPLICATE_PERCENT_OF_SUM_WARN_MSG");
                        }
                    } else if (n == 0 && string2.contains(this.getResString(PERCENT_OF_N_STR))) {
                        string3 = this.getResString("ERR_OC_DUPLICATE_PERCENT_OF_N_WARN_MSG");
                    }
                    if (string3 == null) continue;
                    SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), string3, VersionInfo.getAppVersionString());
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            this.addDragAdapters();
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupJListsPanel(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        void var7_22;
        String string5;
        int n;
        super.loadState(dialogDataModel);
        DefaultListModel defaultListModel = (DefaultListModel)this.mSourceList.getModel();
        DefaultListModel<String> defaultListModel2 = new DefaultListModel<String>();
        Vector<String> vector = ((OlapCubesDlg)this.mParentDlg).getGroupingVariables();
        for (int i = 0; i < defaultListModel.getSize(); ++i) {
            String string2 = (String)((DefaultListModel)this.mSourceList.getModel()).getElementAt(i);
            if (string2.indexOf(this.getResString(PERCENT_OF_SUM_STR)) != -1) {
                String i2 = string2.substring(string2.indexOf("(") + 1, string2.indexOf(")"));
                if (!vector.contains(i2)) continue;
                defaultListModel2.addElement(string2);
                continue;
            }
            if (string2.indexOf(this.getResString(PERCENT_OF_N_STR)) != -1) {
                String string3 = string2.substring(string2.indexOf("(") + 1, string2.indexOf(")"));
                if (!vector.contains(string3)) continue;
                defaultListModel2.addElement(string2);
                continue;
            }
            defaultListModel2.addElement(string2);
        }
        Vector<String> vector2 = new Vector<String>();
        for (n = 0; n < defaultListModel2.getSize(); ++n) {
            String string4 = (String)defaultListModel2.getElementAt(n);
            if (string4.indexOf(this.getResString(PERCENT_OF_SUM_STR)) != -1) {
                string5 = string4.substring(string4.indexOf("(") + 1, string4.indexOf(")"));
                if (vector2.contains(string5)) continue;
                vector2.add(string5);
                continue;
            }
            if (string4.indexOf(this.getResString(PERCENT_OF_N_STR)) == -1 || vector2.contains(string5 = string4.substring(string4.indexOf("(") + 1, string4.indexOf(")")))) continue;
            vector2.add(string5);
        }
        if (vector2.size() > 0) {
            for (n = 0; n < vector2.size(); ++n) {
                for (String string5 : vector) {
                    if (vector2.contains(string5)) continue;
                    defaultListModel2.addElement(this.getResString(PERCENT_OF_SUM_STR) + string5 + ")");
                    defaultListModel2.addElement(this.getResString(PERCENT_OF_N_STR) + string5 + ")");
                    vector2.add(string5);
                }
            }
        } else {
            for (String string6 : vector) {
                defaultListModel2.addElement(this.getResString(PERCENT_OF_SUM_STR) + string6 + ")");
                defaultListModel2.addElement(this.getResString(PERCENT_OF_N_STR) + string6 + ")");
            }
        }
        ((DefaultListModel)this.mSourceList.getModel()).clear();
        this.mSourceList.setModel(defaultListModel2);
        this.mSourceList.getModel().addListDataListener(this);
        this.mParentDlg.getDialogDataModel().putArray(SOURCE_KEY, defaultListModel2.toArray());
        DefaultListModel defaultListModel3 = (DefaultListModel)this.mTargetList.getModel();
        defaultListModel2 = new DefaultListModel();
        boolean bl = false;
        while (var7_22 < defaultListModel3.getSize()) {
            String string7;
            string5 = (String)((DefaultListModel)this.mTargetList.getModel()).getElementAt((int)var7_22);
            if (string5.indexOf(this.getResString(PERCENT_OF_SUM_STR)) != -1) {
                string7 = string5.substring(string5.indexOf("(") + 1, string5.indexOf(")"));
                if (vector.contains(string7)) {
                    defaultListModel2.addElement(string5);
                }
            } else if (string5.indexOf(this.getResString(PERCENT_OF_N_STR)) != -1) {
                string7 = string5.substring(string5.indexOf("(") + 1, string5.indexOf(")"));
                if (vector.contains(string7)) {
                    defaultListModel2.addElement(string5);
                }
            } else {
                defaultListModel2.addElement(string5);
            }
            ++var7_22;
        }
        ((DefaultListModel)this.mTargetList.getModel()).clear();
        this.mTargetList.setModel(defaultListModel2);
        this.mTargetList.getModel().addListDataListener(this);
        this.mParentDlg.getDialogDataModel().putArray(TARGET_KEY, defaultListModel2.toArray());
        this.enableContinue(this.mTargetList.getModel().getSize() > 0);
        this.mSourceList.requestFocusInWindow();
        this.mSourceList.setSelectedIndex(0);
    }

    private void addDragAdapters() {
        DragPane dragPane = (DragPane)this.getGlassPane();
        PlainListDragAdapter plainListDragAdapter = new PlainListDragAdapter(this.mSourceList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(this.mSourceList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mSourceList, this.mPlainListVarMoveHandler));
        plainListDragAdapter = new PlainListDragAdapter(this.mTargetList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(this.mTargetList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mTargetList, this.mPlainListVarMoveHandler));
    }

    private void moveToTargetList(Object[] objectArray) {
        int n = this.mTargetList.getModel().getSize();
        int n2 = 0;
        for (Object object : objectArray) {
            ((DefaultListModel)this.mTargetList.getModel()).addElement(object);
            ++n2;
        }
        if (n != -1) {
            this.mTargetList.setSelectionInterval(n, n + n2 - 1);
        }
        for (Object object : objectArray) {
            ((DefaultListModel)this.mSourceList.getModel()).removeElement(object);
        }
        this.mSourceList.clearSelection();
        this.mTargetList.ensureIndexIsVisible(n + objectArray.length - 1);
        final PlainList plainList = this.mTargetList;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                plainList.requestFocus();
            }
        });
    }

    private void moveToSourceList(Object[] objectArray) {
        int n = this.mSourceList.getModel().getSize();
        int n2 = 0;
        for (Object object : objectArray) {
            ((DefaultListModel)this.mSourceList.getModel()).addElement(object);
            ++n2;
        }
        if (n != -1) {
            this.mSourceList.setSelectionInterval(n, n + n2 - 1);
        }
        for (Object object : objectArray) {
            ((DefaultListModel)this.mTargetList.getModel()).removeElement(object);
        }
        this.mTargetList.clearSelection();
        this.mSourceList.ensureIndexIsVisible(n + objectArray.length - 1);
        this.mSelectedItems = n2;
        final PlainList plainList = this.mSourceList;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                plainList.requestFocus();
            }
        });
    }

    private void initVars() {
        ActionListener[] actionListenerArray;
        this.mSourceList = new PlainList(SOURCE_KEY);
        this.mSourceList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mSourceList.getFixedCellHeight() * 16 + 2));
        this.mTargetList = new PlainList(TARGET_KEY);
        this.mTargetList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetList.getFixedCellHeight() * 16 + 2));
        this.mSourceScroll = new JScrollPane(this.mSourceList);
        this.mSourceScroll.setPreferredSize(this.mSourceList.getMinimumSize());
        this.mSourceScroll.setVerticalScrollBarPolicy(20);
        this.mSourceList.setDragEnabled(true);
        this.mTargetScroll = new JScrollPane(this.mTargetList);
        this.mTargetScroll.setVerticalScrollBarPolicy(20);
        this.mTargetScroll.setPreferredSize(this.mTargetList.getMinimumSize());
        this.mTargetList.setDragEnabled(true);
        this.mStatisticsLabel = DialogUtil.createLabel(this, "IDS_OC_STATISTICS_LIST");
        this.mStatisticsLabel.setLabelFor(this.mSourceList);
        this.mCellStatisticsLabel = DialogUtil.createLabel(this, "IDS_OC_CELL_STATISTICS_LIST");
        this.mCellStatisticsLabel.setLabelFor(this.mTargetList);
        this.mArrowButton = new PlainListArrowButton(SpssArrowButton.ButtonOrientation.left);
        this.mArrowButton.setActionCommand("plainListButton");
        for (ActionListener actionListener : actionListenerArray = this.mArrowButton.getActionListeners()) {
            this.mArrowButton.removeActionListener(actionListener);
        }
        this.mArrowButton.addActionListener(this);
        this.mArrowButton.registerVariableList(this.mSourceList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mPlainListVarMoveHandler = this;
    }

    private void setDefaults() {
        this.mSourceList.setModel(new DefaultListModel());
        DefaultListModel defaultListModel = (DefaultListModel)this.mSourceList.getModel();
        Vector<String> vector = this.addIntoSourceModel();
        for (String iterator2 : vector) {
            defaultListModel.addElement(iterator2);
        }
        Vector<String> vector2 = ((OlapCubesDlg)this.mParentDlg).getGroupingVariables();
        Iterator iterator = vector2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            defaultListModel.addElement(this.getResString(PERCENT_OF_SUM_STR) + string + ")");
            defaultListModel.addElement(this.getResString(PERCENT_OF_N_STR) + string + ")");
        }
        this.mSourceList.getModel().addListDataListener(this);
        this.mSourceList.addFocusListener(this);
        this.mTargetList.setModel(new DefaultListModel());
        defaultListModel = (DefaultListModel)this.mTargetList.getModel();
        vector = this.addIntoTargetModel();
        for (String string : vector) {
            defaultListModel.addElement(string);
        }
        this.mTargetList.getModel().addListDataListener(this);
        this.mTargetList.addFocusListener(this);
        this.mTargetList.requestFocus();
        this.mTargetList.setSelectedIndex(0);
    }

    private void setupJListsPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mStatisticsLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mSourceScroll, gridBagConstraints, 0, 1, 1, 2, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mCellStatisticsLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTargetScroll, gridBagConstraints, 2, 1, 1, 2, n, null);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSourceList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetList);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private Vector<String> addIntoSourceModel() {
        Vector<String> vector = new Vector<String>();
        vector.add(this.getResString("IDS_OC_MEDIAN"));
        vector.add(this.getResString("IDS_OC_GROUPEDMEDIAN"));
        vector.add(this.getResString("IDS_OC_STDERR_OF_MEAN"));
        vector.add(this.getResString("IDS_OC_MINIMUM"));
        vector.add(this.getResString("IDS_OC_MAXIMUM"));
        vector.add(this.getResString("IDS_OC_RANGE"));
        vector.add(this.getResString("IDS_OC_FIRST"));
        vector.add(this.getResString("IDS_OC_LAST"));
        vector.add(this.getResString("IDS_OC_VARIANCE"));
        vector.add(this.getResString("IDS_OC_KURTOSIS"));
        vector.add(this.getResString("IDS_OC_STDERR_OF_KURTOSIS"));
        vector.add(this.getResString("IDS_OC_SKEWNESS"));
        vector.add(this.getResString("IDS_OC_STDERR_OF_SKEWNESS"));
        vector.add(this.getResString("IDS_OC_HARMONIC_MEAN"));
        vector.add(this.getResString("IDS_OC_GEOMETRIC_MEAN"));
        return vector;
    }

    private Vector<String> addIntoTargetModel() {
        Vector<String> vector = new Vector<String>();
        vector.add(this.getResString("IDS_OC_SUM"));
        vector.add(this.getResString("IDS_OC_NUMBER_OF_CASES"));
        vector.add(this.getResString("IDS_OC_MEAN"));
        vector.add(this.getResString("IDS_OC_STD_DEV"));
        vector.add(this.getResString("IDS_OC_PERCENT_OF_TOTAL_SUM"));
        vector.add(this.getResString("IDS_OC_PERCENT_OF_TOTAL_N"));
        return vector;
    }
}

