/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.reports.olap_cubes;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.base.analyze.reports.olap_cubes.OlapCubesDifferences;
import com.spss.java_client.ui.dialogs.base.analyze.reports.olap_cubes.OlapCubesStatistics;
import com.spss.java_client.ui.dialogs.base.analyze.reports.olap_cubes.OlapCubesTitles;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.VarInfoBag;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class OlapCubesDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener {
    private static final String HIDE_SMALL = "IDS_HIDE_SMALL";
    private static final String LESS_THAN = "IDS_LESS_THAN";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetSummaryVarList;
    private TargetVariableList mTargetGroupingVarList;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mTargetSummaryScrollPane;
    private JScrollPane mTargetGroupingScrollPane;
    private JLabel mSummaryVarLabel;
    private JLabel mGroupingVarLabel;
    private ArrowButton mArrowSummaryButton;
    private ArrowButton mArrowGroupingButton;
    private JButton mStatButton;
    private JCheckBox mHideSmallCheck;
    private JLabel mLessThanLabel;
    private IntTextField mLessThanEdit;

    public OlapCubesDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle.getDefaultResourceBundleName(), AnalyzeResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_OC_OLAP_CUBES"));
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetSummaryVarList.removeAll();
        this.mTargetGroupingVarList.removeAll();
        this.setDefaults();
        this.updateOkPaste();
    }

    @Override
    public String generateSyntax() {
        String string;
        Boolean bl;
        Object object;
        String string2;
        String string3;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("OLAP CUBES"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mTargetSummaryVarList.getVariablesStringList()));
        stringBuffer.append(this.getTargetGroupingStrNames());
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Object[] objectArray = dialogDataModel.getArray("targetCmdKey");
        if (objectArray != null) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getMultiValueSubCommand("CELLS", this.generateStatisticsSyntax(objectArray), false));
        } else {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/CELLS="));
            stringBuffer.append("SUM COUNT MEAN STDDEV SPCT NPCT");
        }
        if (this.mHideSmallCheck.isSelected() && this.mLessThanEdit.getText().length() > 0) {
            stringBuffer.append("\n");
            string3 = this.mLessThanEdit.getText();
            stringBuffer.append(SyntaxUtil.getSubCommand(String.format("/HIDESMALLCOUNTS COUNT=%s", string3)));
        }
        if ((string3 = dialogDataModel.getString("IDS_OC_TITLE_COLON")) != null) {
            string2 = CharacterUtil.smartQuote((String)string3).replace("\n", " \\n ");
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/TITLE="));
            stringBuffer.append(string2);
        } else {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/TITLE="));
            stringBuffer.append(CharacterUtil.smartQuote((String)this.getResString("IDS_OC_TITLE_TEXT")));
        }
        string2 = dialogDataModel.getString("IDS_OC_CAPTION_COLON");
        if (string2 != null && !string2.equals("")) {
            object = CharacterUtil.smartQuote((String)string2).replace("\n", " \\n ");
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/FOOTNOTE "));
            stringBuffer.append((String)object);
        }
        if ((object = dialogDataModel.getBoolean("IDS_OC_DIFF_BETWEEN_VARS")) != null && ((Boolean)object).booleanValue()) {
            stringBuffer.append(this.generateDiffVarsSyntax());
        }
        if ((bl = dialogDataModel.getBoolean("IDS_OC_DIFF_BETWEEN_GRPS")) != null && bl.booleanValue() && (string = this.generateDiffGrpSyntax()).length() > 0) {
            stringBuffer.append(string);
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_repo";
    }

    @Override
    public String getIActionKey() {
        return "analyze_reports_olap";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.mTargetGroupingVarList.getModel())) {
            this.mStatButton.setEnabled(this.mTargetGroupingVarList.getModel().getSize() > 0);
        }
        this.updateOkPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.mTargetGroupingVarList.getModel())) {
            this.mStatButton.setEnabled(this.mTargetGroupingVarList.getModel().getSize() > 0);
            this.updateDiffGroupVarsListModel();
        } else if (listDataEvent.getSource().equals(this.mTargetSummaryVarList.getModel())) {
            this.updateDiffVarsListModel();
        }
        this.updateOkPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    public Vector<String> getGroupingVariables() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.mTargetGroupingVarList.getModel().getSize(); ++i) {
            vector.add(this.mTargetGroupingVarList.getModel().getElementAt(i).getName());
        }
        return vector;
    }

    VarListModel getSummaryListModel() {
        return this.mTargetSummaryVarList.getModel();
    }

    VarListModel getGroupingListModel() {
        return this.mTargetGroupingVarList.getModel();
    }

    void updateDiffVarsListModel() {
        Vector<OlapCubesDifferences.MyLabelData> vector = new Vector<OlapCubesDifferences.MyLabelData>();
        SerializableObject[] serializableObjectArray = this.getDialogDataModel().getSerializableArray("varDataVector");
        if (serializableObjectArray != null) {
            Object object;
            for (SerializableObject serializableObject : serializableObjectArray) {
                LocallyUniqueId locallyUniqueId;
                LocallyUniqueId locallyUniqueId2;
                OlapCubesDifferences.MyLabelData myLabelData = (OlapCubesDifferences.MyLabelData)serializableObject;
                ISpssVariable iSpssVariable = myLabelData.getCatLabelVar();
                if (iSpssVariable != null) {
                    locallyUniqueId2 = iSpssVariable.getId();
                    myLabelData.setCatLabelValue(iSpssVariable.getName());
                } else {
                    locallyUniqueId2 = new LocallyUniqueId();
                }
                ISpssVariable iSpssVariable2 = myLabelData.getMinusCatLabelVar();
                if (iSpssVariable2 != null) {
                    locallyUniqueId = iSpssVariable2.getId();
                    myLabelData.setMinusCatLabelValue(iSpssVariable2.getName());
                } else {
                    locallyUniqueId = new LocallyUniqueId();
                }
                if (!this.summaryVarsListContains(locallyUniqueId2) || !this.summaryVarsListContains(locallyUniqueId)) continue;
                vector.add(myLabelData);
            }
            if (vector.size() > 0) {
                object = new SerializableObject[vector.size()];
                this.getDialogDataModel().putSerializableArray("varDataVector", vector.toArray((T[])object));
                this.getDialogDataModel().putSerializableArray("SummaryTargetList", (SerializableObject[])object);
            } else {
                this.getDialogDataModel().putSerializableArray("varDataVector", null);
                this.getDialogDataModel().putSerializableArray("SummaryTargetList", null);
                object = this.getDialogDataModel().getBoolean("IDS_OC_DIFF_BETWEEN_VARS");
                if (object != null && ((Boolean)object).booleanValue()) {
                    this.getDialogDataModel().putBoolean("IDS_OC_DIFF_BETWEEN_VARS", false);
                    this.getDialogDataModel().putBoolean("IDS_OC_NONE", true);
                }
            }
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        JPanel jPanel = this.getViewPanel();
        this.addComponentsToPanel(jPanel);
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.updateDiffVarsListModel();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_STATS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OlapCubesDlg.this.runStatsSubDialog();
            }
        };
        this.mStatButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mStatButton);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_OC_DIFFERENCES_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OlapCubesDlg.this.runDifferencesSubDialog();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_OC_TITLE_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OlapCubesDlg.this.runTitlesSubDialog();
            }
        };
        JButton jButton2 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton2);
        return jPanel;
    }

    private void updateDiffGroupVarsListModel() {
        LocallyUniqueId locallyUniqueId;
        String string = this.getDialogDataModel().getString("GroupingVar");
        VarInfoBag varInfoBag = (VarInfoBag)this.getDialogDataModel().getSerializableObject("GroupingVarId");
        LocallyUniqueId locallyUniqueId2 = locallyUniqueId = varInfoBag != null ? varInfoBag.getVarId() : null;
        if (!(string == null || locallyUniqueId != null && this.summaryVarsListContains(locallyUniqueId))) {
            this.getDialogDataModel().putArray("GrpTargetlist", null);
            this.getDialogDataModel().putSerializableArray("grpsDataVector", null);
            Boolean bl = this.getDialogDataModel().getBoolean("IDS_OC_DIFF_BETWEEN_GRPS");
            if (bl != null && bl.booleanValue()) {
                this.getDialogDataModel().putBoolean("IDS_OC_DIFF_BETWEEN_GRPS", false);
                this.getDialogDataModel().putBoolean("IDS_OC_NONE", true);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mHideSmallCheck) {
            this.updateState();
        }
    }

    private void updateState() {
        this.mLessThanLabel.setEnabled(this.mHideSmallCheck.isSelected());
        this.mLessThanEdit.setEnabled(this.mHideSmallCheck.isSelected());
        this.updateOkPaste();
    }

    private boolean summaryVarsListContains(LocallyUniqueId locallyUniqueId) {
        boolean bl = false;
        for (int i = 0; i < this.mTargetSummaryVarList.getModel().getSize(); ++i) {
            if (!this.mTargetSummaryVarList.getModel().getElementAt(i).getId().equals((Object)locallyUniqueId)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void runStatsSubDialog() {
        this.runSubDialog(new OlapCubesStatistics(this));
    }

    private void runDifferencesSubDialog() {
        this.runSubDialog(new OlapCubesDifferences(this));
    }

    private void runTitlesSubDialog() {
        this.runSubDialog(new OlapCubesTitles(this));
    }

    private void updateOkPaste() {
        boolean bl;
        boolean bl2 = bl = this.mTargetGroupingVarList.getModel().getSize() > 0 && this.mTargetSummaryVarList.getModel().getSize() > 0;
        if (bl && this.mHideSmallCheck.isSelected()) {
            bl = this.mLessThanEdit.getText().length() > 0;
        }
        this.enableOkPaste(bl);
    }

    private String getTargetGroupingStrNames() {
        String string = "";
        int n = this.mTargetGroupingVarList.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            String string2 = this.mTargetGroupingVarList.getModel().getElementAt(i).getName();
            string = string + " BY " + string2;
        }
        return string;
    }

    private List<String> generateStatisticsSyntax(Object[] objectArray) {
        Vector<String> vector = new Vector<String>();
        for (Object object : objectArray) {
            String string;
            String string2 = object.toString();
            if (string2.equalsIgnoreCase(this.getResString("IDS_OC_MEAN"))) {
                vector.add("MEAN");
                continue;
            }
            if (string2.equalsIgnoreCase(this.getResString("IDS_OC_SUM"))) {
                vector.add("SUM");
                continue;
            }
            if (string2.equalsIgnoreCase(this.getResString("IDS_OC_STDERR_OF_MEAN"))) {
                vector.add("SEMEAN");
                continue;
            }
            if (string2.equalsIgnoreCase(this.getResString("IDS_OC_STD_DEV"))) {
                vector.add("STDDEV");
                continue;
            }
            if (string2.equalsIgnoreCase(this.getResString("IDS_OC_MEDIAN"))) {
                vector.add("MEDIAN");
                continue;
            }
            if (string2.equalsIgnoreCase(this.getResString("IDS_OC_GROUPEDMEDIAN"))) {
                vector.add("GMEDIAN");
                continue;
            }
            if (string2.equalsIgnoreCase(this.getResString("IDS_OC_MINIMUM"))) {
                vector.add("MIN");
                continue;
            }
            if (string2.equalsIgnoreCase(this.getResString("IDS_OC_MAXIMUM"))) {
                vector.add("MAX");
                continue;
            }
            if (string2.equalsIgnoreCase(this.getResString("IDS_OC_RANGE"))) {
                vector.add("RANGE");
                continue;
            }
            if (string2.equalsIgnoreCase(this.getResString("IDS_OC_FIRST"))) {
                vector.add("FIRST");
                continue;
            }
            if (string2.equalsIgnoreCase(this.getResString("IDS_OC_LAST"))) {
                vector.add("LAST");
                continue;
            }
            if (string2.equalsIgnoreCase(this.getResString("IDS_OC_VARIANCE"))) {
                vector.add("VAR");
                continue;
            }
            if (string2.equalsIgnoreCase(this.getResString("IDS_OC_KURTOSIS"))) {
                vector.add("KURT");
                continue;
            }
            if (string2.equalsIgnoreCase(this.getResString("IDS_OC_STDERR_OF_KURTOSIS"))) {
                vector.add("SEKURT");
                continue;
            }
            if (string2.equalsIgnoreCase(this.getResString("IDS_OC_SKEWNESS"))) {
                vector.add("SKEW");
                continue;
            }
            if (string2.equalsIgnoreCase(this.getResString("IDS_OC_STDERR_OF_SKEWNESS"))) {
                vector.add("SESKEW");
                continue;
            }
            if (string2.equalsIgnoreCase(this.getResString("IDS_OC_HARMONIC_MEAN"))) {
                vector.add("HARMONIC");
                continue;
            }
            if (string2.equalsIgnoreCase(this.getResString("IDS_OC_GEOMETRIC_MEAN"))) {
                vector.add("GEOMETRIC");
                continue;
            }
            if (string2.equalsIgnoreCase(this.getResString("IDS_OC_PERCENT_OF_TOTAL_SUM"))) {
                vector.add("SPCT");
                continue;
            }
            if (string2.equalsIgnoreCase(this.getResString("IDS_OC_PERCENT_OF_TOTAL_N"))) {
                vector.add("NPCT");
                continue;
            }
            if (string2.equalsIgnoreCase(this.getResString("IDS_OC_NUMBER_OF_CASES"))) {
                vector.add("COUNT");
                continue;
            }
            if (string2.indexOf(this.getResString("IDS_OC_PERCENT_OF_SUM_IN")) != -1) {
                string = string2.substring(string2.indexOf("("), string2.indexOf(")"));
                vector.add("SPCT" + string + ")");
                continue;
            }
            if (string2.indexOf(this.getResString("IDS_OC_PERCENT_OF_N_IN")) == -1) continue;
            string = string2.substring(string2.indexOf("("), string2.indexOf(")"));
            vector.add("NPCT" + string + ")");
        }
        return vector.subList(0, vector.size());
    }

    private String generateDiffVarsSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/CREATE"));
        SerializableObject[] serializableObjectArray = dialogDataModel.getSerializableArray("varDataVector");
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        String string = null;
        String string2 = null;
        for (SerializableObject serializableObject : serializableObjectArray) {
            OlapCubesDifferences.MyLabelData myLabelData = (OlapCubesDifferences.MyLabelData)serializableObject;
            ISpssVariable iSpssVariable = myLabelData.getCatLabelVar();
            String string3 = iSpssVariable.getName();
            ISpssVariable iSpssVariable2 = myLabelData.getMinusCatLabelVar();
            String string4 = iSpssVariable2.getName();
            String string5 = null;
            String string6 = null;
            Boolean bl = dialogDataModel.getBoolean("IDS_OC_PERCENT_DIFF");
            Boolean bl2 = dialogDataModel.getBoolean("IDS_OC_ARITHMETIC_DIFF");
            if (myLabelData.getPercentLableValue() == null && myLabelData.getArithLabelValue() == null) {
                if (bl != null && bl.booleanValue()) {
                    string5 = "DEFAULT";
                    string = "VPC";
                }
                if (bl2 != null && bl2.booleanValue()) {
                    string6 = "DEFAULT";
                    string2 = "VAC";
                }
            } else {
                if (bl != null && bl.booleanValue()) {
                    string5 = !myLabelData.getPercentLableValue().equalsIgnoreCase("DEFAULT") ? CharacterUtil.smartQuote((String)myLabelData.getPercentLableValue()) : "DEFAULT";
                    string = "VPC";
                }
                if (bl2 != null && bl2.booleanValue()) {
                    string6 = !myLabelData.getArithLabelValue().equalsIgnoreCase("DEFAULT") ? CharacterUtil.smartQuote((String)myLabelData.getArithLabelValue()) : "DEFAULT";
                    string2 = "VAC";
                }
            }
            if (string6 != null) {
                stringBuffer2.append(" ").append(string6);
            }
            if (string5 != null) {
                stringBuffer2.append(" ").append(string5);
            }
            stringBuffer3.append(" (").append(string4);
            stringBuffer3.append(" ").append(string3).append(")");
        }
        stringBuffer.append(stringBuffer2);
        stringBuffer.append("=");
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        if (string2 != null && string != null) {
            stringBuffer.append(" ");
        }
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append(stringBuffer3);
        return stringBuffer.toString();
    }

    private String generateDiffGrpSyntax() {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        VarInfoBag varInfoBag = (VarInfoBag)dialogDataModel.getSerializableObject("GroupingVarId");
        LocallyUniqueId locallyUniqueId2 = varInfoBag != null ? varInfoBag.getVarId() : new LocallyUniqueId();
        int n = iSpssDataSrc.findVarIndex(locallyUniqueId2);
        StringBuffer stringBuffer = new StringBuffer();
        if (n != -1) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/CREATE"));
            ISpssVariable iSpssVariable = dialogDataModel.getSerializableArray("grpsDataVector");
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer();
            String string = null;
            String string2 = null;
            for (SerializableObject serializableObject : iSpssVariable) {
                OlapCubesDifferences.MyLabelData myLabelData = (OlapCubesDifferences.MyLabelData)serializableObject;
                String string3 = myLabelData.getCatLabelValue();
                string3 = varInfoBag != null && varInfoBag.getVarType() > 0 ? CharacterUtil.smartQuote((String)string3) : UIToolResUtil.removeLocale((String)string3);
                String string4 = myLabelData.getMinusCatLabelValue();
                string4 = varInfoBag != null && varInfoBag.getVarType() > 0 ? CharacterUtil.smartQuote((String)string4) : UIToolResUtil.removeLocale((String)string4);
                String string5 = null;
                String string6 = null;
                Boolean bl = dialogDataModel.getBoolean("IDS_OC_PERCENT_DIFF");
                Boolean bl2 = dialogDataModel.getBoolean("IDS_OC_ARITHMETIC_DIFF");
                if (myLabelData.getPercentLableValue() == null && myLabelData.getArithLabelValue() == null) {
                    if (bl != null && bl.booleanValue()) {
                        string5 = "DEFAULT";
                        string = "GPC";
                    }
                    if (bl2 != null && bl2.booleanValue()) {
                        string6 = "DEFAULT";
                        string2 = "GAC";
                    }
                } else {
                    if (bl != null && bl.booleanValue()) {
                        string5 = !myLabelData.getPercentLableValue().equalsIgnoreCase("DEFAULT") ? CharacterUtil.smartQuote((String)myLabelData.getPercentLableValue()) : "DEFAULT";
                        string = "GPC";
                    }
                    if (bl2 != null && bl2.booleanValue()) {
                        string6 = !myLabelData.getArithLabelValue().equalsIgnoreCase("DEFAULT") ? CharacterUtil.smartQuote((String)myLabelData.getArithLabelValue()) : "DEFAULT";
                        string2 = "GAC";
                    }
                }
                if (string6 != null) {
                    stringBuffer2.append(" ").append(string6);
                }
                if (string5 != null) {
                    stringBuffer2.append(" ").append(string5);
                }
                stringBuffer3.append(" (").append(string4);
                stringBuffer3.append(" ").append(string3).append(")");
            }
            stringBuffer.append(stringBuffer2);
            stringBuffer.append("=");
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            if (string2 != null && string != null) {
                stringBuffer.append(" ");
            }
            if (string != null) {
                stringBuffer.append(string);
            }
            ISpssVariable iSpssVariable2 = iSpssDataSrc.getVariable(n);
            String string7 = iSpssVariable2.getName();
            this.getDialogDataModel().putString("GroupingVar", string7);
            stringBuffer.append(" (").append(string7);
            stringBuffer.append(stringBuffer3).append(")");
        }
        return stringBuffer.toString();
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList();
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mTargetSummaryVarList = new TargetVariableList();
        this.mTargetSummaryVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetSummaryVarList.getFixedCellHeight() * 4 + 2));
        this.mTargetSummaryVarList.setMaxLimitOfList(100);
        this.mTargetSummaryVarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mTargetSummaryVarList.getModel().addListDataListener(this);
        this.mTargetSummaryVarList.setIdentifier("SummaryList");
        this.mTargetSummaryScrollPane = new JScrollPane(this.mTargetSummaryVarList);
        this.mTargetSummaryScrollPane.setPreferredSize(this.mTargetSummaryVarList.getMinimumSize());
        this.mSummaryVarLabel = DialogUtil.createLabel(this, "IDS_OC_SUMMARY_VARIABLES_COLON");
        this.mSummaryVarLabel.setLabelFor(this.mTargetSummaryVarList);
        this.mTargetGroupingVarList = new TargetVariableList();
        this.mTargetGroupingVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetGroupingVarList.getFixedCellHeight() * 4 + 2));
        this.mTargetGroupingVarList.setMaxLimitOfList(10);
        this.mTargetGroupingVarList.setIdentifier("GroupList");
        this.mTargetGroupingVarList.getModel().addListDataListener(this);
        this.mTargetGroupingScrollPane = new JScrollPane(this.mTargetGroupingVarList);
        this.mTargetGroupingScrollPane.setPreferredSize(this.mTargetGroupingVarList.getMinimumSize());
        this.mGroupingVarLabel = DialogUtil.createLabel(this, "IDS_OC_GROUPING_VARIABLES_COLON");
        this.mGroupingVarLabel.setLabelFor(this.mTargetGroupingVarList);
        this.mArrowSummaryButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowSummaryButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowSummaryButton.registerVariableList(this.mTargetSummaryVarList, SpssArrowButton.ButtonOrientation.left);
        this.mArrowGroupingButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowGroupingButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowGroupingButton.registerVariableList(this.mTargetGroupingVarList, SpssArrowButton.ButtonOrientation.left);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, HIDE_SMALL);
        this.mHideSmallCheck = new JCheckBox(toggleButtonAction);
        this.mHideSmallCheck.addItemListener(this);
        this.mLessThanLabel = new JLabel(this.getResString(LESS_THAN));
        this.mLessThanEdit = new IntTextField(2, Integer.MAX_VALUE, true);
        this.mLessThanEdit.setText("5");
        this.mLessThanEdit.setAction((Action)new TextFieldAction(this, LESS_THAN));
        this.mLessThanEdit.setEnabled(false);
        this.mLessThanEdit.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                OlapCubesDlg.this.updateState();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                OlapCubesDlg.this.updateState();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                OlapCubesDlg.this.updateState();
            }
        });
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mStatButton.setEnabled(false);
        this.mHideSmallCheck.setSelected(false);
        this.mLessThanLabel.setEnabled(false);
        this.mLessThanEdit.setEnabled(false);
        this.mLessThanEdit.setText("5");
    }

    private void addComponentsToPanel(JPanel jPanel) {
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_OC_SRCLIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 3, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowSummaryButton, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mSummaryVarLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTargetSummaryScrollPane, gridBagConstraints, 2, 1, 1, 1, n, null);
        Insets insets3 = new Insets(DialogUtil.getGroupBoxInnerMargin() * 2, 0, insets.bottom, 0);
        gridBagConstraints.weighty = 0.0;
        n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mGroupingVarLabel, gridBagConstraints, 2, 2, 1, 1, n, insets3);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mArrowGroupingButton, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        n = 23;
        gridBagConstraints.fill = 1;
        insets3.set(insets.top, 0, insets.bottom, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTargetGroupingScrollPane, gridBagConstraints, 2, 3, 1, 1, n, insets3);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mHideSmallCheck, gridBagConstraints, 2, 4, 1, 1, n, insets3);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 5, 1, 1, n, new Insets(0, 0, 0, 0));
        Insets insets4 = (Insets)insets3.clone();
        insets4.left += 18;
        insets4.right += 3;
        DialogUtil.addUsingGBL(jPanel2, this.mLessThanLabel, gridBagConstraints, 0, 0, 1, 1, n, insets4);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mLessThanEdit, gridBagConstraints, 1, 0, 1, 1, n, insets3);
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowSummaryButton);
        vector.add(this.mArrowGroupingButton);
        vector.add(this.mTargetSummaryVarList);
        vector.add(this.mTargetGroupingVarList);
        vector.add(this.mHideSmallCheck);
        vector.add(this.mLessThanEdit);
        int n2 = this.mCmdButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        n = this.mOptionButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.mOptionButtonPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(i));
        }
        return vector;
    }
}

