/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.reports.olap_cubes;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ComponentsArrowButton;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.dialogs.base.analyze.reports.olap_cubes.OlapCubesDlg;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.VarInfoBag;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.dialogs.DlgKeyPressListener;
import com.spss.uitools.dialogs.IDlgKeyPressListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OlapCubesDifferences
extends BaseSubDialog
implements ItemListener,
ListSelectionListener,
ActionListener,
KeyListener {
    static final String DIFF_BETWEEN_VARS_RADIO_KEY = "IDS_OC_DIFF_BETWEEN_VARS";
    static final String DIFF_BETWEEN_GRPS_RADIO_KEY = "IDS_OC_DIFF_BETWEEN_GRPS";
    static final String PERCENT_DIFF_CHECK_KEY = "IDS_OC_PERCENT_DIFF";
    static final String ARITHMETIC_DIFF_CHECK_KEY = "IDS_OC_ARITHMETIC_DIFF";
    static final String DIFFS_BETWEEN_VARS_KEY = "IDS_OC_DIFFS_BETWEEN_VARS";
    static final String SELECTED_GROUP_VAR = "GroupingVar";
    static final String SELECTED_GROUP_VAR_ID = "GroupingVarId";
    static final String VAR_DATA_VECTOR = "varDataVector";
    static final String GRPS_DATA_VECTOR = "grpsDataVector";
    static final String NONE_RADIO_KEY = "IDS_OC_NONE";
    static final String SUMMARY_VAR_LIST_IDENTIFIER = "SummaryTargetList";
    static final String GROUP_VAR_LIST_IDENTIFIER = "GrpTargetlist";
    private static final String WARNING_CHANGE_DIFF_CALCULATION = "ERR_OC_WARNING_CHANGE_DIFF_CALCULATION";
    private static final String DIFF_VARS_ARROW_BUTTON_CMD = "diffVarsButtonCmd";
    private static final String DIFF_GRP_ARROW_BUTTON_CMD = "diffGrpButtonCmd";
    private JCheckBox mPercentDiffCheck;
    private JCheckBox mArithDiffCheck;
    private JRadioButton mDiffVarsRadio;
    private JRadioButton mDiffGrpsRadio;
    private JRadioButton mNoneRadio;
    private SpssButtonGroup mSummStatsGroup;
    private JLabel mVarLabel;
    private JLabel mMinusVarLabel;
    private JComboBox mVariablesCombo;
    private JComboBox mMinusVariablesCombo;
    private JLabel mPercentLabel;
    private StringTextField mPercentLabelText;
    private JLabel mArithLabel;
    private StringTextField mArithLabelText;
    private JLabel mPairsLabel;
    private PlainList mDiffVarTargetList;
    private JScrollPane mDiffVarScrollPane;
    private JButton mDeletePairButton;
    private JLabel mGroupVarLabel;
    private JLabel mCategoryLabel;
    private StringTextField mCategoryLabelText;
    private JLabel mGrpMinusCatLabel;
    private StringTextField mGrpMinusCatLabelText;
    private JComboBox mGroupVariablesCombo;
    private JLabel mGrpPercentLabel;
    private StringTextField mGrpPercentLabelText;
    private JLabel mGrpArithLabel;
    private StringTextField mGrpArithLabelText;
    private PlainList mDiffGrpTargetList;
    private JScrollPane mDiffGrpScrollPane;
    private JButton mGrpDeletePairButton;
    private ComponentsArrowButton mVarsPairButton;
    private ComponentsArrowButton mGrpVarsPairButton;
    private VarListModel mSummaryListModel;
    private VarListModel mGroupListModel;
    private Vector<MyLabelData> mVarsVector;
    private Vector<MyLabelData> mGrpsVector;
    private JLabel mDiffBetGrpCasesLabel;

    public OlapCubesDifferences(OlapCubesDlg olapCubesDlg) {
        super(olapCubesDlg, olapCubesDlg.getResString("IDS_OC_DIFF_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_repo_diffs";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equalsIgnoreCase(DIFF_VARS_ARROW_BUTTON_CMD)) {
            if (this.mVarsPairButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.right) {
                this.moveToVarsTargetList();
                this.updateContinue();
            } else {
                this.moveFromVarsTargetList();
                this.updateContinue();
            }
        } else if (actionEvent.getActionCommand().equalsIgnoreCase(DIFF_GRP_ARROW_BUTTON_CMD)) {
            if (this.mGrpVarsPairButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.right) {
                if (this.moveToGrpsTargetList()) {
                    this.mDiffGrpTargetList.requestFocus();
                }
                this.updateContinue();
            } else {
                this.moveFromGrpTargetList();
                if (this.mDiffGrpTargetList.getModel().getSize() < 1) {
                    this.mGroupVariablesCombo.setEnabled(true);
                }
                this.updateContinue();
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource().equals(this.mDiffVarTargetList)) {
            if (this.mDiffVarTargetList.getSelectedIndex() != -1) {
                this.mVarsPairButton.setEnabled(true);
                this.mVarsPairButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            }
        } else if (listSelectionEvent.getSource().equals(this.mDiffGrpTargetList) && this.mDiffGrpTargetList.getSelectedIndex() != -1) {
            this.mGrpVarsPairButton.setEnabled(true);
            this.mGrpVarsPairButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.mGrpVarsPairButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mGrpVarsPairButton.setEnabled(this.mCategoryLabelText.getText().length() > 0 && this.mGrpMinusCatLabelText.getText().length() > 0);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        Object object = itemEvent.getItem();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (object.equals(this.mNoneRadio)) {
            if (bl) {
                this.enableOrDisableVarsPanelComponents(false);
                this.enableOrDisableGroupCasesPanelComponents(false);
                this.mGrpVarsPairButton.setEnabled(false);
                this.mVarsPairButton.setEnabled(false);
                this.mDiffVarTargetList.clearSelection();
                this.mDiffGrpTargetList.clearSelection();
                this.updateContinue();
            }
            this.enableScrollBars(false, false);
        } else if (object.equals(this.mDiffVarsRadio)) {
            if (bl) {
                this.enableOrDisableVarsPanelComponents(true);
                this.enableOrDisableGroupCasesPanelComponents(false);
                this.mGrpVarsPairButton.setEnabled(false);
                this.mDiffVarTargetList.clearSelection();
                this.mDiffGrpTargetList.clearSelection();
                if (this.mVariablesCombo.getSelectedItem() != null && this.mMinusVariablesCombo.getSelectedItem() != null) {
                    this.mVarsPairButton.setEnabled(true);
                }
                this.updateContinue();
            }
            this.enableScrollBars(true, false);
        } else if (object.equals(this.mDiffGrpsRadio)) {
            if (bl) {
                this.enableOrDisableVarsPanelComponents(false);
                this.enableOrDisableGroupCasesPanelComponents(true);
                if (this.mDiffGrpTargetList.getModel().getSize() > 0) {
                    this.mGroupVariablesCombo.setEnabled(false);
                }
                this.mVarsPairButton.setEnabled(false);
                this.mDiffVarTargetList.clearSelection();
                this.mDiffGrpTargetList.clearSelection();
                if (!this.mCategoryLabelText.getText().equals("") && !this.mGrpMinusCatLabelText.getText().equals("")) {
                    this.mGrpVarsPairButton.setEnabled(true);
                }
                this.updateContinue();
            }
            this.enableScrollBars(false, true);
        } else if (itemEvent.getSource().equals(this.mVariablesCombo)) {
            if (this.mVariablesCombo.getSelectedItem() != null && this.mMinusVariablesCombo.getSelectedItem() != null) {
                String string;
                String string2 = (String)this.mVariablesCombo.getSelectedItem();
                if (!string2.equalsIgnoreCase(string = (String)this.mMinusVariablesCombo.getSelectedItem())) {
                    this.mVarsPairButton.setEnabled(true);
                } else {
                    this.mVarsPairButton.setEnabled(false);
                }
            } else if (this.mVariablesCombo.getSelectedItem() != null) {
                this.mVarsPairButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
                this.mVarsPairButton.setEnabled(false);
            }
        } else if (itemEvent.getSource().equals(this.mMinusVariablesCombo)) {
            if (this.mVariablesCombo.getSelectedItem() != null && this.mMinusVariablesCombo.getSelectedItem() != null) {
                String string;
                String string3 = (String)this.mVariablesCombo.getSelectedItem();
                if (!string3.equalsIgnoreCase(string = (String)this.mMinusVariablesCombo.getSelectedItem())) {
                    this.mVarsPairButton.setEnabled(true);
                } else {
                    this.mVarsPairButton.setEnabled(false);
                }
            } else if (this.mMinusVariablesCombo.getSelectedItem() != null) {
                this.mVarsPairButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
                this.mVarsPairButton.setEnabled(false);
            }
        } else if (itemEvent.getSource().equals(this.mGroupVariablesCombo)) {
            if (this.mGroupVariablesCombo.getSelectedItem() != null) {
                if (this.mCategoryLabelText.getText() != null && this.mGrpMinusCatLabelText.getText() != null) {
                    if (!this.mCategoryLabelText.getText().equals("") && !this.mGrpMinusCatLabelText.getText().equals("")) {
                        this.mGrpVarsPairButton.setEnabled(true);
                    }
                } else {
                    this.mGrpVarsPairButton.setEnabled(false);
                }
            } else {
                this.mGrpVarsPairButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
                this.mGrpVarsPairButton.setEnabled(false);
            }
        }
    }

    private void validatePercentDiffCheckbox() {
        if (this.mDiffVarsRadio.isSelected()) {
            if (this.mDiffVarTargetList.getModel().getSize() > 0) {
                if (0 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString(WARNING_CHANGE_DIFF_CALCULATION), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
                    ((DefaultListModel)this.mDiffVarTargetList.getModel()).removeAllElements();
                    this.mVariablesCombo.setSelectedIndex(-1);
                    this.mMinusVariablesCombo.setSelectedIndex(-1);
                    this.mPercentLabel.setEnabled(this.mPercentDiffCheck.isSelected());
                    this.mPercentLabelText.setEnabled(this.mPercentDiffCheck.isSelected());
                    this.mPercentLabelText.setOpaque(this.mPercentDiffCheck.isSelected());
                    this.mVarsVector.removeAllElements();
                } else {
                    this.mPercentDiffCheck.removeItemListener(this);
                    this.mPercentDiffCheck.setSelected(!this.mPercentDiffCheck.isSelected());
                    this.mPercentDiffCheck.addItemListener(this);
                }
            } else {
                this.mPercentLabel.setEnabled(this.mPercentDiffCheck.isSelected());
                this.mPercentLabelText.setEnabled(this.mPercentDiffCheck.isSelected());
                this.mPercentLabelText.setOpaque(this.mPercentDiffCheck.isSelected());
            }
        } else if (this.mDiffGrpsRadio.isSelected()) {
            if (this.mDiffGrpTargetList.getModel().getSize() > 0) {
                if (0 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString(WARNING_CHANGE_DIFF_CALCULATION), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
                    ((DefaultListModel)this.mDiffGrpTargetList.getModel()).removeAllElements();
                    this.mGrpPercentLabel.setEnabled(this.mPercentDiffCheck.isSelected());
                    this.mGrpPercentLabelText.setEnabled(this.mPercentDiffCheck.isSelected());
                    this.mGrpPercentLabelText.setOpaque(this.mPercentDiffCheck.isSelected());
                    this.mGrpsVector.removeAllElements();
                } else {
                    this.mPercentDiffCheck.removeItemListener(this);
                    this.mPercentDiffCheck.setSelected(!this.mPercentDiffCheck.isSelected());
                    this.mPercentDiffCheck.addItemListener(this);
                }
            } else {
                this.mGrpPercentLabel.setEnabled(this.mPercentDiffCheck.isSelected());
                this.mGrpPercentLabelText.setEnabled(this.mPercentDiffCheck.isSelected());
                this.mGrpPercentLabelText.setOpaque(this.mPercentDiffCheck.isSelected());
            }
        }
        this.updateContinue();
    }

    private void validateArithmeticCheckbox() {
        if (this.mDiffVarsRadio.isSelected()) {
            if (this.mDiffVarTargetList.getModel().getSize() > 0) {
                if (0 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString(WARNING_CHANGE_DIFF_CALCULATION), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
                    ((DefaultListModel)this.mDiffVarTargetList.getModel()).removeAllElements();
                    this.mVariablesCombo.setSelectedIndex(-1);
                    this.mMinusVariablesCombo.setSelectedIndex(-1);
                    this.mArithLabel.setEnabled(this.mArithDiffCheck.isSelected());
                    this.mArithLabelText.setEnabled(this.mArithDiffCheck.isSelected());
                    this.mArithLabelText.setOpaque(this.mArithDiffCheck.isSelected());
                    this.mVarsVector.removeAllElements();
                } else {
                    this.mArithDiffCheck.removeItemListener(this);
                    this.mArithDiffCheck.setSelected(!this.mArithDiffCheck.isSelected());
                    this.mArithDiffCheck.addItemListener(this);
                }
            } else {
                this.mArithLabel.setEnabled(this.mArithDiffCheck.isSelected());
                this.mArithLabelText.setEnabled(this.mArithDiffCheck.isSelected());
                this.mArithLabelText.setOpaque(this.mArithDiffCheck.isSelected());
            }
        } else if (this.mDiffGrpsRadio.isSelected()) {
            if (this.mDiffGrpTargetList.getModel().getSize() > 0) {
                if (0 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString(WARNING_CHANGE_DIFF_CALCULATION), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
                    ((DefaultListModel)this.mDiffGrpTargetList.getModel()).removeAllElements();
                    this.mGrpArithLabel.setEnabled(this.mArithDiffCheck.isSelected());
                    this.mGrpArithLabelText.setEnabled(this.mArithDiffCheck.isSelected());
                    this.mGrpArithLabelText.setOpaque(this.mArithDiffCheck.isSelected());
                    this.mGroupVariablesCombo.setEnabled(true);
                    this.mGrpsVector.removeAllElements();
                } else {
                    this.mArithDiffCheck.removeItemListener(this);
                    this.mArithDiffCheck.setSelected(!this.mArithDiffCheck.isSelected());
                    this.mArithDiffCheck.addItemListener(this);
                }
            } else {
                this.mGrpArithLabel.setEnabled(this.mArithDiffCheck.isSelected());
                this.mGrpArithLabelText.setEnabled(this.mArithDiffCheck.isSelected());
                this.mGrpArithLabelText.setOpaque(this.mArithDiffCheck.isSelected());
            }
        }
        this.updateContinue();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        VarInfoBag varInfoBag;
        LocallyUniqueId locallyUniqueId;
        SerializableObject[] serializableObjectArray;
        ((OlapCubesDlg)this.mParentDlg).updateDiffVarsListModel();
        super.loadState(dialogDataModel);
        SerializableObject[] serializableObjectArray2 = this.mParentDlg.getDialogDataModel().getSerializableArray(VAR_DATA_VECTOR);
        if (serializableObjectArray2 != null) {
            serializableObjectArray = serializableObjectArray2;
            int n = serializableObjectArray.length;
            for (int i = 0; i < n; ++i) {
                SerializableObject serializableObject = serializableObjectArray[i];
                this.mVarsVector.add((MyLabelData)serializableObject);
            }
        }
        if ((serializableObjectArray = this.mParentDlg.getDialogDataModel().getSerializableArray(GRPS_DATA_VECTOR)) != null) {
            for (SerializableObject serializableObject : serializableObjectArray) {
                this.mGrpsVector.add((MyLabelData)serializableObject);
            }
        }
        this.mSummaryListModel = ((OlapCubesDlg)this.mParentDlg).getSummaryListModel();
        if (this.mSummaryListModel.getSize() < 2 && this.mParentDlg.getDialogDataModel().getBoolean(DIFF_BETWEEN_VARS_RADIO_KEY) != null && !this.mParentDlg.getDialogDataModel().getBoolean(DIFF_BETWEEN_VARS_RADIO_KEY).booleanValue()) {
            this.mDiffVarsRadio.setSelected(false);
        }
        this.mGroupListModel = ((OlapCubesDlg)this.mParentDlg).getGroupingListModel();
        if (this.mGroupListModel.getSize() < 1) {
            if (this.mParentDlg.getDialogDataModel().getBoolean(DIFF_BETWEEN_GRPS_RADIO_KEY) != null && !this.mParentDlg.getDialogDataModel().getBoolean(DIFF_BETWEEN_GRPS_RADIO_KEY).booleanValue()) {
                this.mDiffGrpsRadio.setSelected(false);
            }
        } else {
            this.mGroupVariablesCombo.setEnabled(false);
        }
        LocallyUniqueId locallyUniqueId2 = locallyUniqueId = (varInfoBag = (VarInfoBag)this.mParentDlg.getDialogDataModel().getSerializableObject(SELECTED_GROUP_VAR_ID)) != null ? varInfoBag.getVarId() : null;
        if (locallyUniqueId == null || !this.mainDialogListContains(this.mGroupListModel, locallyUniqueId)) {
            ((DefaultListModel)this.mDiffGrpTargetList.getModel()).clear();
            this.mParentDlg.getDialogDataModel().putArray(GROUP_VAR_LIST_IDENTIFIER, ((DefaultListModel)this.mDiffGrpTargetList.getModel()).toArray());
        }
        if (this.mSummaryListModel.getSize() < 2 && this.mGroupListModel.getSize() < 1) {
            this.mNoneRadio.setSelected(true);
            this.mParentDlg.getDialogDataModel().putBoolean(NONE_RADIO_KEY, true);
            this.mCategoryLabelText.setText("");
            this.mGrpMinusCatLabelText.setText("");
            this.mGrpArithLabelText.setText("");
            this.mGrpPercentLabelText.setText("");
            this.mArithLabelText.setText("");
            this.mPercentLabelText.setText("");
        }
        if (this.mParentDlg.getDialogDataModel().getBoolean(NONE_RADIO_KEY) != null && this.mParentDlg.getDialogDataModel().getBoolean(NONE_RADIO_KEY).booleanValue()) {
            this.mNoneRadio.setSelected(true);
        }
        this.updateContinue();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        SerializableObject[] serializableObjectArray;
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        String string = (String)this.mGroupVariablesCombo.getSelectedItem();
        int n = iSpssDataSrc.findVarIndex(string);
        ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n);
        this.mParentDlg.getDialogDataModel().putString(SELECTED_GROUP_VAR, string);
        if (iSpssVariable != null) {
            try {
                serializableObjectArray = new VarInfoBag(iSpssVariable);
                this.mParentDlg.getDialogDataModel().putSerializableObject(SELECTED_GROUP_VAR_ID, (SerializableObject)serializableObjectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.mParentDlg.getDialogDataModel().putBoolean(NONE_RADIO_KEY, this.mNoneRadio.isSelected());
        serializableObjectArray = new SerializableObject[this.mVarsVector.size()];
        this.mParentDlg.getDialogDataModel().putSerializableArray(VAR_DATA_VECTOR, this.mVarsVector.toArray(serializableObjectArray));
        serializableObjectArray = new SerializableObject[this.mGrpsVector.size()];
        this.mParentDlg.getDialogDataModel().putSerializableArray(GRPS_DATA_VECTOR, this.mGrpsVector.toArray(serializableObjectArray));
        return super.saveState(dialogDataModel);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.addComponentsToPanel(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    protected void addDlgKeyPressListener() {
        this.mKeyAdapter.addDlgKeyPressListener((IDlgKeyPressListener)new CubeDiffKeyListener());
    }

    private void enableScrollBars(boolean bl, boolean bl2) {
        this.mDiffVarScrollPane.getVerticalScrollBar().setEnabled(bl);
        this.mDiffVarScrollPane.getHorizontalScrollBar().setEnabled(bl);
        this.mDiffVarScrollPane.setWheelScrollingEnabled(bl);
        this.mDiffGrpScrollPane.getVerticalScrollBar().setEnabled(bl2);
        this.mDiffGrpScrollPane.getHorizontalScrollBar().setEnabled(bl2);
        this.mDiffGrpScrollPane.setWheelScrollingEnabled(bl2);
    }

    private boolean mainDialogListContains(VarListModel varListModel, LocallyUniqueId locallyUniqueId) {
        for (int i = 0; i < varListModel.getSize(); ++i) {
            LocallyUniqueId locallyUniqueId2 = varListModel.getElementAt(i).getId();
            if (!locallyUniqueId2.equals((Object)locallyUniqueId)) continue;
            return true;
        }
        return false;
    }

    private void updateContinue() {
        if (this.mNoneRadio.isSelected()) {
            this.enableContinue(true);
        } else if (this.mDiffVarsRadio.isSelected()) {
            if (this.mPercentDiffCheck.isSelected() || this.mArithDiffCheck.isSelected()) {
                this.enableContinue(this.mDiffVarTargetList.getModel().getSize() > 0);
            }
            if (!this.mPercentDiffCheck.isSelected() && !this.mArithDiffCheck.isSelected()) {
                this.enableContinue(false);
            }
        } else if (this.mDiffGrpsRadio.isSelected()) {
            if (this.mPercentDiffCheck.isSelected() || this.mArithDiffCheck.isSelected()) {
                this.enableContinue(this.mDiffGrpTargetList.getModel().getSize() > 0);
            }
            if (!this.mPercentDiffCheck.isSelected() && !this.mArithDiffCheck.isSelected()) {
                this.enableContinue(false);
            }
        }
    }

    private void enableOrDisableVarsPanelComponents(boolean bl) {
        this.mVarLabel.setEnabled(bl);
        this.mVariablesCombo.setEnabled(bl);
        this.mMinusVarLabel.setEnabled(bl);
        this.mMinusVariablesCombo.setEnabled(bl);
        this.mPairsLabel.setEnabled(bl);
        this.mDiffVarTargetList.setEnabled(bl);
        this.mDiffVarTargetList.setOpaque(bl);
        if (bl) {
            if (this.mPercentDiffCheck.isSelected()) {
                this.mPercentLabel.setEnabled(bl);
                this.mPercentLabelText.setEnabled(bl);
                this.mPercentLabelText.setOpaque(bl);
            } else {
                this.mPercentLabel.setEnabled(!bl);
                this.mPercentLabelText.setEnabled(!bl);
                this.mPercentLabelText.setOpaque(!bl);
            }
            if (this.mArithDiffCheck.isSelected()) {
                this.mArithLabel.setEnabled(bl);
                this.mArithLabelText.setEnabled(bl);
                this.mArithLabelText.setOpaque(bl);
            } else {
                this.mArithLabel.setEnabled(!bl);
                this.mArithLabelText.setEnabled(!bl);
                this.mArithLabelText.setOpaque(!bl);
            }
        } else {
            this.mPercentLabel.setEnabled(bl);
            this.mPercentLabelText.setEnabled(bl);
            this.mPercentLabelText.setOpaque(bl);
            this.mArithLabel.setEnabled(bl);
            this.mArithLabelText.setEnabled(bl);
            this.mArithLabelText.setOpaque(bl);
        }
        this.mDeletePairButton.setEnabled(bl);
    }

    private void enableOrDisableGroupCasesPanelComponents(boolean bl) {
        this.mGroupVarLabel.setEnabled(bl);
        this.mGroupVariablesCombo.setEnabled(bl);
        this.mCategoryLabel.setEnabled(bl);
        this.mCategoryLabelText.setEnabled(bl);
        this.mCategoryLabelText.setOpaque(bl);
        this.mGrpMinusCatLabel.setEnabled(bl);
        this.mGrpMinusCatLabelText.setEnabled(bl);
        this.mGrpMinusCatLabelText.setOpaque(bl);
        if (bl) {
            if (this.mPercentDiffCheck.isSelected()) {
                this.mGrpPercentLabel.setEnabled(bl);
                this.mGrpPercentLabelText.setEnabled(bl);
                this.mGrpPercentLabelText.setOpaque(bl);
            } else {
                this.mGrpPercentLabel.setEnabled(!bl);
                this.mGrpPercentLabelText.setEnabled(!bl);
                this.mGrpPercentLabelText.setOpaque(!bl);
            }
            if (this.mArithDiffCheck.isSelected()) {
                this.mGrpArithLabel.setEnabled(bl);
                this.mGrpArithLabelText.setEnabled(bl);
                this.mGrpArithLabelText.setOpaque(bl);
            } else {
                this.mGrpArithLabel.setEnabled(!bl);
                this.mGrpArithLabelText.setEnabled(!bl);
                this.mGrpArithLabelText.setOpaque(!bl);
            }
        } else {
            this.mGrpPercentLabel.setEnabled(bl);
            this.mGrpPercentLabelText.setEnabled(bl);
            this.mGrpPercentLabelText.setOpaque(bl);
            this.mGrpArithLabel.setEnabled(bl);
            this.mGrpArithLabelText.setEnabled(bl);
            this.mGrpArithLabelText.setOpaque(bl);
        }
        this.mDiffBetGrpCasesLabel.setEnabled(bl);
        this.mDiffGrpTargetList.setEnabled(bl);
        this.mDiffGrpTargetList.setOpaque(bl);
        this.mGrpDeletePairButton.setEnabled(bl);
    }

    private void moveToVarsTargetList() {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        MyLabelData myLabelData = new MyLabelData();
        StringBuffer stringBuffer = new StringBuffer();
        String string = (String)this.mVariablesCombo.getSelectedItem();
        stringBuffer.append(string);
        myLabelData.setCatLabelValue(string);
        int n = iSpssDataSrc.findVarIndex(string);
        ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n);
        if (iSpssVariable != null) {
            myLabelData.setCatLabelVar(iSpssVariable);
        }
        stringBuffer.append("-");
        String string2 = (String)this.mMinusVariablesCombo.getSelectedItem();
        stringBuffer.append(string2);
        myLabelData.setMinusCatLabelValue(string2);
        int n2 = iSpssDataSrc.findVarIndex(string2);
        ISpssVariable iSpssVariable2 = iSpssDataSrc.getVariable(n2);
        if (iSpssVariable2 != null) {
            myLabelData.setMinusCatLabelVar(iSpssVariable2);
        }
        if (this.mPercentDiffCheck.isSelected() && this.mArithDiffCheck.isSelected()) {
            stringBuffer.append("(");
            if (this.mPercentLabelText.getText().length() > 0) {
                stringBuffer.append(this.mPercentLabelText.getText());
                myLabelData.setPercentLableValue(this.mPercentLabelText.getText());
            } else {
                stringBuffer.append(this.getResString("IDS_OC_VAR_PERCENT_DEFAULT_VALUE"));
                myLabelData.setPercentLableValue(this.getResString("IDS_OC_VAR_PERCENT_DEFAULT_VALUE"));
            }
            stringBuffer.append(",");
            if (this.mArithLabelText.getText().length() > 0) {
                stringBuffer.append(this.mArithLabelText.getText());
                myLabelData.setArithLabelValue(this.mArithLabelText.getText());
            } else {
                stringBuffer.append(this.getResString("IDS_OC_VAR_ARITHMETIC_DEFAULT_VALUE"));
                myLabelData.setArithLabelValue(this.getResString("IDS_OC_VAR_ARITHMETIC_DEFAULT_VALUE"));
            }
            stringBuffer.append(")");
        } else if (this.mPercentDiffCheck.isSelected()) {
            stringBuffer.append("(");
            if (this.mPercentLabelText.getText().length() > 0) {
                stringBuffer.append(this.mPercentLabelText.getText());
                myLabelData.setPercentLableValue(this.mPercentLabelText.getText());
            } else {
                stringBuffer.append(this.getResString("IDS_OC_VAR_PERCENT_DEFAULT_VALUE"));
                myLabelData.setPercentLableValue(this.getResString("IDS_OC_VAR_PERCENT_DEFAULT_VALUE"));
            }
            stringBuffer.append(")");
        } else if (this.mArithDiffCheck.isSelected()) {
            stringBuffer.append("(");
            if (this.mArithLabelText.getText().length() > 0) {
                stringBuffer.append(this.mArithLabelText.getText());
                myLabelData.setArithLabelValue(this.mArithLabelText.getText());
            } else {
                stringBuffer.append(this.getResString("IDS_OC_VAR_ARITHMETIC_DEFAULT_VALUE"));
                myLabelData.setArithLabelValue(this.getResString("IDS_OC_VAR_ARITHMETIC_DEFAULT_VALUE"));
            }
            stringBuffer.append(")");
        }
        stringBuffer = this.prepareDiffExprForBidiDisplay(stringBuffer, string, string2);
        ((DefaultListModel)this.mDiffVarTargetList.getModel()).addElement(stringBuffer.toString());
        this.mVariablesCombo.setSelectedIndex(-1);
        this.mMinusVariablesCombo.setSelectedIndex(-1);
        this.mPercentLabelText.setText("");
        this.mArithLabelText.setText("");
        this.mVarsPairButton.setEnabled(false);
        this.mVarsVector.add(myLabelData);
    }

    private StringBuffer prepareDiffExprForBidiDisplay(StringBuffer stringBuffer, String string, String string2) {
        Object var4_4 = null;
        int n = -1;
        if (stringBuffer == null || (n = stringBuffer.indexOf(string)) == -1) {
            return stringBuffer;
        }
        if (ComponentState.isBtdRtlOrLtr()) {
            if (ComponentState.getBTD() == 1) {
                stringBuffer.insert(n, '\u202b');
                stringBuffer.insert(n, '\u200e');
                stringBuffer.insert(n + 2 + string.length(), '\u200e');
                stringBuffer.insert(n + 2 + string.length(), '\u202c');
                n = stringBuffer.indexOf(string2);
                stringBuffer.insert(n, '\u202b');
                stringBuffer.insert(n + 1 + string2.length(), '\u202c');
            } else {
                stringBuffer.insert(n, '\u202a');
                stringBuffer.insert(n, '\u200e');
                stringBuffer.insert(n + 2 + string.length(), '\u200e');
                stringBuffer.insert(n + 2 + string.length(), '\u202c');
                n = stringBuffer.indexOf(string2);
                stringBuffer.insert(n, '\u202a');
                stringBuffer.insert(n + 1 + string2.length(), '\u202c');
            }
        } else if (ComponentState.containsBidiLetter((String)stringBuffer.toString())) {
            if (ComponentState.isBidiLetter((char)stringBuffer.charAt(0))) {
                stringBuffer.insert(n, '\u202b');
                stringBuffer.insert(n, '\u200e');
                stringBuffer.insert(n + 2 + string.length(), '\u200e');
                stringBuffer.insert(n + 2 + string.length(), '\u202c');
                n = stringBuffer.indexOf(string2);
                stringBuffer.insert(n, '\u202b');
                stringBuffer.insert(n + 1 + string2.length(), '\u202c');
            } else {
                stringBuffer.insert(n, '\u202a');
                stringBuffer.insert(n, '\u200e');
                stringBuffer.insert(n + 2 + string.length(), '\u200e');
                stringBuffer.insert(n + 2 + string.length(), '\u202c');
                n = stringBuffer.indexOf(string2);
                stringBuffer.insert(n, '\u202a');
                stringBuffer.insert(n + 1 + string2.length(), '\u202c');
            }
        }
        return stringBuffer;
    }

    private void moveFromVarsTargetList() {
        int n = this.mDiffVarTargetList.getSelectedIndex();
        MyLabelData myLabelData = this.mVarsVector.get(n);
        this.mVariablesCombo.setSelectedItem(myLabelData.getCatLabelValue());
        this.mMinusVariablesCombo.setSelectedItem(myLabelData.getMinusCatLabelValue());
        if (myLabelData.getPercentLableValue() == null && myLabelData.getArithLabelValue() == null) {
            ((DefaultListModel)this.mDiffVarTargetList.getModel()).removeElementAt(this.mDiffVarTargetList.getSelectedIndex());
            this.mVarsPairButton.setEnabled(true);
            this.mVarsPairButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
            this.mVarsVector.remove(n);
            return;
        }
        ((DefaultListModel)this.mDiffVarTargetList.getModel()).removeElementAt(this.mDiffVarTargetList.getSelectedIndex());
        if (myLabelData.getPercentLableValue() != null && myLabelData.getArithLabelValue() != null) {
            if (!myLabelData.getPercentLableValue().equalsIgnoreCase(this.getResString("IDS_OC_VAR_PERCENT_DEFAULT_VALUE"))) {
                this.mPercentLabelText.setText(myLabelData.getPercentLableValue());
            }
            if (!myLabelData.getArithLabelValue().equalsIgnoreCase(this.getResString("IDS_OC_VAR_ARITHMETIC_DEFAULT_VALUE"))) {
                this.mArithLabelText.setText(myLabelData.getArithLabelValue());
            }
        } else if (this.mPercentDiffCheck.isSelected()) {
            if (!myLabelData.getPercentLableValue().equalsIgnoreCase(this.getResString("IDS_OC_VAR_PERCENT_DEFAULT_VALUE"))) {
                this.mPercentLabelText.setText(myLabelData.getPercentLableValue());
            }
        } else if (this.mArithDiffCheck.isSelected() && !myLabelData.getArithLabelValue().equalsIgnoreCase(this.getResString("IDS_OC_VAR_ARITHMETIC_DEFAULT_VALUE"))) {
            this.mArithLabelText.setText(myLabelData.getArithLabelValue());
        }
        this.mVarsPairButton.setEnabled(true);
        this.mVarsPairButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mVarsVector.remove(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean moveToGrpsTargetList() {
        int n;
        String string = this.mCategoryLabelText.getText();
        String string2 = this.mGrpMinusCatLabelText.getText();
        VarListModel varListModel = ((OlapCubesDlg)this.mParentDlg).getGroupingListModel();
        String string3 = (String)this.mGroupVariablesCombo.getSelectedItem();
        int n2 = -1;
        for (n = 0; n < varListModel.getSize(); ++n) {
            if (!varListModel.getElementAt(n).getName().equals(string3)) continue;
            n2 = varListModel.getElementAt(n).getType();
            break;
        }
        if (n2 == 0) {
            if (string.equalsIgnoreCase(string2)) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_OC_WARNING_IMPROPER_BOTH_VALUES_SAME"), VersionInfo.getAppVersionString());
                this.mCategoryLabelText.requestFocus();
                this.mCategoryLabelText.selectAll();
                return false;
            }
            n = this.checkVarType(string) ? 1 : 0;
            boolean bl = this.checkVarType(string2);
            if (n != 0 && bl) {
                this.setGrpTargetListVar();
                return true;
            }
            if (n != 0 && !bl) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_OC_WARNING_IMPROPER_SECOND_VAR_TYPE"), VersionInfo.getAppVersionString());
                this.mGrpMinusCatLabelText.requestFocus();
                this.mGrpMinusCatLabelText.selectAll();
                return false;
            }
            if (bl) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_OC_WARNING_IMPROPER_FIRST_VAR_TYPE"), VersionInfo.getAppVersionString());
                this.mCategoryLabelText.requestFocus();
                this.mCategoryLabelText.selectAll();
                return false;
            }
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_OC_WARNING_IMPROPER_BOTH_VAR_TYPE"), VersionInfo.getAppVersionString());
            this.mCategoryLabelText.requestFocus();
            this.mCategoryLabelText.selectAll();
            return false;
        }
        if (string.equalsIgnoreCase(string2)) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_OC_WARNING_IMPROPER_BOTH_VALUES_SAME"), VersionInfo.getAppVersionString());
            this.mCategoryLabelText.requestFocus();
            this.mCategoryLabelText.selectAll();
            return false;
        }
        this.setGrpTargetListVar();
        return true;
    }

    private boolean checkVarType(String string) {
        if (string.trim().length() > 0) {
            return DialogUtil.isNumber(string);
        }
        return true;
    }

    private void setGrpTargetListVar() {
        MyLabelData myLabelData = new MyLabelData();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.mCategoryLabelText.getText());
        stringBuffer.append("-");
        stringBuffer.append(this.mGrpMinusCatLabelText.getText());
        myLabelData.setCatLabelValue(this.mCategoryLabelText.getText());
        myLabelData.setMinusCatLabelValue(this.mGrpMinusCatLabelText.getText());
        if (this.mPercentDiffCheck.isSelected() && this.mArithDiffCheck.isSelected()) {
            stringBuffer.append("(");
            if (this.mGrpPercentLabelText.getText().length() > 0) {
                stringBuffer.append(this.mGrpPercentLabelText.getText());
                myLabelData.setPercentLableValue(this.mGrpPercentLabelText.getText());
            } else {
                stringBuffer.append(this.getResString("IDS_OC_GRP_PERCENT_DEFAULT_VALUE"));
                myLabelData.setPercentLableValue(this.getResString("IDS_OC_GRP_PERCENT_DEFAULT_VALUE"));
            }
            stringBuffer.append(",");
            if (this.mGrpArithLabelText.getText().length() > 0) {
                stringBuffer.append(this.mGrpArithLabelText.getText());
                myLabelData.setArithLabelValue(this.mGrpArithLabelText.getText());
            } else {
                stringBuffer.append(this.getResString("IDS_OC_GRP_ARITHMETIC_DEFAULT_VALUE"));
                myLabelData.setArithLabelValue(this.getResString("IDS_OC_GRP_ARITHMETIC_DEFAULT_VALUE"));
            }
            stringBuffer.append(")");
        } else if (this.mPercentDiffCheck.isSelected()) {
            stringBuffer.append("(");
            if (this.mGrpPercentLabelText.getText().length() > 0) {
                stringBuffer.append(this.mGrpPercentLabelText.getText());
                myLabelData.setPercentLableValue(this.mGrpPercentLabelText.getText());
            } else {
                stringBuffer.append(this.getResString("IDS_OC_GRP_PERCENT_DEFAULT_VALUE"));
                myLabelData.setPercentLableValue(this.getResString("IDS_OC_GRP_PERCENT_DEFAULT_VALUE"));
            }
            stringBuffer.append(")");
        } else if (this.mArithDiffCheck.isSelected()) {
            stringBuffer.append("(");
            if (this.mGrpArithLabelText.getText().length() > 0) {
                stringBuffer.append(this.mGrpArithLabelText.getText());
                myLabelData.setArithLabelValue(this.mGrpArithLabelText.getText());
            } else {
                stringBuffer.append(this.getResString("IDS_OC_GRP_ARITHMETIC_DEFAULT_VALUE"));
                myLabelData.setArithLabelValue(this.getResString("IDS_OC_GRP_ARITHMETIC_DEFAULT_VALUE"));
            }
            stringBuffer.append(")");
        }
        ((DefaultListModel)this.mDiffGrpTargetList.getModel()).addElement(stringBuffer.toString());
        this.mGroupVariablesCombo.setEnabled(false);
        this.mCategoryLabelText.setText("");
        this.mGrpMinusCatLabelText.setText("");
        this.mGrpPercentLabelText.setText("");
        this.mGrpArithLabelText.setText("");
        this.mGrpVarsPairButton.setEnabled(false);
        this.mGrpsVector.add(myLabelData);
    }

    private void moveFromGrpTargetList() {
        int n = this.mDiffGrpTargetList.getSelectedIndex();
        MyLabelData myLabelData = this.mGrpsVector.get(n);
        this.mCategoryLabelText.setText(myLabelData.getCatLabelValue());
        this.mGrpMinusCatLabelText.setText(myLabelData.getMinusCatLabelValue());
        if (myLabelData.getPercentLableValue() == null && myLabelData.getArithLabelValue() == null) {
            ((DefaultListModel)this.mDiffGrpTargetList.getModel()).removeElementAt(this.mDiffGrpTargetList.getSelectedIndex());
            this.mGrpVarsPairButton.setEnabled(true);
            this.mGrpVarsPairButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
            this.mGrpsVector.remove(n);
            return;
        }
        ((DefaultListModel)this.mDiffGrpTargetList.getModel()).removeElementAt(this.mDiffGrpTargetList.getSelectedIndex());
        if (myLabelData.getPercentLableValue() != null && myLabelData.getArithLabelValue() != null) {
            if (!myLabelData.getPercentLableValue().equalsIgnoreCase(this.getResString("IDS_OC_GRP_PERCENT_DEFAULT_VALUE"))) {
                this.mGrpPercentLabelText.setText(myLabelData.getPercentLableValue());
            }
            if (!myLabelData.getArithLabelValue().equalsIgnoreCase(this.getResString("IDS_OC_GRP_ARITHMETIC_DEFAULT_VALUE"))) {
                this.mGrpArithLabelText.setText(myLabelData.getArithLabelValue());
            }
        } else if (this.mPercentDiffCheck.isSelected()) {
            if (!myLabelData.getPercentLableValue().equalsIgnoreCase(this.getResString("IDS_OC_GRP_PERCENT_DEFAULT_VALUE"))) {
                this.mGrpPercentLabelText.setText(myLabelData.getPercentLableValue());
            }
        } else if (this.mArithDiffCheck.isSelected() && !myLabelData.getArithLabelValue().equalsIgnoreCase(this.getResString("IDS_OC_GRP_ARITHMETIC_DEFAULT_VALUE"))) {
            this.mGrpArithLabelText.setText(myLabelData.getArithLabelValue());
        }
        this.mGrpVarsPairButton.setEnabled(true);
        this.mGrpVarsPairButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mGrpsVector.remove(n);
    }

    private void initVars() {
        ActionListener[] actionListenerArray;
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, NONE_RADIO_KEY);
        this.mNoneRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, DIFF_BETWEEN_VARS_RADIO_KEY);
        this.mDiffVarsRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, DIFF_BETWEEN_GRPS_RADIO_KEY);
        this.mDiffGrpsRadio = new JRadioButton(toggleButtonAction);
        this.mNoneRadio.addItemListener(this);
        this.mDiffVarsRadio.addItemListener(this);
        this.mDiffGrpsRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, PERCENT_DIFF_CHECK_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OlapCubesDifferences.this.validatePercentDiffCheckbox();
            }
        };
        this.mPercentDiffCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, ARITHMETIC_DIFF_CHECK_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OlapCubesDifferences.this.validateArithmeticCheckbox();
            }
        };
        this.mArithDiffCheck = new JCheckBox(toggleButtonAction);
        this.mVarLabel = DialogUtil.createLabel(this, "IDS_OC_VARS_COLON");
        this.mVariablesCombo = new JComboBox();
        this.mVariablesCombo.addItemListener(this);
        this.mVarLabel.setLabelFor(this.mVariablesCombo);
        this.mMinusVarLabel = DialogUtil.createLabel(this, "IDS_OC_MINUS_VARS_COLON");
        this.mMinusVariablesCombo = new JComboBox();
        this.mMinusVariablesCombo.addItemListener(this);
        this.mMinusVarLabel.setLabelFor(this.mMinusVariablesCombo);
        this.mPercentLabelText = new StringTextField();
        this.mPercentLabelText.setColumns(10);
        this.mPercentLabelText.setDocument(new FixedLengthDocument(120));
        this.mPercentLabel = DialogUtil.createLabel(this, "IDS_OC_PERCENT_LABEL_COLON");
        this.mPercentLabel.setLabelFor((Component)((Object)this.mPercentLabelText));
        this.mArithLabelText = new StringTextField();
        this.mArithLabelText.setColumns(10);
        this.mArithLabelText.setDocument(new FixedLengthDocument(120));
        this.mArithLabel = DialogUtil.createLabel(this, "IDS_OC_ARITHMETIC_LABEL_COLON");
        this.mArithLabel.setLabelFor((Component)((Object)this.mArithLabelText));
        this.mPairsLabel = DialogUtil.createLabel(this, "IDS_OC_PAIRS_COLON");
        this.mDiffBetGrpCasesLabel = DialogUtil.createLabel(this, "IDS_OC_PAIRS_COLON");
        this.mDiffVarTargetList = new PlainList(SUMMARY_VAR_LIST_IDENTIFIER);
        this.mDiffVarTargetList.setSelectionMode(0);
        this.mDiffVarTargetList.setDragType(PlainList.DragType.eAutoDragMove);
        this.mDiffVarTargetList.addListSelectionListener(this);
        this.mDiffVarScrollPane = new JScrollPane(this.mDiffVarTargetList);
        this.mDiffVarScrollPane.setPreferredSize(new Dimension(150, 30));
        this.mPairsLabel.setLabelFor(this.mDiffVarTargetList);
        this.mVarsPairButton = new ComponentsArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mVarsPairButton.registerComponents(this.mMinusVariablesCombo, SpssArrowButton.ButtonOrientation.right);
        this.mVarsPairButton.registerComponents(this.mVariablesCombo, SpssArrowButton.ButtonOrientation.right);
        this.mVarsPairButton.registerComponents(this.mDiffVarTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mVarsPairButton.registerComponents((JComponent)((Object)this.mPercentLabelText), SpssArrowButton.ButtonOrientation.right);
        this.mVarsPairButton.setActionCommand(DIFF_VARS_ARROW_BUTTON_CMD);
        for (ActionListener actionListener : actionListenerArray = this.mVarsPairButton.getActionListeners()) {
            this.mVarsPairButton.removeActionListener(actionListener);
        }
        this.mVarsPairButton.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_OC_DELETE_PAIR_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (OlapCubesDifferences.this.mDiffVarTargetList.getModel().getSize() > 0 && OlapCubesDifferences.this.mDiffVarTargetList.getSelectedIndex() != -1) {
                    OlapCubesDifferences.this.mVarsVector.remove(OlapCubesDifferences.this.mDiffVarTargetList.getSelectedIndex());
                    ((DefaultListModel)OlapCubesDifferences.this.mDiffVarTargetList.getModel()).removeElementAt(OlapCubesDifferences.this.mDiffVarTargetList.getSelectedIndex());
                }
                if (OlapCubesDifferences.this.mDiffVarTargetList.getModel().getSize() == 0) {
                    OlapCubesDifferences.this.mVarsPairButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
                    OlapCubesDifferences.this.mVarsPairButton.setEnabled(false);
                }
                OlapCubesDifferences.this.updateContinue();
            }
        };
        this.mDeletePairButton = new JButton(toggleButtonAction);
        this.mDeletePairButton.setActionCommand("deletePairCmd");
        this.mGroupVarLabel = DialogUtil.createLabel(this, "IDS_OC_GROUPING_VARS_COLON");
        this.mGroupVariablesCombo = new JComboBox();
        this.mGroupVariablesCombo.addItemListener(this);
        this.mGroupVarLabel.setLabelFor(this.mGroupVariablesCombo);
        this.mCategoryLabelText = new StringTextField();
        this.mCategoryLabelText.setColumns(10);
        this.mCategoryLabelText.setDocument(new FixedLengthDocument(120));
        this.mCategoryLabelText.addKeyListener(this);
        this.mCategoryLabel = DialogUtil.createLabel(this, "IDS_OC_CATEGORY_COLON");
        this.mCategoryLabel.setLabelFor((Component)((Object)this.mCategoryLabelText));
        this.mGrpMinusCatLabelText = new StringTextField();
        this.mGrpMinusCatLabelText.setColumns(10);
        this.mGrpMinusCatLabelText.setDocument(new FixedLengthDocument(120));
        this.mGrpMinusCatLabelText.addKeyListener(this);
        this.mGrpMinusCatLabel = DialogUtil.createLabel(this, "IDS_OC_MINUS_CATEGORY_COLON");
        this.mGrpMinusCatLabel.setLabelFor((Component)((Object)this.mGrpMinusCatLabelText));
        this.mGrpPercentLabelText = new StringTextField();
        this.mGrpPercentLabelText.setColumns(10);
        this.mGrpPercentLabelText.setDocument(new FixedLengthDocument(120));
        this.mGrpPercentLabel = DialogUtil.createLabel(this, "IDS_OC_GRP_PERCENT_LABEL_COLON");
        this.mGrpPercentLabel.setLabelFor((Component)((Object)this.mGrpPercentLabelText));
        this.mGrpArithLabelText = new StringTextField();
        this.mGrpArithLabelText.setColumns(10);
        this.mGrpArithLabelText.setDocument(new FixedLengthDocument(120));
        this.mGrpArithLabel = DialogUtil.createLabel(this, "IDS_OC_GRP_ARITHMETIC_LABEL_COLON");
        this.mGrpArithLabel.setLabelFor((Component)((Object)this.mGrpArithLabelText));
        this.mDiffGrpTargetList = new PlainList(GROUP_VAR_LIST_IDENTIFIER);
        this.mDiffGrpTargetList.setSelectionMode(0);
        this.mDiffGrpTargetList.setDragType(PlainList.DragType.eAutoDragMove);
        this.mDiffGrpTargetList.addListSelectionListener(this);
        this.mDiffBetGrpCasesLabel.setLabelFor(this.mDiffGrpTargetList);
        this.mDiffGrpScrollPane = new JScrollPane(this.mDiffGrpTargetList);
        this.mDiffGrpScrollPane.setPreferredSize(new Dimension(150, 30));
        this.mGrpVarsPairButton = new ComponentsArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mGrpVarsPairButton.registerComponents(this.mGroupVariablesCombo, SpssArrowButton.ButtonOrientation.right);
        this.mGrpVarsPairButton.registerComponents(this.mDiffGrpTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mGrpVarsPairButton.setActionCommand(DIFF_GRP_ARROW_BUTTON_CMD);
        for (ActionListener actionListener : actionListenerArray = this.mGrpVarsPairButton.getActionListeners()) {
            this.mGrpVarsPairButton.removeActionListener(actionListener);
        }
        this.mGrpVarsPairButton.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_OC_GRP_DELETE_PAIR_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (OlapCubesDifferences.this.mDiffGrpTargetList.getModel().getSize() > 0 && OlapCubesDifferences.this.mDiffGrpTargetList.getSelectedIndex() != -1) {
                    OlapCubesDifferences.this.mGrpsVector.remove(OlapCubesDifferences.this.mDiffGrpTargetList.getSelectedIndex());
                    ((DefaultListModel)OlapCubesDifferences.this.mDiffGrpTargetList.getModel()).removeElementAt(OlapCubesDifferences.this.mDiffGrpTargetList.getSelectedIndex());
                }
                if (OlapCubesDifferences.this.mDiffGrpTargetList.getModel().getSize() == 0) {
                    OlapCubesDifferences.this.mGroupVariablesCombo.setEnabled(true);
                    OlapCubesDifferences.this.mGrpVarsPairButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
                    OlapCubesDifferences.this.mGrpVarsPairButton.setEnabled(false);
                }
                OlapCubesDifferences.this.updateContinue();
            }
        };
        this.mGrpDeletePairButton = new JButton(toggleButtonAction);
        this.mGrpDeletePairButton.setActionCommand("grpDeletePairCmd");
        this.mVarsVector = new Vector();
        this.mGrpsVector = new Vector();
    }

    private void setDefaults() {
        int n;
        this.mNoneRadio.setSelected(true);
        this.mPercentDiffCheck.setSelected(true);
        this.mVarLabel.setEnabled(false);
        this.mVariablesCombo.setEnabled(false);
        this.mMinusVarLabel.setEnabled(false);
        this.mMinusVariablesCombo.setEnabled(false);
        this.mGrpVarsPairButton.setEnabled(false);
        this.mPairsLabel.setEnabled(false);
        this.mVarsPairButton.setEnabled(false);
        this.mDiffVarTargetList.setEnabled(false);
        this.mPercentLabel.setEnabled(false);
        this.mPercentLabelText.setEnabled(false);
        this.mPercentLabelText.setOpaque(false);
        this.mArithLabel.setEnabled(false);
        this.mArithLabelText.setEnabled(false);
        this.mArithLabelText.setOpaque(false);
        this.mDeletePairButton.setEnabled(false);
        this.mGroupVarLabel.setEnabled(false);
        this.mGroupVariablesCombo.setEnabled(false);
        this.mCategoryLabel.setEnabled(false);
        this.mCategoryLabelText.setEnabled(false);
        this.mCategoryLabelText.setOpaque(false);
        this.mGrpMinusCatLabel.setEnabled(false);
        this.mGrpMinusCatLabelText.setEnabled(false);
        this.mGrpMinusCatLabelText.setOpaque(false);
        this.mGrpPercentLabel.setEnabled(false);
        this.mGrpPercentLabelText.setEnabled(false);
        this.mGrpPercentLabelText.setOpaque(false);
        this.mGrpArithLabel.setEnabled(false);
        this.mGrpArithLabelText.setEnabled(false);
        this.mGrpArithLabelText.setOpaque(false);
        this.mGrpVarsPairButton.setEnabled(false);
        this.mDiffGrpTargetList.setEnabled(false);
        this.mGrpDeletePairButton.setEnabled(false);
        this.mSummaryListModel = ((OlapCubesDlg)this.mParentDlg).getSummaryListModel();
        if (this.mSummaryListModel.getSize() >= 2) {
            for (n = 0; n < this.mSummaryListModel.getSize(); ++n) {
                if (ComponentState.isBtdRtlOrLtr()) {
                    this.mVariablesCombo.addItem(ComponentState.prepareStringForBidiRendering((String)this.mSummaryListModel.getElementAt(n).getName()));
                    this.mMinusVariablesCombo.addItem(ComponentState.prepareStringForBidiRendering((String)this.mSummaryListModel.getElementAt(n).getName()));
                    continue;
                }
                this.mVariablesCombo.addItem(this.mSummaryListModel.getElementAt(n).getName());
                this.mMinusVariablesCombo.addItem(this.mSummaryListModel.getElementAt(n).getName());
            }
        } else {
            this.mDiffVarsRadio.setEnabled(false);
            this.mParentDlg.getDialogDataModel().putBoolean(DIFF_BETWEEN_VARS_RADIO_KEY, false);
        }
        this.mVariablesCombo.setSelectedIndex(-1);
        this.mMinusVariablesCombo.setSelectedIndex(-1);
        this.mGroupListModel = ((OlapCubesDlg)this.mParentDlg).getGroupingListModel();
        if (this.mGroupListModel.getSize() >= 1) {
            for (n = 0; n < this.mGroupListModel.getSize(); ++n) {
                if (ComponentState.isBtdRtlOrLtr()) {
                    this.mGroupVariablesCombo.addItem(ComponentState.prepareStringForBidiRendering((String)this.mGroupListModel.getElementAt(n).getName()));
                    continue;
                }
                this.mGroupVariablesCombo.addItem(this.mGroupListModel.getElementAt(n).getName());
            }
        } else {
            this.mDiffGrpsRadio.setEnabled(false);
            this.mParentDlg.getDialogDataModel().putBoolean(DIFF_BETWEEN_GRPS_RADIO_KEY, false);
        }
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSummStatsGroup);
        vector.add(this.mPercentDiffCheck);
        vector.add(this.mArithDiffCheck);
        vector.add(this.mVariablesCombo);
        vector.add(this.mMinusVariablesCombo);
        vector.add(this.mVarsPairButton);
        vector.add(this.mDiffVarTargetList);
        vector.add(this.mPercentLabelText);
        vector.add(this.mArithLabelText);
        vector.add(this.mDeletePairButton);
        vector.add(this.mGroupVariablesCombo);
        vector.add(this.mCategoryLabelText);
        vector.add(this.mGrpMinusCatLabelText);
        vector.add(this.mGrpVarsPairButton);
        vector.add(this.mDiffGrpTargetList);
        vector.add(this.mGrpPercentLabelText);
        vector.add(this.mGrpArithLabelText);
        vector.add(this.mGrpDeletePairButton);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void addComponentsToPanel(JPanel jPanel) {
        JComponent[] jComponentArray = new JComponent[]{this.mNoneRadio, this.mDiffVarsRadio, this.mDiffGrpsRadio};
        JPanel jPanel2 = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_OC_DIFF_SUM_STATS"));
        this.mSummStatsGroup = DialogUtil.createButtonGroup(jPanel2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, 23, null);
        JComponent[] jComponentArray2 = new JComponent[]{this.mPercentDiffCheck, this.mArithDiffCheck};
        JPanel jPanel3 = PanelFactory.getBasicPanel(jComponentArray2, PanelFactory.PanelType.yaxis, this.getResString("IDS_OC_TYPE_OF_DIFF"));
        DialogUtil.createButtonGroup(jPanel3);
        Insets insets = new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 0, 1, 1, 23, insets);
        JPanel jPanel4 = this.setupDiffBetweenVarsPanel();
        insets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 1, 3, 1, 23, insets);
        JPanel jPanel5 = this.setupDiffBetweenGroupsPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 0, 2, 3, 1, 23, insets);
    }

    private JPanel setupDiffBetweenVarsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString(DIFFS_BETWEEN_VARS_KEY));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.bottom * 2, DialogUtil.getGroupBoxInnerMargin(), insets.bottom, insets.right);
        int n = 23;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel2, this.mVarLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            insets2.set(DialogUtil.getGroupBoxInnerMargin() * 2, DialogUtil.getGroupBoxInnerMargin(), insets.bottom, insets.right);
        } else {
            insets2.set(DialogUtil.getGroupBoxInnerMargin() * 3, DialogUtil.getGroupBoxInnerMargin(), insets.bottom, insets.right);
        }
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel2, this.mMinusVarLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel3, this.mVariablesCombo, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            insets2.set(DialogUtil.getGroupBoxInnerMargin(), insets.left, insets.bottom, insets.right);
        } else {
            insets2.set(insets.top, insets.left, insets.bottom, insets.right);
        }
        DialogUtil.addUsingGBL(jPanel3, this.mMinusVariablesCombo, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mPairsLabel, gridBagConstraints, 3, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets2.set(0, DialogUtil.getGroupBoxInnerMargin() * 3, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets2.set(0, DialogUtil.getGroupBoxInnerMargin() * 4, 0, DialogUtil.getGroupBoxInnerMargin() * 4);
        DialogUtil.addUsingGBL(jPanel, this.mVarsPairButton, gridBagConstraints, 2, 1, 1, 1, 10, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        insets2.set(0, 0, insets.bottom, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, this.mDiffVarScrollPane, gridBagConstraints, 3, 1, 1, 1, n, insets2);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets2.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel4, this.mPercentLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        insets2.set(DialogUtil.getGroupBoxInnerMargin() * 2, DialogUtil.getGroupBoxInnerMargin(), insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel4, this.mArithLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        insets2.set(DialogUtil.getGroupBoxInnerMargin(), insets.left, insets.bottom, insets.right);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel5, (JComponent)((Object)this.mPercentLabelText), gridBagConstraints, 0, 0, 1, 1, n, insets2);
        insets2.set(DialogUtil.getGroupBoxInnerMargin(), insets.left, DialogUtil.getGroupBoxInnerMargin(), insets.right);
        DialogUtil.addUsingGBL(jPanel5, (JComponent)((Object)this.mArithLabelText), gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 2, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets2.set(0, DialogUtil.getGroupBoxInnerMargin() * 3, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 24;
        insets2.set(DialogUtil.getGroupBoxInnerMargin(), 0, 0, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, this.mDeletePairButton, gridBagConstraints, 3, 2, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupDiffBetweenGroupsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_OC_DIFFS_BETWEEN_GROUPS"));
        jPanel.setBorder(titledBorder);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(DialogUtil.getGroupBoxInnerMargin() + insets.bottom * 2, DialogUtil.getGroupBoxInnerMargin(), insets.bottom, insets.right);
        int n = 23;
        DialogUtil.addUsingGBL(jPanel2, this.mGroupVarLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        insets2.set(DialogUtil.getGroupBoxInnerMargin(), insets.left, insets.bottom, insets.right);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel3, this.mGroupVariablesCombo, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 0, 1, 1, n, null);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        insets2.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel4, this.mCategoryLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        insets2.set(DialogUtil.getGroupBoxInnerMargin() * 2, DialogUtil.getGroupBoxInnerMargin(), insets.bottom, insets.right);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel4, this.mGrpMinusCatLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets2.set(DialogUtil.getGroupBoxInnerMargin(), insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel5, (JComponent)((Object)this.mCategoryLabelText), gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel5, (JComponent)((Object)this.mGrpMinusCatLabelText), gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 1, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 1, 1, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets2.set(0, DialogUtil.getGroupBoxInnerMargin() * 4, 0, DialogUtil.getGroupBoxInnerMargin() * 4);
        DialogUtil.addUsingGBL(jPanel, this.mGrpVarsPairButton, gridBagConstraints, 2, 1, 1, 1, 10, insets2);
        insets2.set(0, 0, 0, DialogUtil.getGroupBoxInnerMargin() * 4);
        DialogUtil.addUsingGBL(jPanel, this.mDiffBetGrpCasesLabel, gridBagConstraints, 3, 0, 1, 1, 25, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        insets2.set(0, 0, insets.bottom, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, this.mDiffGrpScrollPane, gridBagConstraints, 3, 1, 1, 1, n, insets2);
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        insets2.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel6, this.mGrpPercentLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        insets2.set(DialogUtil.getGroupBoxInnerMargin() * 2, DialogUtil.getGroupBoxInnerMargin(), insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel6, this.mGrpArithLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        JPanel jPanel7 = new JPanel(new GridBagLayout());
        insets2.set(DialogUtil.getGroupBoxInnerMargin(), insets.left, insets.bottom, insets.right);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel7, (JComponent)((Object)this.mGrpPercentLabelText), gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        insets2.set(DialogUtil.getGroupBoxInnerMargin(), insets.left, DialogUtil.getGroupBoxInnerMargin(), insets.left);
        DialogUtil.addUsingGBL(jPanel7, (JComponent)((Object)this.mGrpArithLabelText), gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel6, gridBagConstraints, 0, 2, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel7, gridBagConstraints, 1, 2, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 24;
        insets2.set(DialogUtil.getGroupBoxInnerMargin(), 0, 0, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, this.mGrpDeletePairButton, gridBagConstraints, 3, 2, 1, 1, n, insets2);
        return jPanel;
    }

    class CubeDiffKeyListener
    extends DlgKeyPressListener {
        CubeDiffKeyListener() {
        }

        public void dialogKeyEvent(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            Object object = keyEvent.getSource();
            boolean bl = false;
            if (object instanceof Component) {
                bl = ((Component)object).getParent() instanceof JTable;
            }
            if (n == 10) {
                if (object instanceof JButton) {
                    JButton jButton = (JButton)object;
                    jButton.doClick();
                    keyEvent.consume();
                } else if (object instanceof Component) {
                    JComponent jComponent;
                    boolean bl2;
                    boolean bl3 = bl2 = !(object instanceof JTextArea) && !(object instanceof JTextPane) && !(object instanceof JTextField) && !(object instanceof JTable);
                    if (bl2 && object instanceof JComboBox) {
                        jComponent = (JComboBox)object;
                        if (jComponent.getParent() instanceof JTable) {
                            bl2 = false;
                        } else {
                            boolean bl4 = bl2 = !((JComboBox)jComponent).isPopupVisible();
                        }
                    }
                    if (object instanceof IntTextField) {
                        jComponent = (IntTextField)object;
                        bl2 = jComponent.checkRange();
                    } else if (object instanceof FloatTextField) {
                        jComponent = (FloatTextField)object;
                        bl2 = jComponent.checkRange();
                    } else if (object instanceof ContextEnabledTextField) {
                        jComponent = (ContextEnabledTextField)object;
                        bl2 = jComponent.validateContents();
                    }
                    if (!bl && bl2) {
                        boolean bl5;
                        jComponent = this.getDefaultButton((Component)object);
                        boolean bl6 = bl5 = object == OlapCubesDifferences.this.mCategoryLabelText || object == OlapCubesDifferences.this.mGrpMinusCatLabelText || object == OlapCubesDifferences.this.mGrpPercentLabelText || object == OlapCubesDifferences.this.mPercentLabelText || object == OlapCubesDifferences.this.mGrpArithLabelText || object == OlapCubesDifferences.this.mArithLabelText;
                        if (jComponent != null) {
                            if (!bl5) {
                                ((AbstractButton)jComponent).doClick();
                            }
                            keyEvent.consume();
                        }
                    }
                }
            }
        }
    }

    public static class MyLabelData
    implements SerializableObject {
        private String mCatLabelValue = "";
        private String mMinusCatLabelValue = "";
        private String mPercentLableValue = "";
        private String mArithLabelValue = "";
        private ISpssVariable mCatLabelVar;
        private ISpssVariable mMinusCatLabelVar;

        public String getArithLabelValue() {
            return this.mArithLabelValue.length() > 0 ? this.mArithLabelValue : null;
        }

        public void setArithLabelValue(String string) {
            this.mArithLabelValue = string;
        }

        public String getCatLabelValue() {
            return this.mCatLabelValue.length() > 0 ? this.mCatLabelValue : null;
        }

        public void setCatLabelValue(String string) {
            this.mCatLabelValue = string;
        }

        public String getMinusCatLabelValue() {
            return this.mMinusCatLabelValue.length() > 0 ? this.mMinusCatLabelValue : null;
        }

        public void setMinusCatLabelValue(String string) {
            this.mMinusCatLabelValue = string;
        }

        public String getPercentLableValue() {
            return this.mPercentLableValue.length() > 0 ? this.mPercentLableValue : null;
        }

        public void setPercentLableValue(String string) {
            this.mPercentLableValue = string;
        }

        public ISpssVariable getCatLabelVar() {
            return this.mCatLabelVar;
        }

        public void setCatLabelVar(ISpssVariable iSpssVariable) {
            this.mCatLabelVar = iSpssVariable;
        }

        public ISpssVariable getMinusCatLabelVar() {
            return this.mMinusCatLabelVar;
        }

        public void setMinusCatLabelVar(ISpssVariable iSpssVariable) {
            this.mMinusCatLabelVar = iSpssVariable;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.mCatLabelValue);
            stringBuffer.append("-");
            stringBuffer.append(this.mMinusCatLabelValue);
            if (this.mPercentLableValue == null && this.mArithLabelValue == null) {
                stringBuffer.append("(");
                stringBuffer.append("DEFAULT");
                stringBuffer.append(")");
            } else if (this.mArithLabelValue == null) {
                stringBuffer.append("(");
                stringBuffer.append(this.mPercentLableValue);
                stringBuffer.append(")");
            } else {
                stringBuffer.append("(");
                stringBuffer.append(this.mPercentLableValue);
                stringBuffer.append(",");
                stringBuffer.append(this.mArithLabelValue);
                stringBuffer.append(")");
            }
            return stringBuffer.toString();
        }

        public String getClassName() {
            return "com.spss.java_client.ui.dialogs.base.analyze.reports.olap_cubes.OlapCubesDifferences$MyLabelData";
        }

        public boolean readVersionedObject(ObjectInputStream objectInputStream, int n) throws Exception {
            this.mCatLabelValue = objectInputStream.readUTF();
            this.mMinusCatLabelValue = objectInputStream.readUTF();
            this.mPercentLableValue = objectInputStream.readUTF();
            this.mArithLabelValue = objectInputStream.readUTF();
            this.mCatLabelVar = null;
            VarInfoBag varInfoBag = new VarInfoBag();
            boolean bl = varInfoBag.readVersionedObject(objectInputStream, n);
            if (bl) {
                this.mCatLabelVar = DialogDataModel.varBagToVariable(varInfoBag);
            }
            this.mMinusCatLabelVar = null;
            varInfoBag = new VarInfoBag();
            boolean bl2 = varInfoBag.readVersionedObject(objectInputStream, n);
            if (bl2) {
                this.mMinusCatLabelVar = DialogDataModel.varBagToVariable(varInfoBag);
            }
            return bl && bl2;
        }

        public boolean writeVersionedObject(ObjectOutputStream objectOutputStream, int n) throws Exception {
            objectOutputStream.writeUTF(this.mCatLabelValue);
            objectOutputStream.writeUTF(this.mMinusCatLabelValue);
            objectOutputStream.writeUTF(this.mPercentLableValue);
            objectOutputStream.writeUTF(this.mArithLabelValue);
            VarInfoBag varInfoBag = new VarInfoBag(this.mCatLabelVar);
            boolean bl = varInfoBag.writeVersionedObject(objectOutputStream, n);
            varInfoBag = new VarInfoBag(this.mMinusCatLabelVar);
            return bl &= varInfoBag.writeVersionedObject(objectOutputStream, n);
        }
    }
}

