/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.reports.codebook;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.SpssMRVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.reports.codebook.CodebookDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class VariablesTab
extends BaseProcedureTab
implements ListDataListener {
    private static final String IDS_CODEBOOK_VARIABLES_LIST_KEY = "IDS_CODEBOOK_VARIABLES_LIST";
    private SrcVariableList mSrcVarList;
    private JLabel mVariablesLabel;
    private TargetVariableList mTgtVarsList;
    private JLabel mCodebookVariablesLabel;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mTargetVarsScrollPane;
    private ArrowButton mVarsArrowButton;
    private static int gap = 3;

    public VariablesTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.checkEnableOKPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.checkEnableOKPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.checkEnableOKPaste();
    }

    @Override
    public void reset() {
        super.reset();
        this.mTgtVarsList.removeAll();
        this.mSrcVarList.loadFromActiveDataset(true);
        this.mSrcVarList.setSelectedIndex(0);
        ((CodebookDlg)this.mParent).enableOkPaste(false);
        this.mVarsArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mVarsArrowButton.setEnabled(true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_codebook_variables";
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.addComponents(this);
        this.setFocusTraversalPolicy();
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mSrcVarList;
    }

    String getSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.mTgtVarsList.getModel().getSize(); ++i) {
            ISpssVariable iSpssVariable = this.mTgtVarsList.getModel().getElementAt(i);
            String string = iSpssVariable.getName();
            stringBuffer.append(" " + string);
            if (iSpssVariable instanceof SpssMRVariable) continue;
            stringBuffer.append(" [");
            MeasurementLevel measurementLevel = iSpssVariable.getDisplayMeasurementLevel();
            if (measurementLevel == MeasurementLevel.nominal) {
                stringBuffer.append("n");
            } else if (measurementLevel == MeasurementLevel.ordinal) {
                stringBuffer.append("o");
            } else if (measurementLevel == MeasurementLevel.scale) {
                stringBuffer.append("s");
            } else {
                stringBuffer.append("s");
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        int n = this.mSrcVarList.getContextMenuFlags();
        this.mSrcVarList.setContextMenuFlags(8 | n);
        this.mSrcVarList.loadFromActiveDataset(true);
        if (this.mSrcVarList.getModel().getSize() > 0) {
            this.mSrcVarList.setSelectedIndex(0);
        }
        this.mVariablesLabel = DialogUtil.createLabel(this.mParent, "IDS_CODEBOOK_VARIABLES_COLON_LABEL");
        this.mVariablesLabel.setLabelFor(this.mSrcVarList);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mTgtVarsList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mTgtVarsList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mCodebookVariablesLabel = DialogUtil.createLabel(this.mParent, "IDS_CODEBOOK_CODEBOOK_VARIABLES_COLON_LABEL");
        this.mCodebookVariablesLabel.setLabelFor(this.mTgtVarsList);
        this.mTgtVarsList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTgtVarsList.getFixedCellHeight() * 12 + 2));
        this.mTargetVarsScrollPane = new JScrollPane(this.mTgtVarsList);
        this.mTargetVarsScrollPane.setPreferredSize(this.mTgtVarsList.getMinimumSize());
        this.mTgtVarsList.setIdentifier(IDS_CODEBOOK_VARIABLES_LIST_KEY);
        this.mTgtVarsList.getModel().addListDataListener(this);
        this.mVarsArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mVarsArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mVarsArrowButton.registerVariableList(this.mTgtVarsList, SpssArrowButton.ButtonOrientation.left);
        this.mVarsArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mVarsArrowButton.setEnabled(true);
    }

    private void addComponents(JPanel jPanel) {
        double[] dArray = new double[]{-1.0, -2.0, -1.0};
        double[] dArray2 = new double[]{-2.0, -1.0};
        TableLayout tableLayout = new TableLayout(dArray, dArray2);
        jPanel.setLayout((LayoutManager)tableLayout);
        tableLayout.setHGap(gap);
        tableLayout.setVGap(gap);
        jPanel.add((Component)this.mVariablesLabel, "0, 0, 0, 0");
        jPanel.add((Component)this.mCodebookVariablesLabel, "2, 0, 0, 0");
        jPanel.add((Component)this.mSrcScrollPane, "0, 1, 0, 0");
        jPanel.add((Component)this.mVarsArrowButton, "1, 1, c, c");
        jPanel.add((Component)this.mTargetVarsScrollPane, "2, 1, 0, 0");
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mVarsArrowButton);
        vector.add(this.mTgtVarsList);
        this.setComponentOrder(vector);
    }

    private void checkEnableOKPaste() {
        ((CodebookDlg)this.mParent).enableOkPaste(this.mTgtVarsList.getModel().getSize() > 0);
    }
}

