/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.reports.codebook;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssMultiLineLabel;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.analyze.reports.codebook.CodebookDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.system.OSInfo;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class StatisticsTab
extends BaseProcedureTab {
    private static final String IDS_CODEBOOK_STATISTICS_COUNT_KEY = "IDS_CODEBOOK_STATISTICS_COUNT_LABEL";
    private static final String IDS_CODEBOOK_STATISTICS_PERCENT_KEY = "IDS_CODEBOOK_STATISTICS_PERCENT_LABEL";
    private static final String IDS_CODEBOOK_STATISTICS_MEAN_KEY = "IDS_CODEBOOK_STATISTICS_MEAN_LABEL";
    private static final String IDS_CODEBOOK_STATISTICS_STD_DEV_KEY = "IDS_CODEBOOK_STATISTICS_STD_DEV_LABEL";
    private static final String IDS_CODEBOOK_STATISTICS_QUARTILES_KEY = "IDS_CODEBOOK_STATISTICS_QUARTILES_LABEL";
    private JCheckBox mCountCheck;
    private JCheckBox mPercentCheck;
    private JCheckBox mMeanCheck;
    private JCheckBox mStdDevCheck;
    private JCheckBox mQuartilesCheck;
    private JTextArea mCountAndPercentMsg;
    private StringTextField mCentrolTendencyMsg;
    private static int gap = 3;

    public StatisticsTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    private void setDefaults() {
        this.mCountCheck.setSelected(true);
        this.mPercentCheck.setSelected(true);
        this.mMeanCheck.setSelected(true);
        this.mStdDevCheck.setSelected(true);
        this.mQuartilesCheck.setSelected(true);
        this.mCountAndPercentMsg.setSelectionStart(0);
        this.mCountAndPercentMsg.setSelectionEnd(this.mCountAndPercentMsg.getText().length());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_codebook_statistics";
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setDefaults();
        this.addComponents(this);
    }

    @Override
    protected void aboutToShowTab() {
        this.setFocusTraversalPolicy();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mCountCheck;
    }

    String getSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SyntaxUtil.getSubCommand("/STATISTICS"));
        if (!this.checkboxItemChecked()) {
            stringBuffer.append(" NONE");
        } else {
            if (this.mCountCheck.isSelected()) {
                stringBuffer.append(" COUNT");
            }
            if (this.mPercentCheck.isSelected()) {
                stringBuffer.append(" PERCENT");
            }
            if (this.mMeanCheck.isSelected()) {
                stringBuffer.append(" MEAN");
            }
            if (this.mStdDevCheck.isSelected()) {
                stringBuffer.append(" STDDEV");
            }
            if (this.mQuartilesCheck.isSelected()) {
                stringBuffer.append(" QUARTILES");
            }
        }
        return stringBuffer.toString();
    }

    boolean checkboxItemChecked() {
        return this.mCountCheck.isSelected() || this.mPercentCheck.isSelected() || this.mMeanCheck.isSelected() || this.mStdDevCheck.isSelected() || this.mQuartilesCheck.isSelected();
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, IDS_CODEBOOK_STATISTICS_COUNT_KEY);
        this.mCountCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, IDS_CODEBOOK_STATISTICS_PERCENT_KEY);
        this.mPercentCheck = new JCheckBox(toggleButtonAction);
        this.mCountAndPercentMsg = new JTextArea(this.getResString("IDS_CODEBOOK_STATISTICS_COUNTS_PCT_INFO_TEXT_LABEL"));
        int n = this.mCountAndPercentMsg.getPreferredSize().height;
        this.mCountAndPercentMsg.setPreferredSize(new Dimension(430, n));
        this.mCountAndPercentMsg.setRows(2);
        this.mCountAndPercentMsg.setFont(this.mPercentCheck.getFont());
        this.mCountAndPercentMsg.setEditable(false);
        this.mCountAndPercentMsg.setEnabled(true);
        this.mCountAndPercentMsg.setOpaque(false);
        this.mCountAndPercentMsg.setFocusable(true);
        this.mCountAndPercentMsg.setWrapStyleWord(true);
        this.mCountAndPercentMsg.setLineWrap(true);
        this.mCountAndPercentMsg.setSelectionStart(0);
        this.mCountAndPercentMsg.setSelectionEnd(this.mCountAndPercentMsg.getText().length());
        toggleButtonAction = new ToggleButtonAction(this.mParent, IDS_CODEBOOK_STATISTICS_MEAN_KEY);
        this.mMeanCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, IDS_CODEBOOK_STATISTICS_STD_DEV_KEY);
        this.mStdDevCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, IDS_CODEBOOK_STATISTICS_QUARTILES_KEY);
        this.mQuartilesCheck = new JCheckBox(toggleButtonAction);
        this.mCentrolTendencyMsg = new StringTextField(this.getResString("IDS_CODEBOOK_STATISTICS_CENT_TEND_INFO_LABEL"));
        this.mCentrolTendencyMsg.setEditable(false);
        this.mCentrolTendencyMsg.setEnabled(true);
        this.mCentrolTendencyMsg.setBorder(null);
        this.mCentrolTendencyMsg.setOpaque(false);
    }

    private void addComponents(JPanel jPanel) {
        double[] dArray = new double[]{-1.0};
        double[] dArray2 = new double[]{-1.0, -1.0};
        TableLayout tableLayout = new TableLayout(dArray, dArray2);
        jPanel.setLayout((LayoutManager)tableLayout);
        tableLayout.setHGap(gap);
        tableLayout.setVGap(gap);
        jPanel.add((Component)this.createCountsPanel(), "0, 0, 0, 0");
        jPanel.add((Component)this.createCentralPanel(), "0, 1, 0, 0");
    }

    private JPanel createCountsPanel() {
        int n = 430;
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            n = 450;
        }
        JLabel jLabel = new JLabel(" ");
        JComponent[] jComponentArray = new JComponent[]{this.mCountCheck, this.mPercentCheck, jLabel, this.mCountAndPercentMsg};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_CODEBOOK_STATISTICS_COUNTS_PCT_LABEL"));
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel createCentralPanel() {
        int n = 430;
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            n = 450;
        }
        SpssMultiLineLabel spssMultiLineLabel = new SpssMultiLineLabel(this.getResString("IDS_CODEBOOK_STATISTICS_CENT_TEND_INFO_LABEL"), null, n);
        JLabel jLabel = new JLabel(" ");
        JComponent[] jComponentArray = new JComponent[]{this.mMeanCheck, this.mStdDevCheck, this.mQuartilesCheck, jLabel, this.mCentrolTendencyMsg};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_CODEBOOK_STATISTICS_CENT_TEND_LABEL"));
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mCountCheck);
        vector.add(this.mPercentCheck);
        vector.add(this.mCountAndPercentMsg);
        vector.add(this.mMeanCheck);
        vector.add(this.mStdDevCheck);
        vector.add(this.mQuartilesCheck);
        vector.add(this.mCentrolTendencyMsg);
        JPanel jPanel = ((BaseTabbedDialog)this.mParent).getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        vector.add(((CodebookDlg)this.mParent).getTabbedPane());
        this.setComponentOrder(vector);
    }

    private void checkEnableOKPaste() {
        ((CodebookDlg)this.mParent).enableOkPaste(true);
    }
}

