/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.reports.codebook;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.IDatasourceAttributes;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssMultiLineCheckBox;
import com.spss.java_client.ui.controls.SpssMultiLineLabel;
import com.spss.java_client.ui.dialogs.base.analyze.reports.codebook.CodebookDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.IntTextField;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;

public class OutputTab
extends BaseProcedureTab
implements ItemListener {
    private static final String IDS_CODEBOOK_OUTPUT_VAR_POSITION_CHECKBOX_KEY = "IDS_CODEBOOK_OUTPUT_VAR_POSITION_LABEL";
    private static final String IDS_CODEBOOK_OUTPUT_VAR_LABEL_CHECKBOX_KEY = "IDS_CODEBOOK_OUTPUT_VAR_LABEL_LABEL";
    private static final String IDS_CODEBOOK_OUTPUT_VAR_TYPE_CHECKBOX_KEY = "IDS_CODEBOOK_OUTPUT_VAR_TYPE_LABEL";
    private static final String IDS_CODEBOOK_OUTPUT_VAR_FORMAT_CHECKBOX_KEY = "IDS_CODEBOOK_OUTPUT_VAR_FORMAT_LABEL";
    private static final String IDS_CODEBOOK_OUTPUT_VAR_MEASLEVEL_CHECKBOX_KEY = "IDS_CODEBOOK_OUTPUT_VAR_MEASLEVEL_LABEL";
    private static final String IDS_CODEBOOK_OUTPUT_VAR_ROLE_CHECKBOX_KEY = "IDS_CODEBOOK_OUTPUT_VAR_ROLE_LABEL";
    private static final String IDS_CODEBOOK_OUTPUT_VAR_VAL_LABELS_CHECKBOX_KEY = "IDS_CODEBOOK_OUTPUT_VAR_VALUE_LABELS_LABEL";
    private static final String IDS_CODEBOOK_OUTPUT_VAR_MISS_VALUES_CHECKBOX_KEY = "IDS_CODEBOOK_OUTPUT_VAR_MISSING_LABELS_LABEL";
    private static final String IDS_CODEBOOK_OUTPUT_VAR_CUST_ATTRIB_CHECKBOX_KEY = "IDS_CODEBOOK_OUTPUT_VAR_CUST_ATTRIB_LABEL";
    private static final String IDS_CODEBOOK_OUTPUT_VAR_RESV_ATTRIB_CHECKBOX_KEY = "IDS_CODEBOOK_OUTPUT_VAR_RESV_ATTRIB_LABEL";
    private static final String IDS_CODEBOOK_OUTPUT_FILE_FILE_NAME_CHECKBOX_KEY = "IDS_CODEBOOK_OUTPUT_FILE_FILE_NAME_LABEL";
    private static final String IDS_CODEBOOK_OUTPUT_FILE_LOCATION_CHECKBOX_KEY = "IDS_CODEBOOK_OUTPUT_FILE_LOCATION_LABEL";
    private static final String IDS_CODEBOOK_OUTPUT_FILE_NUM_CASES_CHECKBOX_KEY = "IDS_CODEBOOK_OUTPUT_FILE_NUM_CASES_LABEL";
    private static final String IDS_CODEBOOK_OUTPUT_FILE_LABEL_CHECKBOX_KEY = "IDS_CODEBOOK_OUTPUT_FILE_LABEL_LABEL";
    private static final String IDS_CODEBOOK_OUTPUT_FILE_DOCUMENTS_CHECKBOX_KEY = "IDS_CODEBOOK_OUTPUT_FILE_DOCUMENTS_LABEL";
    private static final String IDS_CODEBOOK_OUTPUT_FILE_WEIGHT_STAT_CHECKBOX_KEY = "IDS_CODEBOOK_OUTPUT_FILE_WEIGHT_STAT_LABEL";
    private static final String IDS_CODEBOOK_OUTPUT_FILE_CUST_ATTRIB_CHECKBOX_KEY = "IDS_CODEBOOK_OUTPUT_FILE_CUST_ATTRIB_LABEL";
    private static final String IDS_CODEBOOK_OUTPUT_FILE_RESV_ATTRIB_CHECKBOX_KEY = "IDS_CODEBOOK_OUTPUT_FILE_RESV_ATTRIB_LABEL";
    private static final String IDS_CODEBOOK_OUTPUT_DISP_ORDER_COMBO_KEY = "IDS_CODEBOOK_DISP_ORDER_COMBOBOX";
    private static final String IDS_CODEBOOK_OUTPUT_DISP_ORDER_ASCENDING_RADIO_KEY = "IDS_CODEBOOK_OUTPUT_ASCENDING_RADIO_LABEL";
    private static final String IDS_CODEBOOK_OUTPUT_DISP_ORDER_DESCENDING_RADIO_KEY = "IDS_CODEBOOK_OUTPUT_DESCENDING_RADIO_LABEL";
    private static final String IDS_CODEBOOK_OUTPUT_SUPRESS_DISPLAY_CHECK_KEY = "IDS_CODEBOOK_OUTPUT_SUPPRESS_DISPLAY_LABEL";
    private static final String IDS_CODEBOOK_OUTPUT_MAX_CATEGORIES_EDIT_KEY = "IDS_CODEBOOK_OUTPUT_MAX_CATS_EDIT";
    private static final String DEFAULT_MAX_CATS_VALUE = "200";
    private static final int DISP_ORDER_ALPHA = 0;
    private static final int DISP_ORDER_FILE = 1;
    private static final int DISP_ORDER_MEASLEVEL = 2;
    private static final int DISP_ORDER_VARLIST = 3;
    private JCheckBox mVarPositionCheck;
    private JCheckBox mVarLabelCheck;
    private JCheckBox mVarTypeCheck;
    private JCheckBox mVarFormatCheck;
    private JCheckBox mVarMeasLevelCheck;
    private JCheckBox mVarRoleCheck;
    private JCheckBox mVarValueLabelsCheck;
    private JCheckBox mVarMissingValuesCheck;
    private JCheckBox mVarCustAttribCheck;
    private JCheckBox mVarResvAttribCheck;
    private JCheckBox mFileFileNameCheck;
    private JCheckBox mFileLocationCheck;
    private JCheckBox mFileNumCasesCheck;
    private JCheckBox mFileLabelCheck;
    private JCheckBox mFileDocumentsCheck;
    private JCheckBox mFileWeightStatusCheck;
    private JCheckBox mFileCustAttribCheck;
    private JCheckBox mFileResvAttribCheck;
    private JComboBox mDisplayOrderCombo;
    private SpssButtonGroup mDispOrderButtonGroup;
    private JRadioButton mAscendingRadio;
    private JRadioButton mDescendingRadio;
    private SpssMultiLineCheckBox mSuppressDisplayCheck;
    private IntTextField mMaxCatsEdit;
    private JLabel mMaxCatsLabel;
    private static int gap = 3;

    public OutputTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mSuppressDisplayCheck) {
            this.mMaxCatsLabel.setEnabled(this.mSuppressDisplayCheck.isSelected());
            this.mMaxCatsEdit.setEnabled(this.mSuppressDisplayCheck.isSelected());
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_codebook_output";
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setDefaults();
        this.addComponents(this);
    }

    @Override
    protected void aboutToShowTab() {
        this.setFocusTraversalPolicy();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mVarPositionCheck;
    }

    String getSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SyntaxUtil.getSubCommand("/VARINFO"));
        if (this.mVarPositionCheck.isSelected()) {
            stringBuffer.append(" POSITION");
        }
        if (this.mVarLabelCheck.isSelected()) {
            stringBuffer.append(" LABEL");
        }
        if (this.mVarTypeCheck.isSelected()) {
            stringBuffer.append(" TYPE");
        }
        if (this.mVarFormatCheck.isSelected()) {
            stringBuffer.append(" FORMAT");
        }
        if (this.mVarMeasLevelCheck.isSelected()) {
            stringBuffer.append(" MEASURE");
        }
        if (this.mVarRoleCheck.isSelected()) {
            stringBuffer.append(" ROLE");
        }
        if (this.mVarValueLabelsCheck.isSelected()) {
            stringBuffer.append(" VALUELABELS");
        }
        if (this.mVarMissingValuesCheck.isSelected()) {
            stringBuffer.append(" MISSING");
        }
        if (this.mVarCustAttribCheck.isSelected()) {
            stringBuffer.append(" ATTRIBUTES");
        }
        if (this.mVarResvAttribCheck.isSelected()) {
            stringBuffer.append(" RESERVEDATTRIBUTES");
        }
        stringBuffer.append("\n");
        if (this.fileVarItemChecked()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/FILEINFO"));
            if (this.mFileFileNameCheck.isSelected()) {
                stringBuffer.append(" NAME");
            }
            if (this.mFileLocationCheck.isSelected()) {
                stringBuffer.append(" LOCATION");
            }
            if (this.mFileNumCasesCheck.isSelected()) {
                stringBuffer.append(" CASECOUNT");
            }
            if (this.mFileLabelCheck.isSelected()) {
                stringBuffer.append(" LABEL");
            }
            if (this.mFileDocumentsCheck.isSelected()) {
                stringBuffer.append(" DOCUMENTS");
            }
            if (this.mFileWeightStatusCheck.isSelected()) {
                stringBuffer.append(" WEIGHT");
            }
            if (this.mFileCustAttribCheck.isSelected()) {
                stringBuffer.append(" ATTRIBUTES");
            }
            if (this.mFileResvAttribCheck.isSelected()) {
                stringBuffer.append(" RESERVEDATTRIBUTES");
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append(SyntaxUtil.getSubCommand("/OPTIONS"));
        stringBuffer.append(" VARORDER=");
        int n = this.mDisplayOrderCombo.getSelectedIndex();
        if (n == 0) {
            stringBuffer.append("ALPHA");
        }
        if (n == 1) {
            stringBuffer.append("FILE");
        }
        if (n == 2) {
            stringBuffer.append("MEASURE");
        }
        if (n == 3) {
            stringBuffer.append("VARLIST");
        }
        if (n > 3) {
            stringBuffer.append("ATTRIBUTE(" + this.mDisplayOrderCombo.getItemAt(n) + ")");
        }
        stringBuffer.append(" SORT=");
        if (this.mAscendingRadio.isSelected()) {
            stringBuffer.append("ASCENDING");
        } else {
            stringBuffer.append("DESCENDING");
        }
        if (this.mSuppressDisplayCheck.isSelected()) {
            stringBuffer.append(" MAXCATS=" + this.mMaxCatsEdit.getText());
        }
        return stringBuffer.toString();
    }

    boolean fileVarItemChecked() {
        return this.mFileFileNameCheck.isSelected() || this.mFileLocationCheck.isSelected() || this.mFileNumCasesCheck.isSelected() || this.mFileLabelCheck.isSelected() || this.mFileDocumentsCheck.isSelected() || this.mFileWeightStatusCheck.isSelected() || this.mFileCustAttribCheck.isSelected() || this.mFileResvAttribCheck.isSelected();
    }

    @Override
    protected boolean validateTab() {
        String string;
        if (!(this.mVarPositionCheck.isSelected() || this.mVarLabelCheck.isSelected() || this.mVarTypeCheck.isSelected() || this.mVarFormatCheck.isSelected() || this.mVarMeasLevelCheck.isSelected() || this.mVarRoleCheck.isSelected() || this.mVarValueLabelsCheck.isSelected() || this.mVarMissingValuesCheck.isSelected() || this.mVarCustAttribCheck.isSelected() || this.mVarResvAttribCheck.isSelected())) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_CODEBOOK_OUTPUT_VAR_INFO_ERR_MSG"), VersionInfo.getAppVersionString());
            this.mVarPositionCheck.requestFocusInWindow();
            return false;
        }
        if (this.mSuppressDisplayCheck.isSelected() && this.mMaxCatsEdit.isEnabled() && ((string = this.mMaxCatsEdit.getText()).length() == 0 || Integer.valueOf(string) < 1)) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_CODEBOOK_OUTPUT_MAX_CATS_ERR_MSG"), VersionInfo.getAppVersionString());
            this.mMaxCatsEdit.requestFocusInWindow();
            return false;
        }
        return true;
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, IDS_CODEBOOK_OUTPUT_VAR_POSITION_CHECKBOX_KEY);
        this.mVarPositionCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, IDS_CODEBOOK_OUTPUT_VAR_LABEL_CHECKBOX_KEY);
        this.mVarLabelCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, IDS_CODEBOOK_OUTPUT_VAR_TYPE_CHECKBOX_KEY);
        this.mVarTypeCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, IDS_CODEBOOK_OUTPUT_VAR_FORMAT_CHECKBOX_KEY);
        this.mVarFormatCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, IDS_CODEBOOK_OUTPUT_VAR_MEASLEVEL_CHECKBOX_KEY);
        this.mVarMeasLevelCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, IDS_CODEBOOK_OUTPUT_VAR_ROLE_CHECKBOX_KEY);
        this.mVarRoleCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, IDS_CODEBOOK_OUTPUT_VAR_VAL_LABELS_CHECKBOX_KEY);
        this.mVarValueLabelsCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, IDS_CODEBOOK_OUTPUT_VAR_MISS_VALUES_CHECKBOX_KEY);
        this.mVarMissingValuesCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, IDS_CODEBOOK_OUTPUT_VAR_CUST_ATTRIB_CHECKBOX_KEY);
        this.mVarCustAttribCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, IDS_CODEBOOK_OUTPUT_VAR_RESV_ATTRIB_CHECKBOX_KEY);
        this.mVarResvAttribCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, IDS_CODEBOOK_OUTPUT_FILE_FILE_NAME_CHECKBOX_KEY);
        this.mFileFileNameCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, IDS_CODEBOOK_OUTPUT_FILE_LOCATION_CHECKBOX_KEY);
        this.mFileLocationCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, IDS_CODEBOOK_OUTPUT_FILE_NUM_CASES_CHECKBOX_KEY);
        this.mFileNumCasesCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, IDS_CODEBOOK_OUTPUT_FILE_LABEL_CHECKBOX_KEY);
        this.mFileLabelCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, IDS_CODEBOOK_OUTPUT_FILE_DOCUMENTS_CHECKBOX_KEY);
        this.mFileDocumentsCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, IDS_CODEBOOK_OUTPUT_FILE_WEIGHT_STAT_CHECKBOX_KEY);
        this.mFileWeightStatusCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, IDS_CODEBOOK_OUTPUT_FILE_CUST_ATTRIB_CHECKBOX_KEY);
        this.mFileCustAttribCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, IDS_CODEBOOK_OUTPUT_FILE_RESV_ATTRIB_CHECKBOX_KEY);
        this.mFileResvAttribCheck = new JCheckBox(toggleButtonAction);
        this.mDisplayOrderCombo = new JComboBox<String>(this.getResStringArray("IDS_CODEBOOK_OUTPUT_DISPLAY_ORDER_COMBO_ARRAY"));
        this.mDisplayOrderCombo.setAction(new ComboboxAction(this.mParent, IDS_CODEBOOK_OUTPUT_DISP_ORDER_COMBO_KEY));
        this.mDispOrderButtonGroup = new SpssButtonGroup();
        this.mAscendingRadio = new JRadioButton(new ToggleButtonAction(this.mParent, IDS_CODEBOOK_OUTPUT_DISP_ORDER_ASCENDING_RADIO_KEY));
        this.mDescendingRadio = new JRadioButton(new ToggleButtonAction(this.mParent, IDS_CODEBOOK_OUTPUT_DISP_ORDER_DESCENDING_RADIO_KEY));
        this.mDispOrderButtonGroup.add(this.mAscendingRadio);
        this.mDispOrderButtonGroup.add(this.mDescendingRadio);
        toggleButtonAction = new ToggleButtonAction(this.mParent, IDS_CODEBOOK_OUTPUT_SUPRESS_DISPLAY_CHECK_KEY);
        this.mSuppressDisplayCheck = new SpssMultiLineCheckBox(toggleButtonAction);
        this.mSuppressDisplayCheck.addItemListener(this);
        this.mMaxCatsEdit = new IntTextField(true);
        this.mMaxCatsLabel = DialogUtil.createLabel(this.mParent, "IDS_CODEBOOK_OUTPUT_MAX_NUM_CATS_LABEL");
        this.mMaxCatsLabel.setLabelFor((Component)this.mMaxCatsEdit);
        this.mMaxCatsEdit.setAction((Action)new TextFieldAction(this.mParent, IDS_CODEBOOK_OUTPUT_MAX_CATEGORIES_EDIT_KEY));
    }

    private void setDefaults() {
        this.mVarPositionCheck.setSelected(true);
        this.mVarLabelCheck.setSelected(true);
        this.mVarTypeCheck.setSelected(true);
        this.mVarFormatCheck.setSelected(true);
        this.mVarMeasLevelCheck.setSelected(true);
        this.mVarRoleCheck.setSelected(true);
        this.mVarValueLabelsCheck.setSelected(true);
        this.mVarMissingValuesCheck.setSelected(true);
        this.mVarCustAttribCheck.setSelected(true);
        this.mVarResvAttribCheck.setSelected(false);
        this.mFileFileNameCheck.setSelected(false);
        this.mFileLocationCheck.setSelected(false);
        this.mFileNumCasesCheck.setSelected(false);
        this.mFileLabelCheck.setSelected(false);
        this.mFileDocumentsCheck.setSelected(false);
        this.mFileWeightStatusCheck.setSelected(false);
        this.mFileCustAttribCheck.setSelected(false);
        this.mFileResvAttribCheck.setSelected(false);
        if (this.mDisplayOrderCombo.getItemCount() > 0) {
            this.mDisplayOrderCombo.removeAllItems();
        }
        String[] stringArray = this.getResStringArray("IDS_CODEBOOK_OUTPUT_DISPLAY_ORDER_COMBO_ARRAY");
        for (int i = 0; i < stringArray.length; ++i) {
            this.mDisplayOrderCombo.addItem(stringArray[i]);
        }
        this.mDisplayOrderCombo.setSelectedIndex(3);
        this.addCustomAttributes(this.mDisplayOrderCombo);
        this.mAscendingRadio.setSelected(true);
        this.mSuppressDisplayCheck.setSelected(true);
        this.mMaxCatsEdit.setText(DEFAULT_MAX_CATS_VALUE);
        this.mMaxCatsLabel.setEnabled(this.mSuppressDisplayCheck.isSelected());
        this.mMaxCatsEdit.setEnabled(this.mSuppressDisplayCheck.isSelected());
    }

    private void addCustomAttributes(JComboBox jComboBox) {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        for (int i = 0; i < iSpssDataSrc.columnCount(); ++i) {
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
            IDatasourceAttributes iDatasourceAttributes = iSpssVariable.getAttributes();
            if (iDatasourceAttributes == null) continue;
            for (int j = 0; j < iDatasourceAttributes.size(); ++j) {
                if (this.isStringInCombo(iDatasourceAttributes.name(j), jComboBox) || this.isSystemAttribute(iDatasourceAttributes.name(j))) continue;
                jComboBox.addItem(iDatasourceAttributes.name(j));
            }
        }
    }

    private boolean isStringInCombo(String string, JComboBox jComboBox) {
        boolean bl = false;
        for (int i = 0; i < jComboBox.getItemCount() && !bl; ++i) {
            if (!string.equals(jComboBox.getItemAt(i))) continue;
            bl = true;
        }
        return bl;
    }

    private boolean isSystemAttribute(String string) {
        return string.startsWith("$") || string.startsWith("@");
    }

    private void addComponents(JPanel jPanel) {
        double[] dArray = new double[]{-1.0, -1.0};
        double[] dArray2 = new double[]{-1.0, -2.0};
        TableLayout tableLayout = new TableLayout(dArray, dArray2);
        jPanel.setLayout((LayoutManager)tableLayout);
        tableLayout.setHGap(gap);
        tableLayout.setVGap(gap);
        jPanel.add((Component)this.createVarInfoPanel(), "0, 0, 0, 0");
        jPanel.add((Component)this.createFileInfoPanel(), "1, 0, 0, 0");
        jPanel.add((Component)this.createVarDisplayOrderPanel(), "0, 1, 0, 0");
        jPanel.add((Component)this.createMaxCatsPanel(), "1, 1, 0, 0");
    }

    private JPanel createMaxCatsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.add(this.mMaxCatsLabel);
        jPanel.add((Component)this.mMaxCatsEdit);
        JComponent[] jComponentArray = new JComponent[]{this.mSuppressDisplayCheck, jPanel};
        return PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_CODEBOOK_OUTPUT_MAX_CATS_LABEL"));
    }

    private JPanel createVarDisplayOrderPanel() {
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_CODEBOOK_OUTPUT_DISPLAY_ORDER_LABEL");
        jLabel.setLabelFor(this.mDisplayOrderCombo);
        JPanel jPanel = new JPanel();
        double[] dArray = new double[]{-1.0, -1.0};
        double[] dArray2 = new double[]{-2.0};
        TableLayout tableLayout = new TableLayout(dArray, dArray2);
        jPanel.setLayout((LayoutManager)tableLayout);
        tableLayout.setHGap(20);
        tableLayout.setVGap(gap);
        jPanel.add((Component)this.mAscendingRadio, "0, 0, 0, 0");
        jPanel.add((Component)this.mDescendingRadio, "1, 0, 0, 0");
        JComponent[] jComponentArray = new JComponent[]{jLabel, this.mDisplayOrderCombo, jPanel};
        return PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_CODEBOOK_OUTPUT_VAR_DISP_ORDER_LABEL"));
    }

    private JPanel createFileInfoPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mFileFileNameCheck, this.mFileLocationCheck, this.mFileNumCasesCheck, this.mFileLabelCheck, this.mFileDocumentsCheck, this.mFileWeightStatusCheck, this.mFileCustAttribCheck, this.mFileResvAttribCheck};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_CODEBOOK_OUTPUT_FILE_INFO_LABEL"));
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel createVarInfoPanel() {
        int n = 220;
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            n = 250;
        }
        SpssMultiLineLabel spssMultiLineLabel = new SpssMultiLineLabel(this.getResString("IDS_CODEBOOK_OUTPUT_VAR_MUST_SEL_MSG"), null, n);
        JLabel jLabel = new JLabel(" ");
        JComponent[] jComponentArray = new JComponent[]{this.mVarPositionCheck, this.mVarLabelCheck, this.mVarTypeCheck, this.mVarFormatCheck, this.mVarMeasLevelCheck, this.mVarRoleCheck, this.mVarValueLabelsCheck, this.mVarMissingValuesCheck, this.mVarCustAttribCheck, this.mVarResvAttribCheck, jLabel, spssMultiLineLabel};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_CODEBOOK_OUTPUT_VAR_INFO_LABEL"));
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mVarPositionCheck);
        vector.add(this.mVarLabelCheck);
        vector.add(this.mVarTypeCheck);
        vector.add(this.mVarFormatCheck);
        vector.add(this.mVarMeasLevelCheck);
        vector.add(this.mVarRoleCheck);
        vector.add(this.mVarValueLabelsCheck);
        vector.add(this.mVarMissingValuesCheck);
        vector.add(this.mVarCustAttribCheck);
        vector.add(this.mVarResvAttribCheck);
        vector.add(this.mFileFileNameCheck);
        vector.add(this.mFileLocationCheck);
        vector.add(this.mFileNumCasesCheck);
        vector.add(this.mFileLabelCheck);
        vector.add(this.mFileDocumentsCheck);
        vector.add(this.mFileWeightStatusCheck);
        vector.add(this.mFileCustAttribCheck);
        vector.add(this.mFileResvAttribCheck);
        vector.add(this.mDisplayOrderCombo);
        vector.add(this.mAscendingRadio);
        vector.add(this.mDescendingRadio);
        vector.add(this.mSuppressDisplayCheck);
        vector.add(this.mMaxCatsEdit);
        JPanel jPanel = ((BaseTabbedDialog)this.mParent).getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        vector.add(((CodebookDlg)this.mParent).getTabbedPane());
        this.setComponentOrder(vector);
    }

    private void checkEnableOKPaste() {
        ((CodebookDlg)this.mParent).enableOkPaste(true);
    }
}

