/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.reports.case_summaries;

import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.PlainListArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.drag_drop.PlainListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PlainListDropListener;
import com.spss.java_client.ui.dialogs.base.analyze.reports.case_summaries.CaseSummariesDlg;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IPlainListVarMoveHandler;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CaseSummariesStatistics
extends BaseSubDialog
implements IPlainListVarMoveHandler {
    static final String SOURCE_KEY = "IDS_SOURCE_KEY";
    static final String TARGET_KEY = "IDS_TARGET_KEY";
    private PlainList mSourceList;
    private JScrollPane mSourceScroll;
    private JScrollPane mTargetScroll;
    private PlainList mTargetList;
    private PlainListArrowButton mArrowButton;
    private JLabel mLabel;
    private Insets insets;

    public CaseSummariesStatistics(CaseSummariesDlg caseSummariesDlg) {
        super(caseSummariesDlg, caseSummariesDlg.getResString("IDS_CASE_STATS_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_summ_stat";
    }

    @Override
    public boolean isDragAllowed(JList jList, JList jList2, Object[] objectArray) {
        return true;
    }

    @Override
    public Object[] getModifiedData(Object[] objectArray, JList jList, PlainList plainList) {
        return null;
    }

    @Override
    public boolean preMoveVariables(Object[] objectArray, PlainList plainList) {
        return true;
    }

    @Override
    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            this.addDragAdapters();
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.SetupJListsPanel(jPanel);
        this.setFocusTraversalPolicy();
        this.mSourceList.requestFocus();
        this.mSourceList.setSelectedIndex(0);
        this.pack();
    }

    private void initVars() {
        this.mSourceList = new PlainList(SOURCE_KEY);
        this.mTargetList = new PlainList(TARGET_KEY);
        this.mArrowButton = new PlainListArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mSourceScroll = new JScrollPane(this.mSourceList);
        this.mTargetScroll = new JScrollPane(this.mTargetList);
        this.mArrowButton.registerVariableList(this.mSourceList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetList, SpssArrowButton.ButtonOrientation.left);
    }

    private void SetupJListsPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mLabel = DialogUtil.createLabel(this, "IDS_STATISTICS_COLON");
        this.mLabel.setLabelFor(this.mSourceList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        this.mSourceList.setModel(new DefaultListModel());
        DefaultListModel defaultListModel = (DefaultListModel)this.mSourceList.getModel();
        Vector vector = this.mAddintoModel();
        for (int i = 0; i < vector.size(); ++i) {
            defaultListModel.addElement(vector.get(i));
        }
        this.insets = new Insets(insets.top, 0, insets.bottom, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        Dimension dimension = this.mSourceList.getMinimumSize();
        dimension.width = 120;
        dimension.height = 250;
        this.mSourceScroll.setPreferredSize(dimension);
        this.mSourceScroll.setVerticalScrollBarPolicy(20);
        this.mSourceList.setDragEnabled(true);
        DialogUtil.addUsingGBL(jPanel, this.mSourceScroll, gridBagConstraints, 0, 1, 1, 2, n, this.insets);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        this.mLabel = DialogUtil.createLabel(this, "IDS_CELLSTATISTICS_COLON");
        this.mLabel.setLabelFor(this.mTargetList);
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mLabel, gridBagConstraints, 2, 0, 1, 1, n, this.insets);
        this.mTargetList.setModel(new DefaultListModel());
        defaultListModel = (DefaultListModel)this.mTargetList.getModel();
        defaultListModel.addElement(this.getResString("IDS_CASESUMMARIES_NUMBER_OF_CASES"));
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.insets = new Insets(insets.top, 0, insets.bottom, 2);
        dimension = this.mTargetList.getMinimumSize();
        dimension.width = 120;
        dimension.height = 250;
        this.mTargetScroll.setVerticalScrollBarPolicy(20);
        this.mTargetScroll.setPreferredSize(dimension);
        this.mTargetList.setDragEnabled(true);
        DialogUtil.addUsingGBL(jPanel, this.mTargetScroll, gridBagConstraints, 2, 1, 1, 2, n, this.insets);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSourceList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetList);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private Vector mAddintoModel() {
        Vector<String> vector = new Vector<String>();
        vector.add(this.getResString("IDS_CASESUMMARIES_MEAN"));
        vector.add(this.getResString("IDS_CASESUMMARIES_MEDIAN"));
        vector.add(this.getResString("IDS_CASESUMMARIES_GROUPEDMEDIAN"));
        vector.add(this.getResString("IDS_CASESUMMARIES_STDERR_OF_MEAN"));
        vector.add(this.getResString("IDS_CASESUMMARIES_SUM"));
        vector.add(this.getResString("IDS_CASESUMMARIES_MINIMUM"));
        vector.add(this.getResString("IDS_CASESUMMARIES_MAXIMUM"));
        vector.add(this.getResString("IDS_CASESUMMARIES_RANGE"));
        vector.add(this.getResString("IDS_CASESUMMARIES_FIRST"));
        vector.add(this.getResString("IDS_CASESUMMARIES_LAST"));
        vector.add(this.getResString("IDS_CASESUMMARIES_STD_DEV"));
        vector.add(this.getResString("IDS_CASESUMMARIES_VAR"));
        vector.add(this.getResString("IDS_CASESUMMARIES_KURTOSIS"));
        vector.add(this.getResString("IDS_CASESUMMARIES_STDERR_OF_KURTOSIS"));
        vector.add(this.getResString("IDS_CASESUMMARIES_SKEWNESS"));
        vector.add(this.getResString("IDS_CASESUMMARIES_STDERR_OF_SKEWNESS"));
        vector.add(this.getResString("IDS_CASESUMMARIES_HARMONIC_MEAN"));
        vector.add(this.getResString("IDS_CASESUMMARIES_GEOMETRIC_MEAN"));
        vector.add(this.getResString("IDS_CASESUMMARIES_PERCENT_OF_TOTAL_SUM"));
        vector.add(this.getResString("IDS_CASESUMMARIES_PERCENT_OF_TOTAL_N"));
        return vector;
    }

    private void addDragAdapters() {
        DragPane dragPane = (DragPane)this.getGlassPane();
        PlainListDragAdapter plainListDragAdapter = new PlainListDragAdapter(this.mSourceList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(this.mSourceList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mSourceList, this.mPlainListVarMoveHandler));
        plainListDragAdapter = new PlainListDragAdapter(this.mTargetList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(this.mTargetList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mTargetList, this.mPlainListVarMoveHandler));
    }
}

