/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.reports.case_summaries;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.reports.case_summaries.CaseSummariesOptions;
import com.spss.java_client.ui.dialogs.base.analyze.reports.case_summaries.CaseSummariesStatistics;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class CaseSummariesDlg
extends BaseProcedureDialog
implements ItemListener,
ListDataListener,
DocumentListener {
    static final String INTTEXT_EDIT_KEY = "IDS_INTTEXT_EDIT";
    private static final String DISPLAYCASES_TABLE_KEY = "IDS_CASESUMMARIES_TABLE_DISPLAYCASES_CHECK";
    private static final String LIMITCASES_TABLE_KEY = "IDS_CASESUMMARIES_TABLE_LIMITCASES_CHECK";
    private static final String VALIDCASES_TABLE_KEY = "IDS_CASESUMMARIES_TABLE_VALIDCASES_CHECK";
    private static final String CASENUMBERS_TABLE_KEY = "IDS_CASESUMMARIES_TABLE_CASENUMBERS_CHECK";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList;
    private TargetVariableList mGroupingVarList;
    private JCheckBox mDisplayCasesCheck;
    private JCheckBox mLimitCheck;
    private JCheckBox mValidCheck;
    private JCheckBox mShowcaseCheck;
    private IntTextField mLimitTextEdit;
    private DialogDataModel model;
    private ArrowButton mArrowButton;
    private ArrowButton mGroupArrowButton;
    private Dimension size;
    private Insets insets;
    private StringBuffer syntax;
    private JPanel CheckPanel;
    private JScrollPane scrollPane;

    public CaseSummariesDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle.getDefaultResourceBundleName(), AnalyzeResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_CASESUMMARIES"));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_summ";
    }

    @Override
    public String generateSyntax() {
        this.syntax = SyntaxUtil.startSyntax();
        this.model = this.getDialogDataModel();
        this.syntax.append(SyntaxUtil.getMainCommand("SUMMARIZE"));
        String string = this.mTargetVarList.getVariablesStringList();
        this.syntax.append("\n");
        this.syntax.append(SyntaxUtil.getSubCommand("/TABLES="));
        this.syntax.append(string);
        String string2 = this.mGroupingVarList.getVariablesStringList();
        string2 = string2 + " ";
        int n = 0;
        String[] stringArray = new String[50];
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
        if (string2 != "") {
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                this.syntax.append(" BY ");
                this.syntax.append(stringArray[n]);
                ++n;
            }
        }
        this.syntax.append("\n");
        this.syntax.append(SyntaxUtil.getSubCommand("/FORMAT="));
        if (!this.mDisplayCasesCheck.isSelected()) {
            this.syntax.append("NOLIST");
            this.syntax.append(this.checkMissing(this.model.getString("IDS_MISSING_EDIT")));
            this.syntax.append(this.checkSubheadingTotal());
        } else {
            if (this.mValidCheck.isSelected()) {
                this.syntax.append("VALIDLIST");
            } else {
                this.syntax.append("LIST");
            }
            this.syntax.append(" ");
            if (this.mShowcaseCheck.isSelected()) {
                this.syntax.append("CASENUM");
            } else {
                this.syntax.append("NOCASENUM");
            }
            this.syntax.append(this.checkMissing(this.model.getString("IDS_MISSING_EDIT")));
            this.syntax.append(this.checkSubheadingTotal());
            if (this.mLimitCheck.isSelected()) {
                this.syntax.append(" LIMIT=");
                this.syntax.append(this.mLimitTextEdit.getText());
            }
        }
        this.syntax.append("\n");
        this.syntax.append(SyntaxUtil.getSubCommand("/TITLE="));
        String string3 = this.model.getString("IDS_TEXTAREA_TITLE");
        if (string3 != null) {
            this.syntax.append(CharacterUtil.smartQuote((String)this.getSyntaxTitleRelated(string3)));
            string3 = this.model.getString("IDS_TEXT_AREA_CAPTION");
            if (string3 != null && string3.length() != 0) {
                this.syntax.append("\n");
                this.syntax.append(SyntaxUtil.getSubCommand("/FOOTNOTE "));
                this.syntax.append(CharacterUtil.smartQuote((String)this.getSyntaxTitleRelated(string3)));
            }
        } else {
            this.syntax.append(CharacterUtil.smartQuote((String)this.getSyntaxTitleRelated(this.getResString("IDS_CASE_OPTION_TITLEAREA"))));
        }
        this.syntax.append("\n");
        this.syntax.append(SyntaxUtil.getSubCommand("/MISSING="));
        Boolean bl = this.model.getBoolean("IDS_CASESUMMARIES_TABLE_MISSINGVAL_CHECK");
        if (bl != null && !bl.booleanValue()) {
            this.syntax.append("VARIABLE");
        } else if (bl == null) {
            this.syntax.append("VARIABLE");
        } else {
            this.syntax.append("TABLE");
        }
        this.syntax.append("\n");
        this.syntax.append(SyntaxUtil.getSubCommand("/CELLS="));
        Object[] objectArray = this.model.getArray("IDS_TARGET_KEY");
        boolean bl2 = false;
        HashMap<String, String> hashMap = this.getStatMap();
        if (this.model.getArray("IDS_TARGET_KEY") == null) {
            this.syntax.append(hashMap.get(this.getResString("IDS_CASESUMMARIES_NUMBER_OF_CASES")));
        } else {
            for (int i = 0; i < objectArray.length; ++i) {
                if (i == objectArray.length - 1) {
                    this.syntax.append(hashMap.get(objectArray[i]));
                } else {
                    String string4 = hashMap.get(objectArray[i]) + " ";
                    this.syntax.append(string4);
                }
                bl2 = true;
            }
            if (!bl2) {
                this.syntax.append("NONE");
            }
        }
        this.syntax.append(SyntaxUtil.terminateSyntax());
        return this.syntax.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.isEnableOkPaste();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.isEnableOkPaste();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.isEnableOkPaste();
    }

    @Override
    public String getIActionKey() {
        return "analyze_reports_case_summ";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(true);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mDisplayCasesCheck) {
            this.checkSelections();
        }
        if (itemEvent.getSource() == this.mLimitCheck) {
            this.mLimitTextEdit.setEnabled(this.mLimitCheck.isSelected());
            this.mLimitTextEdit.setOpaque(this.mLimitCheck.isSelected());
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.SetupJListsPanel(jPanel);
        this.SetupCheckboxPanel(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_STATS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CaseSummariesDlg.this.runStatsSubDialog();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        toggleButtonAction = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CaseSummariesDlg.this.runOptionSubDialog();
            }
        };
        JButton jButton2 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton2);
        return jPanel;
    }

    private void checkSelections() {
        this.mLimitCheck.setEnabled(this.mDisplayCasesCheck.isSelected());
        this.mValidCheck.setEnabled(this.mDisplayCasesCheck.isSelected());
        this.mShowcaseCheck.setEnabled(this.mDisplayCasesCheck.isSelected());
        this.mLimitTextEdit.setEnabled(this.mDisplayCasesCheck.isSelected() && this.mLimitCheck.isSelected());
        this.mLimitTextEdit.setOpaque(this.mDisplayCasesCheck.isSelected() && this.mLimitCheck.isSelected());
    }

    private String getSyntaxTitleRelated(String string) {
        int n = string.length();
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            string2 = string.charAt(i) == '\n' ? string2 + " \\n " : string2 + string.charAt(i);
        }
        return string2;
    }

    private void runStatsSubDialog() {
        this.runSubDialog(new CaseSummariesStatistics(this));
    }

    private void runOptionSubDialog() {
        this.runSubDialog(new CaseSummariesOptions(this));
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.setMaxLimitOfList(500);
        this.mGroupArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mGroupingVarList = new TargetVariableList();
        this.mGroupingVarList.setMaxLimitOfList(10);
        this.mDisplayCasesCheck = new JCheckBox();
        this.mLimitCheck = new JCheckBox();
        this.mValidCheck = new JCheckBox();
        this.mShowcaseCheck = new JCheckBox();
        this.mLimitTextEdit = new IntTextField(1, 1409999999, true);
        this.mLimitTextEdit.setAction((Action)new TextFieldAction(this, INTTEXT_EDIT_KEY));
        this.CheckPanel = new JPanel();
        this.size = this.mLimitTextEdit.getPreferredSize();
        this.mSrcVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.loadFromActiveDataset();
        this.mGroupArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mGroupArrowButton.registerVariableList(this.mGroupingVarList, SpssArrowButton.ButtonOrientation.left);
    }

    private void setDefaults() {
        this.mShowcaseCheck.setSelected(false);
        this.mDisplayCasesCheck.setSelected(true);
        this.mLimitCheck.setSelected(true);
        this.mValidCheck.setSelected(true);
        this.mLimitCheck.setEnabled(true);
        this.mValidCheck.setEnabled(true);
        this.mShowcaseCheck.setEnabled(true);
        this.mLimitTextEdit.setEnabled(true);
        this.mLimitTextEdit.setOpaque(true);
        this.mTargetVarList.removeAll();
        this.mGroupingVarList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
        this.mLimitTextEdit.setText("100");
    }

    private void SetupJListsPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_CASESUMMARIES_SOURCE_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.scrollPane = new JScrollPane(this.mSrcVarList);
        this.scrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, this.scrollPane, gridBagConstraints, 0, 1, 1, 3, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_CASESUMMARIES_VARIABLES_COLON");
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, this.insets);
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.scrollPane = new JScrollPane(this.mTargetVarList);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 6 + 2));
        this.scrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        this.mTargetVarList.setIdentifier("CASE_SOURCE_ID");
        DialogUtil.addUsingGBL(jPanel, this.scrollPane, gridBagConstraints, 2, 1, 1, 1, n, this.insets);
        this.mTargetVarList.getModel().addListDataListener(this);
        jLabel2.setLabelFor(this.mTargetVarList);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_GROUPINGVARIABLES_COLON");
        jLabel3.setLabelFor(this.mGroupingVarList);
        this.insets = new Insets(10, 0, insets.bottom, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 2, 1, 1, n, this.insets);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mGroupArrowButton, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        this.mGroupingVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.scrollPane = new JScrollPane(this.mGroupingVarList);
        this.insets = new Insets(insets.top, 0, insets.bottom, 0);
        this.mGroupingVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 3 + 2));
        this.scrollPane.setPreferredSize(this.mGroupingVarList.getMinimumSize());
        this.mTargetVarList.setIdentifier("CASE_TARGET_ID");
        DialogUtil.addUsingGBL(jPanel, this.scrollPane, gridBagConstraints, 2, 3, 1, 1, n, this.insets);
        this.mTargetVarList.getModel().addListDataListener(this);
    }

    private void SetupCheckboxPanel(JPanel jPanel) {
        this.CheckPanel.setLayout(new GridBagLayout());
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, DISPLAYCASES_TABLE_KEY);
        this.mDisplayCasesCheck.setAction(toggleButtonAction);
        this.mDisplayCasesCheck.addItemListener(this);
        this.insets = new Insets(insets.top, 0, insets.bottom, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.CheckPanel, this.mDisplayCasesCheck, gridBagConstraints, 0, 0, 1, 1, n, this.insets);
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction(this, LIMITCASES_TABLE_KEY);
        this.mLimitCheck.setAction(toggleButtonAction2);
        this.mLimitCheck.addItemListener(this);
        this.insets = new Insets(insets.top, insets.left * 5, insets.bottom, 2);
        DialogUtil.addUsingGBL(this.CheckPanel, this.mLimitCheck, gridBagConstraints, 0, 1, 1, 1, n, this.insets);
        ToggleButtonAction toggleButtonAction3 = new ToggleButtonAction(this, VALIDCASES_TABLE_KEY);
        this.mValidCheck.setAction(toggleButtonAction3);
        this.insets = new Insets(insets.top, insets.left * 5, insets.bottom, 0);
        DialogUtil.addUsingGBL(this.CheckPanel, this.mValidCheck, gridBagConstraints, 0, 2, 1, 1, n, this.insets);
        ToggleButtonAction toggleButtonAction4 = new ToggleButtonAction(this, CASENUMBERS_TABLE_KEY);
        this.mShowcaseCheck.setAction(toggleButtonAction4);
        this.insets = new Insets(insets.top, insets.left * 5, insets.bottom, 0);
        DialogUtil.addUsingGBL(this.CheckPanel, this.mShowcaseCheck, gridBagConstraints, 0, 3, 1, 1, n, this.insets);
        this.mLimitTextEdit.setPreferredSize(this.size);
        gridBagConstraints.ipadx = 15;
        this.insets = new Insets(insets.top, insets.left, insets.bottom, 0);
        DialogUtil.addUsingGBL(this.CheckPanel, (JComponent)this.mLimitTextEdit, gridBagConstraints, 1, 1, 1, 1, n, this.insets);
        this.mLimitTextEdit.getDocument().addDocumentListener(this);
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.fill = 0;
        this.insets = new Insets(n2, 0, 0, 0);
        DialogUtil.createButtonGroup(this.CheckPanel);
        DialogUtil.addUsingGBL(jPanel, this.CheckPanel, gridBagConstraints, 0, 4, 2, 1, n, this.insets);
    }

    private void isEnableOkPaste() {
        if (this.mDisplayCasesCheck.isSelected()) {
            if (this.mLimitTextEdit.getText().length() > 0) {
                int n = this.mTargetVarList.getLastVisibleIndex();
                if (n >= 0) {
                    this.enableOkPaste(true);
                }
            } else {
                this.enableOkPaste(false);
            }
        } else {
            int n = this.mTargetVarList.getLastVisibleIndex();
            if (n >= 0) {
                this.enableOkPaste(true);
            }
        }
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mGroupArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mGroupingVarList);
        vector.add(this.mDisplayCasesCheck);
        vector.add(this.mLimitCheck);
        vector.add(this.mLimitTextEdit);
        vector.add(this.mValidCheck);
        vector.add(this.mShowcaseCheck);
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private String checkMissing(String string) {
        string = string != null && string.length() != 0 ? " MISSING=" + CharacterUtil.smartQuote((String)string) + " " : " ";
        return string;
    }

    private String checkSubheadingTotal() {
        Boolean bl = this.model.getBoolean("IDS_CASESUMMARIES_TABLE_SUBHEADING_CHECK");
        String string = bl != null && bl == false ? "NOTOTAL" : "TOTAL";
        return string;
    }

    private HashMap<String, String> getStatMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(this.getResString("IDS_CASESUMMARIES_MEAN"), "MEAN");
        hashMap.put(this.getResString("IDS_CASESUMMARIES_MEDIAN"), "MEDIAN");
        hashMap.put(this.getResString("IDS_CASESUMMARIES_GROUPEDMEDIAN"), "GMEDIAN");
        hashMap.put(this.getResString("IDS_CASESUMMARIES_STDERR_OF_MEAN"), "SEMEAN");
        hashMap.put(this.getResString("IDS_CASESUMMARIES_SUM"), "SUM");
        hashMap.put(this.getResString("IDS_CASESUMMARIES_MINIMUM"), "MIN");
        hashMap.put(this.getResString("IDS_CASESUMMARIES_MAXIMUM"), "MAX");
        hashMap.put(this.getResString("IDS_CASESUMMARIES_RANGE"), "RANGE");
        hashMap.put(this.getResString("IDS_CASESUMMARIES_FIRST"), "FIRST");
        hashMap.put(this.getResString("IDS_CASESUMMARIES_LAST"), "LAST");
        hashMap.put(this.getResString("IDS_CASESUMMARIES_STD_DEV"), "STDDEV");
        hashMap.put(this.getResString("IDS_CASESUMMARIES_VAR"), "VAR");
        hashMap.put(this.getResString("IDS_CASESUMMARIES_KURTOSIS"), "KURT");
        hashMap.put(this.getResString("IDS_CASESUMMARIES_STDERR_OF_KURTOSIS"), "SEKURT");
        hashMap.put(this.getResString("IDS_CASESUMMARIES_SKEWNESS"), "SKEW");
        hashMap.put(this.getResString("IDS_CASESUMMARIES_STDERR_OF_SKEWNESS"), "SESKEW");
        hashMap.put(this.getResString("IDS_CASESUMMARIES_HARMONIC_MEAN"), "HARMONIC");
        hashMap.put(this.getResString("IDS_CASESUMMARIES_GEOMETRIC_MEAN"), "GEOMETRIC");
        hashMap.put(this.getResString("IDS_CASESUMMARIES_PERCENT_OF_TOTAL_SUM"), "SPCT");
        hashMap.put(this.getResString("IDS_CASESUMMARIES_PERCENT_OF_TOTAL_N"), "NPCT");
        hashMap.put(this.getResString("IDS_CASESUMMARIES_NUMBER_OF_CASES"), "COUNT");
        return hashMap;
    }
}

