/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.reports;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.ExpressionBuilderTextArea;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TextAreaKeyListener;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.ExpressionTextAreaDropListener;
import com.spss.java_client.ui.dialogs.base.analyze.reports.ReportsArrrowButton;
import com.spss.java_client.ui.dialogs.base.analyze.reports.ReportsTextDropListener;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ExpressionBuilderUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ReportTitles
extends BaseSubDialog
implements ActionListener,
DocumentListener,
ListSelectionListener,
FocusListener {
    static final String LAYER_TITLE_COUNT_KEY = "IDS_TITLES_LAYER_COUNT";
    static final String LAYERS_TITLE_KEY = "IDS_TITLE_LAYERS";
    static final String CURRENT_TITLE_LAYER_KEY = "IDS_TITLE_CURRENT_LAYER";
    static final String LAYER_FOOTER_COUNT_KEY = "IDS_FOOTER_LAYER_COUNT";
    static final String LAYERS_FOOTER_KEY = "IDS_FOOTER_LAYERS";
    static final String CURRENT_FOOTER_LAYER_KEY = "IDS_FOOTER_CURRENT_LAYER";
    static final String TITLE_LEFT_TEXT = "IDS_REPORT_TITLES_TITLE_LEFT";
    static final String TITLE_CENTRE_TEXT = "IDS_REPORT_TITLES_TITLE_CENTRE";
    static final String TITLE_RIGHT_TEXT = "IDS_REPORT_TITLES_TITLE_RIGHT";
    static final String FOOTER_LEFT_TEXT = "IDS_REPORT_FOOTERS_TITLE_RIGHT";
    static final String FOOTER_CENTRE_TEXT = "IDS_REPORT_FOOTER_TITLE_CENTRE";
    static final String FOOTER_RIGHT_TEXT = "IDS_REPORT_FOOTER_TITLE_LEFT";
    private SrcVariableList mSrcVarList;
    private VariableList mSpecialvariablesList;
    private JLabel mSpecialvariables;
    private ExpressionBuilderTextArea mPageTitleLeftText;
    private ExpressionBuilderTextArea mPageTitleCentreText;
    private ExpressionBuilderTextArea mPageTitleRightText;
    private ExpressionBuilderTextArea mPageFooterLeftText;
    private ExpressionBuilderTextArea mPageFooterCentreText;
    private ExpressionBuilderTextArea mPageFooterRightText;
    private JLabel mPageTitleLeft;
    private JLabel mPageTitleCentre;
    private JLabel mPageTitleRight;
    private JLabel mPageFooterLeft;
    private JLabel mPageFooterCentre;
    private JLabel mPageFooterRight;
    private ReportsArrrowButton mTitleLeftArrow;
    private ReportsArrrowButton mTitleCentreArrow;
    private ReportsArrrowButton mTitleRightArrow;
    private ReportsArrrowButton mFooterLeftArrow;
    private ReportsArrrowButton mFooterCentreArrow;
    private ReportsArrrowButton mFooterRightArrow;
    private JButton mTitlePrevious;
    private JButton mTitleNext;
    private JButton mFooterPrevious;
    private JButton mFooterNext;
    private boolean mPreviousClicked = false;
    private TitledBorder mTitlePanelBorder;
    private int mTitleCurrentPanel;
    private Vector<String[]> mTitleLayers;
    private TitledBorder mFooterPanelBorder;
    private int mFooterCurrentPanel;
    private Vector<String[]> mFooterLayers;
    private JPanel mSourceListPanel;
    private JPanel mPageTitlePanel;
    private JPanel mPageFooterPanel;
    private JPanel mPageTitlePreviousNextPanel;
    private JPanel mPageFooterPreviousNextPanel;

    public ReportTitles(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_REPORT_SUMMARIES_TITLE"), true);
        this.mPageTitleLeftText.setValidateOnFocusLost(true);
        this.mPageTitleCentreText.setValidateOnFocusLost(true);
        this.mPageTitleRightText.setValidateOnFocusLost(true);
        this.mPageFooterLeftText.setValidateOnFocusLost(true);
        this.mPageFooterCentreText.setValidateOnFocusLost(true);
        this.mPageFooterRightText.setValidateOnFocusLost(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        this.changeArrowRegistration(object);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        this.changeArrowRegistration(object);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.mTitleLayers.size() < 10 && (object == this.mTitleLeftArrow || object == this.mTitleCentreArrow || object == this.mTitleRightArrow)) {
            this.mTitleNext.setEnabled(true);
        }
        if (this.mFooterLayers.size() < 10 && (object == this.mFooterLeftArrow || object == this.mFooterCentreArrow || object == this.mFooterRightArrow)) {
            this.mFooterNext.setEnabled(true);
        }
        if (object == this.mTitlePrevious) {
            this.doTitlePrevious();
        }
        if (object == this.mTitleNext) {
            this.doTitleNext();
        }
        if (object == this.mFooterPrevious) {
            this.doFooterPrevious();
        }
        if (object == this.mFooterNext) {
            this.doFooterNext();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.mTitleNext.setEnabled(this.isAllTitleTextFieldEmpty());
        this.mFooterNext.setEnabled(this.isAllFooterTextFieldEmpty());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.mTitleNext.setEnabled(this.isAllTitleTextFieldEmpty());
        this.mFooterNext.setEnabled(this.isAllFooterTextFieldEmpty());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.mTitleNext.setEnabled(this.isAllTitleTextFieldEmpty());
        this.mFooterNext.setEnabled(this.isAllFooterTextFieldEmpty());
    }

    public Vector<String[]> getTitleLayersVector() {
        return this.mTitleLayers;
    }

    public Vector<String[]> getFooterLayersVector() {
        return this.mFooterLayers;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_rptr_titles";
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        Integer n;
        Integer n2;
        Object object;
        super.loadState(dialogDataModel);
        Integer n3 = dialogDataModel.getInteger(LAYER_TITLE_COUNT_KEY);
        int n4 = n3 != null ? n3 : -1;
        for (int i = 0; i < n4; ++i) {
            object = (String[])dialogDataModel.getArray(LAYERS_TITLE_KEY + i);
            this.mTitleLayers.add((String[])object);
        }
        if (n4 == 0) {
            this.mTitleLayers.add(new String[3]);
        }
        if (n4 == -1) {
            this.mTitleLayers.add(new String[]{"", "", this.getResString("IDS_REPORT_PAGE_VALUE") + " )PAGE"});
        }
        if (n4 == 0) {
            this.mTitleNext.setEnabled(false);
        }
        this.mTitleCurrentPanel = (n2 = dialogDataModel.getInteger(CURRENT_TITLE_LAYER_KEY)) != null ? n2 : 0;
        this.doTitleLayerPopulate();
        if (n4 > 0 && n2 > 0) {
            this.mTitlePrevious.setEnabled(true);
        }
        int n5 = (object = dialogDataModel.getInteger(LAYER_FOOTER_COUNT_KEY)) != null ? (Integer)object : 0;
        for (int i = 0; i < n5; ++i) {
            String[] stringArray = (String[])dialogDataModel.getArray(LAYERS_FOOTER_KEY + i);
            this.mFooterLayers.add(stringArray);
        }
        if (n5 == 0) {
            this.mFooterLayers.add(new String[3]);
        }
        this.mFooterCurrentPanel = (n = dialogDataModel.getInteger(CURRENT_FOOTER_LAYER_KEY)) != null ? n : 0;
        this.doFooterLayerPopulate();
        if (n5 > 0 && n > 0) {
            this.mFooterPrevious.setEnabled(true);
        }
        this.mSpecialvariablesList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        this.saveTitleLayer();
        this.saveFooterLayer();
        boolean bl = super.saveState(dialogDataModel);
        if (bl) {
            int n;
            dialogDataModel.putInteger(LAYER_TITLE_COUNT_KEY, this.mTitleLayers.size());
            for (n = 0; n < this.mTitleLayers.size(); ++n) {
                dialogDataModel.putArray(LAYERS_TITLE_KEY + n, this.mTitleLayers.get(n));
            }
            dialogDataModel.putInteger(CURRENT_TITLE_LAYER_KEY, this.mTitleCurrentPanel);
            dialogDataModel.putInteger(LAYER_FOOTER_COUNT_KEY, this.mFooterLayers.size());
            for (n = 0; n < this.mFooterLayers.size(); ++n) {
                dialogDataModel.putArray(LAYERS_FOOTER_KEY + n, this.mFooterLayers.get(n));
            }
            dialogDataModel.putInteger(CURRENT_FOOTER_LAYER_KEY, this.mFooterCurrentPanel);
        }
        return bl;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        JPanel jPanel = this.getViewPanel();
        this.mSourceListPanel = new JPanel();
        this.mSourceListPanel = this.setUpSourceListPanel();
        this.mPageTitlePanel = new JPanel();
        this.mPageTitlePanel = this.setUpPageTitlePanel();
        this.mPageFooterPanel = new JPanel();
        this.mPageFooterPanel = this.setUpPageFooterPanel();
        int n = 23;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mSourceListPanel, gridBagConstraints, 0, 0, 2, 5, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mPageTitlePanel, gridBagConstraints, 2, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mPageFooterPanel, gridBagConstraints, 2, 2, 2, 3, n, insets);
        this.mPageTitleLeftText.addKeyListener(new TextAreaKeyListener((JTextArea)((Object)this.mPageTitleLeftText), this, dialogFocusTraversalPolicy));
        this.mPageTitleCentreText.addKeyListener(new TextAreaKeyListener((JTextArea)((Object)this.mPageTitleCentreText), this, dialogFocusTraversalPolicy));
        this.mPageTitleRightText.addKeyListener(new TextAreaKeyListener((JTextArea)((Object)this.mPageTitleRightText), this, dialogFocusTraversalPolicy));
        this.mPageFooterLeftText.addKeyListener(new TextAreaKeyListener((JTextArea)((Object)this.mPageFooterLeftText), this, dialogFocusTraversalPolicy));
        this.mPageFooterCentreText.addKeyListener(new TextAreaKeyListener((JTextArea)((Object)this.mPageFooterCentreText), this, dialogFocusTraversalPolicy));
        this.mPageFooterRightText.addKeyListener(new TextAreaKeyListener((JTextArea)((Object)this.mPageFooterRightText), this, dialogFocusTraversalPolicy));
        if (this.getGlassPane() instanceof DragPane) {
            DragPane dragPane = (DragPane)this.getGlassPane();
            ExpressionBuilderUtil.addExpTextDragAdapter(dragPane, this.mPageTitleLeftText, (ExpressionTextAreaDropListener)new ReportsTextDropListener(this.mPageTitleLeftText));
            ExpressionBuilderUtil.addExpTextDragAdapter(dragPane, this.mPageTitleCentreText, (ExpressionTextAreaDropListener)new ReportsTextDropListener(this.mPageTitleCentreText));
            ExpressionBuilderUtil.addExpTextDragAdapter(dragPane, this.mPageTitleRightText, (ExpressionTextAreaDropListener)new ReportsTextDropListener(this.mPageTitleRightText));
            ExpressionBuilderUtil.addExpTextDragAdapter(dragPane, this.mPageFooterLeftText, (ExpressionTextAreaDropListener)new ReportsTextDropListener(this.mPageFooterLeftText));
            ExpressionBuilderUtil.addExpTextDragAdapter(dragPane, this.mPageFooterCentreText, (ExpressionTextAreaDropListener)new ReportsTextDropListener(this.mPageFooterCentreText));
            ExpressionBuilderUtil.addExpTextDragAdapter(dragPane, this.mPageFooterRightText, (ExpressionTextAreaDropListener)new ReportsTextDropListener(this.mPageFooterRightText));
        }
        this.pack();
    }

    protected void doTitleNext() {
        this.mTitlePrevious.setEnabled(true);
        if (this.saveTitleLayer()) {
            ++this.mTitleCurrentPanel;
        }
        if (this.mTitleCurrentPanel == this.mTitleLayers.size()) {
            this.addTitleLayer();
        }
        if (this.mPreviousClicked && this.mTitleCurrentPanel + 1 < this.mTitleLayers.size()) {
            this.mTitleNext.setEnabled(true);
        }
        if (this.mPreviousClicked && this.mTitleCurrentPanel + 1 == this.mTitleLayers.size() && !this.isAllTitleTextFieldEmpty()) {
            this.mTitleNext.setEnabled(false);
        }
        if (!this.mPreviousClicked && this.mTitleCurrentPanel + 1 == this.mTitleLayers.size()) {
            this.mTitleNext.setEnabled(false);
        }
        this.doTitleLayerPopulate();
    }

    protected void doTitlePrevious() {
        this.mPreviousClicked = true;
        this.mTitleNext.setEnabled(true);
        if (this.mTitleCurrentPanel == 1) {
            this.mTitlePrevious.setEnabled(false);
        }
        if (this.mTitleCurrentPanel == 0) {
            return;
        }
        this.saveTitleLayer();
        --this.mTitleCurrentPanel;
        this.doTitleLayerPopulate();
    }

    protected void doFooterNext() {
        this.mFooterPrevious.setEnabled(true);
        if (this.saveFooterLayer()) {
            ++this.mFooterCurrentPanel;
        }
        if (this.mFooterCurrentPanel == this.mFooterLayers.size()) {
            this.addFooterLayer();
        }
        if (this.mPreviousClicked && this.mFooterCurrentPanel + 1 < this.mFooterLayers.size()) {
            this.mFooterNext.setEnabled(true);
        }
        if (this.mPreviousClicked && this.mFooterCurrentPanel + 1 == this.mFooterLayers.size() && !this.isAllFooterTextFieldEmpty()) {
            this.mFooterNext.setEnabled(false);
        }
        if (!this.mPreviousClicked && this.mFooterCurrentPanel + 1 == this.mFooterLayers.size()) {
            this.mFooterNext.setEnabled(false);
        }
        this.doFooterLayerPopulate();
    }

    protected void doFooterPrevious() {
        this.mPreviousClicked = true;
        this.mFooterNext.setEnabled(true);
        if (this.mFooterCurrentPanel == 1) {
            this.mFooterPrevious.setEnabled(false);
        }
        if (this.mFooterCurrentPanel == 0) {
            return;
        }
        this.saveFooterLayer();
        --this.mFooterCurrentPanel;
        this.doFooterLayerPopulate();
    }

    private void initVars() {
        this.mTitleLayers = new Vector();
        this.mFooterLayers = new Vector();
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.addListSelectionListener(this);
        this.mSrcVarList.setIdentifier("SRC_LIST");
        this.mSrcVarList.addFocusListener(this);
        this.mSpecialvariables = DialogUtil.createLabel(this, "IDS_REPORT_TITLE_SPECIAL");
        VarListModel varListModel = new VariableList().getModel();
        SpssVariable spssVariable = new SpssVariable();
        SpssVariable spssVariable2 = new SpssVariable();
        spssVariable.setName("DATE");
        spssVariable2.setName("PAGE");
        varListModel.addElement((ISpssVariable)spssVariable);
        varListModel.addElement((ISpssVariable)spssVariable2);
        this.mSpecialvariablesList = new VariableList(varListModel, VariableList.VarMoveType.eKeepOriginal);
        this.mSpecialvariablesList.addListSelectionListener(this);
        this.mSpecialvariablesList.setBorder(new EtchedBorder());
        this.mSpecialvariablesList.setShowIcon(false);
        this.mSpecialvariablesList.addFocusListener(this);
        this.mSpecialvariables.setLabelFor(this.mSpecialvariablesList);
        this.mTitleLeftArrow = new ReportsArrrowButton();
        Dimension dimension = null;
        dimension = OSInfo.getOSType() == OSInfo.OSType.MAC ? new Dimension(DialogUtil.getVarListWidth(), 25) : new Dimension(DialogUtil.getVarListWidth(), 23);
        this.mPageTitleLeft = DialogUtil.createLabel(this, "IDS_REPORT_LEFT");
        this.mPageTitleLeftText = new ReportTitlesTextArea(1, 20);
        this.mPageTitleLeftText.setMinimumSize(dimension);
        this.mPageTitleLeftText.getDocument().addDocumentListener(this);
        this.mPageTitleLeft.setLabelFor((Component)((Object)this.mPageTitleLeftText));
        this.mTitleLeftArrow.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mTitleLeftArrow.registerComponents((JComponent)((Object)this.mPageTitleLeftText), SpssArrowButton.ButtonOrientation.left);
        this.mTitleCentreArrow = new ReportsArrrowButton();
        this.mPageTitleCentre = DialogUtil.createLabel(this, "IDS_REPORT_CENTRE");
        this.mPageTitleCentreText = new ReportTitlesTextArea(1, 20);
        this.mPageTitleCentreText.setMinimumSize(dimension);
        this.mPageTitleCentreText.getDocument().addDocumentListener(this);
        this.mPageTitleCentre.setLabelFor((Component)((Object)this.mPageTitleCentreText));
        this.mTitleCentreArrow.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mTitleCentreArrow.registerComponents((JComponent)((Object)this.mPageTitleCentreText), SpssArrowButton.ButtonOrientation.left);
        this.mTitleRightArrow = new ReportsArrrowButton();
        this.mPageTitleRight = DialogUtil.createLabel(this, "IDS_REPORT_RIGHT");
        this.mPageTitleRightText = new ReportTitlesTextArea(1, 20);
        this.mPageTitleRightText.setMinimumSize(dimension);
        this.mPageTitleRightText.getDocument().addDocumentListener(this);
        this.mPageTitleRight.setLabelFor((Component)((Object)this.mPageTitleRightText));
        this.mTitleRightArrow.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mTitleRightArrow.registerComponents((JComponent)((Object)this.mPageTitleRightText), SpssArrowButton.ButtonOrientation.left);
        this.mFooterLeftArrow = new ReportsArrrowButton();
        this.mPageFooterLeft = DialogUtil.createLabel(this, "IDS_REPORT_FOOTER_LEFT");
        this.mPageFooterLeftText = new ReportTitlesTextArea();
        this.mPageFooterLeftText.setMinimumSize(dimension);
        this.mPageFooterLeftText.getDocument().addDocumentListener(this);
        this.mPageFooterLeft.setLabelFor((Component)((Object)this.mPageFooterLeftText));
        this.mFooterLeftArrow.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mFooterLeftArrow.registerComponents((JComponent)((Object)this.mPageFooterLeftText), SpssArrowButton.ButtonOrientation.left);
        this.mFooterCentreArrow = new ReportsArrrowButton();
        this.mPageFooterCentre = DialogUtil.createLabel(this, "IDS_REPORT_FOOTER_CENTRE");
        this.mPageFooterCentreText = new ReportTitlesTextArea();
        this.mPageFooterCentreText.setMinimumSize(dimension);
        this.mPageFooterCentreText.getDocument().addDocumentListener(this);
        this.mPageFooterCentre.setLabelFor((Component)((Object)this.mPageFooterCentreText));
        this.mFooterCentreArrow.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mFooterCentreArrow.registerComponents((JComponent)((Object)this.mPageFooterCentreText), SpssArrowButton.ButtonOrientation.left);
        this.mFooterRightArrow = new ReportsArrrowButton();
        this.mPageFooterRight = DialogUtil.createLabel(this, "IDS_REPORT_FOOTER_RIGHT");
        this.mPageFooterRightText = new ReportTitlesTextArea();
        this.mPageFooterRightText.setMinimumSize(dimension);
        this.mPageFooterRightText.getDocument().addDocumentListener(this);
        this.mPageFooterRight.setLabelFor((Component)((Object)this.mPageFooterRightText));
        this.mFooterRightArrow.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mFooterRightArrow.registerComponents((JComponent)((Object)this.mPageFooterRightText), SpssArrowButton.ButtonOrientation.left);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, "IDS_REPORT_PREVIOUS");
        this.mTitlePrevious = new JButton(toggleButtonAction);
        this.mTitlePrevious.setEnabled(false);
        this.mTitlePrevious.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, "IDS_REPORT_NEXT");
        this.mTitleNext = new JButton(toggleButtonAction);
        this.mTitleNext.setEnabled(true);
        this.mTitleNext.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, "IDS_REPORT_FOOTER_PREVIOUS");
        this.mFooterPrevious = new JButton(toggleButtonAction);
        this.mFooterPrevious.setEnabled(false);
        this.mFooterPrevious.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, "IDS_REPORT_FOOTER_NEXT");
        this.mFooterNext = new JButton(toggleButtonAction);
        this.mFooterNext.setEnabled(false);
        this.mFooterNext.addActionListener(this);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mSpecialvariablesList);
        vector.add(this.mTitleLeftArrow);
        vector.add((Object)this.mPageTitleLeftText);
        vector.add(this.mTitleCentreArrow);
        vector.add((Object)this.mPageTitleCentreText);
        vector.add(this.mTitleRightArrow);
        vector.add((Object)this.mPageTitleRightText);
        vector.add(this.mTitleNext);
        vector.add(this.mTitlePrevious);
        vector.add(this.mFooterLeftArrow);
        vector.add((Object)this.mPageFooterLeftText);
        vector.add(this.mFooterCentreArrow);
        vector.add((Object)this.mPageFooterCentreText);
        vector.add(this.mFooterRightArrow);
        vector.add((Object)this.mPageFooterRightText);
        vector.add(this.mFooterNext);
        vector.add(this.mFooterPrevious);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private JPanel setUpSourceListPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EtchedBorder());
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        this.setupTopSourceList(jPanel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(5, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSpecialvariables, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mSpecialvariablesList, gridBagConstraints, 0, 3, 1, 1, n, null);
        return jPanel;
    }

    private void setupTopSourceList(JPanel jPanel) {
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 0, 1, 2, n, null);
    }

    private JPanel setUpPageTitlePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setMinimumSize(new Dimension(150, 150));
        this.mTitlePanelBorder = new TitledBorder("");
        jPanel.setBorder(this.mTitlePanelBorder);
        this.mTitlePanelBorder.setTitle(this.formatTitleCurrentPanelTitle());
        this.mPageTitlePreviousNextPanel = this.setUpTitlePreviousNextPanel();
        Insets insets = DialogUtil.getStandardControlInsets();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel2, this.mPageTitlePreviousNextPanel, gridBagConstraints, 0, 0, 1, 1, n, new Insets(0, 0, 0, insets.left + insets.bottom));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder());
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        DialogUtil.addUsingGBL(jPanel3, this.mTitleLeftArrow, gridBagConstraints, 0, 1, 1, 2, 20, null);
        Insets insets3 = new Insets(0, insets2.left, 0, n2);
        DialogUtil.addUsingGBL(jPanel3, this.mPageTitleLeft, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        gridBagConstraints.fill = 2;
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.mPageTitleLeftText));
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setPreferredSize(this.mPageTitleLeftText.getMinimumSize());
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel3, jScrollPane, gridBagConstraints, 1, 2, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel3, this.mTitleCentreArrow, gridBagConstraints, 0, 3, 1, 2, 20, null);
        insets3.set(n2, insets2.left, 0, n2);
        DialogUtil.addUsingGBL(jPanel3, this.mPageTitleCentre, gridBagConstraints, 1, 3, 1, 1, n, insets3);
        gridBagConstraints.fill = 2;
        jScrollPane = new JScrollPane((Component)((Object)this.mPageTitleCentreText));
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setPreferredSize(this.mPageTitleCentreText.getMinimumSize());
        insets3.set(0, insets2.left, 0, n2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel3, jScrollPane, gridBagConstraints, 1, 4, 1, 1, n, insets3);
        gridBagConstraints.fill = 0;
        insets3.set(n2, 0, n2, 0);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel3, this.mTitleRightArrow, gridBagConstraints, 0, 5, 1, 2, 20, insets3);
        insets3.set(n2, insets2.left, 0, n2);
        DialogUtil.addUsingGBL(jPanel3, this.mPageTitleRight, gridBagConstraints, 1, 5, 1, 1, n, insets3);
        gridBagConstraints.fill = 2;
        jScrollPane = new JScrollPane((Component)((Object)this.mPageTitleRightText));
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setPreferredSize(this.mPageTitleRightText.getMinimumSize());
        insets3.set(0, insets2.left, n2, n2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel3, jScrollPane, gridBagConstraints, 1, 6, 1, 1, n, insets3);
        insets3.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets3);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets3);
        return jPanel;
    }

    private JPanel setUpTitlePreviousNextPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mTitlePrevious, gridBagConstraints, 0, 0, 1, 1, n, null);
        n = 24;
        DialogUtil.addUsingGBL(jPanel, this.mTitleNext, gridBagConstraints, 1, 0, 1, 1, n, null);
        UIToolDialogUtil.normalizeButtonWidths((JPanel)jPanel);
        return jPanel;
    }

    private boolean saveTitleLayer() {
        boolean bl = false;
        if (this.mTitleCurrentPanel < this.mTitleLayers.size()) {
            String[] stringArray = new String[]{this.mPageTitleLeftText.getText(), this.mPageTitleCentreText.getText(), this.mPageTitleRightText.getText()};
            if (stringArray.length > 1) {
                this.mTitleLayers.set(this.mTitleCurrentPanel, stringArray);
                bl = true;
            } else {
                this.mTitleLayers.remove(this.mTitleCurrentPanel);
            }
        }
        return bl;
    }

    private void addTitleLayer() {
        this.mTitleLayers.add(new String[3]);
    }

    private void doTitleLayerPopulate() {
        String[] stringArray;
        this.mPageTitleLeftText.setText("");
        this.mPageTitleCentreText.setText("");
        this.mPageTitleRightText.setText("");
        if (this.mTitleCurrentPanel < this.mTitleLayers.size()) {
            stringArray = this.mTitleLayers.get(this.mTitleCurrentPanel);
            this.mPageTitleLeftText.setText(stringArray[0]);
            this.mPageTitleCentreText.setText(stringArray[1]);
            this.mPageTitleRightText.setText(stringArray[2]);
        }
        stringArray = this.formatTitleCurrentPanelTitle();
        this.mTitlePanelBorder.setTitle((String)stringArray);
        this.repaint();
    }

    private String formatTitleCurrentPanelTitle() {
        return String.format(ComponentState.getSPSSLocale(), this.getResString("IDS_REPORT_TITLE_FORMAT"), this.mTitleCurrentPanel + 1, this.mTitleLayers.size());
    }

    private boolean isAllTitleTextFieldEmpty() {
        if (this.mTitleCurrentPanel >= 9) {
            return false;
        }
        return !this.mPageTitleLeftText.getText().equals("") || !this.mPageTitleCentreText.getText().equals("") || !this.mPageTitleRightText.getText().equals("");
    }

    private JPanel setUpPageFooterPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setMinimumSize(new Dimension(150, 150));
        this.mFooterPanelBorder = new TitledBorder("");
        jPanel.setBorder(this.mFooterPanelBorder);
        this.mFooterPanelBorder.setTitle(this.formatTitleCurrentPanelTitle());
        this.mPageFooterPreviousNextPanel = this.setUpFooterPreviousNextPanel();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel2, this.mPageFooterPreviousNextPanel, gridBagConstraints, 0, 0, 3, 1, n, new Insets(0, 0, 0, insets.left + insets.bottom));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder());
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        DialogUtil.addUsingGBL(jPanel3, this.mFooterLeftArrow, gridBagConstraints, 0, 1, 1, 2, 20, null);
        Insets insets3 = new Insets(0, insets2.left, 0, n2);
        DialogUtil.addUsingGBL(jPanel3, this.mPageFooterLeft, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.mPageFooterLeftText));
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setPreferredSize(this.mPageFooterLeftText.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel3, jScrollPane, gridBagConstraints, 1, 2, 1, 1, n, insets3);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel3, this.mFooterCentreArrow, gridBagConstraints, 0, 3, 1, 2, 20, null);
        insets3.set(n2, insets2.left, 0, n2);
        DialogUtil.addUsingGBL(jPanel3, this.mPageFooterCentre, gridBagConstraints, 1, 3, 1, 1, n, insets3);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jScrollPane = new JScrollPane((Component)((Object)this.mPageFooterCentreText));
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setPreferredSize(this.mPageFooterCentreText.getMinimumSize());
        insets3.set(0, insets2.left, 0, n2);
        DialogUtil.addUsingGBL(jPanel3, jScrollPane, gridBagConstraints, 1, 4, 1, 1, n, insets3);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        insets3.set(n2, 0, n2, 0);
        DialogUtil.addUsingGBL(jPanel3, this.mFooterRightArrow, gridBagConstraints, 0, 5, 1, 2, 20, insets3);
        insets3.set(n2, insets2.left, 0, n2);
        DialogUtil.addUsingGBL(jPanel3, this.mPageFooterRight, gridBagConstraints, 1, 5, 1, 1, n, insets3);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jScrollPane = new JScrollPane((Component)((Object)this.mPageFooterRightText));
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setPreferredSize(this.mPageFooterRightText.getMinimumSize());
        insets3.set(0, insets2.left, n2, n2);
        DialogUtil.addUsingGBL(jPanel3, jScrollPane, gridBagConstraints, 1, 6, 1, 1, n, insets3);
        insets3.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets3);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets3);
        return jPanel;
    }

    private JPanel setUpFooterPreviousNextPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mFooterPrevious, gridBagConstraints, 0, 0, 1, 1, n, null);
        n = 24;
        DialogUtil.addUsingGBL(jPanel, this.mFooterNext, gridBagConstraints, 1, 0, 1, 1, n, null);
        UIToolDialogUtil.normalizeButtonWidths((JPanel)jPanel);
        return jPanel;
    }

    private boolean saveFooterLayer() {
        boolean bl = false;
        if (this.mFooterCurrentPanel < this.mFooterLayers.size()) {
            String[] stringArray = new String[]{this.mPageFooterLeftText.getText(), this.mPageFooterCentreText.getText(), this.mPageFooterRightText.getText()};
            if (stringArray.length > 1) {
                this.mFooterLayers.set(this.mFooterCurrentPanel, stringArray);
                bl = true;
            } else {
                this.mFooterLayers.remove(this.mFooterCurrentPanel);
            }
        }
        return bl;
    }

    private void addFooterLayer() {
        this.mFooterLayers.add(new String[3]);
    }

    private void doFooterLayerPopulate() {
        String[] stringArray;
        this.mPageFooterLeftText.setText("");
        this.mPageFooterCentreText.setText("");
        this.mPageFooterRightText.setText("");
        if (this.mFooterCurrentPanel < this.mFooterLayers.size()) {
            stringArray = this.mFooterLayers.get(this.mFooterCurrentPanel);
            this.mPageFooterLeftText.setText(stringArray[0]);
            this.mPageFooterCentreText.setText(stringArray[1]);
            this.mPageFooterRightText.setText(stringArray[2]);
        }
        stringArray = this.formatFooterCurrentPanelTitle();
        this.mFooterPanelBorder.setTitle((String)stringArray);
        this.repaint();
    }

    private String formatFooterCurrentPanelTitle() {
        return String.format(ComponentState.getSPSSLocale(), this.getResString("IDS_REPORT_FOOTER_FORMAT"), this.mFooterCurrentPanel + 1, this.mFooterLayers.size());
    }

    private boolean isAllFooterTextFieldEmpty() {
        if (this.mFooterCurrentPanel >= 9) {
            return false;
        }
        return !this.mPageFooterLeftText.getText().equals("") || !this.mPageFooterCentreText.getText().equals("") || !this.mPageFooterRightText.getText().equals("");
    }

    private void changeArrowRegistration(Object object) {
        if (object == this.mSrcVarList && this.mSrcVarList.getSelectedIndex() > -1) {
            this.mSpecialvariablesList.clearSelection();
            this.mTitleLeftArrow.unRegisterVariableList(this.mSpecialvariablesList);
            this.mTitleLeftArrow.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
            this.mTitleCentreArrow.unRegisterVariableList(this.mSpecialvariablesList);
            this.mTitleCentreArrow.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
            this.mTitleRightArrow.unRegisterVariableList(this.mSpecialvariablesList);
            this.mTitleRightArrow.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
            this.mFooterLeftArrow.unRegisterVariableList(this.mSpecialvariablesList);
            this.mFooterLeftArrow.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
            this.mFooterCentreArrow.unRegisterVariableList(this.mSpecialvariablesList);
            this.mFooterCentreArrow.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
            this.mFooterRightArrow.unRegisterVariableList(this.mSpecialvariablesList);
            this.mFooterRightArrow.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        } else if (object == this.mSpecialvariablesList && this.mSpecialvariablesList.getSelectedIndex() > -1) {
            this.mSrcVarList.clearSelection();
            this.mTitleLeftArrow.unRegisterVariableList(this.mSrcVarList);
            this.mTitleLeftArrow.registerComponents(this.mSpecialvariablesList, SpssArrowButton.ButtonOrientation.right);
            this.mTitleCentreArrow.unRegisterVariableList(this.mSrcVarList);
            this.mTitleCentreArrow.registerComponents(this.mSpecialvariablesList, SpssArrowButton.ButtonOrientation.right);
            this.mTitleRightArrow.unRegisterVariableList(this.mSrcVarList);
            this.mTitleRightArrow.registerComponents(this.mSpecialvariablesList, SpssArrowButton.ButtonOrientation.right);
            this.mFooterLeftArrow.unRegisterVariableList(this.mSrcVarList);
            this.mFooterLeftArrow.registerComponents(this.mSpecialvariablesList, SpssArrowButton.ButtonOrientation.right);
            this.mFooterCentreArrow.unRegisterVariableList(this.mSrcVarList);
            this.mFooterCentreArrow.registerComponents(this.mSpecialvariablesList, SpssArrowButton.ButtonOrientation.right);
            this.mFooterRightArrow.unRegisterVariableList(this.mSrcVarList);
            this.mFooterRightArrow.registerComponents(this.mSpecialvariablesList, SpssArrowButton.ButtonOrientation.right);
        }
    }

    private class ReportTitlesTextArea
    extends ExpressionBuilderTextArea
    implements KeyListener {
        public ReportTitlesTextArea() {
            this.addKeyListener(this);
        }

        public ReportTitlesTextArea(int n, int n2) {
            super(n, n2);
            this.addKeyListener(this);
        }

        @Override
        public void setText(String string) {
            if (string != null && string.contains("\n")) {
                string = string.substring(0, string.indexOf(10));
            }
            super.setText(string);
        }

        @Override
        public void replaceSelection(String string) {
            if (string != null && string.contains("\n")) {
                string = string.substring(0, string.indexOf(10));
            }
            super.replaceSelection(string);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                keyEvent.consume();
                this.getRootPane().getDefaultButton().doClick();
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

