/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.reports;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.reports.report_summaries_in_column.ReportSummariesInColumnsDlg;
import com.spss.java_client.ui.dialogs.base.analyze.reports.report_summaries_in_row.ReportSummariesInRowsDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.ContextEnabledTextArea;
import com.spss.uitools.controls.IntTextField;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ReportBreakFormat
extends BaseSubDialog
implements DocumentListener,
ItemListener {
    static final String OFFSET_FROM_LEFT = "IDS_REPORT_BREAK_OFFSET_LEFT";
    static final String OFFSET_FROM_RIGHT = "IDS_REPORT_BREAK_OFFSET_RIGHT";
    static final String CENTERED_FROM_COLUMN = "IDS_REPORT_BREAK_CENTERED";
    static final String VALUES = "IDS_REPORT_BREAK_CONTENT_VALUE";
    static final String VALUES_LABELS = "IDS_REPORT_BREAK_CONTENT_LABELS";
    static final String OFFSET_AMOUNT_TEXT = "IDS_REPORT_BREAK_OFFSET_AMOUNT_TEXT";
    static final String COLUMN_WIDTH_TEXT = "IDS_REPORT_BREAK_WIDTH_TEXT";
    static final String COLUMN_JUSTIFICATION = "IDS_REPORT_LAYOUT_ALIGN_COMBO";
    private JRadioButton mValues;
    private JRadioButton mValueLabels;
    private JRadioButton mOffsetFromLeft;
    private JRadioButton mCentered;
    private SpssButtonGroup mOffsetButtonGroup;
    private SpssButtonGroup mValuesButtonGroup;
    private JLabel mOffsetAmount;
    private JLabel mColumntitle;
    private JLabel mColumnJustification;
    private JLabel mColumnWidth;
    private IntTextField mOffsetAmountText;
    private IntTextField mColumnWidthText;
    private ContextEnabledTextArea mColumnTitleTextArea;
    private JScrollPane mTextAreaScrollPane;
    private JComboBox mColumnJustificationCombo;
    private String mCurrentListSelectionVariableName;
    private String mVariableName;

    public ReportBreakFormat(BaseProcedureDialog baseProcedureDialog, String string) {
        super(baseProcedureDialog, String.format(baseProcedureDialog.getResString("IDS_REPORT_BREAK_FORMAT"), string), true);
        this.mVariableName = string;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(true);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mOffsetFromLeft.isSelected() && this.mOffsetAmountText.getText().equals("")) {
            this.enableContinue(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.mOffsetFromLeft.isSelected() && this.mOffsetAmountText.getText().equals("")) {
            this.enableContinue(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        boolean bl = itemEvent.getStateChange() == 1;
        boolean bl2 = false;
        if (object == this.mCentered) {
            this.mOffsetAmountText.setEnabled(!bl);
            this.mOffsetAmountText.setOpaque(!bl);
            if (bl) {
                this.enableContinue(true);
            } else {
                this.enableContinue(this.mOffsetAmountText.getText().length() > 0);
            }
        }
        if (this.mParentDlg instanceof ReportSummariesInRowsDlg) {
            bl2 = ((ReportSummariesInRowsDlg)this.mParentDlg).isCurrentBreakSelectedTypeInteger();
        }
        if (this.mParentDlg instanceof ReportSummariesInColumnsDlg) {
            bl2 = ((ReportSummariesInColumnsDlg)this.mParentDlg).isCurrentBreakSelectedTypeInteger();
        }
        if (bl2) {
            if (object == this.mValues && bl) {
                this.mOffsetFromLeft.setText(this.getResString(OFFSET_FROM_RIGHT));
            } else if (object == this.mValueLabels && bl) {
                this.mOffsetFromLeft.setText(this.getResString(OFFSET_FROM_LEFT));
            }
        }
    }

    @Override
    public boolean continuePressed() {
        if (!this.mColumnTitleTextArea.validateContents()) {
            return false;
        }
        if (this.mColumnWidthText.isLastFocusLostHadError()) {
            return false;
        }
        if (!this.mColumnWidthText.getText().equals("") && this.mOffsetAmountText.isEnabled() && !this.mOffsetAmountText.getText().equals("") && Integer.valueOf(this.mOffsetAmountText.getText()) >= Integer.valueOf(this.mColumnWidthText.getText())) {
            String string = this.getResString("ERR_REPORTS_OFFSET_AMT_TOO_LARGE_WARNING");
            string = String.format(string, this.mOffsetAmountText.getText(), this.mColumnWidthText.getText());
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
            this.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_rptr_brkfmt";
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        Integer n;
        String string;
        Boolean bl = dialogDataModel.getBoolean(this.mCurrentListSelectionVariableName + "OFFSET_FROM_LEFT");
        if (bl != null) {
            this.mOffsetFromLeft.setSelected(bl);
        }
        if ((bl = dialogDataModel.getBoolean(this.mCurrentListSelectionVariableName + "CENTERED_FROM_COLUMN")) != null) {
            this.mCentered.setSelected(bl);
        }
        if ((bl = dialogDataModel.getBoolean(this.mCurrentListSelectionVariableName + "VALUES")) != null) {
            this.mValues.setSelected(bl);
        }
        if ((bl = dialogDataModel.getBoolean(this.mCurrentListSelectionVariableName + "VALUES_LABELS")) != null) {
            this.mValueLabels.setSelected(bl);
        }
        if ((string = dialogDataModel.getString(this.mCurrentListSelectionVariableName + "OFFSET_AMOUNT_TEXT")) != null) {
            this.mOffsetAmountText.setText(string);
        }
        if ((string = dialogDataModel.getString(this.mCurrentListSelectionVariableName + "COLUMN_WIDTH_TEXT")) != null) {
            this.mColumnWidthText.setText(string);
        }
        if ((string = dialogDataModel.getString(this.mCurrentListSelectionVariableName + "TEXT_AREA")) != null) {
            this.mColumnTitleTextArea.setText(string);
        }
        if ((n = dialogDataModel.getInteger(this.mCurrentListSelectionVariableName + "COLUMN_JUSTIFICATION")) != null) {
            this.mColumnJustificationCombo.setSelectedIndex(n);
        }
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        dialogDataModel.putObject(this.mVariableName, this.mCurrentListSelectionVariableName);
        dialogDataModel.putString(this.mCurrentListSelectionVariableName + "TEXT_AREA", this.mColumnTitleTextArea.getText());
        dialogDataModel.putBoolean(this.mCurrentListSelectionVariableName + "OFFSET_FROM_LEFT", this.mOffsetFromLeft.isSelected());
        dialogDataModel.putBoolean(this.mCurrentListSelectionVariableName + "CENTERED_FROM_COLUMN", this.mCentered.isSelected());
        dialogDataModel.putBoolean(this.mCurrentListSelectionVariableName + "VALUES", this.mValues.isSelected());
        dialogDataModel.putBoolean(this.mCurrentListSelectionVariableName + "VALUES_LABELS", this.mValueLabels.isSelected());
        dialogDataModel.putString(this.mCurrentListSelectionVariableName + "OFFSET_AMOUNT_TEXT", this.mOffsetAmountText.getText());
        dialogDataModel.putString(this.mCurrentListSelectionVariableName + "COLUMN_WIDTH_TEXT", this.mColumnWidthText.getText());
        dialogDataModel.putInteger(this.mCurrentListSelectionVariableName + "COLUMN_JUSTIFICATION", this.mColumnJustificationCombo.getSelectedIndex());
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setUpColumnPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mColumntitle, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTextAreaScrollPane, gridBagConstraints, 0, 1, 4, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        DialogUtil.addUsingGBL(jPanel3, this.setUpColumnJustificationPanel(), gridBagConstraints2, 0, 0, 1, 1, n, insets);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel3, this.setUpValuePositionPanel(), gridBagConstraints2, 0, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        Insets insets2 = new Insets(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 2, 2, 3, n, insets2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        Insets insets3 = new Insets(insets.top + 35, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mColumnWidth, gridBagConstraints, 2, 3, 1, 1, n, insets3);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mColumnWidthText, gridBagConstraints, 3, 3, 1, 1, n, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 4, 3, 1, n, insets);
        this.pack();
    }

    private void initVars() {
        this.mCurrentListSelectionVariableName = this.mParentDlg instanceof ReportSummariesInRowsDlg ? ((ReportSummariesInRowsDlg)this.mParentDlg).getCurrentBreakSelectionName() : ((ReportSummariesInColumnsDlg)this.mParentDlg).getCurrentBreakSelection();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, VALUES);
        this.mValues = new JRadioButton(toggleButtonAction);
        this.mValues.setSelected(false);
        this.mValues.addItemListener(this);
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction(this.mParentDlg, VALUES_LABELS);
        this.mValueLabels = new JRadioButton(toggleButtonAction2);
        this.mValueLabels.setSelected(true);
        this.mValueLabels.addItemListener(this);
        this.mValuesButtonGroup = new SpssButtonGroup();
        this.mValuesButtonGroup.add(this.mValues);
        this.mValuesButtonGroup.add(this.mValueLabels);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, CENTERED_FROM_COLUMN);
        this.mCentered = new JRadioButton(toggleButtonAction);
        this.mCentered.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, OFFSET_FROM_LEFT);
        this.mOffsetFromLeft = new JRadioButton(toggleButtonAction);
        this.mOffsetFromLeft.setSelected(true);
        this.mOffsetButtonGroup = new SpssButtonGroup();
        this.mOffsetButtonGroup.add(this.mOffsetFromLeft);
        this.mOffsetButtonGroup.add(this.mCentered);
        this.mOffsetAmount = DialogUtil.createLabel(this, "IDS_REPORT_BREAK_OFFSET_AMOUNT");
        this.mOffsetAmountText = new IntTextField(0, 99, true);
        this.mOffsetAmountText.setColumns(4);
        this.mOffsetAmountText.setAction((Action)new TextFieldAction(this.mParentDlg, OFFSET_AMOUNT_TEXT));
        this.mOffsetAmountText.setText("0");
        this.mOffsetAmountText.getDocument().addDocumentListener(this);
        this.mOffsetAmount.setLabelFor((Component)this.mOffsetAmountText);
        this.mColumntitle = DialogUtil.createLabel(this, "IDS_REPORT_BREAK_COLOUMN");
        this.mColumnTitleTextArea = new ContextEnabledTextArea(3, 25, ComponentState.getCurrentCharset());
        KeyStroke keyStroke = KeyStroke.getKeyStroke("ctrl TAB");
        HashSet hashSet = new HashSet(this.mColumnTitleTextArea.getFocusTraversalKeys(0));
        hashSet.remove(keyStroke);
        this.mColumnTitleTextArea.setFocusTraversalKeys(0, hashSet);
        this.mColumnTitleTextArea.getInputMap().put(keyStroke, "insert-tab");
        HashSet<AWTKeyStroke> hashSet2 = new HashSet<AWTKeyStroke>(1);
        hashSet2.add(AWTKeyStroke.getAWTKeyStroke(9, 0));
        this.mColumnTitleTextArea.setFocusTraversalKeys(0, Collections.unmodifiableSet(hashSet2));
        HashSet<AWTKeyStroke> hashSet3 = new HashSet<AWTKeyStroke>(1);
        hashSet3.add(AWTKeyStroke.getAWTKeyStroke(9, 65));
        this.mColumnTitleTextArea.setFocusTraversalKeys(1, Collections.unmodifiableSet(hashSet3));
        this.mColumntitle.setLabelFor((Component)this.mColumnTitleTextArea);
        this.mTextAreaScrollPane = new JScrollPane((Component)this.mColumnTitleTextArea, 20, 31);
        this.mTextAreaScrollPane.setPreferredSize(new Dimension(this.mColumnTitleTextArea.getPreferredSize().width, this.mColumnTitleTextArea.getPreferredSize().height + 2));
        this.mColumnJustification = DialogUtil.createLabel(this, "IDS_REPORT_BREAK_JUSTIFICATION");
        String[] stringArray = new String[]{this.getResString("IDS_REPORT_BREAK_FORMAT_COMBO_LEFT"), this.getResString("IDS_REPORT_BREAK_FORMAT_COMBO_CENTRE"), this.getResString("IDS_REPORT_BREAK_FORMAT_COMBO_RIGHT")};
        ComboboxAction comboboxAction = new ComboboxAction(this.mParentDlg, COLUMN_JUSTIFICATION);
        this.mColumnJustificationCombo = new JComboBox();
        this.mColumnJustificationCombo.setAction(comboboxAction);
        for (String string : stringArray) {
            this.mColumnJustificationCombo.addItem(string);
        }
        this.mColumnJustificationCombo.setSelectedIndex(0);
        this.mColumnJustification.setLabelFor(this.mColumnJustificationCombo);
        this.mColumnWidth = DialogUtil.createLabel(this, "IDS_REPORT_WIDTH");
        this.mColumnWidthText = new IntTextField(1, 100, true);
        this.mColumnWidthText.setColumns(4);
        this.mColumnWidthText.setAction((Action)new TextFieldAction(this.mParentDlg, COLUMN_WIDTH_TEXT));
        this.mColumnWidth.setLabelFor((Component)this.mColumnWidthText);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mColumnTitleTextArea);
        vector.add(this.mColumnJustificationCombo);
        vector.add(this.mOffsetButtonGroup);
        vector.add(this.mOffsetAmountText);
        vector.add(this.mColumnWidthText);
        vector.add(this.mValuesButtonGroup);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private JPanel setUpColumnPanel() {
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setMinimumSize(new Dimension(120, 50));
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_REPORT_BREAK_CONTENT")));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mValues, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mValueLabels, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setUpValuePositionPanel() {
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setMinimumSize(new Dimension(300, 50));
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_REPORT_BREAK_VALUE_POSITION")));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mOffsetFromLeft, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mOffsetAmount, gridBagConstraints, 0, 2, 1, 1, n, new Insets(0, 25, 3, 0));
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mOffsetAmountText, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mCentered, gridBagConstraints, 0, 3, 2, 1, n, insets);
        return jPanel;
    }

    private JPanel setUpColumnJustificationPanel() {
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setMinimumSize(new Dimension(20, 20));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mColumnJustification, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mColumnJustificationCombo, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }
}

