/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.regression.partial_least_squares;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.ComponentsArrowButton;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.AbstractTableDropListener;
import com.spss.java_client.ui.controls.drag_drop.PlainTableDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.VarListDropListener;
import com.spss.java_client.ui.dialogs.base.analyze.regression.partial_least_squares.PLSComboBoxModel;
import com.spss.java_client.ui.dialogs.base.analyze.regression.partial_least_squares.PartialLeastSquaresDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SpssFocusCellRenderer;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.DropEvent;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

public class VariablesTab
extends BaseProcedureTab
implements KeyListener,
FocusListener,
ListDataListener {
    public static final String SOURCE_LIST_IDENTIFIER_KEY = "PLSsourcevars";
    public static final String INDEPENDENT_LIST_IDENTIFIER_KEY = "PLSindependentvars";
    public static final String CASE_ID_LIST_IDENTIFIER_KEY = "PLScaseidvar";
    static final String DEPENDENT_VARS_MODEL_KEY = "dependentVarsTableModel";
    static final String DEPENDENT_VARS_MAP_KEYS_KEY = "dependentVarsHashMapKeys";
    static final String DEPENDENT_VARS_MAP_VALUES_KEY = "dependentVarsHashMapValues";
    static final String DEPENDENT_VARS_COMBOS_KEY = "dependentVarsCombosHashMap";
    static final String SOURCE_LIST_MODEL = "srclistmodel";
    static final String MAX_LATENTS_KEY = "maxLatentsText";
    static final String MAX_LATENTS_DEFAULT = "5";
    private SrcListTableArrowButton mArrowDependentButton;
    private ArrowButton mArrowIndependentButton;
    private JLabel mSrcListLabel;
    private SrcVariableList mSrcVarList;
    private JScrollPane mSrcVarScrollPane;
    private JTextArea mChangeMeasuresText;
    private JLabel mDependentListLabel;
    private PlainTable mDependentTable;
    private JScrollPane mDependentScrollPane;
    private DefaultTableModel mDependentModel;
    private JComboBox mDependentComboBox;
    private HashMap<String, ISpssVariable> mDependentLocallyUniqueIdMap;
    private HashMap<String, SerializableObject> mMapOfModels;
    private ArrowButton mArrowCaseIDVarButton;
    private JLabel mIndependentListLabel;
    private TargetVariableList mIndependentList;
    private JScrollPane mIndependentScrollPane;
    private JLabel mCaseIDVarLabel;
    private TargetVariableList mCaseIDVarsList;
    private JScrollPane mCaseIDVarScrollPane;
    private JLabel mMaxLatentsLabel;
    private IntTextField mMaxLatents;
    private JTextArea mSpecialSetupText;
    private Border mDefaultScrollPaneBorder;
    private Border mBlueBorder = BorderFactory.createLineBorder(Color.BLUE);

    public VariablesTab(BaseTabbedDialog baseTabbedDialog, boolean bl) {
        super(baseTabbedDialog, bl);
        this.mSrcVarList.getInputMap().put(ResUtil.getShortcut("edit_copy"), "copyAction");
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_pls_variables";
    }

    @Override
    public void reset() {
        super.reset();
        this.mDependentLocallyUniqueIdMap.clear();
        this.setDefaults();
    }

    @Override
    protected void aboutToShowTab() {
        ISpssVariable[] iSpssVariableArray;
        Object object;
        super.aboutToShowTab();
        this.mSrcVarList.clearSelection();
        Component component = ((PartialLeastSquaresDlg)((Object)this.getTopLevelAncestor())).getGlassPane();
        if (component instanceof DragPane) {
            object = (DragPane)component;
            object.getDropListeners().removeAllElements();
            object.addDropListener((IDropListener)new SrcVarListDropListener(this.mSrcVarList, new DependentsTableVarMoveHandler()));
            object.addDropListener((IDropListener)new DependentsTableDropListener(this.mDependentTable, new DependentsTableVarMoveHandler(), this.mSrcVarList));
            object.addDropListener((IDropListener)new VarListDropListener(this.mIndependentList));
            object.addDropListener((IDropListener)new VarListDropListener(this.mCaseIDVarsList));
        }
        ISpssVariable[] iSpssVariableArray2 = iSpssVariableArray = (object = ((PartialLeastSquaresDlg)this.mParent).getDialogDataModel()) != null ? ((DialogDataModel)object).getVarArray(DEPENDENT_VARS_MAP_VALUES_KEY) : null;
        if (object != null && iSpssVariableArray != null) {
            VarListModel varListModel = this.mSrcVarList.getModel();
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                varListModel.removeElement(iSpssVariable);
            }
        }
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        super.saveTabState(dialogDataModel);
        dialogDataModel.putString(MAX_LATENTS_KEY, this.mMaxLatents.getText());
        Object[] objectArray = new String[this.mDependentLocallyUniqueIdMap.size()];
        ISpssVariable[] iSpssVariableArray = new ISpssVariable[this.mDependentLocallyUniqueIdMap.size()];
        this.mDependentLocallyUniqueIdMap.keySet().toArray(objectArray);
        this.mDependentLocallyUniqueIdMap.values().toArray(iSpssVariableArray);
        dialogDataModel.putArray(DEPENDENT_VARS_MAP_KEYS_KEY, objectArray);
        dialogDataModel.putVarArray(DEPENDENT_VARS_MAP_VALUES_KEY, iSpssVariableArray);
        dialogDataModel.putSerializableMap(DEPENDENT_VARS_COMBOS_KEY, this.mMapOfModels);
        Vector<Vector> vector = this.mDependentModel.getDataVector();
        dialogDataModel.putObject(DEPENDENT_VARS_MODEL_KEY, vector);
    }

    @Override
    protected void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        super.loadTabState(dialogDataModel, nameLabelOption);
        String string = dialogDataModel.getString(MAX_LATENTS_KEY);
        if (string == null || string.trim().length() == 0) {
            string = MAX_LATENTS_DEFAULT;
        }
        this.mMaxLatents.setText(string);
        Vector<String> vector = new Vector<String>();
        vector.add(this.getResString("IDS_PARTIAL_LEAST_SQUARES_VARSTAB_DEPENDENT_TABLE_HEADER_0"));
        vector.add(this.getResString("IDS_PARTIAL_LEAST_SQUARES_VARSTAB_DEPENDENT_TABLE_HEADER_1"));
        Vector vector2 = (Vector)dialogDataModel.getObject(DEPENDENT_VARS_MODEL_KEY);
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.mDependentTable.getModel();
        defaultTableModel.setDataVector(vector2, vector);
        this.mDependentTable.getColumnModel().getColumn(1).setCellRenderer(new CategoryCellRenderer());
        this.mDependentTable.getColumnModel().getColumn(1).setCellEditor(new CategoryCellEditor(this.mDependentComboBox));
        HashMap<String, ISpssVariable> hashMap = new HashMap<String, ISpssVariable>();
        String[] stringArray = (String[])dialogDataModel.getArray(DEPENDENT_VARS_MAP_KEYS_KEY);
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray(DEPENDENT_VARS_MAP_VALUES_KEY);
        if (stringArray != null && iSpssVariableArray != null) {
            for (int i = 0; i < stringArray.length && i < iSpssVariableArray.length; ++i) {
                hashMap.put(stringArray[i], iSpssVariableArray[i]);
            }
        }
        this.mDependentLocallyUniqueIdMap = hashMap;
        HashMap<String, SerializableObject> hashMap2 = dialogDataModel.getSerializableMap(DEPENDENT_VARS_COMBOS_KEY);
        if (hashMap2 != null) {
            this.mMapOfModels = hashMap2;
        }
        this.mDependentModel = this.mDependentTable.getDefaultTableModel();
        this.mDependentTable.validate();
        this.mDependentScrollPane.repaint();
        this.updateOKPasteButtons();
        this.mSrcVarList.setSelectedIndex(0);
        final SrcVariableList srcVariableList = this.mSrcVarList;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                srcVariableList.requestFocusInWindow();
            }
        });
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        ((PartialLeastSquaresDlg)this.mParent).getModelTab().loadFactorsList();
        this.updateOKPasteButtons();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        ((PartialLeastSquaresDlg)this.mParent).getModelTab().loadFactorsList();
        ((PartialLeastSquaresDlg)this.mParent).getModelTab().pruneModelsList();
        this.updateOKPasteButtons();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateOKPasteButtons();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if ((n == 127 || n == 8) && this.mDependentTable.hasFocus()) {
            int[] nArray = this.mDependentTable.getSelectedRows();
            keyEvent.consume();
            for (int i = 0; i < nArray.length; ++i) {
                String string = (String)this.mDependentTable.getModel().getValueAt(nArray[i] - i, 0);
                this.mSrcVarList.getModel().addElement(this.mDependentLocallyUniqueIdMap.get(string));
                this.mDependentLocallyUniqueIdMap.remove(string);
                this.mDependentModel.removeRow(nArray[i] - i);
                this.mDependentTable.repaint();
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        boolean bl;
        if (focusEvent.getSource() == this.mSrcVarList) {
            this.mSrcVarScrollPane.setBorder(this.mBlueBorder);
        } else if (focusEvent.getSource() == this.mDependentScrollPane || focusEvent.getSource() == this.mDependentTable) {
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.mDependentScrollPane.setBorder(this.mBlueBorder);
            }
        } else if (focusEvent.getSource() == this.mIndependentList) {
            this.mIndependentScrollPane.setBorder(this.mBlueBorder);
        } else if (focusEvent.getSource() == this.mCaseIDVarsList) {
            this.mCaseIDVarScrollPane.setBorder(this.mBlueBorder);
        }
        if (this.mSrcVarList.hasFocus()) {
            bl = false;
            if (this.mSrcVarList.getModel().getSize() > 0) {
                bl = true;
            }
            this.mArrowDependentButton.setEnabled(bl);
            this.mArrowDependentButton.setArrowOrientation(bl ? SpssArrowButton.ButtonOrientation.right : SpssArrowButton.ButtonOrientation.left);
            this.mArrowIndependentButton.setEnabled(bl);
            this.mArrowIndependentButton.setArrowOrientation(bl ? SpssArrowButton.ButtonOrientation.right : SpssArrowButton.ButtonOrientation.left);
            this.mArrowCaseIDVarButton.setEnabled(bl);
            this.mArrowCaseIDVarButton.setArrowOrientation(bl ? SpssArrowButton.ButtonOrientation.right : SpssArrowButton.ButtonOrientation.left);
        }
        if (this.mDependentTable.hasFocus()) {
            bl = false;
            if (this.mDependentModel.getRowCount() > 0) {
                bl = true;
            }
            this.mArrowDependentButton.setEnabled(bl);
            this.mArrowDependentButton.setArrowOrientation(bl ? SpssArrowButton.ButtonOrientation.left : SpssArrowButton.ButtonOrientation.right);
            this.mArrowIndependentButton.setEnabled(!bl);
            this.mArrowIndependentButton.setArrowOrientation(bl ? SpssArrowButton.ButtonOrientation.left : SpssArrowButton.ButtonOrientation.right);
            this.mArrowCaseIDVarButton.setEnabled(!bl);
            this.mArrowCaseIDVarButton.setArrowOrientation(bl ? SpssArrowButton.ButtonOrientation.left : SpssArrowButton.ButtonOrientation.right);
        }
        if (this.mIndependentList.hasFocus()) {
            bl = false;
            if (this.mIndependentList.getModel().getSize() > 0) {
                bl = true;
            }
            this.mArrowDependentButton.setEnabled(!bl);
            this.mArrowDependentButton.setArrowOrientation(bl ? SpssArrowButton.ButtonOrientation.left : SpssArrowButton.ButtonOrientation.right);
            this.mArrowIndependentButton.setEnabled(bl);
            this.mArrowIndependentButton.setArrowOrientation(bl ? SpssArrowButton.ButtonOrientation.left : SpssArrowButton.ButtonOrientation.right);
            this.mArrowCaseIDVarButton.setEnabled(!bl);
            this.mArrowCaseIDVarButton.setArrowOrientation(bl ? SpssArrowButton.ButtonOrientation.left : SpssArrowButton.ButtonOrientation.right);
        }
        if (this.mCaseIDVarsList.hasFocus()) {
            bl = false;
            if (this.mCaseIDVarsList.getModel().getSize() > 0) {
                bl = true;
            }
            this.mArrowDependentButton.setEnabled(!bl);
            this.mArrowDependentButton.setArrowOrientation(bl ? SpssArrowButton.ButtonOrientation.left : SpssArrowButton.ButtonOrientation.right);
            this.mArrowIndependentButton.setEnabled(!bl);
            this.mArrowIndependentButton.setArrowOrientation(bl ? SpssArrowButton.ButtonOrientation.left : SpssArrowButton.ButtonOrientation.right);
            this.mArrowCaseIDVarButton.setEnabled(bl);
            this.mArrowCaseIDVarButton.setArrowOrientation(bl ? SpssArrowButton.ButtonOrientation.left : SpssArrowButton.ButtonOrientation.right);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        Component component;
        if (focusEvent.getSource() == this.mSrcVarList) {
            this.mSrcVarScrollPane.setBorder(this.mDefaultScrollPaneBorder);
        } else if (focusEvent.getSource() == this.mDependentTable) {
            Component component2 = focusEvent.getOppositeComponent();
            if ((component2 == null || component2.getParent() != this.mDependentTable) && OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.mDependentScrollPane.setBorder(this.mDefaultScrollPaneBorder);
            }
        } else if (focusEvent.getSource() == this.mIndependentList) {
            this.mIndependentScrollPane.setBorder(this.mDefaultScrollPaneBorder);
        } else if (focusEvent.getSource() == this.mCaseIDVarsList) {
            this.mCaseIDVarScrollPane.setBorder(this.mDefaultScrollPaneBorder);
        } else if (focusEvent.getSource() == this.mDependentComboBox && (component = focusEvent.getOppositeComponent()) != null && component != this.mDependentTable && OSInfo.getOSType() != OSInfo.OSType.MAC) {
            this.mDependentScrollPane.setBorder(this.mDefaultScrollPaneBorder);
        }
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setupUI(this);
        this.setDefaults();
        this.setFocusTraversalPolicy();
    }

    protected void generateSyntax(StringBuffer stringBuffer) {
        String string;
        ISpssVariable iSpssVariable;
        for (int i = 0; i < this.mDependentModel.getRowCount(); ++i) {
            String string2 = (String)this.mDependentModel.getValueAt(i, 0);
            iSpssVariable = this.mDependentLocallyUniqueIdMap.get(string2);
            string = " " + iSpssVariable.getName();
            switch (iSpssVariable.getDisplayMeasurementLevel()) {
                case nominal: {
                    string = string + " MLEVEL=N";
                    break;
                }
                case ordinal: {
                    string = string + " MLEVEL=O";
                    break;
                }
                default: {
                    string = string + " MLEVEL=S";
                }
            }
            if (iSpssVariable.getDisplayMeasurementLevel() != MeasurementLevel.scale && iSpssVariable.getDisplayMeasurementLevel() != MeasurementLevel.unknown) {
                string = string + " REFERENCE=" + ((CategoryCellEditor)this.mDependentTable.getCellEditor(0, 1)).getSyntaxValue(string2);
            }
            stringBuffer.append(string);
        }
        String string3 = "";
        string = "";
        block8: for (int i = 0; i < this.mIndependentList.getModel().getSize(); ++i) {
            iSpssVariable = this.mIndependentList.getModel().getElementAt(i);
            switch (iSpssVariable.getDisplayMeasurementLevel()) {
                case nominal: 
                case ordinal: {
                    if (string3.length() == 0) {
                        string3 = " BY";
                    }
                    string3 = string3 + " " + iSpssVariable.getName();
                    continue block8;
                }
                default: {
                    if (string.length() == 0) {
                        string = " WITH";
                    }
                    string = string + " " + iSpssVariable.getName();
                }
            }
        }
        if (string3.length() > 0) {
            stringBuffer.append(string3);
        }
        if (string.length() > 0) {
            stringBuffer.append(string);
        }
        if (this.mCaseIDVarsList.getModel().getSize() > 0) {
            stringBuffer.append("\n  /ID VARIABLE=");
            stringBuffer.append(this.mCaseIDVarsList.getModel().getElementAt(0).getName());
        }
        stringBuffer.append("\n  /CRITERIA");
        stringBuffer.append(" LATENTFACTORS=");
        stringBuffer.append(this.mMaxLatents.getText());
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        for (int i = this.mDependentModel.getRowCount() - 1; i > -1; --i) {
            this.mDependentModel.removeRow(i);
        }
        this.mDependentTable.validate();
        this.mIndependentList.removeAll();
        this.mCaseIDVarsList.removeAll();
        this.mMaxLatents.setText(MAX_LATENTS_DEFAULT);
        this.updateOKPasteButtons();
    }

    private void setupTableForFocusRepainting(final JTable jTable) {
        SpssFocusCellRenderer spssFocusCellRenderer = new SpssFocusCellRenderer();
        jTable.setDefaultRenderer(Object.class, spssFocusCellRenderer);
        jTable.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                jTable.repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                jTable.repaint();
            }
        });
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.setIdentifier(SOURCE_LIST_IDENTIFIER_KEY);
        this.mSrcVarList.addFocusListener(this);
        this.mSrcVarList.setSelectionMode(2);
        this.mSrcVarList.setContextMenuFlags(8 | this.mSrcVarList.getContextMenuFlags());
        ((DragPane)((PartialLeastSquaresDlg)this.mParent).getGlassPane()).addDropListener((IDropListener)new SrcVarListDropListener(this.mSrcVarList, new DependentsTableVarMoveHandler()));
        this.mSrcVarScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcListLabel = new JLabel(this.getResString("IDS_CASESUMMARIES_VARIABLES_COLON"));
        this.mSrcListLabel.setDisplayedMnemonic(this.getDlgAccessKey("IDK_CASESUMMARIES_VARIABLES_COLON_KEY"));
        this.mSrcListLabel.setLabelFor(this.mSrcVarList);
        this.mChangeMeasuresText = new JTextArea(this.getResString("IDS_PARTIAL_LEAST_SQUARES_VARSTAB_CHANGE_MEASURES_LABEL"));
        this.mChangeMeasuresText.setLineWrap(true);
        this.mChangeMeasuresText.setWrapStyleWord(true);
        this.mChangeMeasuresText.setBorder(null);
        this.mChangeMeasuresText.setOpaque(false);
        this.mChangeMeasuresText.setFocusable(false);
        this.mChangeMeasuresText.setPreferredSize(new Dimension(this.mSrcVarList.getMinimumSize().width, 80));
        this.mChangeMeasuresText.setCursor(new Cursor(0));
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        vector2.add(this.getResString("IDS_PARTIAL_LEAST_SQUARES_VARSTAB_DEPENDENT_TABLE_HEADER_0"));
        vector2.add(this.getResString("IDS_PARTIAL_LEAST_SQUARES_VARSTAB_DEPENDENT_TABLE_HEADER_1"));
        this.mDependentModel = new DefaultTableModel(vector, vector2){

            @Override
            public boolean isCellEditable(int n, int n2) {
                if (n2 == 0) {
                    return false;
                }
                String string = (String)VariablesTab.this.mDependentTable.getModel().getValueAt(n, 0);
                ISpssVariable iSpssVariable = (ISpssVariable)VariablesTab.this.mDependentLocallyUniqueIdMap.get(string);
                return iSpssVariable.getDisplayMeasurementLevel() != MeasurementLevel.scale && iSpssVariable.getDisplayMeasurementLevel() != MeasurementLevel.unknown;
            }
        };
        this.mDependentTable = new PlainTable();
        this.mDependentTable.setModel(this.mDependentModel);
        this.mDependentTable.addFocusListener(this);
        this.mDependentTable.setRowSelectionAllowed(true);
        this.mDependentTable.setSelectionMode(2);
        this.mDependentTable.setColumnSelectionAllowed(false);
        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            this.mDependentTable.setRowHeight(this.mDependentTable.getRowHeight() + 5);
        }
        this.mDependentComboBox = new JComboBox(new PLSComboBoxModel(new String[]{this.getResString("IDS_PARTIAL_LEAST_SQUARES_VARSTAB_DEPENDENT_TABLE_COMBOBOX_HIGHEST_OPTION"), this.getResString("IDS_PARTIAL_LEAST_SQUARES_VARSTAB_DEPENDENT_TABLE_COMBOBOX_LOWEST_OPTION")}, new String[]{this.getResString("IDS_PARTIAL_LEAST_SQUARES_VARSTAB_DEPENDENT_TABLE_COMBOBOX_HIGHEST_OPTION"), this.getResString("IDS_PARTIAL_LEAST_SQUARES_VARSTAB_DEPENDENT_TABLE_COMBOBOX_LOWEST_OPTION")}, this.mDependentTable));
        this.mDependentComboBox.setEditable(false);
        this.mDependentComboBox.addFocusListener(this);
        this.mDependentTable.getColumnModel().getColumn(0).setCellRenderer(new SpssFocusCellRenderer());
        this.mDependentTable.getColumnModel().getColumn(1).setCellRenderer(new CategoryCellRenderer());
        this.mDependentTable.getColumnModel().getColumn(1).setCellEditor(new CategoryCellEditor(this.mDependentComboBox));
        this.setupTableForFocusRepainting(this.mDependentTable);
        JTableHeader jTableHeader = this.mDependentTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        PlainTableDragAdapter plainTableDragAdapter = new PlainTableDragAdapter(this.mDependentTable, (DragPane)this.mParent.getGlassPane(), "PlainTable");
        DialogUtil.modifyMouseInputListeners(this.mDependentTable, plainTableDragAdapter);
        ((DragPane)((PartialLeastSquaresDlg)this.mParent).getGlassPane()).addDropListener((IDropListener)new DependentsTableDropListener(this.mDependentTable, new DependentsTableVarMoveHandler(), this.mSrcVarList));
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = VariablesTab.this.mDependentTable.getSelectedRow();
                if (n > 0) {
                    int n2 = n - 1;
                    VariablesTab.this.mDependentModel.moveRow(n, n, n2);
                    VariablesTab.this.mDependentTable.getSelectionModel().setSelectionInterval(n2, n2);
                    VariablesTab.this.mDependentTable.scrollRectToVisible(VariablesTab.this.mDependentTable.getCellRect(n2, 0, false));
                }
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = VariablesTab.this.mDependentTable.getSelectedRow();
                if (n < VariablesTab.this.mDependentModel.getRowCount() - 1) {
                    int n2 = n + 1;
                    VariablesTab.this.mDependentModel.moveRow(n, n, n2);
                    VariablesTab.this.mDependentTable.getSelectionModel().setSelectionInterval(n2, n2);
                    VariablesTab.this.mDependentTable.scrollRectToVisible(VariablesTab.this.mDependentTable.getCellRect(n2, 0, false));
                }
            }
        };
        this.mDependentTable.getInputMap(0).put(KeyStroke.getKeyStroke(38, 2), "moveRowUp");
        this.mDependentTable.getInputMap(0).put(KeyStroke.getKeyStroke(40, 2), "moveRowDown");
        this.mDependentTable.getActionMap().put("moveRowUp", abstractAction);
        this.mDependentTable.getActionMap().put("moveRowDown", abstractAction2);
        this.mDependentScrollPane = new JScrollPane(this.mDependentTable);
        this.mDefaultScrollPaneBorder = this.mDependentScrollPane.getBorder();
        this.mDependentListLabel = DialogUtil.createLabel(this.mParent, "IDS_PARTIAL_LEAST_SQUARES_VARSTAB_DEPENDENT_VARIABLES");
        this.mDependentListLabel.setLabelFor(this.mDependentTable);
        this.mArrowDependentButton = new SrcListTableArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowDependentButton.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowDependentButton.registerComponents(this.mDependentTable, SpssArrowButton.ButtonOrientation.left);
        this.mIndependentList = new TargetVariableList();
        this.mIndependentList.setIdentifier(INDEPENDENT_LIST_IDENTIFIER_KEY);
        this.mIndependentList.setVisibleRowCount(4);
        this.mIndependentList.getModel().addListDataListener(this);
        this.mIndependentList.addFocusListener(this);
        this.mIndependentList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mIndependentScrollPane = new JScrollPane(this.mIndependentList);
        this.mIndependentListLabel = DialogUtil.createLabel(this.mParent, "IDS_PARTIAL_LEAST_SQUARES_VARSTAB_INDEPENDENT_VARIABLES");
        this.mIndependentListLabel.setLabelFor(this.mIndependentList);
        this.mArrowIndependentButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowIndependentButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowIndependentButton.registerVariableList(this.mIndependentList, SpssArrowButton.ButtonOrientation.left);
        this.mMapOfModels = new HashMap();
        this.mDependentLocallyUniqueIdMap = new HashMap();
        this.mDependentTable.addKeyListener(this);
        TargetVariableList.TargetListType targetListType = TargetVariableList.TargetListType.single_item;
        this.mCaseIDVarsList = new TargetVariableList(targetListType);
        this.mCaseIDVarsList.setIdentifier(CASE_ID_LIST_IDENTIFIER_KEY);
        this.mCaseIDVarsList.addFocusListener(this);
        this.mCaseIDVarScrollPane = new JScrollPane(this.mCaseIDVarsList);
        this.mCaseIDVarScrollPane.setPreferredSize(this.mCaseIDVarsList.getMinimumSize());
        this.mCaseIDVarScrollPane.setHorizontalScrollBarPolicy(31);
        this.mCaseIDVarScrollPane.setVerticalScrollBarPolicy(21);
        this.mCaseIDVarLabel = DialogUtil.createLabel(this.mParent, "IDS_PARTIAL_LEAST_SQUARES_VARSTAB_CASE_ID_VARIABLE");
        this.mCaseIDVarLabel.setLabelFor(this.mCaseIDVarsList);
        this.mArrowCaseIDVarButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowCaseIDVarButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowCaseIDVarButton.registerVariableList(this.mCaseIDVarsList, SpssArrowButton.ButtonOrientation.left);
        this.mMaxLatentsLabel = DialogUtil.createLabel(this.mParent, "IDS_PARTIAL_LEAST_SQUARES_VARSTAB_MAX_LATENTS_LABEL");
        this.mMaxLatentsLabel.setLabelFor((Component)this.mMaxLatents);
        this.mMaxLatents = new IntTextField(true);
        this.mMaxLatents.setAction((Action)new TextFieldAction(this.mParent, "IDS_MIN_WIDTH"));
        this.mMaxLatents.setText(MAX_LATENTS_DEFAULT);
        this.mMaxLatents.setAlignmentX(1.0f);
        this.mSpecialSetupText = new JTextArea(this.getResString("IDS_PARTIAL_LEAST_SQUARES_SPECIAL_SETUP_LABEL"));
        this.mSpecialSetupText.setLineWrap(true);
        this.mSpecialSetupText.setWrapStyleWord(true);
        this.mSpecialSetupText.setBorder(null);
        this.mSpecialSetupText.setOpaque(false);
        this.mSpecialSetupText.setFocusable(false);
    }

    private void setupUI(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        Insets insets2 = (Insets)DialogUtil.getArrowButtonInsets().clone();
        Insets insets3 = (Insets)DialogUtil.getStandardDialogInsets().clone();
        int n = insets3.top;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        this.mSrcListLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel2, this.mSrcListLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mSrcVarScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel2, this.mSrcVarScrollPane, gridBagConstraints, 0, 1, 1, 2, n2, insets);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel2, this.mChangeMeasuresText, gridBagConstraints, 0, 3, 1, 1, n2, insets);
        JPanel jPanel3 = new JPanel(new GridBagLayout(), true);
        gridBagConstraints = new GridBagConstraints();
        n2 = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel3, this.mArrowDependentButton, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        n2 = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel3, this.mArrowIndependentButton, gridBagConstraints, 0, 3, 1, 1, n2, insets2);
        n2 = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.top += n + 2;
        DialogUtil.addUsingGBL(jPanel3, this.mArrowCaseIDVarButton, gridBagConstraints, 0, 4, 1, 2, n2, new Insets(insets.top + n, insets2.left, 0, insets2.right));
        n2 = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel3, this.mDependentListLabel, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        n2 = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.mDependentScrollPane.setPreferredSize(this.mDependentTable.getMinimumSize());
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel3, this.mDependentScrollPane, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        n2 = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.top += n;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel3, this.mIndependentListLabel, gridBagConstraints, 1, 2, 1, 1, n2, insets);
        n2 = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.top -= n;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel3, this.mIndependentScrollPane, gridBagConstraints, 1, 3, 1, 1, n2, insets);
        n2 = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.top += n;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel3, this.mCaseIDVarLabel, gridBagConstraints, 1, 4, 1, 1, n2, insets);
        this.mCaseIDVarsList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        n2 = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.top -= n;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel3, this.mCaseIDVarScrollPane, gridBagConstraints, 1, 5, 1, 1, n2, insets);
        JPanel jPanel4 = new JPanel(new FlowLayout(), true);
        jPanel4.add(this.mMaxLatentsLabel);
        jPanel4.add((Component)this.mMaxLatents);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.top += n;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.fill = 1;
        n2 = 17;
        DialogUtil.addUsingGBL(jPanel3, jPanel4, gridBagConstraints, 1, 6, 1, 1, n2, new Insets(insets.top, 0, insets.bottom, insets.right));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n2 = 18;
        int n3 = insets3.right;
        gridBagConstraints.insets.right = 0;
        insets3.right = 0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n2, insets3);
        gridBagConstraints.insets.left = 0;
        insets3.left = 0;
        gridBagConstraints.insets.right = n3;
        insets3.right = n3;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 0, 1, 1, n2, insets3);
        insets3 = (Insets)DialogUtil.getStandardDialogInsets().clone();
        JPanel jPanel5 = new JPanel(new GridBagLayout(), true);
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        ImageIcon imageIcon = new ImageIcon(uRL);
        n2 = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel5, new JLabel(imageIcon), gridBagConstraints, 0, 0, 1, 1, n2, new Insets(0, insets.left, 0, insets.right));
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel5, this.mSpecialSetupText, gridBagConstraints, 1, 0, 1, 1, n2, new Insets(0, insets.left + 5, 0, insets.right));
        insets3.top = 0;
        insets3.bottom = 0;
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 0, 1, 2, 1, n2, insets3);
    }

    void updateOKPasteButtons() {
        if (this.mDependentTable.getModel().getRowCount() > 0 && this.mIndependentList.getModel().getSize() > 0) {
            ((PartialLeastSquaresDlg)this.mParent).enableOkPaste(true);
        } else {
            ((PartialLeastSquaresDlg)this.mParent).enableOkPaste(false);
        }
    }

    @Override
    protected boolean validateTab() {
        if (this.mDependentTable.isEditing()) {
            this.mDependentTable.getCellEditor().stopCellEditing();
        }
        if (this.mMaxLatents.getText().trim().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_PARTIAL_LEAST_SQUARES_VARSTAB_MAX_LATENTS_EMPTY_ALERT"), VersionInfo.getAppVersionString());
            this.mMaxLatents.requestFocus();
            return false;
        }
        Integer n = new Integer(this.mMaxLatents.getText().trim());
        if (n < 1) {
            SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_PARTIAL_LEAST_SQUARES_VARSTAB_MAX_LATENTS_EMPTY_ALERT"), VersionInfo.getAppVersionString());
            this.mMaxLatents.requestFocus();
            return false;
        }
        return super.validateTab();
    }

    private void setFocusTraversalPolicy() {
        this.mComponentOrder.removeAllElements();
        this.mComponentOrder.add(this.mSrcVarList);
        this.mComponentOrder.add(this.mArrowDependentButton);
        this.mComponentOrder.add(this.mArrowIndependentButton);
        this.mComponentOrder.add(this.mArrowCaseIDVarButton);
        this.mComponentOrder.add(this.mDependentTable);
        this.mComponentOrder.add(this.mIndependentList);
        this.mComponentOrder.add(this.mCaseIDVarsList);
        this.mComponentOrder.add(this.mMaxLatents);
    }

    protected TargetVariableList getIndependentVars() {
        return this.mIndependentList;
    }

    private void moveVarsFromTableToSrcList(PlainTable plainTable, SrcVariableList srcVariableList) {
        String string;
        int n;
        int[] nArray = plainTable.getSelectedRows();
        int[] nArray2 = new int[nArray.length];
        srcVariableList.clearSelection();
        DefaultTableModel defaultTableModel = (DefaultTableModel)plainTable.getModel();
        for (n = nArray.length - 1; n >= 0; --n) {
            string = (String)defaultTableModel.getValueAt(nArray[n], 0);
            srcVariableList.getModel().addElement(this.mDependentLocallyUniqueIdMap.get(string));
        }
        for (n = nArray.length - 1; n >= 0; --n) {
            string = (String)defaultTableModel.getValueAt(nArray[n], 0);
            nArray2[n] = srcVariableList.getModel().findElementIndex(this.mDependentLocallyUniqueIdMap.get(string));
            this.mDependentLocallyUniqueIdMap.remove(string);
            defaultTableModel.removeRow(nArray[n]);
        }
        srcVariableList.setSelectedIndices(nArray2);
        if (srcVariableList.getModel().getSize() > 0) {
            srcVariableList.ensureIndexIsVisible(nArray2[0]);
        }
        this.updateOKPasteButtons();
        final SrcVariableList srcVariableList2 = srcVariableList;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                srcVariableList2.requestFocusInWindow();
            }
        });
    }

    private void moveVarsFromSrcListToTable(SrcVariableList srcVariableList, PlainTable plainTable) {
        ISpssVariable[] iSpssVariableArray = srcVariableList.getSelectedValues();
        DefaultTableModel defaultTableModel = (DefaultTableModel)plainTable.getModel();
        ISpssVariable[] iSpssVariableArray2 = srcVariableList.getSelectedValues();
        int[] nArray = srcVariableList.getSelectedIndices();
        for (int i = iSpssVariableArray2.length - 1; i > -1; --i) {
            Object[] objectArray;
            String string = iSpssVariableArray2[i].getDisplayMeasurementLevel() == MeasurementLevel.scale || iSpssVariableArray2[i].getDisplayMeasurementLevel() == MeasurementLevel.unknown ? this.getResString("IDS_PARTIAL_LEAST_SQUARES_VARSTAB_DEPENDENT_TABLE_COMBOBOX_NA_LABEL") : this.getResString("IDS_PARTIAL_LEAST_SQUARES_VARSTAB_DEPENDENT_TABLE_COMBOBOX_HIGHEST_OPTION");
            String string2 = iSpssVariableArray2[i].getLabel();
            String string3 = iSpssVariableArray2[i].getName();
            if (srcVariableList.getShowVarLabels()) {
                objectArray = new Object[]{string2 + " [" + string3 + "]", string};
                defaultTableModel.addRow(objectArray);
                this.mDependentLocallyUniqueIdMap.put(string2 + " [" + string3 + "]", iSpssVariableArray2[i]);
            } else {
                objectArray = new Object[]{string3, string};
                defaultTableModel.addRow(objectArray);
                this.mDependentLocallyUniqueIdMap.put(string3, iSpssVariableArray2[i]);
            }
            srcVariableList.getModel().removeElementAt(nArray[i]);
        }
        this.updateOKPasteButtons();
        plainTable.setRowSelectionInterval(plainTable.getRowCount() - 1 - (iSpssVariableArray.length - 1), plainTable.getRowCount() - 1);
        plainTable.scrollRectToVisible(plainTable.getCellRect(plainTable.getRowCount() - 1, 0, false));
        final PlainTable plainTable2 = plainTable;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                plainTable2.requestFocusInWindow();
            }
        });
    }

    private class SrcListTableArrowButton
    extends ComponentsArrowButton {
        public SrcListTableArrowButton() {
        }

        public SrcListTableArrowButton(SpssArrowButton.ButtonOrientation buttonOrientation) {
            super(buttonOrientation);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if ("arrowPressed".equals(actionEvent.getActionCommand())) {
                ComponentsArrowButton.ComponentHolder componentHolder = (ComponentsArrowButton.ComponentHolder)this.getSourceVarHolder();
                ComponentsArrowButton.ComponentHolder componentHolder2 = (ComponentsArrowButton.ComponentHolder)this.getTargetVarHolder();
                if (componentHolder != null && componentHolder2 != null) {
                    JComponent jComponent = this.getSrcHolderComponent();
                    JComponent jComponent2 = this.getTargetHolderComponent();
                    if (jComponent instanceof SrcVariableList && jComponent2 instanceof PlainTable) {
                        VariablesTab.this.moveVarsFromSrcListToTable((SrcVariableList)jComponent, (PlainTable)jComponent2);
                    } else if (jComponent instanceof PlainTable && jComponent2 instanceof SrcVariableList) {
                        VariablesTab.this.moveVarsFromTableToSrcList((PlainTable)jComponent, (SrcVariableList)jComponent2);
                    }
                }
            }
        }

        protected boolean moveSelectedRowToList(int n, PlainTable plainTable, SrcVariableList srcVariableList) {
            if (plainTable.getSelectedRow() != -1) {
                DefaultTableModel defaultTableModel = (DefaultTableModel)plainTable.getModel();
                String string = (String)defaultTableModel.getValueAt(n, 0);
                srcVariableList.getModel().addElement((ISpssVariable)VariablesTab.this.mDependentLocallyUniqueIdMap.get(string));
                defaultTableModel.removeRow(n);
                VariablesTab.this.mDependentLocallyUniqueIdMap.remove(string);
            }
            srcVariableList.requestFocus();
            return true;
        }

        @Override
        protected void updateEnable(SpssArrowButton.SrcDestHolder srcDestHolder) {
            if (srcDestHolder != null) {
                SpssArrowButton.ButtonOrientation buttonOrientation = this.getArrowOrientation();
                JComponent jComponent = this.getSrcHolderComponent();
                if (jComponent instanceof PlainTable) {
                    ListSelectionModel listSelectionModel = ((PlainTable)jComponent).getSelectionModel();
                    if (buttonOrientation == SpssArrowButton.ButtonOrientation.up || buttonOrientation == SpssArrowButton.ButtonOrientation.down) {
                        int n = listSelectionModel.getMinSelectionIndex();
                        int n2 = listSelectionModel.getMaxSelectionIndex();
                        int n3 = ((PlainTable)jComponent).getRowCount();
                        if (buttonOrientation == SpssArrowButton.ButtonOrientation.up) {
                            this.setEnabled(n > 0);
                        } else {
                            this.setEnabled(n2 > -1 && n2 < n3 - 1);
                        }
                    } else {
                        this.setEnabled(listSelectionModel.getMinSelectionIndex() > -1);
                    }
                } else if (jComponent instanceof PlainList) {
                    this.setEnabled(jComponent.isEnabled() && ((PlainList)jComponent).getSelectedIndices().length > 0);
                }
            }
        }
    }

    public class DependentsTableVarMoveHandler
    implements IVarMoveHandler {
        @Override
        public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
            return true;
        }
    }

    private class DependentsTableDropListener
    extends AbstractTableDropListener {
        public DependentsTableDropListener(PlainTable plainTable, Component component) {
            super(plainTable, component);
        }

        public DependentsTableDropListener(PlainTable plainTable, IVarMoveHandler iVarMoveHandler, Component component) {
            super(plainTable, iVarMoveHandler, component);
        }

        @Override
        public boolean canDrop(DragDropAdapter dragDropAdapter) {
            return true;
        }

        @Override
        public JTable getTarget() {
            return (JTable)super.getTarget();
        }

        @Override
        public void itemDropped(DropEvent dropEvent) {
            if (dropEvent.getSource() instanceof SrcVariableList) {
                boolean bl;
                Component component = dropEvent.getSource();
                boolean bl2 = bl = this.contains(dropEvent.getDropLocation()) && this.canDrop(dropEvent.getDragSourceAdapter());
                if (bl && this.mDropTarget != null && component instanceof VariableList) {
                    Object object = dropEvent.getTransferData();
                    if (object == null) {
                        return;
                    }
                    if (!(object instanceof VariableList.TransferData)) {
                        return;
                    }
                    VariableList.TransferData transferData = (VariableList.TransferData)object;
                    ISpssVariable[] iSpssVariableArray = transferData.getVariables();
                    Point point = (Point)dropEvent.getDropLocation().clone();
                    SwingUtilities.convertPointFromScreen(point, this.mDropTarget);
                    int n = this.getTarget().rowAtPoint(point);
                    this.importData(iSpssVariableArray, (JComponent)component, n);
                }
            }
            VariablesTab.this.updateOKPasteButtons();
        }

        @Override
        protected void importData(Object object, JComponent jComponent, int n) {
            if (!(this.mDropTarget instanceof PlainTable)) {
                assert (false);
                return;
            }
            final PlainTable plainTable = (PlainTable)this.mDropTarget;
            int n2 = plainTable.getSelectionModel().getMinSelectionIndex();
            final int n3 = n2 < n ? n - plainTable.getSelectedRowCount() : n;
            int[] nArray = ((SrcVariableList)jComponent).getSelectedIndices();
            int n4 = nArray.length;
            if (jComponent instanceof PlainTable && object instanceof Vector) {
                Vector vector = (Vector)object;
                n4 = vector.size();
                for (Object[] objectArray : vector) {
                    plainTable.getDefaultTableModel().insertRow(n++, objectArray);
                }
            } else if (jComponent instanceof SrcVariableList && object instanceof Object[]) {
                VariablesTab.this.moveVarsFromSrcListToTable((SrcVariableList)jComponent, (PlainTable)this.mDropTarget);
            } else {
                return;
            }
            final int n5 = n4;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    plainTable.requestFocus();
                    plainTable.clearSelection();
                    plainTable.getSelectionModel().addSelectionInterval(n3, n3 + n5 - 1);
                }
            });
        }
    }

    private class SrcVarListDropListener
    extends VarListDropListener {
        private SrcVariableList mList;

        public SrcVarListDropListener(SrcVariableList srcVariableList, IVarMoveHandler iVarMoveHandler) {
            super(srcVariableList, iVarMoveHandler);
            this.mList = srcVariableList;
        }

        @Override
        public boolean canDrop(DragDropAdapter dragDropAdapter) {
            return true;
        }

        @Override
        public void itemDropped(DropEvent dropEvent) {
            Component component;
            boolean bl;
            boolean bl2 = bl = this.contains(dropEvent.getDropLocation()) && this.canDrop(dropEvent.getDragSourceAdapter());
            if (!bl || this.mDropTarget == null) {
                return;
            }
            if (dropEvent.getSource() instanceof PlainTable) {
                component = dropEvent.getSource();
                VariablesTab.this.moveVarsFromTableToSrcList((PlainTable)component, this.mList);
            } else if (dropEvent.getSource() instanceof TargetVariableList) {
                int n;
                component = (TargetVariableList)dropEvent.getSource();
                int[] nArray = ((JList)component).getSelectedIndices();
                int[] nArray2 = new int[nArray.length];
                boolean bl3 = false;
                this.mList.clearSelection();
                VarListModel varListModel = ((VariableList)component).getModel();
                for (n = nArray.length - 1; n >= 0; --n) {
                    this.mList.getModel().addElement(varListModel.getElementAt(nArray[n]));
                }
                for (n = nArray.length - 1; n >= 0; --n) {
                    nArray2[n] = this.mList.getModel().findElementIndex(varListModel.getElementAt(nArray[n]));
                    varListModel.removeElementAt(nArray[n]);
                }
                this.mList.setSelectedIndices(nArray2);
                if (this.mList.getModel().getSize() > 0) {
                    this.mList.ensureIndexIsVisible(nArray2[0]);
                }
            }
            VariablesTab.this.updateOKPasteButtons();
            component = this.mList;
            SwingUtilities.invokeLater(new Runnable((SrcVariableList)component){
                final /* synthetic */ SrcVariableList val$varList;
                {
                    this.val$varList = srcVariableList;
                }

                @Override
                public void run() {
                    this.val$varList.requestFocusInWindow();
                }
            });
        }
    }

    private class CategoryCellEditor
    extends DefaultCellEditor {
        private JComboBox mComboBox;

        public CategoryCellEditor(JComboBox jComboBox) {
            super(jComboBox);
            this.mComboBox = jComboBox;
        }

        private void fixJavaBug() {
            JComponent jComponent = (JComponent)((Object)this.mComboBox.getUI().getAccessibleChild(this.mComboBox, 0));
            JList<Object> jList = ((ComboPopup)((Object)jComponent)).getList();
            if (jList != null) {
                jList.setRequestFocusEnabled(false);
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = (String)jTable.getModel().getValueAt(n, 0);
            ISpssVariable iSpssVariable = (ISpssVariable)VariablesTab.this.mDependentLocallyUniqueIdMap.get(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = this.getVarValues(iSpssVariable, arrayList);
            for (int i = arrayList2.size() - 1; i > -1; --i) {
                String string2 = arrayList2.get(i);
                if (string2.trim().length() == 0) {
                    arrayList2.remove(i);
                    continue;
                }
                string2 = string2.substring(string2.indexOf(" ") + 1);
                arrayList2.set(i, string2);
            }
            arrayList2.add(0, VariablesTab.this.getResString("IDS_PARTIAL_LEAST_SQUARES_VARSTAB_DEPENDENT_TABLE_COMBOBOX_HIGHEST_OPTION"));
            arrayList2.add(1, VariablesTab.this.getResString("IDS_PARTIAL_LEAST_SQUARES_VARSTAB_DEPENDENT_TABLE_COMBOBOX_LOWEST_OPTION"));
            arrayList.add(0, VariablesTab.this.getResString("IDS_PARTIAL_LEAST_SQUARES_VARSTAB_DEPENDENT_TABLE_COMBOBOX_HIGHEST_OPTION"));
            arrayList.add(1, VariablesTab.this.getResString("IDS_PARTIAL_LEAST_SQUARES_VARSTAB_DEPENDENT_TABLE_COMBOBOX_LOWEST_OPTION"));
            if (VariablesTab.this.mMapOfModels.containsKey(string)) {
                PLSComboBoxModel pLSComboBoxModel = (PLSComboBoxModel)VariablesTab.this.mMapOfModels.get(string);
                pLSComboBoxModel.setTableModel((DefaultTableModel)VariablesTab.this.mDependentTable.getModel());
                this.mComboBox.setModel(pLSComboBoxModel);
                if (object == null) {
                    pLSComboBoxModel.setSelectedItem(VariablesTab.this.getResString("IDS_PARTIAL_LEAST_SQUARES_VARSTAB_DEPENDENT_TABLE_COMBOBOX_HIGHEST_OPTION"), n, 1);
                } else {
                    pLSComboBoxModel.setSelectedItem(object.toString(), n, 1);
                }
            } else {
                PLSComboBoxModel pLSComboBoxModel = new PLSComboBoxModel(arrayList2.toArray(new String[arrayList2.size()]), arrayList.toArray(new String[arrayList.size()]), VariablesTab.this.mDependentTable);
                VariablesTab.this.mMapOfModels.put(string, pLSComboBoxModel);
                this.mComboBox.setModel(pLSComboBoxModel);
                if (object == null) {
                    pLSComboBoxModel.setSelectedItem(VariablesTab.this.getResString("IDS_PARTIAL_LEAST_SQUARES_VARSTAB_DEPENDENT_TABLE_COMBOBOX_HIGHEST_OPTION"), n, 1);
                } else {
                    pLSComboBoxModel.setSelectedItem(object.toString(), n, 1);
                }
            }
            VariablesTab.this.mArrowDependentButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            this.fixJavaBug();
            return this.mComboBox;
        }

        public ArrayList<String> getVarValues(ISpssVariable iSpssVariable, ArrayList<String> arrayList) {
            SPSS_Format sPSS_Format = iSpssVariable.getFormat();
            IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            int n = 0;
            Set set = iValueLabelMap.getValueLabelEntries();
            for (Map.Entry entry : set) {
                OBS oBS = (OBS)entry.getKey();
                if (iSpssVariable.isMissing(oBS)) continue;
                String string = (String)entry.getValue();
                if (oBS.isEmpty() || sPSS_Format == null) continue;
                String string2 = CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)sPSS_Format);
                arrayList2.add(string2 + " " + string);
                arrayList.add(string2);
                ++n;
            }
            if (arrayList2.size() == 0) {
                arrayList2.add("");
                arrayList.add("");
            }
            return arrayList2;
        }

        protected String getSyntaxValue(String string) {
            PLSComboBoxModel pLSComboBoxModel = (PLSComboBoxModel)VariablesTab.this.mMapOfModels.get(string);
            if (pLSComboBoxModel == null) {
                return "LAST";
            }
            String string2 = pLSComboBoxModel.getValueForSelectedIndex().trim();
            if (pLSComboBoxModel.getSelectedIndex() > 1) {
                try {
                    Double.parseDouble(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    string2 = CharacterUtil.smartQuote((String)string2);
                }
            }
            return string2;
        }
    }

    private class CategoryCellRenderer
    extends SpssFocusCellRenderer {
        private CategoryCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ISpssVariable iSpssVariable = (ISpssVariable)VariablesTab.this.mDependentLocallyUniqueIdMap.get(jTable.getModel().getValueAt(n, 0).toString());
            if (iSpssVariable.getDisplayMeasurementLevel() == MeasurementLevel.scale || iSpssVariable.getDisplayMeasurementLevel() == MeasurementLevel.unknown) {
                this.setText(VariablesTab.this.getResString("IDS_PARTIAL_LEAST_SQUARES_VARSTAB_DEPENDENT_TABLE_COMBOBOX_NA_LABEL"));
                this.setEnabled(false);
            } else if (object != null) {
                this.setText(object.toString());
                this.setEnabled(true);
            }
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }
    }
}

