/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.regression.partial_least_squares;

import com.spss.java_client.ui.dialogs.base.analyze.regression.partial_least_squares.DefineMeasuresSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.regression.partial_least_squares.ModelTab;
import com.spss.java_client.ui.dialogs.base.analyze.regression.partial_least_squares.OptionsTab;
import com.spss.java_client.ui.dialogs.base.analyze.regression.partial_least_squares.VariablesTab;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.base.data.define_var_properties.DefVarPropsGatingDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;

public class PartialLeastSquaresDlg
extends BaseTabbedDialog {
    private VariablesTab mVariablesTab;
    private ModelTab mModelTab;
    private OptionsTab mOptionsTab;

    public PartialLeastSquaresDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle.getDefaultResourceBundleName(), AnalyzeResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_PARTIAL_LEAST_SQUARES_TITLE"));
        this.setLocationRelativeTo(jFrame);
        int n = DefineMeasuresSubDlg.runDialog(this);
        if (n == 2) {
            this.setVisible(false);
            DefVarPropsGatingDialog defVarPropsGatingDialog = new DefVarPropsGatingDialog(jFrame);
            defVarPropsGatingDialog.setVisible(true);
            this.dispose();
        } else if (n == 0) {
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public String getIActionKey() {
        return "analyze_regression_partial_least_squares";
    }

    @Override
    public String getDialogHelpID() {
        BaseProcedureTab baseProcedureTab = (BaseProcedureTab)this.mTabbedPane.getSelectedComponent();
        return baseProcedureTab.getDialogHelpID();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        super.stateChanged(changeEvent);
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    protected void enableOkPaste(boolean bl) {
        super.enableOkPaste(bl);
    }

    @Override
    protected void loadDialogState() {
        this.mVariablesTab.loadTabState(this.getDialogDataModel(), this.mNameLabelOverride);
        this.mModelTab.loadTabState(this.getDialogDataModel(), this.mNameLabelOverride);
        this.mOptionsTab.loadTabState(this.getDialogDataModel(), this.mNameLabelOverride);
        this.mVariablesTab.setVisible(false);
        this.mModelTab.setVisible(false);
        this.mOptionsTab.setVisible(false);
        super.loadDialogState();
    }

    @Override
    protected void saveDialogState() {
        this.mVariablesTab.saveTabState(this.getDialogDataModel());
        this.mModelTab.saveTabState(this.getDialogDataModel());
        this.mOptionsTab.saveTabState(this.getDialogDataModel());
        super.saveDialogState();
    }

    @Override
    protected void init() {
        super.init();
        this.mVariablesTab = new VariablesTab(this, true);
        this.mModelTab = new ModelTab(this, true);
        this.mOptionsTab = new OptionsTab(this, true);
        this.addTab(this.getResString("IDS_PARTIAL_LEAST_SQUARES_VARSTAB_TITLE"), this.mVariablesTab);
        this.addTab(this.getResString("IDS_PARTIAL_LEAST_SQUARES_MODELTAB_TITLE"), this.mModelTab);
        this.addTab(this.getResString("IDS_PARTIAL_LEAST_SQUARES_OPTIONSTAB_TITLE"), this.mOptionsTab);
        this.mTabbedPane.addChangeListener(this);
        this.pack();
    }

    public VariablesTab getVariablesTab() {
        return this.mVariablesTab;
    }

    public ModelTab getModelTab() {
        return this.mModelTab;
    }

    public OptionsTab getOptionsTab() {
        return this.mOptionsTab;
    }

    @Override
    public boolean okPastePressed() {
        return super.okPastePressed();
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("PLS");
        this.mVariablesTab.generateSyntax(stringBuffer);
        this.mModelTab.generateSyntax(stringBuffer);
        this.mOptionsTab.generateSyntax(stringBuffer);
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    protected String buildBracketedNumList(Integer n) {
        if (n == null) {
            return "[]";
        }
        String string = "[";
        if (n >= 1) {
            for (int i = n.intValue(); i >= 1; --i) {
                String string2 = i == n ? String.format("%d", i) : String.format(",%d", i);
                string = string + string2;
            }
        } else {
            String string3 = "0";
            string = string + string3;
        }
        string = string + "]";
        return string;
    }
}

