/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.regression.partial_least_squares;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.SpssCovariateVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssFactorVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.ComponentsArrowButton;
import com.spss.java_client.ui.controls.ModelTermsList;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.ListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.TermsListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.TermsListDropListener;
import com.spss.java_client.ui.controls.drag_drop.VarListDropListener;
import com.spss.java_client.ui.dialogs.base.analyze.regression.partial_least_squares.PartialLeastSquaresDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.drag_drop.ComponentDragAdapter;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.DropEvent;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class ModelTab
extends BaseProcedureTab
implements ActionListener {
    public static final String FACTORS_COVARIATES_LIST_IDENTIFIER_KEY = "factorsandcovarslist";
    public static final String MODELS_LIST_IDENTIFIER_KEY = "modelslist";
    private static final String COMBO_SELECTION_KEY = "comboSelect";
    final int INTERACTION = 0;
    final int MAIN_EFFECTS = 1;
    final int ALL_TWO_WAY = 2;
    final int ALL_THREE_WAY = 3;
    final int ALL_FOUR_WAY = 4;
    final int ALL_FIVE_WAY = 5;
    private JRadioButton mMainEffectsRadio;
    private JRadioButton mCustomRadio;
    private TargetVariableList mFactorsVarList;
    private JScrollPane mFactorsVarScrollPane;
    private JLabel mFactorsVarLabel;
    private ModelTermsList mModelTermsVarList;
    private JScrollPane mModelTermsVarScrollPane;
    private JLabel mModelTermsVarLabel;
    private JLabel mTypeLabel;
    private JComboBox mBuildTermsCombo;
    private ComponentsArrowButton mArrowButton;

    public ModelTab(BaseDialog baseDialog, boolean bl) {
        super(baseDialog, bl);
        this.reset();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_pls_model";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        super.saveTabState(dialogDataModel);
        dialogDataModel.putInteger(COMBO_SELECTION_KEY, this.mBuildTermsCombo.getSelectedIndex());
    }

    @Override
    protected void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        Integer n = dialogDataModel.getInteger(COMBO_SELECTION_KEY);
        if (n == null || n < 0) {
            n = 0;
        }
        this.mBuildTermsCombo.setSelectedIndex(n);
        super.loadTabState(dialogDataModel, nameLabelOption);
        this.setObjectsEnable(this.mCustomRadio.isSelected());
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.setupPanel();
        this.setFocusTraversalPolicy();
    }

    @Override
    protected void aboutToShowTab() {
        this.mFactorsVarList.setShowVarLabels(false, false);
        Component component = ((PartialLeastSquaresDlg)((Object)this.getTopLevelAncestor())).getGlassPane();
        if (component instanceof DragPane) {
            DragPane dragPane = (DragPane)component;
            dragPane.getDropListeners().removeAllElements();
            this.addDragAdapters(dragPane, this.mModelTermsVarList);
            dragPane.addDropListener((IDropListener)new TermsListDropListener(this.mModelTermsVarList, this.mArrowButton));
            dragPane.addDropListener((IDropListener)new RemoveModelsDropListener(this.mFactorsVarList));
        }
        this.setFocusTraversalPolicy();
        this.loadFactorsList();
        this.setObjectsEnable(this.mCustomRadio.isSelected());
    }

    private void addDragAdapters(DragPane dragPane, Component component) {
        block11: {
            block10: {
                int n;
                if (!(component instanceof JList)) break block10;
                JList jList = (JList)component;
                MouseListener[] mouseListenerArray = jList.getMouseListeners();
                MouseMotionListener[] mouseMotionListenerArray = jList.getMouseMotionListeners();
                ComponentDragAdapter componentDragAdapter = null;
                if (jList instanceof VariableList) {
                    componentDragAdapter = new ListDragAdapter(jList, dragPane, "VariableList");
                } else if (jList instanceof ModelTermsList) {
                    componentDragAdapter = new TermsListDragAdapter((ModelTermsList)jList, dragPane, "TermsList");
                }
                int n2 = -1;
                for (n = 0; n < mouseListenerArray.length; ++n) {
                    jList.removeMouseListener(mouseListenerArray[n]);
                    if (!mouseListenerArray[n].getClass().getSimpleName().equals("ListDragGestureRecognizer")) continue;
                    n2 = n;
                }
                for (n = 0; n < mouseListenerArray.length; ++n) {
                    if (n == n2) {
                        jList.addMouseListener((MouseListener)componentDragAdapter);
                        continue;
                    }
                    if (mouseListenerArray[n] instanceof ListDragAdapter) continue;
                    jList.addMouseListener(mouseListenerArray[n]);
                }
                n2 = -1;
                for (n = 0; n < mouseMotionListenerArray.length; ++n) {
                    jList.removeMouseMotionListener(mouseMotionListenerArray[n]);
                    if (!mouseMotionListenerArray[n].getClass().getSimpleName().equals("ListDragGestureRecognizer")) continue;
                    n2 = n;
                }
                for (n = 0; n < mouseMotionListenerArray.length; ++n) {
                    if (n == n2) {
                        jList.addMouseMotionListener((MouseMotionListener)componentDragAdapter);
                        continue;
                    }
                    if (mouseMotionListenerArray[n] instanceof ListDragAdapter) continue;
                    jList.addMouseMotionListener(mouseMotionListenerArray[n]);
                }
                break block11;
            }
            if (!(component instanceof Container)) break block11;
            Container container = (Container)component;
            for (Component component2 : container.getComponents()) {
                this.addDragAdapters(dragPane, component2);
            }
        }
    }

    protected void generateSyntax(StringBuffer stringBuffer) {
        if (this.mCustomRadio.isSelected() && this.mModelTermsVarList.getModel().getSize() > 0) {
            stringBuffer.append("\n  /MODEL ");
            for (int i = 0; i < this.mModelTermsVarList.getModel().getSize(); ++i) {
                stringBuffer.append(this.mModelTermsVarList.getModel().getElementAt(i));
                stringBuffer.append(" ");
            }
        }
    }

    private void setDefaults() {
        this.mMainEffectsRadio.setSelected(true);
        this.mCustomRadio.setSelected(false);
        this.setObjectsEnable(false);
        this.mBuildTermsCombo.setSelectedIndex(1);
        ((DefaultListModel)this.mModelTermsVarList.getModel()).removeAllElements();
    }

    private void setupPanel() {
        this.mMainEffectsRadio = new JRadioButton(this.createToggleButtonAction(this.getResString("IDS_PARTIAL_LEAST_SQUARES_MODELTAB_MAIN_EFFECTS_RADIO")));
        this.mMainEffectsRadio.setText(this.getResString("IDS_PARTIAL_LEAST_SQUARES_MODELTAB_MAIN_EFFECTS_RADIO"));
        this.mMainEffectsRadio.setMnemonic(this.getDlgAccessKey("IDK_PARTIAL_LEAST_SQUARES_MODELTAB_MAIN_EFFECTS_RADIO_KEY"));
        this.mCustomRadio = new JRadioButton(this.createToggleButtonAction(this.getResString("IDS_PARTIAL_LEAST_SQUARES_MODELTAB_CUSTOM_RADIO")));
        this.mCustomRadio.setText(this.getResString("IDS_PARTIAL_LEAST_SQUARES_MODELTAB_CUSTOM_RADIO"));
        this.mCustomRadio.setMnemonic(this.getDlgAccessKey("IDK_PARTIAL_LEAST_SQUARES_MODELTAB_CUSTOM_RADIO_KEY"));
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mMainEffectsRadio);
        spssButtonGroup.add(this.mCustomRadio);
        this.mFactorsVarList = new TargetVariableList();
        this.mFactorsVarList.setIdentifier(FACTORS_COVARIATES_LIST_IDENTIFIER_KEY);
        this.mFactorsVarLabel = DialogUtil.createLabel(this.mParent, "IDS_PARTIAL_LEAST_SQUARES_MODELTAB_FACTORS_LIST_LABEL");
        this.mFactorsVarLabel.setLabelFor(this.mFactorsVarList);
        this.mFactorsVarScrollPane = new JScrollPane(this.mFactorsVarList);
        this.mTypeLabel = DialogUtil.createLabel(this.mParent, "IDS_PARTIAL_LEAST_SQUARES_MODELTAB_TYPE_COMBO_LABEL");
        this.mTypeLabel.setLabelFor(this.mBuildTermsCombo);
        String[] stringArray = new String[]{this.getResString("IDS_MODEL_INTERACTION"), this.getResString("IDS_MODEL_MAIN_EFFECTS"), this.getResString("IDS_MODEL_2_WAY"), this.getResString("IDS_MODEL_3_WAY"), this.getResString("IDS_MODEL_4_WAY"), this.getResString("IDS_MODEL_5_WAY")};
        this.mBuildTermsCombo = new JComboBox<String>(stringArray);
        this.mModelTermsVarList = new ModelTermsList("IDS_PARTIAL_LEAST_SQUARES_MODELTAB_MODEL_LIST_LABEL");
        this.mModelTermsVarList.setIdentifier(MODELS_LIST_IDENTIFIER_KEY);
        this.mModelTermsVarLabel = DialogUtil.createLabel(this.mParent, "IDS_PARTIAL_LEAST_SQUARES_MODELTAB_MODEL_LIST_LABEL");
        this.mModelTermsVarLabel.setLabelFor(this.mModelTermsVarList);
        this.mModelTermsVarScrollPane = new JScrollPane(this.mModelTermsVarList);
        this.mArrowButton = new ComponentsArrowButton();
        this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerComponents(this.mFactorsVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerComponents(this.mModelTermsVarList, SpssArrowButton.ButtonOrientation.left);
        this.mArrowButton.addActionListener(this);
        this.setLayout(new GridBagLayout());
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        Insets insets2 = (Insets)DialogUtil.getStandardDialogInsets().clone();
        Insets insets3 = new Insets(0, 0, 0, 0);
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = DialogUtil.getComponentGroupGap();
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PARTIAL_LEAST_SQUARES_MODELTAB_OUTER_GROUP_BOX")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n3 = 18;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n3, new Insets(insets2.top, 0, 0, 0));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mMainEffectsRadio, gridBagConstraints, 0, 0, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCustomRadio, gridBagConstraints, 0, 1, 1, 1, n3, insets);
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        gridBagConstraints.insets.left += 20;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n3, insets);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n3 = 18;
        DialogUtil.addUsingGBL(jPanel2, this.mFactorsVarLabel, gridBagConstraints, 0, 0, 1, 1, n3, insets3);
        this.mFactorsVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mFactorsVarList.getFixedCellHeight() * 7 + 2));
        this.mFactorsVarScrollPane.setPreferredSize(this.mFactorsVarList.getMinimumSize());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel2, this.mFactorsVarScrollPane, gridBagConstraints, 0, 1, 1, 1, n3, insets3);
        JPanel jPanel3 = new JPanel(new GridBagLayout(), true);
        jPanel3.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PARTIAL_LEAST_SQUARES_MODELTAB_BUILD_GROUP_BOX")));
        jPanel3.setMinimumSize(new Dimension(250, 250));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n3 = 11;
        gridBagConstraints.insets.left = n2;
        DialogUtil.addUsingGBL(jPanel2, jPanel3, gridBagConstraints, 1, 1, 1, 1, n3, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n3 = 18;
        DialogUtil.addUsingGBL(jPanel2, this.mModelTermsVarLabel, gridBagConstraints, 2, 0, 1, 1, n3, insets3);
        this.mModelTermsVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mModelTermsVarList.getFixedCellHeight() * 7 + 2));
        this.mModelTermsVarScrollPane.setPreferredSize(this.mModelTermsVarList.getMinimumSize());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = n2;
        gridBagConstraints.insets.right = n2;
        DialogUtil.addUsingGBL(jPanel2, this.mModelTermsVarScrollPane, gridBagConstraints, 2, 1, 1, 1, n3, insets3);
        gridBagConstraints = new GridBagConstraints();
        Insets insets4 = new Insets(n2, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel3, this.mTypeLabel, gridBagConstraints, 0, 0, 1, 1, n3, insets4);
        gridBagConstraints.insets.top = 0;
        DialogUtil.addUsingGBL(jPanel3, this.mBuildTermsCombo, gridBagConstraints, 0, 1, 1, 1, n3, insets4);
        n3 = 10;
        gridBagConstraints.insets.top = n;
        gridBagConstraints.insets.bottom = n2;
        DialogUtil.addUsingGBL(jPanel3, this.mArrowButton, gridBagConstraints, 0, 2, 1, 1, n3, insets4);
    }

    private ToggleButtonAction createToggleButtonAction(String string) {
        return new ToggleButtonAction(this.mParent, string){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof JRadioButton) {
                    boolean bl = ((JRadioButton)object).isSelected();
                    if (object == ModelTab.this.mMainEffectsRadio) {
                        ModelTab.this.setObjectsEnable(!bl);
                    } else if (object == ModelTab.this.mCustomRadio) {
                        ModelTab.this.setObjectsEnable(bl);
                    }
                }
            }
        };
    }

    private void setObjectsEnable(boolean bl) {
        this.mFactorsVarLabel.setEnabled(bl);
        this.mFactorsVarList.setEnabled(bl);
        this.mTypeLabel.setEnabled(bl);
        this.mBuildTermsCombo.setEnabled(bl);
        this.mArrowButton.setEnabled(bl);
        this.mModelTermsVarLabel.setEnabled(bl);
        this.mModelTermsVarList.setEnabled(bl);
    }

    private void setFocusTraversalPolicy() {
        this.mComponentOrder.add(this.mMainEffectsRadio);
        this.mComponentOrder.add(this.mCustomRadio);
        this.mComponentOrder.add(this.mFactorsVarList);
        this.mComponentOrder.add(this.mBuildTermsCombo);
        this.mComponentOrder.add(this.mArrowButton);
        this.mComponentOrder.add(this.mModelTermsVarList);
    }

    @Override
    protected boolean validateTab() {
        boolean bl = super.validateTab();
        if (this.mCustomRadio.isSelected() && this.mModelTermsVarList.getModel().getSize() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_PARTIAL_LEAST_SQUARES_MODELTAB_MODEL_EMPTY_ALERT"), VersionInfo.getAppVersionString());
            bl = false;
            this.mFactorsVarList.requestFocus();
        }
        return bl;
    }

    protected void loadFactorsList() {
        this.mFactorsVarList.getModel().removeAll();
        TargetVariableList targetVariableList = ((PartialLeastSquaresDlg)this.mParent).getVariablesTab().getIndependentVars();
        for (int i = 0; i < targetVariableList.getModel().getSize(); ++i) {
            MeasurementLevel measurementLevel = targetVariableList.getModel().getElementAt(i).getMeasurementLevel();
            if (measurementLevel == MeasurementLevel.nominal || measurementLevel == MeasurementLevel.ordinal) {
                this.mFactorsVarList.getModel().addElement((ISpssVariable)new SpssFactorVariable((SpssVariable)targetVariableList.getModel().getElementAt(i)));
                continue;
            }
            if (measurementLevel != MeasurementLevel.scale) continue;
            this.mFactorsVarList.getModel().addElement((ISpssVariable)new SpssCovariateVariable((SpssVariable)targetVariableList.getModel().getElementAt(i)));
        }
    }

    protected void pruneModelsList() {
        block0: for (int i = this.mModelTermsVarList.getModel().getSize() - 1; i > -1; --i) {
            String[] stringArray;
            for (String string : stringArray = ((String)this.mModelTermsVarList.getModel().getElementAt(i)).split("\\*")) {
                boolean bl = false;
                for (int j = 0; j < this.mFactorsVarList.getModel().getSize(); ++j) {
                    String string2 = this.mFactorsVarList.getModel().getElementAt(j).getName();
                    if (!string2.equals(string)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                DefaultListModel defaultListModel = (DefaultListModel)this.mModelTermsVarList.getModel();
                defaultListModel.removeElementAt(i);
                continue block0;
            }
        }
        if (this.mModelTermsVarList.getModel().getSize() < 1) {
            this.mMainEffectsRadio.setSelected(true);
            this.setObjectsEnable(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mArrowButton) {
            if (this.mArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.right) {
                int n;
                DefaultListModel defaultListModel = (DefaultListModel)this.mModelTermsVarList.getModel();
                ISpssVariable[] iSpssVariableArray = this.mFactorsVarList.getSelectedValues();
                if (iSpssVariableArray == null || iSpssVariableArray.length == 0) {
                    return;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                    arrayList.add(iSpssVariable.getName());
                }
                Vector vector = new Vector();
                for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                    vector.add(iSpssVariable.getName());
                }
                Object var7_9 = null;
                ArrayList<String> arrayList2 = new ArrayList<String>();
                int n2 = this.mBuildTermsCombo.getSelectedIndex();
                switch (n2) {
                    case 1: {
                        ISpssVariable[] iSpssVariableArray2 = iSpssVariableArray;
                        int n3 = iSpssVariableArray2.length;
                        for (n = 0; n < n3; ++n) {
                            ISpssVariable iSpssVariable = iSpssVariableArray2[n];
                            arrayList2.add(iSpssVariable.getName());
                        }
                        break;
                    }
                    case 0: {
                        void var10_22;
                        String string = "";
                        for (int i = 0; i < iSpssVariableArray.length; ++i) {
                            if (i == iSpssVariableArray.length - 1) {
                                String string2 = (String)var10_22 + iSpssVariableArray[i].getName();
                                continue;
                            }
                            String string3 = (String)var10_22 + iSpssVariableArray[i].getName() + "*";
                        }
                        if (iSpssVariableArray.length <= 0) break;
                        arrayList2.add((String)var10_22);
                        break;
                    }
                    case 2: {
                        String string;
                        String[] stringArray;
                        String[] stringArray2 = stringArray = this.get2WayItems(arrayList);
                        n = stringArray2.length;
                        for (int i = 0; i < n; ++i) {
                            string = stringArray2[i];
                            arrayList2.add(string);
                        }
                        break;
                    }
                    case 3: {
                        String[] stringArray;
                        String string;
                        String[] stringArray3 = stringArray = this.get3WayItems(arrayList);
                        n = stringArray3.length;
                        for (int i = 0; i < n; ++i) {
                            string = stringArray3[i];
                            arrayList2.add(string);
                        }
                        break;
                    }
                    case 4: {
                        String[] stringArray;
                        String string;
                        String[] stringArray4 = stringArray = this.get4WayItems(arrayList);
                        n = stringArray4.length;
                        for (int i = 0; i < n; ++i) {
                            string = stringArray4[i];
                            arrayList2.add(string);
                        }
                        break;
                    }
                    case 5: {
                        String[] stringArray;
                        String string;
                        String[] stringArray5 = stringArray = this.get5WayItems(arrayList);
                        n = stringArray5.length;
                        for (int i = 0; i < n; ++i) {
                            string = stringArray5[i];
                            arrayList2.add(string);
                        }
                        break;
                    }
                }
                int n4 = arrayList2.size();
                this.filterUniqueItems(arrayList2, defaultListModel);
                if (arrayList2.size() == 0) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_MODEL_DUPLICATE_MSG1"), VersionInfo.getAppVersionString());
                    this.mFactorsVarList.requestFocus();
                    return;
                }
                if (arrayList2.size() < n4) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_MODEL_DUPLICATE_MSG2"), VersionInfo.getAppVersionString());
                }
                Object object2 = arrayList2.iterator();
                while (object2.hasNext()) {
                    defaultListModel.addElement(object2.next());
                }
                object2 = new int[arrayList2.size()];
                for (n = 0; n < arrayList2.size(); ++n) {
                    int n5 = defaultListModel.indexOf(arrayList2.get(n));
                    if (n5 <= -1) continue;
                    object2[n] = n5;
                }
                this.mFactorsVarList.clearSelection();
                this.mModelTermsVarList.setSelectedIndices((int[])object2);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ModelTab.this.mModelTermsVarList.requestFocus();
                    }
                });
            } else if (this.mArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.left) {
                this.removeSelectedModelItems();
            }
        }
    }

    private void removeSelectedModelItems() {
        String[] stringArray;
        DefaultListModel defaultListModel = (DefaultListModel)this.mModelTermsVarList.getModel();
        for (String string : stringArray = this.mModelTermsVarList.getSelectedValues()) {
            defaultListModel.removeElement(string);
        }
        if (defaultListModel.size() > 0) {
            this.mModelTermsVarList.setSelectedIndex(0);
            this.mModelTermsVarList.requestFocus();
        } else {
            this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        }
    }

    protected String[] get2WayItems(ArrayList<String> arrayList) {
        String[] stringArray;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = arrayList.size();
        if (n < 2) {
            stringArray = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                if (i == 0) {
                    stringArray.append(arrayList.get(i));
                    continue;
                }
                stringArray.append("*").append(arrayList.get(i));
            }
            arrayList2.add(stringArray.toString());
        } else {
            for (int i = 0; i < n; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(arrayList.get(i)).append("*");
                    stringBuffer.append(arrayList.get(j));
                    arrayList2.add(stringBuffer.toString());
                }
            }
        }
        stringArray = new String[arrayList2.size()];
        arrayList2.toArray(stringArray);
        return stringArray;
    }

    protected String[] get3WayItems(ArrayList<String> arrayList) {
        String[] stringArray;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = arrayList.size();
        if (n < 3) {
            stringArray = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                if (i == 0) {
                    stringArray.append(arrayList.get(i));
                    continue;
                }
                stringArray.append("*").append(arrayList.get(i));
            }
            arrayList2.add(stringArray.toString());
        } else {
            for (int i = 0; i < n; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    for (int k = j + 1; k < n; ++k) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(arrayList.get(i)).append("*");
                        stringBuffer.append(arrayList.get(j)).append("*");
                        stringBuffer.append(arrayList.get(k));
                        arrayList2.add(stringBuffer.toString());
                    }
                }
            }
        }
        stringArray = new String[arrayList2.size()];
        arrayList2.toArray(stringArray);
        return stringArray;
    }

    protected String[] get4WayItems(ArrayList<String> arrayList) {
        String[] stringArray;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = arrayList.size();
        if (n < 4) {
            stringArray = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                if (i == 0) {
                    stringArray.append(arrayList.get(i));
                    continue;
                }
                stringArray.append("*").append(arrayList.get(i));
            }
            arrayList2.add(stringArray.toString());
        } else {
            for (int i = 0; i < n; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    for (int k = j + 1; k < n; ++k) {
                        for (int i2 = k + 1; i2 < n; ++i2) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(arrayList.get(i)).append("*");
                            stringBuffer.append(arrayList.get(j)).append("*");
                            stringBuffer.append(arrayList.get(k)).append("*");
                            stringBuffer.append(arrayList.get(i2));
                            arrayList2.add(stringBuffer.toString());
                        }
                    }
                }
            }
        }
        stringArray = new String[arrayList2.size()];
        arrayList2.toArray(stringArray);
        return stringArray;
    }

    protected String[] get5WayItems(ArrayList<String> arrayList) {
        String[] stringArray;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = arrayList.size();
        if (n < 5) {
            stringArray = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                if (i == 0) {
                    stringArray.append(arrayList.get(i));
                    continue;
                }
                stringArray.append("*").append(arrayList.get(i));
            }
            arrayList2.add(stringArray.toString());
        } else {
            for (int i = 0; i < n; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    for (int k = j + 1; k < n; ++k) {
                        for (int i2 = k + 1; i2 < n; ++i2) {
                            for (int i3 = i2 + 1; i3 < n; ++i3) {
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append(arrayList.get(i)).append("*");
                                stringBuffer.append(arrayList.get(j)).append("*");
                                stringBuffer.append(arrayList.get(k)).append("*");
                                stringBuffer.append(arrayList.get(i2)).append("*");
                                stringBuffer.append(arrayList.get(i3));
                                arrayList2.add(stringBuffer.toString());
                            }
                        }
                    }
                }
            }
        }
        stringArray = new String[arrayList2.size()];
        arrayList2.toArray(stringArray);
        return stringArray;
    }

    protected void filterUniqueItems(ArrayList<String> arrayList, DefaultListModel defaultListModel) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        if (arrayList.get(0).contains("(") || arrayList.get(0).contains("*")) {
            StringTokenizer stringTokenizer = new StringTokenizer(arrayList.get(0), "*()");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken().toString();
                arrayList4.add(string);
            }
        }
        int n = defaultListModel.getSize();
        for (int i = 0; i < n; ++i) {
            String string = (String)defaultListModel.getElementAt(i);
            arrayList2.add(string);
            arrayList3.clear();
            if (string.contains("(") || string.contains("*")) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.mModelTermsVarList.getModel().getElementAt(i).toString(), "*()");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken().toString();
                    arrayList3.add(string2);
                }
            }
            Collections.sort(arrayList4);
            Collections.sort(arrayList3);
            if (arrayList3.size() > 0 && arrayList4.size() > 0 && arrayList3.size() == arrayList4.size() && arrayList3.containsAll(arrayList4)) {
                arrayList.remove(0);
                continue;
            }
            if (arrayList3.size() != 0 || arrayList4.size() != 0) continue;
            arrayList.removeAll(arrayList2);
        }
    }

    private class RemoveModelsDropListener
    extends VarListDropListener {
        public RemoveModelsDropListener(VariableList variableList) {
            super(variableList);
            this.mDropTarget = variableList;
        }

        @Override
        public void itemDropped(DropEvent dropEvent) {
            if (dropEvent.getSource() instanceof ModelTermsList && !this.overSourceList(dropEvent.getDropLocation())) {
                ModelTab.this.removeSelectedModelItems();
            }
        }

        private boolean overSourceList(Point point) {
            Container container;
            for (container = this.mDropTarget.getParent(); container != null && !(container instanceof JDialog); container = container.getParent()) {
            }
            if (container != null) {
                Point point2 = (Point)point.clone();
                SwingUtilities.convertPointFromScreen(point2, container);
                Component component = container.findComponentAt(point2);
                return component instanceof ModelTermsList;
            }
            return false;
        }

        @Override
        public Cursor dragItemOver(Point point, DragDropAdapter dragDropAdapter) {
            Cursor cursor = null;
            Point point2 = (Point)point.clone();
            SwingUtilities.convertPointFromScreen(point2, this.mDropTarget);
            boolean bl = true;
            bl = this.overSourceList(point);
            cursor = Cursor.getPredefinedCursor(12);
            this.mDropTarget.getFocusHighlighter().setHighlightBorder(bl);
            if (this.mCanImport) {
                this.checkAutoScroll(point2);
            }
            return cursor;
        }
    }
}

