/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.regression.partial_least_squares;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DatasetNameValidator;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ExportTab
extends BaseProcedureTab {
    private static final String INDIVIDUAL_DATASET_KEY = "individualDataset";
    private static final String LATENT_DATASET_KEY = "latentDataset";
    private static final String INDEPENDENT_DATASET_KEY = "independentDataset";
    private JCheckBox mIndividualCheck;
    private JLabel mIndividualLabel;
    private JTextField mIndividualText;
    private JCheckBox mLatentFactorsCheck;
    private JLabel mLatentFactorsLabel;
    private JTextField mLatentFactorsText;
    private JCheckBox mIndependentVarsCheck;
    private JLabel mIndependentVarsLabel;
    private JTextField mIndependentVarsText;

    public ExportTab(BaseDialog baseDialog, boolean bl) {
        super(baseDialog, bl);
        this.reset();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_pls_export";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        super.saveTabState(dialogDataModel);
        dialogDataModel.putString(INDIVIDUAL_DATASET_KEY, this.mIndividualText.getText());
        dialogDataModel.putString(LATENT_DATASET_KEY, this.mLatentFactorsText.getText());
        dialogDataModel.putString(INDEPENDENT_DATASET_KEY, this.mIndependentVarsText.getText());
    }

    @Override
    protected void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        super.loadTabState(dialogDataModel, nameLabelOption);
        this.mIndividualText.setText(dialogDataModel.getString(INDIVIDUAL_DATASET_KEY));
        if (this.mIndividualText.getText().trim().length() > 0) {
            this.mIndividualText.setEnabled(true);
        }
        this.mLatentFactorsText.setText(dialogDataModel.getString(LATENT_DATASET_KEY));
        if (this.mLatentFactorsText.getText().trim().length() > 0) {
            this.mLatentFactorsText.setEnabled(true);
        }
        this.mIndependentVarsText.setText(dialogDataModel.getString(INDEPENDENT_DATASET_KEY));
        if (this.mIndependentVarsText.getText().trim().length() > 0) {
            this.mIndependentVarsText.setEnabled(true);
        }
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.setupPanel();
        this.setFocusTraversalPolicy();
    }

    protected void generateSyntax(StringBuffer stringBuffer) {
        if (this.mIndividualCheck.isSelected() || this.mLatentFactorsCheck.isSelected() || this.mIndependentVarsCheck.isSelected()) {
            stringBuffer.append("\n  /OUTDATASET");
            if (this.mIndividualCheck.isSelected()) {
                stringBuffer.append(" CASES=" + this.getIndividualDatasetName(false));
            }
            if (this.mLatentFactorsCheck.isSelected()) {
                stringBuffer.append(" LATENTFACTORS=" + this.getLatentDatasetName(false));
            }
            if (this.mIndependentVarsCheck.isSelected()) {
                stringBuffer.append(" PREDICTORS=" + this.getIndependentDatasetName(false));
            }
        }
    }

    private void setDefaults() {
        this.mIndividualCheck.setSelected(false);
        this.mIndividualLabel.setEnabled(false);
        this.mIndividualText.setEnabled(false);
        this.mIndividualText.setText("");
        this.mLatentFactorsCheck.setSelected(false);
        this.mLatentFactorsLabel.setEnabled(false);
        this.mLatentFactorsText.setEnabled(false);
        this.mLatentFactorsText.setText("");
        this.mIndependentVarsCheck.setSelected(false);
        this.mIndependentVarsLabel.setEnabled(false);
        this.mIndependentVarsText.setEnabled(false);
        this.mIndependentVarsText.setText("");
    }

    private void setupPanel() {
        this.mIndividualCheck = new JCheckBox(this.createToggleButtonAction("IDS_PARTIAL_LEAST_SQUARES_EXPORTTAB_INDIVID_CASES_CHECK_BOX"));
        this.mIndividualCheck.setText(this.getResString("IDS_PARTIAL_LEAST_SQUARES_EXPORTTAB_INDIVID_CASES_CHECK_BOX"));
        this.mIndividualCheck.setMnemonic(this.getDlgAccessKey("IDS_PARTIAL_LEAST_SQUARES_EXPORTTAB_INDIVID_CASES_CHECK_BOX_KEY"));
        this.mIndividualLabel = new JLabel(this.getResString("IDS_PARTIAL_LEAST_SQUARES_EXPORTTAB_DATASET_NAME_LABEL"));
        this.mIndividualLabel.setDisplayedMnemonic(this.getDlgAccessKey("IDS_PARTIAL_LEAST_SQUARES_EXPORTTAB_INDIVID_CASES_DATASET_KEY"));
        this.mIndividualLabel.setLabelFor(this.mIndividualText);
        this.mIndividualText = new JTextField();
        this.mIndividualText.setColumns(10);
        this.mLatentFactorsCheck = new JCheckBox(this.createToggleButtonAction("IDS_PARTIAL_LEAST_SQUARES_EXPORTTAB_LATENT_CHECK_BOX"));
        this.mLatentFactorsCheck.setText(this.getResString("IDS_PARTIAL_LEAST_SQUARES_EXPORTTAB_LATENT_CHECK_BOX"));
        this.mLatentFactorsCheck.setMnemonic(this.getDlgAccessKey("IDS_PARTIAL_LEAST_SQUARES_EXPORTTAB_LATENT_CHECK_BOX_KEY"));
        this.mLatentFactorsLabel = new JLabel(this.getResString("IDS_PARTIAL_LEAST_SQUARES_EXPORTTAB_DATASET_NAME_LABEL"));
        this.mLatentFactorsLabel.setDisplayedMnemonic(this.getDlgAccessKey("IDS_PARTIAL_LEAST_SQUARES_EXPORTTAB_LATENT_DATASET_KEY"));
        this.mLatentFactorsLabel.setLabelFor(this.mLatentFactorsText);
        this.mLatentFactorsText = new JTextField();
        this.mLatentFactorsText.setColumns(10);
        this.mIndependentVarsCheck = new JCheckBox(this.createToggleButtonAction("IDS_PARTIAL_LEAST_SQUARES_EXPORTTAB_INDEPENDENT_VARS_CHECK_BOX"));
        this.mIndependentVarsCheck.setText(this.getResString("IDS_PARTIAL_LEAST_SQUARES_EXPORTTAB_INDEPENDENT_VARS_CHECK_BOX"));
        this.mIndependentVarsCheck.setMnemonic(this.getDlgAccessKey("IDS_PARTIAL_LEAST_SQUARES_EXPORTTAB_INDEPENDENT_VARS_CHECK_BOX_KEY"));
        this.mIndependentVarsLabel = new JLabel(this.getResString("IDS_PARTIAL_LEAST_SQUARES_EXPORTTAB_DATASET_NAME_LABEL"));
        this.mIndependentVarsLabel.setDisplayedMnemonic(this.getDlgAccessKey("IDS_PARTIAL_LEAST_SQUARES_EXPORTTAB_INDEPENDENT_VARS_DATASET_KEY"));
        this.mIndependentVarsLabel.setLabelFor(this.mIndependentVarsText);
        this.mIndependentVarsText = new JTextField();
        this.mIndependentVarsText.setColumns(10);
        this.setLayout(new GridBagLayout());
        Insets insets = (Insets)DialogUtil.getStandardDialogInsets().clone();
        Insets insets2 = new Insets(0, 0, 0, 0);
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = DialogUtil.getComponentGroupGap();
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PARTIAL_LEAST_SQUARES_EXPORTTAB_OUTER_GROUP_BOX")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n3 = 18;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n3, new Insets(insets.top, 0, 0, 0));
        Insets insets3 = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets3.top = insets.top;
        Insets insets4 = new Insets(0, 40, 0, 0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mIndividualCheck, gridBagConstraints, 0, 0, 1, 1, n3, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mIndividualLabel, gridBagConstraints, 0, 1, 1, 1, n3, insets4);
        DialogUtil.addUsingGBL(jPanel, this.mIndividualText, gridBagConstraints, 0, 2, 1, 1, n3, insets4);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets3.top += insets.top * 2;
        DialogUtil.addUsingGBL(jPanel, this.mLatentFactorsCheck, gridBagConstraints, 0, 3, 1, 1, n3, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mLatentFactorsLabel, gridBagConstraints, 0, 4, 1, 1, n3, insets4);
        DialogUtil.addUsingGBL(jPanel, this.mLatentFactorsText, gridBagConstraints, 0, 5, 1, 1, n3, insets4);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mIndependentVarsCheck, gridBagConstraints, 0, 6, 1, 1, n3, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mIndependentVarsLabel, gridBagConstraints, 0, 7, 1, 1, n3, insets4);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mIndependentVarsText, gridBagConstraints, 0, 8, 1, 1, n3, insets4);
    }

    private ToggleButtonAction createToggleButtonAction(String string) {
        return new ToggleButtonAction(this.mParent, string){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof JCheckBox) {
                    boolean bl = ((JCheckBox)object).isSelected();
                    if (object == ExportTab.this.mIndividualCheck) {
                        ExportTab.this.mIndividualLabel.setEnabled(bl);
                        ExportTab.this.mIndividualText.setEnabled(bl);
                    } else if (object == ExportTab.this.mLatentFactorsCheck) {
                        ExportTab.this.mLatentFactorsLabel.setEnabled(bl);
                        ExportTab.this.mLatentFactorsText.setEnabled(bl);
                    } else if (object == ExportTab.this.mIndependentVarsCheck) {
                        ExportTab.this.mIndependentVarsLabel.setEnabled(bl);
                        ExportTab.this.mIndependentVarsText.setEnabled(bl);
                    }
                }
            }
        };
    }

    private void setFocusTraversalPolicy() {
        this.mComponentOrder.add(this.mIndividualCheck);
        this.mComponentOrder.add(this.mIndividualText);
        this.mComponentOrder.add(this.mLatentFactorsCheck);
        this.mComponentOrder.add(this.mLatentFactorsText);
        this.mComponentOrder.add(this.mIndependentVarsCheck);
        this.mComponentOrder.add(this.mIndependentVarsText);
    }

    @Override
    protected boolean validateTab() {
        boolean bl = super.validateTab();
        if (bl && this.mIndividualCheck.isSelected()) {
            if (this.mIndividualText.getText().trim().length() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("IDS_PARTIAL_LEAST_SQUARES_EXPORTTAB_DATASET_NAME_MISSING_ALERT"), VersionInfo.getAppVersionString());
                bl = false;
            } else if (DatasetNameValidator.validateDatasetName((String)this.mIndividualText.getText(), (Component)this) == 0) {
                bl = false;
            }
            if (!bl) {
                this.mIndividualText.requestFocus();
            }
        }
        if (bl && this.mLatentFactorsCheck.isSelected()) {
            if (this.mLatentFactorsText.getText().trim().length() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("IDS_PARTIAL_LEAST_SQUARES_EXPORTTAB_DATASET_NAME_MISSING_ALERT"), VersionInfo.getAppVersionString());
                bl = false;
            } else if (DatasetNameValidator.validateDatasetName((String)this.mLatentFactorsText.getText(), (Component)this) == 0) {
                bl = false;
            } else if (this.mIndividualCheck.isSelected() && this.mLatentFactorsText.getText().trim().toUpperCase().equals(this.mIndividualText.getText().trim().toUpperCase())) {
                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("IDS_PARTIAL_LEAST_SQUARES_EXPORTTAB_DATASET_NAME_NOT_UNIQE_ALERT"), VersionInfo.getAppVersionString());
                bl = false;
            }
            if (!bl) {
                this.mLatentFactorsText.requestFocus();
            }
        }
        if (bl && this.mIndependentVarsCheck.isSelected()) {
            if (this.mIndependentVarsText.getText().trim().length() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("IDS_PARTIAL_LEAST_SQUARES_EXPORTTAB_DATASET_NAME_MISSING_ALERT"), VersionInfo.getAppVersionString());
                bl = false;
            } else if (DatasetNameValidator.validateDatasetName((String)this.mIndependentVarsText.getText(), (Component)this) == 0) {
                bl = false;
            } else if (this.mIndividualCheck.isSelected() && this.mIndependentVarsText.getText().trim().toUpperCase().equals(this.mIndividualText.getText().trim().toUpperCase()) || this.mLatentFactorsCheck.isSelected() && this.mIndependentVarsText.getText().trim().toUpperCase().equals(this.mLatentFactorsText.getText().trim().toUpperCase())) {
                SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("IDS_PARTIAL_LEAST_SQUARES_EXPORTTAB_DATASET_NAME_NOT_UNIQE_ALERT"), VersionInfo.getAppVersionString());
                bl = false;
            }
            if (!bl) {
                this.mIndependentVarsText.requestFocus();
            }
        }
        return bl;
    }

    protected boolean isIndividualChecked() {
        return this.mIndividualCheck.isSelected();
    }

    protected boolean isLatentChecked() {
        return this.mLatentFactorsCheck.isSelected();
    }

    protected boolean isIndependentChecked() {
        return this.mIndependentVarsCheck.isSelected();
    }

    protected String getIndividualDatasetName(boolean bl) {
        if (bl) {
            return CharacterUtil.smartQuote((String)this.mIndividualText.getText().trim());
        }
        return this.mIndividualText.getText().trim();
    }

    protected String getLatentDatasetName(boolean bl) {
        if (bl) {
            return CharacterUtil.smartQuote((String)this.mLatentFactorsText.getText().trim());
        }
        return this.mLatentFactorsText.getText().trim();
    }

    protected String getIndependentDatasetName(boolean bl) {
        if (bl) {
            return CharacterUtil.smartQuote((String)this.mIndependentVarsText.getText().trim());
        }
        return this.mIndependentVarsText.getText().trim();
    }
}

