/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.regression.ordinal_regression;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.dialogs.base.analyze.regression.ordinal_regression.OrdinalRegressionDlg;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.text.DecimalFormatSymbols;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class OrdinalRegressionOptions
extends BaseSubDialog
implements DocumentListener {
    protected static final String MAX_ITERS_TEXT_KEY = "IDS_REGRESSION_ORDINAL_OPTIONS_MAX_ITERATION_TEXT";
    protected static final String MAX_STEP_HALV_TEXT_KEY = "IDS_REGRESSION_ORDINAL_OPTIONS_MAX_STEP_HALV_TEXT";
    protected static final String MAX_CONF_INTERVAL_TEXT_KEY = "IDS_REGRESSION_ORDINAL_OPTIONS_CONFIDENCE";
    protected static final String MAX_DELTA_TEXT_KEY = "IDS_REGRESSION_ORDINAL_OPTIONS_DELTA";
    protected static final String SING_TOLERANCE_COMBO_KEY = "IDS_REGRESSION_ORDINAL_OPTIONS_SINGULARITY_TOLERANCE";
    protected static final String LOG_LIKELIHOOD_COMBO_KEY = "IDS_REGRESSION_ORDINAL_OPTIONS_LOG_LIKELIHOOD_CONVERGENCE";
    protected static final String LINK_COMBO_KEY = "IDS_REGRESSION_ORDINAL_OPTIONS_LINK";
    protected static final String PARAM_CONV_COMBO_KEY = "IDS_REGRESSION_ORDINAL_OPTIONS_PARAMETER_CONVERGENCE";
    protected static final String CIN_DEFAULT = "95";
    protected static final String DELTA_DEFAULT = "0";
    protected static final String LCONVERGE_COMBO_DEFAULT = "0";
    protected static final String MXITER_DEFAULT = "100";
    protected static final String MXSTEP_DEFAULT = "5";
    protected static final String PCONVERGE_COMBO_DEFAULT = "1.0E-6";
    protected static final String SINGULAR_COMBO_DEFAULT = "1.0E-8";
    protected static final String LINK_COMBO_DEFAULT = "LOGIT";
    protected static final String ORDINAL_REGRESSION_OPTIONS_HELP_KEY = "idh_plum_opt";
    private static final float MAX_CIN_VALUE = 100.0f;
    private static final String POINT = ".";
    private static final int MIN_STEP_VALUE = 0;
    private static final int MAX_DELTA_VALUE = 1;
    private JComboBox mLikelihoodValueCombo;
    private JComboBox mParameterValueCombo;
    private JComboBox mSingToleranceCombo;
    private JComboBox mLinkCombo;
    private IntTextField mMaxItersText;
    private IntTextField mMaxStepHalvText;
    private FloatTextField mConfIntervalText;
    private FloatTextField mDeltaText;
    private Vector<Object> mTabOrder;

    public OrdinalRegressionOptions(OrdinalRegressionDlg ordinalRegressionDlg) {
        super(ordinalRegressionDlg, ordinalRegressionDlg.getResString("IDS_REGRESSION_ORDINAL_OPTIONS_TITLE"), true);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public String getDialogHelpID() {
        return ORDINAL_REGRESSION_OPTIONS_HELP_KEY;
    }

    @Override
    public boolean continuePressed() {
        if (this.mConfIntervalText.getText().equals(POINT)) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_REGRESSION_ORDINAL_OPTIONS_CONF_WARNING_TWO"), VersionInfo.getAppVersionString());
            this.mConfIntervalText.requestFocus();
            return false;
        }
        if (Float.parseFloat(this.mConfIntervalText.getText()) >= 100.0f) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_REGRESSION_ORDINAL_OPTIONS_CONF_WARNING_ONE"), VersionInfo.getAppVersionString());
            this.mConfIntervalText.requestFocus();
            return false;
        }
        if (Float.parseFloat(this.mDeltaText.getText()) >= 1.0f) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_REGRESSION_ORDINAL_OPTIONS_DELTA_WARNING"), VersionInfo.getAppVersionString());
            this.mDeltaText.requestFocus();
            return false;
        }
        if (Integer.parseInt(this.mMaxStepHalvText.getText()) == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_REGRESSION_ORDINAL_GREATER_THAN_ZERO_WARNING"), VersionInfo.getAppVersionString());
            this.mMaxStepHalvText.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        boolean bl = super.saveState(dialogDataModel);
        if (bl) {
            dialogDataModel.putString(LOG_LIKELIHOOD_COMBO_KEY, (String)this.mLikelihoodValueCombo.getSelectedItem());
            dialogDataModel.putString(PARAM_CONV_COMBO_KEY, (String)this.mParameterValueCombo.getSelectedItem());
            dialogDataModel.putString(SING_TOLERANCE_COMBO_KEY, (String)this.mSingToleranceCombo.getSelectedItem());
            dialogDataModel.putString(LINK_COMBO_KEY, (String)this.mLinkCombo.getSelectedItem());
        }
        return bl;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.setTabPolicy();
        this.pack();
    }

    private void initVars() {
        this.mMaxItersText = new IntTextField();
        this.mMaxItersText.setAction((Action)new TextFieldAction(this.mParentDlg, MAX_ITERS_TEXT_KEY));
        this.mMaxItersText.setPreferredSize((Dimension)this.mMaxItersText.getPreferredSize().clone());
        this.mMaxItersText.setDocument((Document)new FixedLengthNumericDocument(8, true, false));
        this.mMaxItersText.setColumns(6);
        this.mMaxItersText.getDocument().addDocumentListener(this);
        this.mMaxStepHalvText = new IntTextField();
        this.mMaxStepHalvText.setAction((Action)new TextFieldAction(this.mParentDlg, MAX_STEP_HALV_TEXT_KEY));
        this.mMaxStepHalvText.setPreferredSize((Dimension)this.mMaxStepHalvText.getPreferredSize().clone());
        this.mMaxStepHalvText.setDocument((Document)new FixedLengthNumericDocument(8, true, false));
        this.mMaxStepHalvText.setColumns(6);
        this.mMaxStepHalvText.getDocument().addDocumentListener(this);
        this.mConfIntervalText = new FloatTextField();
        this.mConfIntervalText.setAction((Action)new TextFieldAction(this.mParentDlg, MAX_CONF_INTERVAL_TEXT_KEY));
        this.mConfIntervalText.setPreferredSize((Dimension)this.mConfIntervalText.getPreferredSize().clone());
        this.mConfIntervalText.setDocument((Document)new FixedLengthNumericDocument(8, true, true));
        this.mConfIntervalText.setColumns(6);
        this.mConfIntervalText.getDocument().addDocumentListener(this);
        this.mDeltaText = new FloatTextField();
        this.mDeltaText.setAction((Action)new TextFieldAction(this.mParentDlg, MAX_DELTA_TEXT_KEY));
        this.mDeltaText.setPreferredSize((Dimension)this.mConfIntervalText.getPreferredSize().clone());
        this.mDeltaText.setDocument((Document)new FixedLengthNumericDocument(8, true, true));
        this.mDeltaText.getDocument().addDocumentListener(this);
        this.mDeltaText.setColumns(6);
        ComboboxAction comboboxAction = new ComboboxAction(this.mParentDlg, SING_TOLERANCE_COMBO_KEY);
        String[] stringArray = new String[]{"0.00001", "0.000001", "0.0000001", "0.00000001", "0.000000001", "0.0000000001"};
        Vector<String> vector = new Vector<String>();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(UIToolResUtil.getSPSSLocale());
        String string = null;
        Object object = stringArray;
        int n = ((String[])object).length;
        for (int i = 0; i < n; ++i) {
            String string2;
            string = string2 = object[i];
            if (decimalFormatSymbols.getDecimalSeparator() != '.') {
                string = string2.replace('.', decimalFormatSymbols.getDecimalSeparator());
            }
            vector.add(string);
        }
        this.mSingToleranceCombo = new JComboBox(vector);
        this.mSingToleranceCombo.setAction(comboboxAction);
        this.mSingToleranceCombo.setEnabled(true);
        this.mSingToleranceCombo.setSelectedIndex(3);
        comboboxAction = new ComboboxAction(this.mParentDlg, LOG_LIKELIHOOD_COMBO_KEY);
        object = new Vector();
        String[] stringArray2 = new String[]{"0.1", "0.01", "0.001", "0.0001", "0.00001", "0"};
        string = null;
        String[] stringArray3 = stringArray2;
        int n2 = stringArray3.length;
        for (int i = 0; i < n2; ++i) {
            String string3;
            string = string3 = stringArray3[i];
            if (decimalFormatSymbols.getDecimalSeparator() != '.') {
                string = string3.replace('.', decimalFormatSymbols.getDecimalSeparator());
            }
            ((Vector)object).add(string);
        }
        this.mLikelihoodValueCombo = new JComboBox(object);
        this.mLikelihoodValueCombo.setAction(comboboxAction);
        this.mLikelihoodValueCombo.setEnabled(true);
        this.mLikelihoodValueCombo.setSelectedIndex(5);
        comboboxAction = new ComboboxAction(this.mParentDlg, PARAM_CONV_COMBO_KEY);
        stringArray3 = new String[]{"0.0001", "0.00001", "0.000001", "0.0000001", "0.00000001", "0"};
        Vector<String> vector2 = new Vector<String>();
        string = null;
        Object[] objectArray = stringArray3;
        int n3 = objectArray.length;
        for (int i = 0; i < n3; ++i) {
            String string4;
            string = string4 = objectArray[i];
            if (decimalFormatSymbols.getDecimalSeparator() != '.') {
                string = string4.replace('.', decimalFormatSymbols.getDecimalSeparator());
            }
            vector2.add(string);
        }
        this.mParameterValueCombo = new JComboBox(vector2);
        this.mParameterValueCombo.setAction(comboboxAction);
        this.mParameterValueCombo.setEnabled(true);
        this.mParameterValueCombo.setSelectedIndex(2);
        comboboxAction = new ComboboxAction(this.mParentDlg, LINK_COMBO_KEY);
        objectArray = new Object[]{this.getResString("IDS_REGRESSION_ORDINAL_OPTIONS_LINK_OPTION1"), this.getResString("IDS_REGRESSION_ORDINAL_OPTIONS_LINK_OPTION2"), this.getResString("IDS_REGRESSION_ORDINAL_OPTIONS_LINK_OPTION3"), this.getResString("IDS_REGRESSION_ORDINAL_OPTIONS_LINK_OPTION4"), this.getResString("IDS_REGRESSION_ORDINAL_OPTIONS_LINK_OPTION5")};
        this.mLinkCombo = new JComboBox<Object>(objectArray);
        this.mLinkCombo.setAction(comboboxAction);
        this.mLinkCombo.setEnabled(true);
        this.mLinkCombo.setSelectedItem(this.getResString("IDS_REGRESSION_ORDINAL_OPTIONS_LINK_OPTION3"));
        this.mTabOrder = new Vector();
    }

    private void setDefaults() {
        this.mMaxItersText.setText(MXITER_DEFAULT);
        this.mMaxStepHalvText.setText(MXSTEP_DEFAULT);
        this.mConfIntervalText.setText(CIN_DEFAULT);
        this.mDeltaText.setText("0");
    }

    private void setupViewPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(true);
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setupIerationPanel(), gridBagConstraints, 0, 0, 3, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setupConfidancePanel(), gridBagConstraints, 0, 1, 3, 1, n, insets);
    }

    private JPanel setupIerationPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_REGRESSION_ORDINAL_OPTIONS_ITERATIONS_BORDER")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardButtonInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        JLabel jLabel = DialogUtil.createLabel(this, MAX_ITERS_TEXT_KEY);
        jLabel.setLabelFor((Component)this.mMaxItersText);
        JLabel jLabel2 = DialogUtil.createLabel(this, MAX_STEP_HALV_TEXT_KEY);
        jLabel2.setLabelFor((Component)this.mMaxStepHalvText);
        JLabel jLabel3 = DialogUtil.createLabel(this, LOG_LIKELIHOOD_COMBO_KEY);
        jLabel3.setLabelFor(this.mLikelihoodValueCombo);
        JLabel jLabel4 = DialogUtil.createLabel(this, PARAM_CONV_COMBO_KEY);
        jLabel4.setLabelFor(this.mParameterValueCombo);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxItersText, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxStepHalvText, gridBagConstraints, 2, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 2, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mLikelihoodValueCombo, gridBagConstraints, 2, 2, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 0, 3, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mParameterValueCombo, gridBagConstraints, 2, 3, 2, 1, n, insets);
        return jPanel;
    }

    private JPanel setupConfidancePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, MAX_CONF_INTERVAL_TEXT_KEY);
        jLabel.setLabelFor((Component)this.mConfIntervalText);
        JLabel jLabel2 = new JLabel(this.getResString("IDS_REGRESSION_ORDINAL_OPTIONS_PERCENT"), 10);
        JLabel jLabel3 = DialogUtil.createLabel(this, MAX_DELTA_TEXT_KEY);
        jLabel3.setLabelFor((Component)this.mDeltaText);
        JLabel jLabel4 = DialogUtil.createLabel(this, SING_TOLERANCE_COMBO_KEY);
        jLabel4.setLabelFor(this.mSingToleranceCombo);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardButtonInsets();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 2, 1, n, new Insets(insets.top, insets.left, insets.bottom, n2 * 3));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mConfIntervalText, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, new Insets(insets.top * 2, insets.left * 30, 0, 0));
        insets = DialogUtil.getStandardButtonInsets();
        n = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mDeltaText, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 0, 2, 2, 1, n, new Insets(insets.top, insets.left, insets.bottom, n2 * 3));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mSingToleranceCombo, gridBagConstraints, 2, 2, 2, 1, n, insets);
        JLabel jLabel5 = DialogUtil.createLabel(this, LINK_COMBO_KEY);
        jLabel5.setLabelFor(this.mLinkCombo);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel5, gridBagConstraints, 0, 3, 2, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mLinkCombo, gridBagConstraints, 2, 3, 1, 1, n, insets);
        return jPanel;
    }

    private void setTabPolicy() {
        this.mTabOrder.add(this.mMaxItersText);
        this.mTabOrder.add(this.mMaxStepHalvText);
        this.mTabOrder.add(this.mLikelihoodValueCombo);
        this.mTabOrder.add(this.mParameterValueCombo);
        this.mTabOrder.add(this.mConfIntervalText);
        this.mTabOrder.add(this.mDeltaText);
        this.mTabOrder.add(this.mSingToleranceCombo);
        this.mTabOrder.add(this.mLinkCombo);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.mTabOrder.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mTabOrder, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void updateContinueButton() {
        if (this.mMaxItersText.getText().length() > 0 && this.mMaxStepHalvText.getText().length() > 0 && this.mConfIntervalText.getText().length() > 0 && this.mDeltaText.getText().length() > 0) {
            this.enableContinue(true);
        } else {
            this.enableContinue(false);
        }
    }
}

