/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.regression.ordinal_regression;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.regression.ordinal_regression.OrdinalRegressionLocation;
import com.spss.java_client.ui.dialogs.base.analyze.regression.ordinal_regression.OrdinalRegressionOptions;
import com.spss.java_client.ui.dialogs.base.analyze.regression.ordinal_regression.OrdinalRegressionOutput;
import com.spss.java_client.ui.dialogs.base.analyze.regression.ordinal_regression.OrdinalRegressionScale;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BootstrapDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class OrdinalRegressionDlg
extends BaseProcedureDialog
implements ListDataListener {
    protected static final String ORDINAL_REGRESSION_HELP_FILE_LOCATION = "idh_plum";
    protected static final String TARGETLISTDEPENDENTKEY = "TARGET_LIST_DEPENDENT";
    protected static final String TARGETLISTFACTORKEY = "TARGET_LIST_FACTOR";
    protected static final String TARGETLISTCOVARKEY = "TARGET_LIST_COVAR";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetCovarList;
    private TargetVariableList mTargetFactorList;
    private TargetVariableList mTargetDependList;
    private JScrollPane mScrollPaneSourcelist;
    private JScrollPane mScrollPaneCovarList;
    private JScrollPane mScrollPaneDependList;
    private JScrollPane mScrollPaneFactorlist;
    private ArrowButton mArrowButtonDependList;
    private ArrowButton mArrowButtonFactorlist;
    private ArrowButton mArrowButtonCovarList;
    private JLabel mDependListLabel;
    private JLabel mFactorListLabel;
    private JLabel mCovarListLabel;
    private JButton mOptionButton;
    private JButton mOutputButton;
    private JButton mLocationButton;
    private JButton mScaleButton;
    private JButton mBootstrappingButton;
    private Insets mInsets;
    private Boolean bexclude;
    private boolean mIsBootstrapOK;

    public OrdinalRegressionDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_ORDINAL"));
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        String string = this.mTargetCovarList.getVariablesStringList();
        String string2 = this.mTargetFactorList.getVariablesStringList();
        String string3 = this.mTargetDependList.getVariablesStringList();
        DialogDataModel dialogDataModel = (DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY);
        if (this.mIsBootstrapOK && dialogDataModel != null) {
            String string4 = string + " " + string2;
            stringBuffer.append(BootstrapDlg.getBootstrapSyntax(string3, string4, dialogDataModel));
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("PLUM"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(string3));
        int n = string2.length();
        if (n != 0) {
            stringBuffer.append(" BY " + string2);
        }
        if ((n = string.length()) != 0) {
            stringBuffer.append(" WITH " + string);
        }
        DialogDataModel dialogDataModel2 = this.getDialogDataModel();
        stringBuffer.append(this.generateOptionSubCommand(dialogDataModel2));
        stringBuffer.append(this.generateLocationSyntax(dialogDataModel2));
        if (this.generateOutputSyntax(dialogDataModel2).length() > 0) {
            stringBuffer.append(this.generateOutputSyntax(dialogDataModel2));
        } else if (this.bexclude == null) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/PRINT="));
            stringBuffer.append("FIT PARAMETER SUMMARY");
        }
        stringBuffer.append(this.generateScaleSyntax(dialogDataModel2));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (this.mIsBootstrapOK && dialogDataModel != null) {
            stringBuffer.append(BootstrapDlg.getRestoreSyntax(dialogDataModel));
        }
        return stringBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return "analyze_regression_ordinal";
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetCovarList.removeAll();
        this.mTargetFactorList.removeAll();
        this.mTargetDependList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetDependList.getModel().getSize() > 0);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetDependList.getModel().getSize() > 0);
        this.validateDialogDataModel();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetDependList.getModel().getSize() > 0);
    }

    @Override
    public String getDialogHelpID() {
        return ORDINAL_REGRESSION_HELP_FILE_LOCATION;
    }

    @Override
    public boolean okPastePressed() {
        if (this.mIsBootstrapOK && BootstrapDlg.isStrataVariableListEmpty(this)) {
            this.runSubDialog(new BootstrapDlg(this));
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        this.mInsets = new Insets(0, 0, 0, 0);
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = this.setupLists();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, 23, null);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrdinalRegressionDlg.this.runOptionsSubDialog();
            }
        };
        this.mOptionButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mOptionButton);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_ORDINAL_OUTPUT_3DOTS"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrdinalRegressionDlg.this.runOutputSubDialog();
            }
        };
        this.mOutputButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mOutputButton);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_ORDINAL_LOCATION_3DOTS"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrdinalRegressionDlg.this.runLocationSubDialog();
            }
        };
        this.mLocationButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mLocationButton);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_ORDINAL_SCALE_3DOTS"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrdinalRegressionDlg.this.runScaleSubDialog();
            }
        };
        this.mScaleButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mScaleButton);
        this.mIsBootstrapOK = false;
        if (VersionInfo.allowBootstrapping()) {
            this.mIsBootstrapOK = true;
            toggleButtonAction = new ToggleButtonAction("IDS_COMMON_BOOTSTRAPPING_BUTTON"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OrdinalRegressionDlg.this.runSubDialog(new BootstrapDlg(OrdinalRegressionDlg.this));
                }
            };
            this.mBootstrappingButton = new JButton(toggleButtonAction);
            this.addOptionsPanelButton(jPanel, this.mBootstrappingButton);
            if (BootstrapDlg.isCurrentDatasetInMIMode()) {
                this.mBootstrappingButton.setEnabled(false);
                this.mIsBootstrapOK = false;
            }
        }
        return jPanel;
    }

    protected VariableList getFactorsList() {
        return this.mTargetFactorList;
    }

    protected VariableList getCovariatesList() {
        return this.mTargetCovarList;
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.loadFromActiveDataset();
        this.mScrollPaneSourcelist = new JScrollPane(this.mSrcVarList);
        this.mScrollPaneSourcelist.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mArrowButtonDependList = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDependListLabel = DialogUtil.createLabel(this, "IDS_ORDINAL_DEPENDENTLIST_COLON");
        this.mTargetDependList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetDependList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mScrollPaneDependList = new JScrollPane(this.mTargetDependList);
        this.mScrollPaneDependList.setPreferredSize(this.mTargetDependList.getMinimumSize());
        this.mScrollPaneDependList.setHorizontalScrollBarPolicy(31);
        this.mScrollPaneDependList.setVerticalScrollBarPolicy(21);
        this.mTargetDependList.getModel().addListDataListener(this);
        this.mTargetDependList.setIdentifier(TARGETLISTCOVARKEY);
        this.mArrowButtonFactorlist = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mFactorListLabel = DialogUtil.createLabel(this, "IDS_ORDINAL_FACTORLIST_COLON");
        this.mTargetFactorList = new TargetVariableList();
        this.mTargetFactorList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mScrollPaneFactorlist = new JScrollPane(this.mTargetFactorList);
        this.mTargetFactorList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetFactorList.getFixedCellHeight() * 3 + 2));
        this.mScrollPaneFactorlist.setPreferredSize(this.mTargetFactorList.getMinimumSize());
        this.mTargetFactorList.getModel().addListDataListener(this);
        this.mTargetFactorList.setIdentifier(TARGETLISTFACTORKEY);
        this.mArrowButtonCovarList = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCovarListLabel = DialogUtil.createLabel(this, "IDS_ORDINAL_COVARLIST_COLON");
        this.mTargetCovarList = new TargetVariableList();
        this.mTargetCovarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetCovarList.addVarFilter(new SpssVarFilter(8, false));
        this.mScrollPaneCovarList = new JScrollPane(this.mTargetCovarList);
        this.mTargetCovarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetCovarList.getFixedCellHeight() * 3 + 2));
        this.mScrollPaneCovarList.setPreferredSize(this.mTargetCovarList.getMinimumSize());
        this.mTargetCovarList.getModel().addListDataListener(this);
        this.mTargetCovarList.setIdentifier(TARGETLISTDEPENDENTKEY);
        this.mDependListLabel.setLabelFor(this.mTargetDependList);
        this.mCovarListLabel.setLabelFor(this.mTargetCovarList);
        this.mFactorListLabel.setLabelFor(this.mTargetFactorList);
        this.mArrowButtonDependList.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonDependList.registerVariableList(this.mTargetDependList, SpssArrowButton.ButtonOrientation.left);
        this.mArrowButtonFactorlist.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonFactorlist.registerVariableList(this.mTargetFactorList, SpssArrowButton.ButtonOrientation.left);
        this.mArrowButtonCovarList.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonCovarList.registerVariableList(this.mTargetCovarList, SpssArrowButton.ButtonOrientation.left);
    }

    private void setDefaults() {
        this.mArrowButtonDependList.setEnabled(false);
        this.mArrowButtonFactorlist.setEnabled(false);
        this.mArrowButtonCovarList.setEnabled(false);
        this.mSrcVarList.setSelectedIndex(0);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButtonDependList);
        vector.add(this.mTargetDependList);
        vector.add(this.mArrowButtonFactorlist);
        vector.add(this.mTargetFactorList);
        vector.add(this.mArrowButtonCovarList);
        vector.add(this.mTargetCovarList);
        vector.add(this.mOptionButton);
        vector.add(this.mOutputButton);
        vector.add(this.mLocationButton);
        vector.add(this.mScaleButton);
        if (VersionInfo.allowBootstrapping()) {
            vector.add(this.mBootstrappingButton);
        }
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private JPanel setupLists() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_ORDINAL_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mScrollPaneSourcelist, gridBagConstraints, 0, 1, 1, 6, n, null);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mArrowButtonDependList, gridBagConstraints, 1, 0, 1, 2, n, null);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mDependListLabel, gridBagConstraints, 2, 0, 1, 2, n, null);
        gridBagConstraints.weightx = 1.0;
        n = 20;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mScrollPaneDependList, gridBagConstraints, 2, 1, 1, 1, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButtonFactorlist, gridBagConstraints, 1, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 2;
        this.mInsets.set(DialogUtil.getGroupBoxInnerMargin(), 0, DialogUtil.getGroupBoxInnerMargin(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mFactorListLabel, gridBagConstraints, 2, 3, 1, 1, n, new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0));
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mScrollPaneFactorlist, gridBagConstraints, 2, 4, 1, 1, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButtonCovarList, gridBagConstraints, 1, 6, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 2;
        this.mInsets.set(0, 0, DialogUtil.getGroupBoxInnerMargin(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mCovarListLabel, gridBagConstraints, 2, 5, 1, 1, n, new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0));
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mScrollPaneCovarList, gridBagConstraints, 2, 6, 1, 1, n, null);
        return jPanel;
    }

    private void runOptionsSubDialog() {
        this.runSubDialog(new OrdinalRegressionOptions(this));
    }

    private void runOutputSubDialog() {
        this.runSubDialog(new OrdinalRegressionOutput(this));
    }

    private void runLocationSubDialog() {
        this.runSubDialog(new OrdinalRegressionLocation(this, this.getResString("IDS_REGRESSION_ORDINAL_LOCATION_DLG_TITLE"), this.mTargetFactorList.getModel(), this.mTargetCovarList.getModel(), null, "IDS_REGRESSION_ORDINAL_LOCATION_MAIN"));
    }

    private void runScaleSubDialog() {
        this.runSubDialog(new OrdinalRegressionScale(this, this.getResString("IDS_REGRESSION_ORDINAL_SCALE_DLG_TITLE"), this.mTargetFactorList.getModel(), this.mTargetCovarList.getModel(), null, "IDS_REGRESSION_ORDINAL_SCALE_MAIN"));
    }

    private String generateOptionSubCommand(DialogDataModel dialogDataModel) {
        CharSequence charSequence;
        CharSequence charSequence2;
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(UIToolResUtil.getSPSSLocale());
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/CRITERIA="));
        if (dialogDataModel.getString("IDS_REGRESSION_ORDINAL_OPTIONS_CONFIDENCE") != null) {
            stringBuffer.append("CIN(" + dialogDataModel.getString("IDS_REGRESSION_ORDINAL_OPTIONS_CONFIDENCE") + ")");
        } else {
            stringBuffer.append("CIN(95)");
        }
        if (dialogDataModel.getString("IDS_REGRESSION_ORDINAL_OPTIONS_DELTA") != null) {
            stringBuffer.append(" DELTA(" + dialogDataModel.getString("IDS_REGRESSION_ORDINAL_OPTIONS_DELTA") + ")");
        } else {
            stringBuffer.append(" DELTA(0)");
        }
        ScientificFormat scientificFormat = new ScientificFormat(Locale.US);
        scientificFormat.applyPattern("0.0E0");
        FieldPosition fieldPosition = new FieldPosition(1);
        float f = 0.0f;
        if (dialogDataModel.getString("IDS_REGRESSION_ORDINAL_OPTIONS_LOG_LIKELIHOOD_CONVERGENCE") != null) {
            String string2 = dialogDataModel.getString("IDS_REGRESSION_ORDINAL_OPTIONS_LOG_LIKELIHOOD_CONVERGENCE");
            string = null;
            string = string2.indexOf(decimalFormatSymbols.getDecimalSeparator()) != -1 ? string2.replace(decimalFormatSymbols.getDecimalSeparator(), '.') : string2;
            f = Float.parseFloat(string);
            if (Float.valueOf(f) != null) {
                charSequence2 = new StringBuffer();
                scientificFormat.format(f, (StringBuffer)charSequence2, fieldPosition);
                if (((StringBuffer)charSequence2).toString().equals("0.0E+0")) {
                    stringBuffer.append(" LCONVERGE(0)");
                } else {
                    stringBuffer.append(" LCONVERGE(" + ((StringBuffer)charSequence2).toString() + ")");
                }
            }
        } else {
            stringBuffer.append(" LCONVERGE(0)");
        }
        if (dialogDataModel.getString("IDS_REGRESSION_ORDINAL_OPTIONS_MAX_ITERATION_TEXT") != null) {
            stringBuffer.append(" MXITER(" + dialogDataModel.getString("IDS_REGRESSION_ORDINAL_OPTIONS_MAX_ITERATION_TEXT") + ")");
        } else {
            stringBuffer.append(" MXITER(100)");
        }
        if (dialogDataModel.getString("IDS_REGRESSION_ORDINAL_OPTIONS_MAX_STEP_HALV_TEXT") != null) {
            stringBuffer.append(" MXSTEP(" + dialogDataModel.getString("IDS_REGRESSION_ORDINAL_OPTIONS_MAX_STEP_HALV_TEXT") + ")");
        } else {
            stringBuffer.append(" MXSTEP(5)");
        }
        float f2 = 0.0f;
        if (dialogDataModel.getString("IDS_REGRESSION_ORDINAL_OPTIONS_PARAMETER_CONVERGENCE") != null) {
            string = dialogDataModel.getString("IDS_REGRESSION_ORDINAL_OPTIONS_PARAMETER_CONVERGENCE");
            charSequence2 = null;
            charSequence2 = string.indexOf(decimalFormatSymbols.getDecimalSeparator()) != -1 ? string.replace(decimalFormatSymbols.getDecimalSeparator(), '.') : string;
            f2 = Float.parseFloat((String)charSequence2);
            if (Float.valueOf(f2) != null) {
                charSequence = new StringBuffer();
                scientificFormat.format(f2, (StringBuffer)charSequence, fieldPosition);
                if (((StringBuffer)charSequence).toString().equals("0.0E+0")) {
                    stringBuffer.append(" PCONVERGE(0)");
                } else {
                    stringBuffer.append(" PCONVERGE(" + ((StringBuffer)charSequence).toString() + ")");
                }
            }
        } else {
            stringBuffer.append(" PCONVERGE(1.0E-6)");
        }
        float f3 = 0.0f;
        if (dialogDataModel.getString("IDS_REGRESSION_ORDINAL_OPTIONS_SINGULARITY_TOLERANCE") != null) {
            charSequence2 = dialogDataModel.getString("IDS_REGRESSION_ORDINAL_OPTIONS_SINGULARITY_TOLERANCE");
            charSequence = null;
            charSequence = ((String)charSequence2).indexOf(decimalFormatSymbols.getDecimalSeparator()) != -1 ? ((String)charSequence2).replace(decimalFormatSymbols.getDecimalSeparator(), '.') : charSequence2;
            f3 = Float.parseFloat((String)charSequence);
            if (Float.valueOf(f3) != null) {
                StringBuffer stringBuffer2 = new StringBuffer();
                scientificFormat.format(f3, stringBuffer2, fieldPosition);
                if (stringBuffer2.toString().equals("0.0E+0")) {
                    stringBuffer.append(" SINGULAR(0)");
                } else {
                    stringBuffer.append(" SINGULAR(" + stringBuffer2.toString() + ")");
                }
            }
        } else {
            stringBuffer.append(" SINGULAR(1.0E-8)");
        }
        stringBuffer.append("\n");
        charSequence2 = dialogDataModel.getString("IDS_REGRESSION_ORDINAL_OPTIONS_LINK");
        charSequence = "LOGIT";
        if (charSequence2 != null) {
            charSequence = ((String)charSequence2).equals(this.getResString("IDS_REGRESSION_ORDINAL_OPTIONS_LINK_OPTION1")) ? "CAUCHIT" : (((String)charSequence2).equals(this.getResString("IDS_REGRESSION_ORDINAL_OPTIONS_LINK_OPTION2")) ? "CLOGLOG" : (((String)charSequence2).equals(this.getResString("IDS_REGRESSION_ORDINAL_OPTIONS_LINK_OPTION3")) ? "LOGIT" : (((String)charSequence2).equals(this.getResString("IDS_REGRESSION_ORDINAL_OPTIONS_LINK_OPTION4")) ? "NLOGLOG" : (((String)charSequence2).equals(this.getResString("IDS_REGRESSION_ORDINAL_OPTIONS_LINK_OPTION5")) ? "PROBIT" : charSequence2))));
        }
        stringBuffer.append(SyntaxUtil.getSingleValueSubCommand("LINK", (String)charSequence, false).toString());
        return stringBuffer.toString();
    }

    private String generateOutputSyntax(DialogDataModel dialogDataModel) {
        String string = "";
        StringBuffer stringBuffer = new StringBuffer("");
        StringBuffer stringBuffer2 = new StringBuffer("");
        Boolean bl = dialogDataModel.getBoolean("IDS_REGRESSION_ORDINAL_OUTPUT_DISPLAY_PANEL_CELL_INFO");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("CELLINFO ");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REGRESSION_ORDINAL_OUTPUT_DISPLAY_PANEL_ASYMPT_CORR")) != null && bl.booleanValue()) {
            stringBuffer.append("CORB ");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REGRESSION_ORDINAL_OUTPUT_DISPLAY_PANEL_ASYMPT_COVAR")) != null && bl.booleanValue()) {
            stringBuffer.append("COVB ");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REGRESSION_ORDINAL_OUTPUT_DISPLAY_PANEL_GOODNESS_FIT_STAT")) != null && bl.booleanValue()) {
            stringBuffer.append("FIT ");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REGRESSION_ORDINAL_OUTPUT_DISPLAY_PANEL_ITERATION_HISTORY")) != null && bl.booleanValue()) {
            stringBuffer.append("HISTORY");
            stringBuffer.append("(");
            stringBuffer.append(dialogDataModel.getString("IDS_REGRESSION_ORDINAL_OUTPUT_DISPLAY_PANEL_ITERATION_HISTORY_STEPS"));
            stringBuffer.append(") ");
        }
        this.bexclude = dialogDataModel.getBoolean("IDS_REGRESSION_ORDINAL_OUTPUT_PRINT_PANEL_EXCLUDE");
        if (this.bexclude != null && this.bexclude.booleanValue()) {
            stringBuffer.append("KERNEL ");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REGRESSION_ORDINAL_OUTPUT_DISPLAY_PANEL_PARAM_ESTM")) != null && bl.booleanValue()) {
            stringBuffer.append("PARAMETER ");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REGRESSION_ORDINAL_OUTPUT_DISPLAY_PANEL_SUMMERY_STAT")) != null && bl.booleanValue()) {
            stringBuffer.append("SUMMARY ");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REGRESSION_ORDINAL_OUTPUT_DISPLAY_PANEL_TEST_PARALLEL")) != null && bl.booleanValue()) {
            stringBuffer.append("TPARALLEL ");
        }
        if (stringBuffer.length() > 0) {
            string = "\n";
            string = string + SyntaxUtil.getSubCommand("/PRINT=");
            string = string + stringBuffer.toString().trim();
        }
        if (this.bexclude == null) {
            stringBuffer2.append("");
        } else {
            stringBuffer2.append(string);
        }
        StringBuffer stringBuffer3 = new StringBuffer();
        bl = dialogDataModel.getBoolean("IDS_REGRESSION_ORDINAL_OUTPUT_SAVE_PANEL_ESTM_RESP_PROB");
        if (bl != null && bl.booleanValue()) {
            stringBuffer3.append("ESTPROB ");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REGRESSION_ORDINAL_OUTPUT_SAVE_PANEL_PREDICT_CAT")) != null && bl.booleanValue()) {
            stringBuffer3.append("PREDCAT ");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REGRESSION_ORDINAL_OUTPUT_SAVE_PANEL_PREDICT_CAT_PROB")) != null && bl.booleanValue()) {
            stringBuffer3.append("PCPROB ");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_REGRESSION_ORDINAL_OUTPUT_SAVE_PANEL_ACT_CAT_PROB")) != null && bl.booleanValue()) {
            stringBuffer3.append("ACPROB ");
        }
        String string2 = "";
        if (stringBuffer3.length() > 0) {
            stringBuffer2.append("\n");
            stringBuffer2.append(SyntaxUtil.getSubCommand("/SAVE="));
            string2 = stringBuffer3.toString().trim();
            stringBuffer2.append(string2);
        }
        return stringBuffer2.toString();
    }

    private String generateLocationSyntax(DialogDataModel dialogDataModel) {
        Object[] objectArray;
        StringBuffer stringBuffer = new StringBuffer();
        Boolean bl = dialogDataModel.getBoolean("IDS_REGRESSION_ORDINAL_LOCATION_MAIN");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("");
        } else if (dialogDataModel.getArray("IDS_LOCATION") != null && (objectArray = dialogDataModel.getArray("IDS_LOCATION")).length > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/LOCATION="));
            for (Object object : objectArray) {
                stringBuffer.append(object + " ");
            }
        }
        return stringBuffer.toString();
    }

    private String generateScaleSyntax(DialogDataModel dialogDataModel) {
        Object[] objectArray;
        StringBuffer stringBuffer = new StringBuffer("");
        if (dialogDataModel.getArray("IDS_SCALE") != null && (objectArray = dialogDataModel.getArray("IDS_SCALE")).length > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/SCALE="));
            for (Object object : objectArray) {
                stringBuffer.append(object + " ");
            }
        }
        return stringBuffer.toString();
    }

    public void validateDialogDataModel() {
        int n;
        Object object;
        Object object2;
        String string = this.mTargetFactorList.getVariablesStringList();
        String string2 = this.mTargetCovarList.getVariablesStringList();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        stringTokenizer = new StringTokenizer(string2, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector2.add(stringTokenizer.nextToken());
        }
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Vector<String> vector3 = new Vector<String>();
        Object[] objectArray = dialogDataModel.getArray("IDS_LOCATION");
        if (objectArray != null) {
            object2 = "";
            for (int i = 0; i < objectArray.length; ++i) {
                String string3 = objectArray[i].toString();
                object = new StringTokenizer(string3, "*");
                n = ((StringTokenizer)object).countTokens();
                for (int j = 0; j < n && (vector.contains(object2 = ((StringTokenizer)object).nextToken()) || vector2.contains(object2)); ++j) {
                    if (j < n - 1) continue;
                    vector3.add(string3);
                }
            }
        }
        dialogDataModel.putArray("IDS_LOCATION", vector3.toArray());
        object = new Vector();
        object2 = dialogDataModel.getArray("IDS_SCALE");
        if (object2 != null) {
            String string4 = "";
            for (n = 0; n < ((Object[])object2).length; ++n) {
                String string5 = object2[n].toString();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string5, "*");
                int n2 = stringTokenizer2.countTokens();
                for (int i = 0; i < n2 && (vector.contains(string4 = stringTokenizer2.nextToken()) || vector2.contains(string4)); ++i) {
                    if (i < n2 - 1) continue;
                    ((Vector)object).add(string5);
                }
            }
        }
        dialogDataModel.putArray("IDS_SCALE", ((Vector)object).toArray());
    }

    class ScientificFormat
    extends DecimalFormat {
        public ScientificFormat(Locale locale) {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
            this.setDecimalFormatSymbols(decimalFormatSymbols);
        }

        public StringBuffer format(float f, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            StringBuffer stringBuffer2 = super.format((double)f, stringBuffer, fieldPosition);
            int n = stringBuffer2.indexOf("E");
            int n2 = stringBuffer2.indexOf("E-");
            if (n > -1 && n2 < 0) {
                stringBuffer2.insert(n + 1, "+");
            }
            return stringBuffer2;
        }
    }
}

