/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.regression.curve_estimation;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ITrendsInfo;
import com.spss.java_client.ui.controls.DateFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.regression.curve_estimation.CurveEstimationDlg;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CurveEstimationSave
extends BaseSubDialog
implements ItemListener,
DocumentListener {
    public static final String CURVE_ESTIMATION_DATE_PANEL_FIELDS = "curveEstimationDatePanelFields";
    public static final String CURVE_ESTIMATION_DATE_PANEL_LABELS = "curveEstimationDatePanelLabels";
    static final String COMBO_KEY = "IDS_COMBO_VALUE";
    private JComboBox mConfidenceIntervalComboBox;
    private JLabel mConfidenceIntervalLabel;
    private DateFactory.DatePanel mDatesPanel;
    private List<Integer> mPeriodicity;
    private JRadioButton mEstimationPeriodButton;
    private JRadioButton mObservationButton;
    private JPanel mPredictCasesPanel;
    private JCheckBox mPredictedValuesCheckBox;
    private JCheckBox mPredictionIntervalsCheckBox;
    private JCheckBox mResidualsCheckBox;
    private Vector<Object> mTabOrder;

    public CurveEstimationSave(CurveEstimationDlg curveEstimationDlg) {
        super(curveEstimationDlg, curveEstimationDlg.getResString("IDS_CURVE_ESTIMATION_SAVE_TITLE"), true);
        this.setLocationRelativeTo((Component)((Object)curveEstimationDlg));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_curv_save";
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkConditionsAndEnableContinue();
    }

    public CurveEstimationDlg getParent() {
        return (CurveEstimationDlg)((Object)super.getParent());
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkConditionsAndEnableContinue();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        Object object = itemEvent.getItem();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (object == this.mPredictionIntervalsCheckBox) {
            DialogUtil.enableHTMLComponent(this.mConfidenceIntervalLabel, bl);
            this.mConfidenceIntervalComboBox.setEnabled(bl);
        }
        if (this.getParent().isIndependentsTimeButtonSelected() && (this.mPredictedValuesCheckBox.isSelected() || this.mPredictionIntervalsCheckBox.isSelected() || this.mResidualsCheckBox.isSelected())) {
            this.mEstimationPeriodButton.setEnabled(true);
            this.mObservationButton.setEnabled(true);
            if (this.mObservationButton.isSelected()) {
                this.setComponentEnableState(this.mDatesPanel, true);
                this.checkConditionsAndEnableContinue();
            } else {
                this.setComponentEnableState(this.mDatesPanel, false);
                this.enableContinue(true);
            }
        } else {
            this.mEstimationPeriodButton.setEnabled(false);
            this.mObservationButton.setEnabled(false);
            this.setComponentEnableState(this.mDatesPanel, false);
            this.enableContinue(true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkConditionsAndEnableContinue();
    }

    @Override
    public boolean continuePressed() {
        boolean bl = true;
        if (this.mObservationButton.isSelected()) {
            int n = this.mDatesPanel.getFields().length;
            for (int i = 1; bl && i < n; ++i) {
                if (this.mDatesPanel.getFields()[i - 1].getText().length() != 0 || this.mDatesPanel.getFields()[i].getText().length() <= 0) continue;
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_CURVE_ESTIMATION_HIGHERDATE_EMPTY_WARNING"), VersionInfo.getAppVersionString());
                this.mDatesPanel.getFields()[i - 1].requestFocus();
                bl = false;
            }
            try {
                for (int i = 0; bl && i < n; ++i) {
                    String string = this.mDatesPanel.getFields()[i].getText();
                    int n2 = Integer.parseInt(string);
                    int n3 = this.mPeriodicity.get(i);
                    Integer n4 = DateFactory.getPeriodMinVal(this.getDateVarType(i));
                    if (string.length() <= 0 || n3 <= 0) continue;
                    if (!(n4 != 0 ? n2 < n4 : n2 < n4 || n2 >= n3)) {
                        if (n4 != 1 || n3 == 1 || n2 >= n4 && n2 <= n3) continue;
                    }
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_CURVE_ESTIMATION_EXCEED_PERIODICITY_WARNING"), VersionInfo.getAppVersionString());
                    this.mDatesPanel.getFields()[i].requestFocus();
                    this.mDatesPanel.getFields()[i].selectAll();
                    bl = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (bl) {
            bl = super.continuePressed();
        }
        return bl;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.setupPredictCasesPanel();
        jPanel.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.getViewPanel(), this.setupSaveVariablesPanel(), gridBagConstraints, 0, 0, 1, 1, 19, new Insets(0, 0, DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap()));
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.getViewPanel(), jPanel, gridBagConstraints, 1, 0, 3, 2, 10, new Insets(0, 0, DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap()));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.getViewPanel(), this.setupPeriodMessagePanel(), gridBagConstraints, 0, 1, 1, 1, 10, new Insets(0, 0, DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap()));
        this.setDefaults();
        this.pack();
        this.setTabPolicy();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        if (!DateFactory.hasDateFormatChanged(dialogDataModel, CURVE_ESTIMATION_DATE_PANEL_LABELS, this.getParent().getSrcVariableList())) {
            this.mDatesPanel.loadState(dialogDataModel, CURVE_ESTIMATION_DATE_PANEL_FIELDS);
        } else {
            this.mEstimationPeriodButton.setSelected(true);
            this.mObservationButton.setSelected(false);
        }
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        this.mDatesPanel.saveState(dialogDataModel, CURVE_ESTIMATION_DATE_PANEL_FIELDS, CURVE_ESTIMATION_DATE_PANEL_LABELS, this.getParent().getSrcVariableList());
        dialogDataModel.putString(COMBO_KEY, (String)this.mConfidenceIntervalComboBox.getSelectedItem());
        return super.saveState(dialogDataModel);
    }

    private void checkConditionsAndEnableContinue() {
        this.enableContinue(!this.mDatesPanel.getFields()[0].getText().equals(""));
    }

    private void initVars() {
        this.mDatesPanel = DateFactory.getPanel(this.getParent().getSrcVariableList());
        this.mDatesPanel.getFields()[0].getDocument().addDocumentListener(this);
        this.mPeriodicity = DateFactory.getPeriodicity(this.getParent().getSrcVariableList());
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        this.mEstimationPeriodButton = new JRadioButton(new ToggleButtonAction(this.getParent(), "IDS_PREDICT_THROUGH_LAST_CASE"));
        spssButtonGroup.add(this.mEstimationPeriodButton);
        this.mPredictCasesPanel = new JPanel(new GridBagLayout());
        this.mPredictCasesPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PREDICT_CASES")));
        this.mPredictCasesPanel.setEnabled(false);
        this.mObservationButton = new JRadioButton(new ToggleButtonAction(this.getParent(), "IDS_PREDICT_THROUGH"));
        this.mObservationButton.setEnabled(false);
        this.mObservationButton.addItemListener(this);
        spssButtonGroup.add(this.mObservationButton);
        SpssButtonGroup spssButtonGroup2 = new SpssButtonGroup();
        this.mPredictedValuesCheckBox = new JCheckBox(new ToggleButtonAction(this.getParent(), "IDS_PREDICTED_VALUES"));
        this.mPredictedValuesCheckBox.addItemListener(this);
        this.mResidualsCheckBox = new JCheckBox(new ToggleButtonAction(this.getParent(), "IDS_RESIDUALS"));
        this.mResidualsCheckBox.addItemListener(this);
        this.mPredictionIntervalsCheckBox = new JCheckBox(new ToggleButtonAction(this.getParent(), "IDS_PREDICTION_INTERVALS"));
        this.mPredictionIntervalsCheckBox.addItemListener(this);
        spssButtonGroup2.add(this.mPredictedValuesCheckBox);
        spssButtonGroup2.add(this.mResidualsCheckBox);
        spssButtonGroup2.add(this.mPredictionIntervalsCheckBox);
        this.mConfidenceIntervalComboBox = new JComboBox();
        this.mConfidenceIntervalComboBox.setAction(new ComboboxAction(this.getParent(), COMBO_KEY));
        this.mConfidenceIntervalComboBox.addItem("90");
        this.mConfidenceIntervalComboBox.addItem("95");
        this.mConfidenceIntervalComboBox.addItem("99");
        this.mConfidenceIntervalComboBox.setEnabled(false);
        this.mConfidenceIntervalLabel = DialogUtil.createMultiLineLabel(this, "IDS_CONFIDENCE_INTERVAL", 100);
        this.mConfidenceIntervalLabel.setLabelFor(this.mConfidenceIntervalComboBox);
        this.mTabOrder = new Vector();
    }

    private void setDefaults() {
        this.setComponentEnableState(this.mDatesPanel, false);
        this.mEstimationPeriodButton.setEnabled(false);
        this.mEstimationPeriodButton.setSelected(true);
        this.mConfidenceIntervalComboBox.setSelectedIndex(1);
        DialogUtil.enableHTMLComponent(this.mConfidenceIntervalLabel, false);
    }

    private void setTabPolicy() {
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mEstimationPeriodButton);
        spssButtonGroup.add(this.mObservationButton);
        this.mTabOrder.add(this.mPredictedValuesCheckBox);
        this.mTabOrder.add(this.mResidualsCheckBox);
        this.mTabOrder.add(this.mPredictionIntervalsCheckBox);
        this.mTabOrder.add(this.mConfidenceIntervalComboBox);
        this.mTabOrder.add(spssButtonGroup);
        this.mTabOrder.add(this.mDatesPanel.getFields()[0]);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.mTabOrder.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mTabOrder, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private JPanel setupPeriodMessagePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 0, 0, 1, 1, 10, null);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, new JLabel(this.getResString("IDS_ESTIMATION_PERIOD")), gridBagConstraints, 0, 1, 1, 1, 25, null);
        DialogUtil.addUsingGBL(jPanel, new JLabel(this.getResString("IDS_ALL_CASES")), gridBagConstraints, 0, 2, 1, 1, 25, null);
        return jPanel;
    }

    private JPanel setupPredictCasesPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(this.mPredictCasesPanel, this.mEstimationPeriodButton, gridBagConstraints, 0, 0, 1, 1, 21, null);
        DialogUtil.addUsingGBL(this.mPredictCasesPanel, this.mObservationButton, gridBagConstraints, 0, 1, 1, 1, 21, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mPredictCasesPanel, this.mDatesPanel, gridBagConstraints, 0, 2, 1, 1, 21, new Insets(0, 20, 0, 0));
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mPredictCasesPanel, new JPanel(), gridBagConstraints, 0, 3, 1, 1, 21, new Insets(0, 20, 0, 0));
        return this.mPredictCasesPanel;
    }

    private JPanel setupSaveVariablesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_SAVE_VARIABLES")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mPredictedValuesCheckBox, gridBagConstraints, 0, 0, 2, 1, 23, null);
        DialogUtil.addUsingGBL(jPanel, this.mResidualsCheckBox, gridBagConstraints, 0, 1, 2, 1, 23, null);
        DialogUtil.addUsingGBL(jPanel, this.mPredictionIntervalsCheckBox, gridBagConstraints, 0, 2, 2, 1, 23, null);
        DialogUtil.addUsingGBL(jPanel, this.mConfidenceIntervalComboBox, gridBagConstraints, 0, 3, 1, 1, 23, DialogUtil.getStandardControlInsets());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mConfidenceIntervalLabel, gridBagConstraints, 1, 3, 1, 1, 23, new Insets(0, 5, 0, 0));
        return jPanel;
    }

    private ITrendsInfo.DateVarTypes getDateVarType(int n) {
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        ITrendsInfo iTrendsInfo = iSpssDataSrc.getTrendsInfo();
        return iTrendsInfo.getNDateVars() != 0 ? iTrendsInfo.getDateVarType(n) : ITrendsInfo.DateVarTypes.e_NONE;
    }
}

