/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.regression.curve_estimation;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.dialogs.base.analyze.regression.curve_estimation.ComponentWalker;
import com.spss.java_client.ui.dialogs.base.analyze.regression.curve_estimation.CurveEstimationSave;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.ContextEnabledTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.Document;

public class CurveEstimationDlg
extends BaseProcedureDialog
implements ItemListener,
ListDataListener {
    private static final int TARGET_LIST_MAX_LIMIT = 100;
    private TargetVariableList mCaseLabelsList;
    private TargetVariableList mDependentsList;
    private JCheckBox mDisplayAnovaTableCheckBox;
    private JCheckBox mIncludeConstantCheckBox;
    private ArrowButton mIndependentsArrowButton;
    private TargetVariableList mIndependentsList;
    private JRadioButton mIndependentsTimeButton;
    private JCheckBox mLinearModelCheckBox;
    private JCheckBox mLogisticsCheckBox;
    private JPanel mModelsPanel;
    private JCheckBox mPlotModelsCheckBox;
    private SrcVariableList mSrcVariableList;
    private ContextEnabledTextField mUpperBoundsField;
    private JLabel mUpperBoundsLabel;
    private JRadioButton mVariableRadioButton;
    private Vector<Object> mTabOrder;
    private ArrowButton mDepArrowButton;
    private ArrowButton mCaseLabelsArrowButton;
    private JButton mSaveButton;
    private JCheckBox mQuadratic;
    private JCheckBox mCompound;
    private JCheckBox mGrowth;
    private JCheckBox mLog;
    private JCheckBox mCurveEstCubic;
    private JCheckBox mS;
    private JCheckBox mExponential;
    private JCheckBox mInverse;
    private JCheckBox mPower;

    public CurveEstimationDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle.getDefaultResourceBundleName(), AnalyzeResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_CURVE_ESTIMATION_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.checkConditionsAndEnableOkPaste();
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("* " + this.getResString("IDS_CURVE_ESTIMATION_SYNTAX_TITLE") + ".");
        Boolean bl = null;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        int n = this.getNoOfVariablesToAdd();
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getMainCommand("TSET"));
        if (n > 0) {
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("MXNEWVAR="));
            stringBuffer.append(n);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
            bl = dialogDataModel.getBoolean("IDS_TIME");
            Boolean bl2 = dialogDataModel.getBoolean("IDS_PREDICTED_VALUES");
            Boolean bl3 = dialogDataModel.getBoolean("IDS_RESIDUALS");
            Boolean bl4 = dialogDataModel.getBoolean("IDS_PREDICTION_INTERVALS");
            if (bl != null && bl != false && bl2 != null && bl2 != false || bl != null && bl != false && bl3 != null && bl3 != false || bl != null && bl.booleanValue() && bl4 != null && bl4.booleanValue()) {
                bl2 = dialogDataModel.getBoolean("IDS_PREDICT_THROUGH_LAST_CASE");
                stringBuffer.append(SyntaxUtil.getMainCommand("PREDICT"));
                if (bl2 != null && bl2.booleanValue()) {
                    stringBuffer.append(SyntaxUtil.getMainCommandParamters("THRU END"));
                    stringBuffer.append(SyntaxUtil.terminateSyntax());
                } else {
                    stringBuffer.append(SyntaxUtil.getMainCommandParamters("THRU "));
                    stringBuffer.append(this.generateDatesPanelSyntax(dialogDataModel));
                    stringBuffer.append(SyntaxUtil.terminateSyntax());
                }
            }
        } else {
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("NEWVAR=NONE"));
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("CURVEFIT"));
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/VARIABLES="));
        stringBuffer.append(this.mDependentsList.getVariablesStringList());
        bl = dialogDataModel.getBoolean("IDS_TIME");
        if (!this.mIndependentsList.getVariablesStringList().equals("") && bl != null && !bl.booleanValue()) {
            stringBuffer.append(" WITH " + this.mIndependentsList.getVariablesStringList());
        }
        bl = dialogDataModel.getBoolean("IDS_INCLUDE_CONSTANT");
        stringBuffer.append("\n");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/CONSTANT"));
        } else {
            stringBuffer.append(SyntaxUtil.getSubCommand("/NOCONSTANT"));
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/MODEL="));
        bl = dialogDataModel.getBoolean("IDS_CURVE_ESTIMATION_LINEAR");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("LINEAR ");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_LOGARITHMIC")) != null && bl.booleanValue()) {
            stringBuffer.append("LOGARITHMIC ");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_INVERSE")) != null && bl.booleanValue()) {
            stringBuffer.append("INVERSE ");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_QURADRATIC")) != null && bl.booleanValue()) {
            stringBuffer.append("QUADRATIC ");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_CURVE_ESTIMATION_CUBIC")) != null && bl.booleanValue()) {
            stringBuffer.append("CUBIC ");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_COMPOUND")) != null && bl.booleanValue()) {
            stringBuffer.append("COMPOUND ");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_POWER")) != null && bl.booleanValue()) {
            stringBuffer.append("POWER ");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_S")) != null && bl.booleanValue()) {
            stringBuffer.append("S ");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_GROWTH")) != null && bl.booleanValue()) {
            stringBuffer.append("GROWTH ");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_EXPONENTIAL")) != null && bl.booleanValue()) {
            stringBuffer.append("EXPONENTIAL ");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_LOGISTIC")) != null && bl.booleanValue()) {
            stringBuffer.append("LGSTIC ");
            if (!dialogDataModel.getString("IDS_UPPER_BOUND").equals("")) {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/UPPERBOUND="));
                stringBuffer.append(dialogDataModel.getString("IDS_UPPER_BOUND"));
            }
        }
        if ((bl = dialogDataModel.getBoolean("IDS_DISPLAY_ANOVA_TABLE")) != null && bl.booleanValue()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/PRINT ANOVA"));
        }
        bl = dialogDataModel.getBoolean("IDS_PLOT_MODELS");
        stringBuffer.append("\n");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/PLOT FIT"));
        } else {
            stringBuffer.append(SyntaxUtil.getSubCommand("/PLOT NONE"));
        }
        bl = dialogDataModel.getBoolean("IDS_PREDICTION_INTERVALS");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/CIN="));
            stringBuffer.append(dialogDataModel.getString("IDS_COMBO_VALUE"));
        }
        if (n > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/SAVE="));
            bl = dialogDataModel.getBoolean("IDS_PREDICTED_VALUES");
            if (bl != null && bl.booleanValue()) {
                stringBuffer.append("PRED ");
            }
            if ((bl = dialogDataModel.getBoolean("IDS_RESIDUALS")) != null && bl.booleanValue()) {
                stringBuffer.append("RESID ");
            }
            if ((bl = dialogDataModel.getBoolean("IDS_PREDICTION_INTERVALS")) != null && bl.booleanValue()) {
                stringBuffer.append("CIN ");
            }
        }
        if (!this.mCaseLabelsList.getVariablesStringList().equals("")) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/ID="));
            stringBuffer.append(this.mCaseLabelsList.getVariablesStringList());
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax().toString());
        return stringBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return "analyze_regression_curve_estim";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_curv";
    }

    public SrcVariableList getSrcVariableList() {
        return this.mSrcVariableList;
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.checkConditionsAndEnableOkPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.checkConditionsAndEnableOkPaste();
    }

    public boolean isIndependentsTimeButtonSelected() {
        return this.mIndependentsTimeButton.isSelected();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        Object object = itemEvent.getItem();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (object == this.mLogisticsCheckBox) {
            this.mUpperBoundsField.setEnabled(bl);
            this.mUpperBoundsField.setOpaque(bl);
            this.mUpperBoundsLabel.setEnabled(bl);
        } else if (object == this.mVariableRadioButton) {
            this.mIndependentsArrowButton.setEnabled(bl && this.mSrcVariableList.getSelectedIndices().length == 1 && this.mIndependentsList.getModel().getSize() == 0);
            this.mIndependentsList.setEnabled(bl);
            if (bl) {
                this.mIndependentsArrowButton.registerVariableList(this.mIndependentsList, SpssArrowButton.ButtonOrientation.left);
                this.mIndependentsArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
            } else {
                this.mIndependentsArrowButton.unRegisterVariableList(this.mIndependentsList);
                this.mIndependentsArrowButton.unRegisterVariableList(this.mSrcVariableList);
            }
            this.checkConditionsAndEnableOkPaste(!bl);
        }
        if (object instanceof JCheckBox && ((JComponent)object).getParent() == this.mModelsPanel) {
            this.checkConditionsAndEnableOkPaste(this.mIndependentsTimeButton.isSelected());
        }
    }

    @Override
    public boolean okPastePressed() {
        if (this.mUpperBoundsField.getText().length() != 0 && Double.parseDouble(this.mUpperBoundsField.getText()) == 0.0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_CONTEXT_TEXTFIELD_ERROR_MESSAGE"), VersionInfo.getAppVersionString());
            this.mUpperBoundsField.requestFocus();
            this.mUpperBoundsField.selectAll();
            return false;
        }
        int n = this.getNoOfVariablesToAdd();
        if (n > 0) {
            String string = String.format(ComponentState.getSPSSLocale(), this.getResString("ERR_ADD_VARIABLES_CONFIRMATION_MESSAGE"), n, n);
            int n2 = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
            return n2 == 0;
        }
        return true;
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVariableList);
        jScrollPane.setPreferredSize(this.mSrcVariableList.getMinimumSize());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_CURVE_ESTIMATION_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVariableList);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.getViewPanel(), jLabel, gridBagConstraints, 0, 0, 1, 1, 23, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.getViewPanel(), jScrollPane, gridBagConstraints, 0, 1, 1, 1, 10, null);
        DialogUtil.addUsingGBL(this.getViewPanel(), this.setupRestOfThingsPanel(), gridBagConstraints, 1, 0, 1, 2, 10, null);
        this.setDefaults();
        this.pack();
        this.setTabPolicy();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_SAVE_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CurveEstimationDlg.this.runSubDialog(new CurveEstimationSave(CurveEstimationDlg.this));
            }
        };
        this.mSaveButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mSaveButton);
        return jPanel;
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVariableList.setSelectedIndex(0);
    }

    private void checkConditionsAndEnableOkPaste() {
        this.checkConditionsAndEnableOkPaste(this.isIndependentsTimeButtonSelected());
    }

    private void checkConditionsAndEnableOkPaste(boolean bl) {
        CheckboxesSelectedCounter checkboxesSelectedCounter = new CheckboxesSelectedCounter();
        checkboxesSelectedCounter.walk(this.mModelsPanel);
        this.enableOkPaste(this.mDependentsList.getModel().getSize() > 0 && (bl || this.mIndependentsList.getModel().getSize() > 0) && checkboxesSelectedCounter.getNoOfCheckedCheckboxes() > 0);
    }

    private String generateDatesPanelSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = dialogDataModel.getArray("curveEstimationDatePanelFields");
        Object[] objectArray2 = dialogDataModel.getArray("curveEstimationDatePanelLabels");
        if (objectArray2.length < objectArray.length) {
            stringBuffer.append(objectArray[0] + " ");
        } else {
            for (int i = 0; i < objectArray.length && (i != 1 && i != 2 || objectArray[i].toString().length() != 0); ++i) {
                stringBuffer.append(objectArray2[i] + " " + objectArray[i] + " ");
            }
        }
        return stringBuffer.deleteCharAt(stringBuffer.length() - 1).toString();
    }

    private int getNoOfVariablesToAdd() {
        Boolean bl = null;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        int n = 0;
        bl = dialogDataModel.getBoolean("IDS_PREDICTED_VALUES");
        if (bl != null && bl.booleanValue()) {
            ++n;
        }
        if ((bl = dialogDataModel.getBoolean("IDS_RESIDUALS")) != null && bl.booleanValue()) {
            ++n;
        }
        if ((bl = dialogDataModel.getBoolean("IDS_PREDICTION_INTERVALS")) != null && bl.booleanValue()) {
            n += 2;
        }
        CheckboxesSelectedCounter checkboxesSelectedCounter = new CheckboxesSelectedCounter();
        checkboxesSelectedCounter.walk(this.mModelsPanel);
        int n2 = n * this.mDependentsList.getModel().getSize() * checkboxesSelectedCounter.getNoOfCheckedCheckboxes();
        return n2;
    }

    private void initVars() {
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, true, false);
        this.mSrcVariableList = new SrcVariableList();
        this.mCaseLabelsList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mCaseLabelsList.setIdentifier("IDS_CASE_LABELS");
        this.mDependentsList = new TargetVariableList();
        this.mDependentsList.setIdentifier("IDS_DEPENDENTS");
        this.mDependentsList.addVarFilter(spssVarFilter);
        this.mDependentsList.getModel().addListDataListener(this);
        this.mDependentsList.setMaxLimitOfList(100);
        this.mVariableRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_VARIABLE"));
        this.mVariableRadioButton.addItemListener(this);
        this.mIndependentsArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mIndependentsList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mIndependentsList.setIdentifier("IDS_VARIABLE");
        this.mIndependentsList.addVarFilter(spssVarFilter);
        this.mIndependentsList.getModel().addListDataListener(this);
        this.mIndependentsArrowButton.registerVariableList(this.mIndependentsList, SpssArrowButton.ButtonOrientation.left);
        this.mIndependentsArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mIndependentsTimeButton = new JRadioButton(new ToggleButtonAction(this, "IDS_TIME"));
        this.mIndependentsTimeButton.addItemListener(this);
        this.mLinearModelCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_CURVE_ESTIMATION_LINEAR"));
        this.mLinearModelCheckBox.addItemListener(this);
        this.mLogisticsCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_LOGISTIC"));
        this.mLogisticsCheckBox.addItemListener(this);
        this.mUpperBoundsField = new ContextEnabledTextField();
        this.mUpperBoundsField.setDocument((Document)new FixedLengthNumericDocument(20, true, true));
        this.mUpperBoundsField.setAction((Action)new TextFieldAction(this, "IDS_UPPER_BOUND"));
        this.mUpperBoundsField.setEnabled(false);
        this.mUpperBoundsField.setOpaque(false);
        this.mUpperBoundsField.setColumns(4);
        this.mUpperBoundsLabel = DialogUtil.createLabel(this, "IDS_UPPER_BOUND");
        this.mUpperBoundsLabel.setEnabled(false);
        this.mUpperBoundsLabel.setLabelFor((Component)this.mUpperBoundsField);
        this.mModelsPanel = this.setupModelsPanel();
        this.mDisplayAnovaTableCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_DISPLAY_ANOVA_TABLE"));
        this.mIncludeConstantCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_INCLUDE_CONSTANT"));
        this.mPlotModelsCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_PLOT_MODELS"));
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mIncludeConstantCheckBox);
        spssButtonGroup.add(this.mPlotModelsCheckBox);
        this.mTabOrder = new Vector();
    }

    private void setTabPolicy() {
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mVariableRadioButton);
        spssButtonGroup.add(this.mIndependentsTimeButton);
        this.mTabOrder.add(this.mSrcVariableList);
        this.mTabOrder.add(this.mDepArrowButton);
        this.mTabOrder.add(this.mIndependentsArrowButton);
        this.mTabOrder.add(this.mCaseLabelsArrowButton);
        this.mTabOrder.add(this.mDependentsList);
        this.mTabOrder.add(spssButtonGroup);
        this.mTabOrder.add(this.mIndependentsList);
        this.mTabOrder.add(this.mCaseLabelsList);
        this.mTabOrder.add(this.mIncludeConstantCheckBox);
        this.mTabOrder.add(this.mPlotModelsCheckBox);
        this.mTabOrder.add(this.mLinearModelCheckBox);
        this.mTabOrder.add(this.mLog);
        this.mTabOrder.add(this.mInverse);
        this.mTabOrder.add(this.mQuadratic);
        this.mTabOrder.add(this.mCurveEstCubic);
        this.mTabOrder.add(this.mPower);
        this.mTabOrder.add(this.mCompound);
        this.mTabOrder.add(this.mS);
        this.mTabOrder.add(this.mLogisticsCheckBox);
        this.mTabOrder.add(this.mGrowth);
        this.mTabOrder.add(this.mExponential);
        this.mTabOrder.add(this.mUpperBoundsField);
        this.mTabOrder.add(this.mDisplayAnovaTableCheckBox);
        this.mTabOrder.add(this.mSaveButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.mTabOrder.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mTabOrder, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setDefaults() {
        this.mSrcVariableList.loadFromActiveDataset();
        this.mCaseLabelsList.getModel().removeAll();
        this.mDependentsList.getModel().removeAll();
        this.mIndependentsList.getModel().removeAll();
        this.mDisplayAnovaTableCheckBox.setSelected(false);
        this.mIncludeConstantCheckBox.setSelected(true);
        this.mPlotModelsCheckBox.setSelected(true);
        ComponentWalker componentWalker = new ComponentWalker(){

            @Override
            public void walkingOverJCheckBox(JCheckBox jCheckBox) {
                jCheckBox.setSelected(false);
            }
        };
        componentWalker.walk(this.mModelsPanel);
        this.mLinearModelCheckBox.setSelected(true);
        this.mVariableRadioButton.setSelected(true);
        this.mSrcVariableList.requestFocus();
        if (this.mSrcVariableList.getModel().getSize() > 0) {
            this.mSrcVariableList.setSelectedIndex(0);
        }
        this.mUpperBoundsField.setText("");
    }

    private JPanel setupCaseLabelsPanel() {
        this.mCaseLabelsArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        JScrollPane jScrollPane = new JScrollPane(this.mCaseLabelsList);
        jScrollPane.setPreferredSize(this.mCaseLabelsList.getMinimumSize());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_CASE_LABELS");
        jLabel.setLabelFor(this.mCaseLabelsList);
        this.mCaseLabelsArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mCaseLabelsArrowButton.registerVariableList(this.mCaseLabelsList, SpssArrowButton.ButtonOrientation.left);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        DialogUtil.addUsingGBL(jPanel, this.mCaseLabelsArrowButton, gridBagConstraints, 0, 0, 1, 1, 20, new Insets(0, DialogUtil.getArrowButtonInsets().left + 12, 0, DialogUtil.getArrowButtonInsets().right));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, 23, new Insets(0, 0, DialogUtil.getGroupBoxInnerMargin() * 4, 0));
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 0, 1, 1, 20, new Insets(0, 0, 0, 8));
        return jPanel;
    }

    private JPanel setupDependentsPanel() {
        this.mDepArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_DEPENDENTS");
        jLabel.setLabelFor(this.mDependentsList);
        JScrollPane jScrollPane = new JScrollPane(this.mDependentsList);
        this.mDependentsList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mDependentsList.getFixedCellHeight() * 3 + 2));
        jScrollPane.setPreferredSize(this.mDependentsList.getMinimumSize());
        this.mDepArrowButton.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mDepArrowButton.registerVariableList(this.mDependentsList, SpssArrowButton.ButtonOrientation.left);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        DialogUtil.addUsingGBL(jPanel, this.mDepArrowButton, gridBagConstraints, 0, 0, 1, 2, 10, new Insets(DialogUtil.getArrowButtonInsets().top, DialogUtil.getArrowButtonInsets().left + 12, DialogUtil.getArrowButtonInsets().bottom, DialogUtil.getArrowButtonInsets().right));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, 23, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, 23, new Insets(1, 0, 1, 8));
        return jPanel;
    }

    private JPanel setupIndependentsPanel() {
        JScrollPane jScrollPane = new JScrollPane(this.mIndependentsList);
        jScrollPane.setPreferredSize(this.mIndependentsList.getMinimumSize());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_INDEPENDENT")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mVariableRadioButton, gridBagConstraints, 0, 0, 2, 1, 23, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mIndependentsArrowButton, gridBagConstraints, 0, 1, 1, 1, 20, new Insets(0, DialogUtil.getArrowButtonInsets().left - 1, 0, DialogUtil.getArrowButtonInsets().right));
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, 20, new Insets(0, 0, 0, 3));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mIndependentsTimeButton, gridBagConstraints, 0, 2, 2, 1, 23, null);
        return jPanel;
    }

    private JPanel setupModelsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_MODELS")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        DialogUtil.addUsingGBL(jPanel, this.mLinearModelCheckBox, gridBagConstraints, 0, 0, 1, 1, 23, DialogUtil.getStandardControlInsets());
        this.mQuadratic = new JCheckBox(new ToggleButtonAction(this, "IDS_QURADRATIC"));
        this.mQuadratic.addItemListener(this);
        DialogUtil.addUsingGBL(jPanel, this.mQuadratic, gridBagConstraints, 1, 0, 1, 1, 23, DialogUtil.getStandardControlInsets());
        this.mCompound = new JCheckBox(new ToggleButtonAction(this, "IDS_COMPOUND"));
        this.mCompound.addItemListener(this);
        DialogUtil.addUsingGBL(jPanel, this.mCompound, gridBagConstraints, 2, 0, 1, 1, 23, DialogUtil.getStandardControlInsets());
        this.mGrowth = new JCheckBox(new ToggleButtonAction(this, "IDS_GROWTH"));
        this.mGrowth.addItemListener(this);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mGrowth, gridBagConstraints, 3, 0, 1, 1, 23, DialogUtil.getStandardControlInsets());
        this.mLog = new JCheckBox(new ToggleButtonAction(this, "IDS_LOGARITHMIC"));
        this.mLog.addItemListener(this);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mLog, gridBagConstraints, 0, 1, 1, 1, 23, DialogUtil.getStandardControlInsets());
        this.mCurveEstCubic = new JCheckBox(new ToggleButtonAction(this, "IDS_CURVE_ESTIMATION_CUBIC"));
        this.mCurveEstCubic.addItemListener(this);
        DialogUtil.addUsingGBL(jPanel, this.mCurveEstCubic, gridBagConstraints, 1, 1, 1, 1, 23, DialogUtil.getStandardControlInsets());
        this.mS = new JCheckBox(new ToggleButtonAction(this, "IDS_S"));
        this.mS.addItemListener(this);
        DialogUtil.addUsingGBL(jPanel, this.mS, gridBagConstraints, 2, 1, 1, 1, 23, DialogUtil.getStandardControlInsets());
        this.mExponential = new JCheckBox(new ToggleButtonAction(this, "IDS_EXPONENTIAL"));
        this.mExponential.addItemListener(this);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mExponential, gridBagConstraints, 3, 1, 1, 1, 23, DialogUtil.getStandardControlInsets());
        this.mInverse = new JCheckBox(new ToggleButtonAction(this, "IDS_INVERSE"));
        this.mInverse.addItemListener(this);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mInverse, gridBagConstraints, 0, 2, 1, 1, 23, DialogUtil.getStandardControlInsets());
        this.mPower = new JCheckBox(new ToggleButtonAction(this, "IDS_POWER"));
        this.mPower.addItemListener(this);
        DialogUtil.addUsingGBL(jPanel, this.mPower, gridBagConstraints, 1, 2, 1, 1, 23, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, this.mLogisticsCheckBox, gridBagConstraints, 2, 2, 1, 1, 23, DialogUtil.getStandardControlInsets());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel2, this.mUpperBoundsLabel, gridBagConstraints2, 0, 0, 1, 1, 21, new Insets(1, 15, 1, 2));
        gridBagConstraints2.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mUpperBoundsField, gridBagConstraints2, 1, 0, 1, 1, 21, DialogUtil.getStandardControlInsets());
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints2, 2, 3, 2, 1, 23, DialogUtil.getStandardControlInsets());
        spssButtonGroup.add(this.mLinearModelCheckBox);
        spssButtonGroup.add(this.mLog);
        spssButtonGroup.add(this.mInverse);
        spssButtonGroup.add(this.mQuadratic);
        spssButtonGroup.add(this.mCurveEstCubic);
        spssButtonGroup.add(this.mPower);
        spssButtonGroup.add(this.mCompound);
        spssButtonGroup.add(this.mS);
        spssButtonGroup.add(this.mLogisticsCheckBox);
        spssButtonGroup.add(this.mGrowth);
        spssButtonGroup.add(this.mExponential);
        return jPanel;
    }

    private JPanel setupRestOfThingsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.setupRightCheckboxPanel(), gridBagConstraints, 1, 0, 1, 3, 23, new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0));
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setupDependentsPanel(), gridBagConstraints, 0, 0, 1, 1, 23, null);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.setupIndependentsPanel(), gridBagConstraints, 0, 1, 1, 1, 23, new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0));
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.setupCaseLabelsPanel(), gridBagConstraints, 0, 2, 1, 1, 23, null);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mModelsPanel, gridBagConstraints, 0, 3, 2, 1, 23, new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0));
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mDisplayAnovaTableCheckBox, gridBagConstraints, 0, 4, 2, 1, 23, new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0));
        return jPanel;
    }

    private JPanel setupRightCheckboxPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mIncludeConstantCheckBox, gridBagConstraints, 0, 0, 1, 1, 25, null);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mPlotModelsCheckBox, gridBagConstraints, 0, 1, 1, 1, 25, null);
        return jPanel;
    }

    private final class CheckboxesSelectedCounter
    extends ComponentWalker {
        private int mNoOfCheckedCheckboxes;

        private CheckboxesSelectedCounter() {
        }

        public int getNoOfCheckedCheckboxes() {
            return this.mNoOfCheckedCheckboxes;
        }

        @Override
        public void walkingOverJCheckBox(JCheckBox jCheckBox) {
            if (jCheckBox.isSelected()) {
                ++this.mNoOfCheckedCheckboxes;
            }
        }
    }
}

