/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.regression.binary_logistic;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.dialogs.base.analyze.regression.binary_logistic.BinaryLogisticDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.uitools.controls.FloatDocument;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

class BinaryLogisticSetRules
extends BaseSubDialog
implements DocumentListener {
    public static String RULE_KEY = "RULE_KEY";
    private JComboBox mRuleCombo;
    private FloatTextField mValueText;
    private String mVarNameStr;
    private String[] mComboItems;

    public BinaryLogisticSetRules(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_REG_BL_DEFINE_RULES_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_LREG_VAL";
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mValueText.getText().length() > 0) {
            this.enableContinue(true);
        } else {
            this.enableContinue(false);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mValueText.getText().length() > 0) {
            this.enableContinue(true);
        } else {
            this.enableContinue(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.mValueText.getText().length() > 0) {
            this.enableContinue(true);
        } else {
            this.enableContinue(false);
        }
    }

    @Override
    public boolean continuePressed() {
        if (this.mValueText.getText().equals(".") || this.mValueText.getText().equals("-") || this.mValueText.getText().equals("+")) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_REG_BL_RULE_INVALID_VAL"), VersionInfo.getAppVersionString());
        }
        double d = Double.parseDouble(this.mValueText.getText());
        return true;
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        super.saveState(dialogDataModel);
        if (this.mRuleCombo.getSelectedItem().equals(this.mComboItems[0])) {
            dialogDataModel.putString(RULE_KEY, "=" + this.mValueText.getText());
        }
        if (this.mRuleCombo.getSelectedItem().equals(this.mComboItems[1])) {
            dialogDataModel.putString(RULE_KEY, "~=" + this.mValueText.getText());
        }
        if (this.mRuleCombo.getSelectedItem().equals(this.mComboItems[2])) {
            dialogDataModel.putString(RULE_KEY, "<" + this.mValueText.getText());
        }
        if (this.mRuleCombo.getSelectedItem().equals(this.mComboItems[3])) {
            dialogDataModel.putString(RULE_KEY, "<=" + this.mValueText.getText());
        }
        if (this.mRuleCombo.getSelectedItem().equals(this.mComboItems[4])) {
            dialogDataModel.putString(RULE_KEY, ">" + this.mValueText.getText());
        }
        if (this.mRuleCombo.getSelectedItem().equals(this.mComboItems[5])) {
            dialogDataModel.putString(RULE_KEY, ">=" + this.mValueText.getText());
        }
        return true;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        if (dialogDataModel.getString(RULE_KEY) != null) {
            String[] stringArray;
            String string = dialogDataModel.getString(RULE_KEY);
            if (string.contains("=")) {
                this.mRuleCombo.setSelectedItem(this.mComboItems[0]);
                stringArray = string.split("=");
                this.mVarNameStr = stringArray[0];
                this.mValueText.setText(stringArray[1]);
            }
            if (string.contains("~=")) {
                this.mRuleCombo.setSelectedItem(this.mComboItems[1]);
                stringArray = string.split("~=");
                this.mVarNameStr = stringArray[0];
                this.mValueText.setText(stringArray[1]);
            }
            if (string.contains("<")) {
                this.mRuleCombo.setSelectedItem(this.mComboItems[2]);
                stringArray = string.split("<");
                this.mVarNameStr = stringArray[0];
                this.mValueText.setText(stringArray[1]);
            }
            if (string.contains("<=")) {
                this.mRuleCombo.setSelectedItem(this.mComboItems[3]);
                stringArray = string.split("<=");
                this.mVarNameStr = stringArray[0];
                this.mValueText.setText(stringArray[1]);
            }
            if (string.contains(">")) {
                this.mRuleCombo.setSelectedItem(this.mComboItems[4]);
                stringArray = string.split(">");
                this.mVarNameStr = stringArray[0];
                this.mValueText.setText(stringArray[1]);
            }
            if (string.contains(">=")) {
                this.mRuleCombo.setSelectedItem(this.mComboItems[5]);
                stringArray = string.split(">=");
                this.mVarNameStr = stringArray[0];
                this.mValueText.setText(stringArray[1]);
            }
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        JLabel jLabel = new JLabel(this.getResString("IDS_REG_BL_DEFINE_RULES_LABEL"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JLabel jLabel2 = new JLabel(this.mVarNameStr);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_REG_BL_VALUE_LABEL");
        jLabel3.setLabelFor((Component)this.mValueText);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mRuleCombo, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mValueText, gridBagConstraints, 1, 3, 1, 1, n, insets);
        this.pack();
    }

    private void initVars() {
        this.mComboItems = this.getResStringArray("IDS_REG_BL_RULES_COMBO");
        this.mRuleCombo = new JComboBox<String>(this.mComboItems);
        this.mValueText = new FloatTextField();
        FloatDocument floatDocument = new FloatDocument();
        this.mValueText.setDocument((Document)floatDocument);
        this.mValueText.getDocument().addDocumentListener(this);
        this.mVarNameStr = ((BinaryLogisticDlg)this.mParentDlg).getVarName();
        this.setDefaults();
    }

    private void setDefaults() {
        this.enableContinue(false);
    }
}

