/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.regression.binary_logistic;

import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

class BinaryLogisticSave
extends BaseSubDialog {
    static final String PROBABILITY_KEY = "IDS_REG_BL_SAVE_PROBABILITIES_CHECK";
    static final String GROUP_MEM_KEY = "IDS_REG_BL_SAVE_GROUP_MEM_CHECK";
    static final String COOKS_KEY = "IDS_REG_BL_SAVE_COOKS_CHECK";
    static final String LEVERAGE_KEY = "IDS_REG_BL_SAVE_LEVERAGE_CHECK";
    static final String DF_BETA_KEY = "IDS_REG_BL_SAVE_DFBETA_CHECK";
    static final String UNSTANDARD_KEY = "IDS_REG_BL_SAVE_UNSTANDARDIZE_CHECK";
    static final String LOGIT_KEY = "IDS_REG_BL_SAVE_LOGIT_CHECK";
    static final String STUDENT_KEY = "IDS_REG_BL_SAVE_STUDENTIZE_CHECK";
    static final String STANDARD_KEY = "IDS_REG_BL_SAVE_STANDARDIZED_CHECK";
    static final String DEVIANCE_KEY = "IDS_REG_BL_SAVE_DEVIANCE_CHECK";
    static final String INCLUDE_KEY = "IDS_REG_BL_SAVE_INCLUDE_COVARIANCE_CHECK";
    private JCheckBox mProbabilitiesCheckBox;
    private JCheckBox mGroupMemCheckBox;
    private JCheckBox mCooksCheckBox;
    private JCheckBox mLeverageCheckBox;
    private JCheckBox mDfBetaCheckBox;
    private JCheckBox mUnstandardizedCheckBox;
    private JCheckBox mLogitCheckBox;
    private JCheckBox mStudentizedCheckBox;
    private JCheckBox mStandardizedCheckBox;
    private JCheckBox mDevianceCheckBox;
    private FileTextField mFileTextField;
    private JButton mBrowseButton;
    private JCheckBox mIncludeCovarianceCheckButton;

    public BinaryLogisticSave(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_REG_BL_SAVE_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_LREG_SAV";
    }

    @Override
    public boolean continuePressed() {
        if (!RemoteFileChooser.enableSaveInModeler()) {
            return true;
        }
        boolean bl = FileValidator.validatePath((Component)((Object)this), this.mFileTextField.getText(), true, DataServerProxy.getDataProxy().isRemoteConnection());
        if (!bl) {
            this.mFileTextField.requestFocus();
        }
        return bl;
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        dialogDataModel.putString("EXPORT_XML_FILE_PATH", this.mFileTextField.getText());
        return super.saveState(dialogDataModel);
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        if (dialogDataModel.getString("EXPORT_XML_FILE_PATH") != null) {
            this.mFileTextField.setText(dialogDataModel.getString("EXPORT_XML_FILE_PATH"));
        }
        super.loadState(dialogDataModel);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, 0, 0);
        JPanel jPanel2 = new JPanel(true);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel2 = this.setupPredictedValuesPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        jPanel2 = this.setupInfluencePanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        jPanel2 = this.setupResidualsPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 2, n, insets);
        jPanel2 = this.setupExportPanel();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 2, 1, n, insets);
        this.setTabTraversalOrder();
        this.pack();
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mProbabilitiesCheckBox);
        vector.add(this.mGroupMemCheckBox);
        vector.add(this.mCooksCheckBox);
        vector.add(this.mLeverageCheckBox);
        vector.add(this.mDfBetaCheckBox);
        vector.add(this.mUnstandardizedCheckBox);
        vector.add(this.mLogitCheckBox);
        vector.add(this.mStudentizedCheckBox);
        vector.add(this.mStandardizedCheckBox);
        vector.add(this.mDevianceCheckBox);
        vector.add(this.mFileTextField);
        vector.add(this.mBrowseButton);
        vector.add(this.mIncludeCovarianceCheckButton);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private JPanel setupPredictedValuesPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mProbabilitiesCheckBox, this.mGroupMemCheckBox};
        return PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_REG_BL_PROBABILITIES_BORDER_TITLE"));
    }

    private JPanel setupInfluencePanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mCooksCheckBox, this.mLeverageCheckBox, this.mDfBetaCheckBox};
        return PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_REG_BL_INFLUENECE_BORDER_TITLE"));
    }

    private JPanel setupResidualsPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mUnstandardizedCheckBox, this.mLogitCheckBox, this.mStudentizedCheckBox, this.mStandardizedCheckBox, this.mDevianceCheckBox};
        return PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_REG_BL_RESIDUAL_BORDER_TITLE"));
    }

    private JPanel setupExportPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n, 0, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileTextField), gridBagConstraints, 0, 0, 1, 1, n2, null);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        n2 = 23;
        insets.top = n;
        DialogUtil.addUsingGBL(jPanel, this.mIncludeCovarianceCheckButton, gridBagConstraints, 0, 1, 1, 1, n2, null);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_REG_BL_EXPORT_BORDER_TITLE");
        jPanel = PanelFactory.setupMnemonickey(jPanel, jLabel);
        return jPanel;
    }

    private void performSave() {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        remoteFileChooser.setDialogTitle(this.getResString("IDS_REG_BL_SAVE_FILE_TITLE"));
        RefFileFilter refFileFilter = new RefFileFilter(this.getResString("IDS_REG_BL_SAVE_FILE_DESC"), this.getResString("IDS_REG_BL_SAVE_FILE_EXT"));
        remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
        int n = remoteFileChooser.showSaveDialog(this.getParent());
        if (n == 0) {
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            String string = remoteFileChooser.getSelectedFilePath();
            if (!string.endsWith(this.getResString("IDS_REG_BL_SAVE_FILE_EXT"))) {
                string = string + this.getResString("IDS_REG_BL_SAVE_FILE_EXT");
            }
            this.mFileTextField.setText(string);
        }
    }

    private void initVars() {
        this.mFileTextField = new FileTextField();
        FixedLengthDocument fixedLengthDocument = new FixedLengthDocument(255);
        this.mFileTextField.setDocument(fixedLengthDocument);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, PROBABILITY_KEY);
        this.mProbabilitiesCheckBox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, GROUP_MEM_KEY);
        this.mGroupMemCheckBox = new JCheckBox(toggleButtonAction);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mProbabilitiesCheckBox);
        spssButtonGroup.add(this.mGroupMemCheckBox);
        toggleButtonAction = new ToggleButtonAction(this, COOKS_KEY);
        this.mCooksCheckBox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, LEVERAGE_KEY);
        this.mLeverageCheckBox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, DF_BETA_KEY);
        this.mDfBetaCheckBox = new JCheckBox(toggleButtonAction);
        SpssButtonGroup spssButtonGroup2 = new SpssButtonGroup();
        spssButtonGroup2.add(this.mCooksCheckBox);
        spssButtonGroup2.add(this.mLeverageCheckBox);
        spssButtonGroup2.add(this.mDfBetaCheckBox);
        toggleButtonAction = new ToggleButtonAction(this, UNSTANDARD_KEY);
        this.mUnstandardizedCheckBox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, LOGIT_KEY);
        this.mLogitCheckBox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, STUDENT_KEY);
        this.mStudentizedCheckBox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, STANDARD_KEY);
        this.mStandardizedCheckBox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, DEVIANCE_KEY);
        this.mDevianceCheckBox = new JCheckBox(toggleButtonAction);
        SpssButtonGroup spssButtonGroup3 = new SpssButtonGroup();
        spssButtonGroup3.add(this.mUnstandardizedCheckBox);
        spssButtonGroup3.add(this.mLogitCheckBox);
        spssButtonGroup3.add(this.mStudentizedCheckBox);
        spssButtonGroup3.add(this.mStandardizedCheckBox);
        spssButtonGroup3.add(this.mDevianceCheckBox);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_REG_BL_SAVE_BROWSE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BinaryLogisticSave.this.performSave();
            }
        };
        this.mBrowseButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, INCLUDE_KEY);
        this.mIncludeCovarianceCheckButton = new JCheckBox(toggleButtonAction);
        this.mFileTextField.setFocusable(true);
        this.SetDefaults();
    }

    private void SetDefaults() {
        this.mIncludeCovarianceCheckButton.setSelected(true);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mFileTextField.setEnabled(false);
            this.mBrowseButton.setEnabled(false);
        }
    }
}

