/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.regression.binary_logistic;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class BinaryLogisticOptions
extends BaseSubDialog
implements ItemListener,
DocumentListener {
    static final String PLOT_KEY = "IDS_REG_BL_OPTIONS_CLASSIFICATION_PLOTS_CHECK";
    static final String GOODNESS_KEY = "IDS_REG_BL_OPTIONS_HOSMER_CHECK";
    static final String OUTLIER_TEXT_KEY = "OUTLIER_TEXT_KEY";
    static final String CASEWISE_KEY = "IDS_REG_BL_OPTIONS_RESIDUAL_CHECK";
    static final String OUTLIER_KEY = "IDS_REG_BL_OPTIONS_OUTLIERS_RADIO";
    static final String ALLCASES_KEY = "IDS_REG_BL_OPTIONS_ALLCASES_RADIO";
    static final String CORR_KEY = "IDS_REG_BL_OPTIONS_CORR_ESTI_CHECK";
    static final String ITER_KEY = "IDS_REG_BL_OPTIONS_ITERATION_CHECK";
    static final String CI_KEY = "IDS_REG_BL_OPTIONS_CI_CHECK";
    static final String CI_TEXT_KEY = "CI_TEXT_KEY";
    static final String EACH_STEP_KEY = "IDS_REG_BL_OPTIONS_EACHSTEP_RADIO";
    static final String LAST_STEP_KEY = "IDS_REG_BL_OPTIONS_LASTSTEP_RADIO";
    static final String ENTRY_KEY = "ENTRY_KEY";
    static final String REMOVAL_KEY = "REMOVAL_KEY";
    static final String CUTOFF_KEY = "CUTOFF_KEY";
    static final String ITERATE_KEY = "ITERATE_KEY";
    static final String CONSERVE_MEMORY_KEY = "IDS_REG_BL_OPTIONS_CONSERVE_MEMORY";
    static final String INCLUDE_CONST_KEY = "IDS_REG_BL_OPTIONS_INCLUDE_CONST_CHECK";
    private JCheckBox mCasewiseCheck;
    private JRadioButton mOutlierRadio;
    private JRadioButton mAllCases;
    private FloatTextField mOutlierText;
    private JLabel mOutlierLabel;
    private JCheckBox mCICheck;
    private FloatTextField mCIText;
    private FloatTextField mEntryText;
    private FloatTextField mRemovalText;
    private FloatTextField mClsfText;
    private IntTextField mIterText;
    private JCheckBox mClassificationCheck;
    private JCheckBox mHosmerCheck;
    private JCheckBox mCorrelationCheck;
    private JCheckBox mIterationCheck;
    private JRadioButton mEachStepRadio;
    private JRadioButton mLastStepRadio;
    private JCheckBox mConserveMemory;
    private JCheckBox mIncludeConstCheck;
    private SpssButtonGroup mDisplayGroup;

    public BinaryLogisticOptions(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_REG_BL_OPTIONS_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_LREG_OPT";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.mCasewiseCheck.isSelected()) {
            this.mOutlierRadio.setEnabled(true);
            this.mOutlierLabel.setEnabled(true);
            this.mAllCases.setEnabled(true);
        } else {
            this.mOutlierRadio.setEnabled(false);
            this.mOutlierLabel.setEnabled(false);
            this.mAllCases.setEnabled(false);
        }
        if (this.mCICheck.isSelected()) {
            this.mCIText.setEnabled(true);
            this.mCIText.setOpaque(true);
        } else {
            this.mCIText.setEnabled(false);
            this.mCIText.setOpaque(false);
        }
        this.mOutlierText.setEnabled(this.mCasewiseCheck.isSelected() && this.mOutlierRadio.isSelected());
        this.mOutlierText.setOpaque(this.mCasewiseCheck.isSelected() && this.mOutlierRadio.isSelected());
        this.updateContinueButton();
    }

    private void updateContinueButton() {
        if (this.mEntryText.getText().length() == 0 || this.mRemovalText.getText().length() == 0 || this.mClsfText.getText().length() == 0 || this.mIterText.getText().length() == 0) {
            this.enableContinue(false);
        } else if (this.mCasewiseCheck.isSelected() && this.mOutlierRadio.isSelected() && this.mOutlierText.getText().length() == 0) {
            this.enableContinue(false);
        } else if (this.mCICheck.isSelected() && this.mCIText.getText().length() == 0) {
            this.enableContinue(false);
        } else {
            this.enableContinue(true);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        dialogDataModel.putString(OUTLIER_TEXT_KEY, this.mOutlierText.getText());
        dialogDataModel.putString(CI_TEXT_KEY, this.mCIText.getText());
        dialogDataModel.putString(ENTRY_KEY, this.mEntryText.getText());
        dialogDataModel.putString(REMOVAL_KEY, this.mRemovalText.getText());
        dialogDataModel.putString(CUTOFF_KEY, this.mClsfText.getText());
        return super.saveState(dialogDataModel);
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        if (dialogDataModel.getString(OUTLIER_TEXT_KEY) != null) {
            this.mOutlierText.setText(dialogDataModel.getString(OUTLIER_TEXT_KEY));
        }
        if (dialogDataModel.getString(CI_TEXT_KEY) != null) {
            this.mCIText.setText(dialogDataModel.getString(CI_TEXT_KEY));
        }
        if (dialogDataModel.getString(ENTRY_KEY) != null) {
            this.mEntryText.setText(dialogDataModel.getString(ENTRY_KEY));
        }
        if (dialogDataModel.getString(REMOVAL_KEY) != null) {
            this.mRemovalText.setText(dialogDataModel.getString(REMOVAL_KEY));
        }
        if (dialogDataModel.getString(CUTOFF_KEY) != null) {
            this.mClsfText.setText(dialogDataModel.getString(CUTOFF_KEY));
        }
        super.loadState(dialogDataModel);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, 0, 0);
        jPanel2 = this.setupStatisticsPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 3, 2, n, insets);
        jPanel2 = this.setupProbabilityPanel();
        gridBagConstraints.fill = 1;
        insets.top = n2;
        insets.right = 2;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 2, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets.top = n2 + 7;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_REG_BL_OPTIONS_CLSF_CUTOFF_LABEL");
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 2, 1, 1, n, insets);
        jLabel.setLabelFor((Component)this.mClsfText);
        gridBagConstraints.weightx = 0.0;
        this.mClsfText.setColumns(3);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mClsfText, gridBagConstraints, 2, 2, 1, 1, n, insets);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_REG_BL_OPTIONS_MAX_ITER_LABEL");
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        insets.top = n2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 1, 3, 1, 1, n, insets);
        jLabel2.setLabelFor((Component)this.mIterText);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mIterText, gridBagConstraints, 2, 3, 1, 1, n, insets);
        this.mConserveMemory.setSelected(false);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.left = n2 + 4;
        DialogUtil.addUsingGBL(jPanel, this.mConserveMemory, gridBagConstraints, 0, 4, 1, 1, n, insets);
        this.mIncludeConstCheck.setSelected(true);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.left = n2 + 4;
        DialogUtil.addUsingGBL(jPanel, this.mIncludeConstCheck, gridBagConstraints, 0, 5, 1, 1, n, insets);
        this.setTabTraversalOrder();
        this.pack();
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mOutlierRadio);
        spssButtonGroup.add(this.mAllCases);
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mClassificationCheck);
        vector.add(this.mHosmerCheck);
        vector.add(this.mCasewiseCheck);
        vector.add(this.mCorrelationCheck);
        vector.add(this.mIterationCheck);
        vector.add(this.mCICheck);
        vector.add(this.mCIText);
        vector.add(spssButtonGroup);
        vector.add(this.mOutlierText);
        vector.add(this.mDisplayGroup);
        vector.add(this.mEntryText);
        vector.add(this.mRemovalText);
        vector.add(this.mClsfText);
        vector.add(this.mIterText);
        vector.add(this.mConserveMemory);
        vector.add(this.mIncludeConstCheck);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private JPanel setupStatisticsPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setOpaque(false);
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_REG_BL_OPTIONS_STAT_BORDER_TITLE"));
        titledBorder.getBorderInsets(jPanel, new Insets(0, 0, 0, 0));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n3, n3, DialogUtil.getStandardControlInsets().bottom, n3);
        insets.bottom = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mClassificationCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mHosmerCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCasewiseCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel2, this.mOutlierRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        n = 21;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mOutlierText, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mOutlierLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 3, 1, 1, n, null);
        insets.top = 0;
        insets.left = n3;
        DialogUtil.addUsingGBL(jPanel, this.mAllCases, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        insets.left = n2;
        DialogUtil.addUsingGBL(jPanel, this.mCorrelationCheck, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mIterationCheck, gridBagConstraints, 1, 1, 1, 1, n, insets);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        n = 23;
        DialogUtil.addUsingGBL(jPanel3, this.mCICheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        n = 21;
        DialogUtil.addUsingGBL(jPanel3, (JComponent)this.mCIText, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.left = n3 / 2;
        JLabel jLabel = new JLabel(this.getResString("IDS_REG_BL_OPTIONS_PERCENT_LABEL"));
        DialogUtil.addUsingGBL(jPanel3, jLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 2, 1, 1, n, null);
        JPanel jPanel4 = this.setupDisplayPanel();
        insets.top = 0;
        insets.left = -5;
        insets.right = -5;
        insets.bottom = -5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 5, 3, 1, n, insets);
        this.pack();
        return jPanel;
    }

    private JPanel setupDisplayPanel() {
        this.mDisplayGroup.add(this.mEachStepRadio);
        this.mDisplayGroup.add(this.mLastStepRadio);
        this.mEachStepRadio.setSelected(true);
        JComponent[] jComponentArray = new JComponent[]{this.mEachStepRadio, this.mLastStepRadio};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.xaxis, null);
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_REG_BL_OPTIONS_DISPLAY_BORDER_TITLE"));
        titledBorder.getBorderInsets(jPanel, new Insets(0, 0, 0, 0));
        jPanel.setBorder(titledBorder);
        jPanel.setOpaque(false);
        return jPanel;
    }

    private JPanel setupProbabilityPanel() {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_REG_BL_OPTIONS_ENTRY_LABEL");
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_REG_BL_OPTIONS_REMOVAL_LABEL");
        this.mEntryText.setColumns(3);
        this.mRemovalText.setColumns(3);
        jLabel.setLabelFor((Component)this.mEntryText);
        jLabel2.setLabelFor((Component)this.mRemovalText);
        JComponent[] jComponentArray = new JComponent[]{jLabel, this.mEntryText, jLabel2, this.mRemovalText};
        return PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.xaxis, this.getResString("IDS_REG_BL_OPTIONS_PROB_STEP_BORDER_TITLE"));
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, PLOT_KEY);
        this.mClassificationCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, GOODNESS_KEY);
        this.mHosmerCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, CASEWISE_KEY);
        this.mCasewiseCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, CORR_KEY);
        this.mCorrelationCheck = new JCheckBox(toggleButtonAction);
        this.mCasewiseCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, ITER_KEY);
        this.mIterationCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, OUTLIER_KEY);
        this.mOutlierRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, ALLCASES_KEY);
        this.mAllCases = new JRadioButton(toggleButtonAction);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mOutlierRadio);
        spssButtonGroup.add(this.mAllCases);
        this.mOutlierRadio.addItemListener(this);
        this.mAllCases.addItemListener(this);
        this.mOutlierText = new FloatTextField(0.0, 9999.0, 3, true);
        this.mOutlierText.setColumns(3);
        this.mOutlierText.setIncludeMinRange(false);
        this.mOutlierText.getDocument().addDocumentListener(this);
        this.mOutlierLabel = new JLabel(this.getResString("IDS_REG_BL_OPTIONS_STDDEV_LABEL"));
        toggleButtonAction = new ToggleButtonAction(this, CI_KEY);
        this.mCICheck = new JCheckBox(toggleButtonAction);
        this.mCICheck.addItemListener(this);
        this.mCIText = new FloatTextField(0.001, 100.0, 5, true);
        this.mCIText.setIncludeMaxRange(false);
        this.mCIText.setColumns(4);
        this.mCIText.getDocument().addDocumentListener(this);
        this.mEntryText = new FloatTextField(0.0, 1.0, 2, true);
        this.mEntryText.setColumns(2);
        this.mEntryText.getDocument().addDocumentListener(this);
        this.mRemovalText = new FloatTextField(0.0, 1.0, 2, true);
        this.mRemovalText.setColumns(2);
        this.mRemovalText.getDocument().addDocumentListener(this);
        this.mClsfText = new FloatTextField(0.0, 1.0, 2, true);
        this.mClsfText.setIncludeMaxRange(false);
        this.mClsfText.setIncludeMinRange(false);
        this.mClsfText.getDocument().addDocumentListener(this);
        this.mIterText = new IntTextField(1, 999, true);
        this.mIterText.setAction((Action)new TextFieldAction(this, ITERATE_KEY));
        this.mIterText.getDocument().addDocumentListener(this);
        toggleButtonAction = new ToggleButtonAction(this, EACH_STEP_KEY);
        this.mEachStepRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, LAST_STEP_KEY);
        this.mLastStepRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, CONSERVE_MEMORY_KEY);
        this.mConserveMemory = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, INCLUDE_CONST_KEY);
        this.mIncludeConstCheck = new JCheckBox(toggleButtonAction);
        this.mDisplayGroup = new SpssButtonGroup();
        SpssButtonGroup spssButtonGroup2 = new SpssButtonGroup();
        spssButtonGroup2.add(this.mClassificationCheck);
        spssButtonGroup2.add(this.mHosmerCheck);
        spssButtonGroup2.add(this.mCasewiseCheck);
        spssButtonGroup2.add(this.mCorrelationCheck);
        spssButtonGroup2.add(this.mIterationCheck);
        spssButtonGroup2.add(this.mCICheck);
        this.setDefault();
    }

    private void setDefault() {
        this.mOutlierRadio.setSelected(true);
        this.mOutlierRadio.setEnabled(false);
        this.mOutlierText.setText("2");
        this.mOutlierText.setEnabled(false);
        this.mOutlierLabel.setEnabled(false);
        this.mAllCases.setEnabled(false);
        this.mCIText.setText("95");
        this.mCIText.setEnabled(false);
        this.mEntryText.setText("0.05");
        this.mRemovalText.setText("0.10");
        this.mClsfText.setText("0.5");
        this.mIterText.setText("20");
        this.mConserveMemory.setSelected(false);
    }
}

