/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.quality_control.pareto_charts;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.base.graphs.ImageLabelKeyListener;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImage;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImagesGroup;
import com.spss.java_client.ui.dialogs.common.BaseGatingDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class ParetoChartsDlg
extends BaseGatingDialog {
    private GridBagConstraints mConstraints;
    private Insets mInsets;
    private JRadioButton mGroupsRadioButton;
    private JRadioButton mSeparateVariablesRadioButton;
    private JRadioButton mIndividualCasesRadioButton;
    private SpssButtonGroup mParetoGroup;
    private JLabel mSimpleLabel;
    private JLabel mStackedLabel;
    private MatrixImage mSimpleBarImageLabel;
    private MatrixImage mStackedImageLabel;
    private MatrixImagesGroup mParetoImageLabelGroup;

    public ParetoChartsDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_PARETO_CHARTS_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_gpar";
    }

    @Override
    public String getIActionKey() {
        return "analyze_qlty_cont__pareto";
    }

    @Override
    public String getNextProcDlgActionKey() {
        if (this.mGroupsRadioButton.isSelected() && this.mParetoImageLabelGroup.isSelected(this.mSimpleBarImageLabel)) {
            return "analyze_qlty_cont_pareto_simple_group_of_cases";
        }
        if (this.mGroupsRadioButton.isSelected() && this.mParetoImageLabelGroup.isSelected(this.mStackedImageLabel)) {
            return "analyze_qlty_cont_pareto_stacked_group_of_cases";
        }
        if (this.mSeparateVariablesRadioButton.isSelected() && this.mParetoImageLabelGroup.isSelected(this.mSimpleBarImageLabel)) {
            return "analyze_qlty_cont_pareto_simple_sums_of_separate_var";
        }
        if (this.mSeparateVariablesRadioButton.isSelected() && this.mParetoImageLabelGroup.isSelected(this.mStackedImageLabel)) {
            return "analyze_qlty_cont_pareto_stacked_sums_of_separate_var";
        }
        if (this.mIndividualCasesRadioButton.isSelected() && this.mParetoImageLabelGroup.isSelected(this.mSimpleBarImageLabel)) {
            return "analyze_qlty_cont_pareto_simple_individual_cases";
        }
        return "analyze_qlty_cont_pareto_stacked_individual_cases";
    }

    @Override
    public boolean continuePressed() {
        return true;
    }

    @Override
    public void loadDialogState() {
        Integer n = this.mDialogDataModel.getInteger("IDS_PARETO_SELECTED_IMAGE");
        if (n != null) {
            this.setImageSelected(n);
        }
        super.loadDialogState();
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
        this.mDialogDataModel.putInteger("IDS_PARETO_SELECTED_IMAGE", this.getSelectedImageIndex());
    }

    @Override
    protected void init() {
        super.init();
        this.renameContinueAction("IDS_DEFINE");
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        this.setUpUI(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void setUpUI(JPanel jPanel) {
        JPanel jPanel2 = this.setupRadioButtonPanel();
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        JPanel jPanel3 = this.setupImageLabelPanel();
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, this.mConstraints, 0, 0, 1, 1, 23, null);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mConstraints, 0, 1, 2, 1, 23, this.mInsets);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            vector.add(this.mDefineButton);
            vector.add(this.mSimpleBarImageLabel);
            vector.add(this.mParetoGroup);
            vector.add(this.mHelpButton);
            vector.add(this.mCancelButton);
        } else {
            vector.add(this.mDefineButton);
            vector.add(this.mCancelButton);
            vector.add(this.mHelpButton);
            vector.add(this.mStackedImageLabel);
            vector.add(this.mParetoGroup);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void initVars() {
        this.mParetoImageLabelGroup = new MatrixImagesGroup();
        this.mParetoImageLabelGroup = new MatrixImagesGroup();
        this.mSimpleLabel = new JLabel(this.getResString("IDS_PARETO_SIMPLE"));
        this.mSimpleBarImageLabel = new MatrixImage(this.getResImageURL("IDS_PARETO_SIMPLE_IMAGE"));
        this.mSimpleBarImageLabel.setImageLabelGroup(this.mParetoImageLabelGroup);
        this.mStackedLabel = new JLabel(this.getResString("IDS_PARETO_STACKED"));
        this.mStackedImageLabel = new MatrixImage(this.getResImageURL("IDS_PARETO_STACKED_IMAGE"));
        this.mStackedImageLabel.setImageLabelGroup(this.mParetoImageLabelGroup);
        this.mConstraints = new GridBagConstraints();
        this.mGroupsRadioButton = DialogUtil.createRadioButton(this, "IDS_PARETO_COUNTS_OR_SUM_GRPS", null);
        this.mGroupsRadioButton.setSelected(true);
        this.mSeparateVariablesRadioButton = DialogUtil.createRadioButton(this, "IDS_PARETO_SUM_OF_SEPERATE_VAR", null);
        this.mIndividualCasesRadioButton = DialogUtil.createRadioButton(this, "IDS_PARETO_VALUES_INDIVIDUAL_CASES", null);
        this.mParetoGroup = new SpssButtonGroup();
        this.mParetoGroup.add(this.mGroupsRadioButton);
        this.mParetoGroup.add(this.mSeparateVariablesRadioButton);
        this.mParetoGroup.add(this.mIndividualCasesRadioButton);
        Vector<MatrixImage> vector = new Vector<MatrixImage>();
        vector.add(this.mSimpleBarImageLabel);
        vector.add(this.mStackedImageLabel);
        this.mSimpleBarImageLabel.addKeyListener(new ImageLabelKeyListener(vector, this.mParetoImageLabelGroup));
        this.mStackedImageLabel.addKeyListener(new ImageLabelKeyListener(vector, this.mParetoImageLabelGroup));
    }

    private JPanel setupRadioButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_PARETO_DATA_IN_CHART")));
        this.mConstraints.weightx = 1.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mInsets = new Insets(n, n, insets.bottom, n);
        DialogUtil.addUsingGBL(jPanel, this.mGroupsRadioButton, this.mConstraints, 0, 0, 1, 1, 23, this.mInsets);
        this.mInsets.set(0, n, insets.bottom, n);
        DialogUtil.addUsingGBL(jPanel, this.mSeparateVariablesRadioButton, this.mConstraints, 0, 1, 1, 1, 23, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 2;
        this.mInsets.set(0, n, n, n);
        DialogUtil.addUsingGBL(jPanel, this.mIndividualCasesRadioButton, this.mConstraints, 0, 2, 1, 1, 23, this.mInsets);
        return jPanel;
    }

    private JPanel setupImageLabelPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mSimpleBarImageLabel, this.mStackedImageLabel, this.mSimpleLabel, this.mStackedLabel, new JLabel()};
        return PanelFactory.getPanelForImageLabels(jComponentArray, "", 2);
    }

    private int getSelectedImageIndex() {
        int n = -1;
        if (this.mParetoImageLabelGroup.isSelected(this.mSimpleBarImageLabel)) {
            n = 0;
        } else if (this.mParetoImageLabelGroup.isSelected(this.mStackedImageLabel)) {
            n = 1;
        }
        return n;
    }

    private void setImageSelected(int n) {
        switch (n) {
            case 0: {
                this.mSimpleBarImageLabel.setDefaultSelectedImage(true);
                break;
            }
            case 1: {
                this.mStackedImageLabel.setDefaultSelectedImage(true);
            }
        }
    }

    private void setDefaults() {
        this.mStackedImageLabel.setDefaultSelectedImage(false);
        this.mSimpleBarImageLabel.setDefaultSelectedImage(true);
    }
}

