/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.quality_control.pareto_charts;

import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsRemoteFileChooser;
import com.spss.java_client.ui.dialogs.base.graphs.TitlesSubDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DefineStackedIndividualCases
extends BaseProcedureDialog
implements ListDataListener,
ItemListener,
ActionListener {
    private static final String FILE_TEXT_FIELD_KEY = "IDS_STACKED_INDIVIDUAL_FILE_TEXT_FIELD_KEY";
    private static final String SUM_OF_VAR_TARGET_LIST_KEY = "IDS_STACKED_INDIVIDUAL_SUM_OF_VAR_TARGET_LIST_KEY";
    private static final String VALUES_TARGET_LIST_KEY = "IDS_STACKED_INDIVIDUAL_VALUE_TARGET_LIST_KEY";
    private static final String ROWS_TARGET_LIST_KEY = "IDS_STACKED_INDIVIDUAL_ROWS_TARGET_LIST_KEY";
    private static final String SIMPLE_CASE_NUMBER_KEY = "IDS_PARETO_CASE_NUMBER";
    private static final String SIMPLE_VARIABLE_KEY = "IDS_PARETO_VARIABLE";
    private static final String SIMPLE_DISPLAY_CUMULATIVE_KEY = "IDS_PARETO_DISPLAY_CUMULATIVE";
    private static final String SIMPLE_NEST_VAR_KEY = "IDS_PARETO_NEST_VAR";
    private static final String SIMPLE_TEMPLATE_CHART_KEY = "IDS_PARETO_TEMPLATE_USE_CHART";
    private SrcVariableList mSrcVarList;
    private JRadioButton mCaseNumbersRadio;
    private JRadioButton mVariableRadio;
    private ArrowButton mVarArrowButton;
    private ArrowButton mRowsArrowButton;
    private ArrowButton mValuesArrowButton;
    private TargetVariableList mTargetVarList;
    private TargetVariableList mRowsTargetVarList;
    private TargetVariableList mValueTargetVarList;
    private JCheckBox mNestVarCheck;
    private JCheckBox mTemplateCheck;
    private JCheckBox mDisplayCumulativeCheck;
    private JButton mFileButton;
    private FileTextField mFileTextField;
    private SpssButtonGroup mCategoryLabelsGroup;

    public DefineStackedIndividualCases(JFrame jFrame) throws HeadlessException {
        super(jFrame, false, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_PARETO_STACKED_INDIVIDUAL_CASES_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String generateSyntax() {
        String string;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("GRAPH"));
        stringBuffer.append("\n");
        if (this.mDisplayCumulativeCheck.isSelected()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/PARETO (CUM STACKED)="));
        } else {
            stringBuffer.append(SyntaxUtil.getSubCommand("/PARETO (NOCUM STACKED)="));
        }
        stringBuffer.append("VALUE(" + this.mValueTargetVarList.getVariablesStringList() + ")");
        if (this.mVariableRadio.isSelected()) {
            stringBuffer.append(" BY " + this.mTargetVarList.getVariablesStringList());
        }
        if (this.mRowsTargetVarList.getModel().getSize() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/PANEL ROWVAR=") + this.mRowsTargetVarList.getVariablesStringList());
            if (this.mNestVarCheck.isSelected()) {
                stringBuffer.append(" ROWOP=NEST");
            } else {
                stringBuffer.append(" ROWOP=CROSS");
            }
        }
        if (this.mTemplateCheck.isSelected()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/TEMPLATE=") + CharacterUtil.smartQuote((String)this.mFileTextField.getText()));
        }
        String string2 = dialogDataModel.getString("IDS_TITLE_LINE1_EDIT");
        String string3 = dialogDataModel.getString("IDS_TITLE_LINE2_EDIT");
        if (string2 != null && string2.length() > 0 || string3 != null && string3.length() > 0) {
            if (string2 != null && string2.length() == 0) {
                string2 = " ";
            }
            if (!(string = (CharacterUtil.smartQuote((String)string2) + " " + CharacterUtil.smartQuote((String)string3)).trim()).equals("")) {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/TITLE=") + string);
            }
        }
        if ((string2 = dialogDataModel.getString("IDS_SUBTITLE_EDIT")) != null && string2.length() > 0 && !(string = CharacterUtil.smartQuote((String)string2).trim()).equals("")) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/SUBTITLE=") + string);
        }
        string2 = dialogDataModel.getString("IDS_FOOTNOTE_LINE1_EDIT");
        string3 = dialogDataModel.getString("IDS_FOOTNOTE_LINE2_EDIT");
        if ((string2 != null && string2.length() > 0 || string3 != null && string3.length() > 0) && !(string = (CharacterUtil.smartQuote((String)string2) + " " + CharacterUtil.smartQuote((String)string3)).trim()).equals("")) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/FOOTNOTE=") + string);
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_gtti";
    }

    @Override
    public String getIActionKey() {
        return "analyze_qlty_cont_pareto_stacked_individual_cases";
    }

    @Override
    public void reset() {
        super.reset();
        this.mValueTargetVarList.removeAll();
        this.mTargetVarList.removeAll();
        this.mRowsTargetVarList.removeAll();
        this.setDefaults();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.setEnabledOkPaste();
        this.setEnabledNestVarCheck();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.setEnabledOkPaste();
        this.setEnabledNestVarCheck();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.setEnabledOkPaste();
        this.setEnabledNestVarCheck();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableArrowButton();
        this.mFileButton.setEnabled(this.mTemplateCheck.isSelected());
        this.mFileTextField.setEnabled(this.mTemplateCheck.isSelected());
        this.setEnabledOkPaste();
    }

    public void enableArrowButton() {
        boolean bl = true;
        if (!this.mVariableRadio.isSelected()) {
            bl = false;
        } else {
            boolean bl2;
            boolean bl3 = this.mSrcVarList.getSelectedValues() != null && this.mSrcVarList.getSelectedValues().length == 1;
            boolean bl4 = bl2 = this.mTargetVarList.getSelectedValues() != null && this.mTargetVarList.getSelectedValues().length > 0;
            if (this.mVarArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.right && (!bl3 || bl2)) {
                bl = false;
            }
            if (!bl2 && this.mVarArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.left) {
                bl = false;
            }
        }
        this.mVarArrowButton.setEnabled(bl);
        this.mTargetVarList.setEnabled(this.mVariableRadio.isSelected());
        this.mTargetVarList.setOpaque(this.mVariableRadio.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.openRemoteFile();
        this.setEnabledOkPaste();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.mFileTextField.getText() != null) {
            this.mFileTextField.setText(this.mFileTextField.getText());
        }
        super.validate();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupComponents(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_REPORT_COMMON_TITLES_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefineStackedIndividualCases.this.runTitlesSubDialog();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        return jPanel;
    }

    private void runTitlesSubDialog() {
        this.runSubDialog(new TitlesSubDialog(this, this.getResString("IDS_PARETO_TITLES_TITLE"), true));
    }

    private void setEnabledOkPaste() {
        boolean bl = this.mValueTargetVarList.getModel().getSize() > 1;
        boolean bl2 = true;
        boolean bl3 = true;
        if (this.mVariableRadio.isSelected()) {
            boolean bl4 = bl2 = this.mTargetVarList.getModel().getSize() > 0;
        }
        if (this.mTemplateCheck.isSelected()) {
            bl3 = this.mFileTextField.getText() != null && this.mFileTextField.getText().length() > 0;
            DialogDataModel dialogDataModel = this.getDialogDataModel();
            String string = dialogDataModel.getString(FILE_TEXT_FIELD_KEY);
            if (string != null && string.length() > 0) {
                bl3 = true;
            }
        }
        this.enableOkPaste(bl && bl2 && bl3);
    }

    private void setEnabledNestVarCheck() {
        this.mNestVarCheck.setEnabled(this.mRowsTargetVarList.getModel().getSize() > 0);
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mValuesArrowButton);
        vector.add(this.mRowsArrowButton);
        vector.add(this.mValueTargetVarList);
        vector.add(this.mCategoryLabelsGroup);
        vector.add(this.mVarArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mDisplayCumulativeCheck);
        vector.add(this.mRowsTargetVarList);
        vector.add(this.mNestVarCheck);
        vector.add(this.mTemplateCheck);
        vector.add(this.mFileButton);
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            if (!this.mOptionButtonPanel.getComponent(n).getClass().equals(JButton.class)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        n2 = this.mCmdButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setupComponents(JPanel jPanel) {
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_PARETO_CATEGORY_AXIS");
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_PARETO_ROWS");
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_PARETO_VALUES");
        jLabel.setLabelFor(this.mValueTargetVarList);
        jLabel2.setLabelFor(this.mRowsTargetVarList);
        jLabel3.setLabelFor(this.mValueTargetVarList);
        JScrollPane jScrollPane2 = new JScrollPane(this.mValueTargetVarList);
        jScrollPane2.setPreferredSize(this.mValueTargetVarList.getMinimumSize());
        JComponent[] jComponentArray = new JComponent[]{this.mTargetVarList, this.mVarArrowButton, this.mCaseNumbersRadio, this.mVariableRadio};
        JPanel jPanel2 = PanelFactory.getGraphsLabelPanel(jComponentArray, this.getResString("IDS_PARETO_CATEGORY_LABELS"));
        jComponentArray = new JComponent[]{jLabel2, this.mRowsArrowButton, this.mRowsTargetVarList, this.mNestVarCheck};
        JPanel jPanel3 = this.getGraphsPanelByPanel(jComponentArray, this.getResString("IDS_PARETO_PANEL_BY"));
        jComponentArray = new JComponent[]{this.mTemplateCheck, this.mFileButton, this.mFileTextField};
        JPanel jPanel4 = PanelFactory.getGraphsChartTemplatePanel(jComponentArray, this.getResString("IDS_PARETO_TEMPLATE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_PARETO_STACKED_INDIVIDUAL_CASES_SOURCE_LABEL");
        jLabel4.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 4, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        Insets insets3 = OSCheck.getOSType() == OSInfo.OSType.MAC ? new Insets(0, insets2.left + n3 + 4, 0, insets2.right) : new Insets(0, insets2.left + n3 + 3, 0, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mValuesArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        insets.set(0, 3, 0, n3);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 0, 1, 1, n, null);
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(0, 3, 0, n3 + 4);
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 2, 2, 1, n, insets);
        insets.set(n2 - 5, n2 + 13, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDisplayCumulativeCheck, gridBagConstraints, 1, 3, 2, 1, n, insets);
        insets.set(n2, n2, 0, 0);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 4, 2, 1, n, insets);
        insets.set(n2, 0, 0, 0);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 5, 3, 1, n, insets);
    }

    private JPanel getGraphsPanelByPanel(JComponent[] jComponentArray, String string) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        JScrollPane jScrollPane = new JScrollPane(jComponentArray[2]);
        Dimension dimension = jComponentArray[2].getMinimumSize();
        Dimension dimension2 = new Dimension(dimension.width, dimension.height * 4);
        jScrollPane.setPreferredSize(dimension2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jComponentArray[0], gridBagConstraints, 1, 0, 1, 1, 23, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        Insets insets3 = new Insets(insets2.top, insets2.left - 5, insets2.bottom, insets2.right);
        DialogUtil.addUsingGBL(jPanel, jComponentArray[1], gridBagConstraints, 0, 1, 1, 1, 10, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets4 = new Insets(insets.top, 0, insets.bottom, n - 1);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, 23, insets4);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets4.set(insets.top, insets.left, n * 2, insets.right);
        DialogUtil.addUsingGBL(jPanel, jComponentArray[3], gridBagConstraints, 1, 2, 1, 1, 23, insets4);
        return jPanel;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mValueTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mValueTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 3 + 2));
        this.mValueTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mValueTargetVarList.getModel().addListDataListener(this);
        this.mValueTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mRowsTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mRowsTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mRowsTargetVarList.getModel().addListDataListener(this);
        this.mVarArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mVarArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mVarArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mValuesArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mValuesArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mValuesArrowButton.registerVariableList(this.mValueTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mRowsArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mRowsArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mRowsArrowButton.registerVariableList(this.mRowsTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mCaseNumbersRadio = DialogUtil.createRadioButton(this, SIMPLE_CASE_NUMBER_KEY, null);
        this.mVariableRadio = DialogUtil.createRadioButton(this, SIMPLE_VARIABLE_KEY, null);
        this.mNestVarCheck = DialogUtil.createCheckBox(this, SIMPLE_NEST_VAR_KEY, null);
        this.mDisplayCumulativeCheck = DialogUtil.createCheckBox(this, SIMPLE_DISPLAY_CUMULATIVE_KEY, null);
        this.mTemplateCheck = DialogUtil.createCheckBox(this, SIMPLE_TEMPLATE_CHART_KEY, null);
        this.mTemplateCheck.addItemListener(this);
        this.mVariableRadio.addItemListener(this);
        this.mCaseNumbersRadio.addItemListener(this);
        this.mFileButton = new JButton(new ToggleButtonAction(this, "IDS_PARETO_FILE"));
        this.mFileButton.addActionListener(this);
        this.mFileTextField = new FileTextField();
        this.mFileTextField.setBorder(BorderFactory.createEmptyBorder());
        this.mFileTextField.setBackground(this.getBackground());
        this.mFileTextField.setOpaque(false);
        this.mFileTextField.setEditable(false);
        this.mFileTextField.setFocusable(false);
        this.mFileTextField.setAction(new TextFieldAction(this, FILE_TEXT_FIELD_KEY));
        this.mCategoryLabelsGroup = new SpssButtonGroup();
        this.mCategoryLabelsGroup.add(this.mCaseNumbersRadio);
        this.mCategoryLabelsGroup.add(this.mVariableRadio);
        this.mTargetVarList.setIdentifier(SUM_OF_VAR_TARGET_LIST_KEY);
        this.mRowsTargetVarList.setIdentifier(ROWS_TARGET_LIST_KEY);
        this.mValueTargetVarList.setIdentifier(VALUES_TARGET_LIST_KEY);
        this.mSrcVarList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefineStackedIndividualCases.this.enableArrowButton();
            }
        });
    }

    private boolean openRemoteFile() {
        GraphsRemoteFileChooser graphsRemoteFileChooser = new GraphsRemoteFileChooser(this);
        graphsRemoteFileChooser.setDialogTitle(this.getResString("IDS_FILE_DIALOG_TITLE"));
        int n = graphsRemoteFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0) {
            this.mFileTextField.setText(graphsRemoteFileChooser.getSelectedFilePath());
            return true;
        }
        return false;
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.setEnabledOkPaste();
        this.mVariableRadio.setSelected(true);
        this.mDisplayCumulativeCheck.setSelected(true);
        this.mNestVarCheck.setEnabled(false);
        this.mFileButton.setEnabled(false);
        this.mTemplateCheck.setSelected(false);
        this.mNestVarCheck.setSelected(false);
        this.mFileTextField.setText("");
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mTemplateCheck.setEnabled(false);
        }
    }
}

