/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.quality_control.pareto_charts;

import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsRemoteFileChooser;
import com.spss.java_client.ui.dialogs.base.graphs.OptionsSubDialog;
import com.spss.java_client.ui.dialogs.base.graphs.TitlesSubDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DefineStackedGroupOfCasesDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener,
ActionListener,
IVarMoveHandler {
    private static final String FILE_TEXT_FIELD_KEY = "IDS_STACKED_GRP_FILE_TEXT_FIELD_KEY";
    private static final String SUM_OF_VAR_TARGET_LIST_KEY = "IDS_STACKED_GRP_SUM_OF_VAR_TARGET_LIST_KEY";
    private static final String CATEGORY_TARGET_LIST_KEY = "IDS_STACKED_GRP_CATEGORY_TARGET_LIST_KEY";
    private static final String ROWS_TARGET_LIST_KEY = "IDS_STACKED_GRP_ROWS_TARGET_LIST_KEY";
    private static final String DEFINE_STACKS_BY_TARGET_LIST_KEY = "IDS_STACKED_GRP_DEFINE_STACKES_TARGET_LIST_KEY";
    private static final String SIMPLE_COUNTS_KEY = "IDS_PARETO_COUNTS";
    private static final String SIMPLE_SUMS_OF_VAR_KEY = "IDS_PARETO_SUMS_OF_VARIABLE";
    private static final String SIMPLE_DISPLAY_CUMULATIVE_KEY = "IDS_PARETO_DISPLAY_CUMULATIVE";
    private static final String SIMPLE_NEST_VAR_KEY = "IDS_PARETO_NEST_VAR";
    private static final String SIMPLE_TEMPLATE_CHART_KEY = "IDS_PARETO_TEMPLATE_USE_CHART";
    private SrcVariableList mSrcVarList;
    private JRadioButton mCountsRadio;
    private JRadioButton mSumsOfVarRadio;
    private ArrowButton mSumsOfVarArrowButton;
    private ArrowButton mCategoryArrowButton;
    private ArrowButton mDefineStacksArrowButton;
    private ArrowButton mRowsArrowButton;
    private TargetVariableList mSumsOfVarTargetVarList;
    private TargetVariableList mCategoryTargetVarList;
    private TargetVariableList mDefineStacksTargetVarList;
    private TargetVariableList mRowsTargetVarList;
    private JCheckBox mNestVarCheck;
    private JCheckBox mTemplateCheck;
    private JCheckBox mDisplayCumulativeCheck;
    private JButton mFileButton;
    private FileTextField mFileTextField;
    private SpssButtonGroup mBarsRepresentGroup;

    public DefineStackedGroupOfCasesDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, false, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_PARETO_STACKED_COUNTS_OR_SUM_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String generateSyntax() {
        String string;
        Boolean bl;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("GRAPH"));
        stringBuffer.append("\n");
        if (this.mDisplayCumulativeCheck.isSelected()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/PARETO (CUM STACKED)="));
        } else {
            stringBuffer.append(SyntaxUtil.getSubCommand("/PARETO (NOCUM STACKED)="));
        }
        if (this.mCountsRadio.isSelected()) {
            stringBuffer.append("COUNT");
        } else {
            stringBuffer.append("SUM(" + this.mSumsOfVarTargetVarList.getVariablesStringList() + ")");
        }
        stringBuffer.append(" BY " + this.mCategoryTargetVarList.getVariablesStringList());
        stringBuffer.append(" BY " + this.mDefineStacksTargetVarList.getVariablesStringList());
        if (this.mRowsTargetVarList.getModel().getSize() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/PANEL ROWVAR=") + this.mRowsTargetVarList.getVariablesStringList());
            if (this.mNestVarCheck.isSelected()) {
                stringBuffer.append(" ROWOP=NEST");
            } else {
                stringBuffer.append(" ROWOP=CROSS");
            }
        }
        if ((bl = dialogDataModel.getBoolean("IDS_OPT_SUBDLG_DISPLAY_GROUPS_CHECK")) != null && bl.booleanValue()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/MISSING=REPORT"));
        }
        if (this.mTemplateCheck.isSelected()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/TEMPLATE=") + CharacterUtil.smartQuote((String)this.mFileTextField.getText()));
        }
        String string2 = dialogDataModel.getString("IDS_TITLE_LINE1_EDIT");
        String string3 = dialogDataModel.getString("IDS_TITLE_LINE2_EDIT");
        if (string2 != null && string2.length() > 0 || string3 != null && string3.length() > 0) {
            if (string2 != null && string2.length() == 0) {
                string2 = " ";
            }
            if (!(string = (CharacterUtil.smartQuote((String)string2) + " " + CharacterUtil.smartQuote((String)string3)).trim()).equals("")) {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/TITLE=") + string);
            }
        }
        if ((string2 = dialogDataModel.getString("IDS_SUBTITLE_EDIT")) != null && string2.length() > 0 && !(string = CharacterUtil.smartQuote((String)string2).trim()).equals("")) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/SUBTITLE=") + string);
        }
        string2 = dialogDataModel.getString("IDS_FOOTNOTE_LINE1_EDIT");
        string3 = dialogDataModel.getString("IDS_FOOTNOTE_LINE2_EDIT");
        if ((string2 != null && string2.length() > 0 || string3 != null && string3.length() > 0) && !(string = (CharacterUtil.smartQuote((String)string2) + " " + CharacterUtil.smartQuote((String)string3)).trim()).equals("")) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/FOOTNOTE=") + string);
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_gttg";
    }

    @Override
    public String getIActionKey() {
        return "analyze_qlty_cont_pareto_stacked_group_of_cases";
    }

    @Override
    public void reset() {
        super.reset();
        this.mCategoryTargetVarList.removeAll();
        this.mSumsOfVarTargetVarList.removeAll();
        this.mRowsTargetVarList.removeAll();
        this.mDefineStacksTargetVarList.removeAll();
        this.setDefaults();
    }

    @Override
    public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
        if (iSpssVariableArray.length > 0 && iSpssVariableArray[0].getType() > 0) {
            this.mSumsOfVarArrowButton.setEnabled(false);
            return false;
        }
        this.mSumsOfVarArrowButton.setEnabled(true);
        return true;
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.setEnabledOkPaste();
        this.setEnabledNestVarCheck();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.setEnabledOkPaste();
        this.setEnabledNestVarCheck();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.setEnabledOkPaste();
        this.setEnabledNestVarCheck();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableArrowButton();
        this.mFileButton.setEnabled(this.mTemplateCheck.isSelected());
        this.mFileTextField.setEnabled(this.mTemplateCheck.isSelected());
        this.setEnabledOkPaste();
    }

    public void enableArrowButton() {
        boolean bl = true;
        if (!this.mSumsOfVarRadio.isSelected()) {
            bl = false;
        } else {
            boolean bl2;
            boolean bl3 = this.mSrcVarList.getSelectedValues() != null && this.mSrcVarList.getSelectedValues().length == 1;
            boolean bl4 = bl2 = this.mSumsOfVarTargetVarList.getSelectedValues() != null && this.mSumsOfVarTargetVarList.getSelectedValues().length > 0;
            if (this.mSumsOfVarArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.right && (!bl3 || bl2)) {
                bl = false;
            }
            if (!bl2 && this.mSumsOfVarArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.left) {
                bl = false;
            }
        }
        this.mSumsOfVarArrowButton.setEnabled(bl);
        this.mSumsOfVarTargetVarList.setEnabled(this.mSumsOfVarRadio.isSelected());
        this.mSumsOfVarTargetVarList.setOpaque(this.mSumsOfVarRadio.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.openRemoteFile();
        this.setEnabledOkPaste();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.mFileTextField.getText() != null) {
            this.mFileTextField.setText(this.mFileTextField.getText());
        }
        super.validate();
    }

    private JPanel getCategoryPanel(JComponent[] jComponentArray) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(jComponentArray[2]);
        jScrollPane.setPreferredSize(jComponentArray[2].getMinimumSize());
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, jComponentArray[0], gridBagConstraints, 1, 0, 1, 1, 23, null);
        Insets insets = OSCheck.getOSType() == OSInfo.OSType.MAC ? new Insets(0, DialogUtil.getArrowButtonInsets().left + 5, 0, DialogUtil.getArrowButtonInsets().right) : new Insets(0, DialogUtil.getArrowButtonInsets().left + 4, 0, DialogUtil.getArrowButtonInsets().right);
        DialogUtil.addUsingGBL(jPanel, jComponentArray[1], gridBagConstraints, 0, 0, 1, 2, 20, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(0, 0, 0, n + 16);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, 23, insets);
        return jPanel;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupComponents(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefineStackedGroupOfCasesDlg.this.runOptionsSubDialog();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction("IDS_REPORT_COMMON_TITLES_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefineStackedGroupOfCasesDlg.this.runTitlesSubDialog();
            }
        };
        JButton jButton2 = new JButton(toggleButtonAction2);
        this.addOptionsPanelButton(jPanel, jButton2);
        this.addOptionsPanelButton(jPanel, jButton);
        return jPanel;
    }

    private void runTitlesSubDialog() {
        this.runSubDialog(new TitlesSubDialog(this, this.getResString("IDS_PARETO_TITLES_TITLE"), true));
    }

    private void runOptionsSubDialog() {
        int n = 1026;
        this.runSubDialog(new OptionsSubDialog(this, n));
    }

    private void setEnabledNestVarCheck() {
        this.mNestVarCheck.setEnabled(this.mRowsTargetVarList.getModel().getSize() > 0);
    }

    private void setEnabledOkPaste() {
        boolean bl;
        boolean bl2 = this.mCategoryTargetVarList.getModel().getSize() > 0;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = bl = this.mDefineStacksTargetVarList.getModel().getSize() > 0;
        if (this.mSumsOfVarRadio.isSelected()) {
            boolean bl6 = bl3 = this.mSumsOfVarTargetVarList.getModel().getSize() > 0;
        }
        if (this.mTemplateCheck.isSelected()) {
            bl4 = this.mFileTextField.getText() != null && this.mFileTextField.getText().length() > 0;
            DialogDataModel dialogDataModel = this.getDialogDataModel();
            String string = dialogDataModel.getString(FILE_TEXT_FIELD_KEY);
            if (string != null && string.length() > 0) {
                bl4 = true;
            }
        }
        this.enableOkPaste(bl2 && bl3 && bl4 && bl);
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mBarsRepresentGroup);
        vector.add(this.mSumsOfVarArrowButton);
        vector.add(this.mSumsOfVarTargetVarList);
        vector.add(this.mCategoryArrowButton);
        vector.add(this.mDefineStacksArrowButton);
        vector.add(this.mRowsArrowButton);
        vector.add(this.mCategoryTargetVarList);
        vector.add(this.mDefineStacksTargetVarList);
        vector.add(this.mDisplayCumulativeCheck);
        vector.add(this.mRowsTargetVarList);
        vector.add(this.mNestVarCheck);
        vector.add(this.mTemplateCheck);
        vector.add(this.mFileButton);
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            if (!this.mOptionButtonPanel.getComponent(n).getClass().equals(JButton.class)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        n2 = this.mCmdButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setupComponents(JPanel jPanel) {
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_PARETO_CATEGORY_AXIS");
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_PARETO_DEFINE_STACK_BY");
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_PARETO_ROWS");
        jLabel.setLabelFor(this.mCategoryTargetVarList);
        jLabel3.setLabelFor(this.mRowsTargetVarList);
        jLabel2.setLabelFor(this.mDefineStacksTargetVarList);
        JComponent[] jComponentArray = new JComponent[]{this.mSumsOfVarTargetVarList, this.mSumsOfVarArrowButton, this.mCountsRadio, this.mSumsOfVarRadio};
        JPanel jPanel2 = this.getLabelPanel(jComponentArray, this.getResString("IDS_PARETO_BAR_REPRESENT"));
        jComponentArray = new JComponent[]{jLabel, this.mCategoryArrowButton, this.mCategoryTargetVarList};
        JPanel jPanel3 = this.getCategoryPanel(jComponentArray);
        jComponentArray = new JComponent[]{jLabel2, this.mDefineStacksArrowButton, this.mDefineStacksTargetVarList};
        JPanel jPanel4 = this.getCategoryPanel(jComponentArray);
        jComponentArray = new JComponent[]{jLabel3, this.mRowsArrowButton, this.mRowsTargetVarList, this.mNestVarCheck};
        JPanel jPanel5 = this.getGraphsPanelByPanel(jComponentArray, this.getResString("IDS_PARETO_PANEL_BY"));
        jComponentArray = new JComponent[]{this.mTemplateCheck, this.mFileButton, this.mFileTextField};
        JPanel jPanel6 = PanelFactory.getGraphsChartTemplatePanel(jComponentArray, this.getResString("IDS_PARETO_TEMPLATE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 0, 1, 5, n, null);
        gridBagConstraints.weighty = 0.0;
        insets.set(0, 6, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.set(n2, 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 1, 1, 1, n, insets);
        insets.set(n2 - 6, 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 1, 2, 1, 1, n, insets);
        insets.set(n2, n2 + 13, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDisplayCumulativeCheck, gridBagConstraints, 1, 3, 1, 1, n, insets);
        insets.set(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 1, 4, 1, 1, n, insets);
        insets.set(n2, 4, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel6, gridBagConstraints, 0, 5, 2, 1, n, insets);
    }

    private JPanel getLabelPanel(JComponent[] jComponentArray, String string) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        Insets insets = DialogUtil.getStandardControlInsets();
        JScrollPane jScrollPane = new JScrollPane(jComponentArray[0]);
        jScrollPane.setPreferredSize(jComponentArray[0].getMinimumSize());
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets2 = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jComponentArray[2], gridBagConstraints, 0, 0, 2, 1, 23, insets);
        DialogUtil.addUsingGBL(jPanel, jComponentArray[3], gridBagConstraints, 0, 1, 2, 1, 23, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets3 = OSCheck.getOSType() == OSInfo.OSType.MAC ? new Insets(n, insets2.left + 3, 0, DialogUtil.getArrowButtonInsets().right) : new Insets(n, insets2.left + 3, 0, DialogUtil.getArrowButtonInsets().right);
        DialogUtil.addUsingGBL(jPanel, jComponentArray[1], gridBagConstraints, 0, 3, 1, 1, 10, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets3.set(n * 3, 0, 5, n2 * 2 + 3);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 3, 1, 1, 23, insets3);
        return jPanel;
    }

    private JPanel getGraphsPanelByPanel(JComponent[] jComponentArray, String string) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        JScrollPane jScrollPane = new JScrollPane(jComponentArray[2]);
        Dimension dimension = jComponentArray[2].getMinimumSize();
        Dimension dimension2 = new Dimension(dimension.width, dimension.height * 4);
        jScrollPane.setPreferredSize(dimension2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jComponentArray[0], gridBagConstraints, 1, 0, 1, 1, 23, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        Insets insets3 = new Insets(insets2.top, insets2.left - 7, insets2.bottom, insets2.right);
        DialogUtil.addUsingGBL(jPanel, jComponentArray[1], gridBagConstraints, 0, 1, 1, 1, 10, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets4 = new Insets(insets.top, 0, insets.bottom, n * 2 + 3);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, 23, insets4);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets4.set(insets.top, insets.left, n * 2, insets.right);
        DialogUtil.addUsingGBL(jPanel, jComponentArray[3], gridBagConstraints, 1, 2, 1, 1, 23, insets4);
        return jPanel;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSumsOfVarTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mSumsOfVarTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mSumsOfVarTargetVarList.getModel().addListDataListener(this);
        this.mSumsOfVarTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mCategoryTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mCategoryTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mCategoryTargetVarList.getModel().addListDataListener(this);
        this.mDefineStacksTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mDefineStacksTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mDefineStacksTargetVarList.getModel().addListDataListener(this);
        this.mRowsTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mRowsTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mRowsTargetVarList.getModel().addListDataListener(this);
        this.mSumsOfVarArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mSumsOfVarArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mSumsOfVarArrowButton.registerVariableList(this.mSumsOfVarTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mSumsOfVarArrowButton.setVarMoveHandler(this);
        this.mCategoryArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCategoryArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mCategoryArrowButton.registerVariableList(this.mCategoryTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mRowsArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mRowsArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mRowsArrowButton.registerVariableList(this.mRowsTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mDefineStacksArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDefineStacksArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mDefineStacksArrowButton.registerVariableList(this.mDefineStacksTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mCountsRadio = DialogUtil.createRadioButton(this, SIMPLE_COUNTS_KEY, null);
        this.mSumsOfVarRadio = DialogUtil.createRadioButton(this, SIMPLE_SUMS_OF_VAR_KEY, null);
        this.mNestVarCheck = DialogUtil.createCheckBox(this, SIMPLE_NEST_VAR_KEY, null);
        this.mDisplayCumulativeCheck = DialogUtil.createCheckBox(this, SIMPLE_DISPLAY_CUMULATIVE_KEY, null);
        this.mTemplateCheck = DialogUtil.createCheckBox(this, SIMPLE_TEMPLATE_CHART_KEY, null);
        this.mTemplateCheck.addItemListener(this);
        this.mSumsOfVarRadio.addItemListener(this);
        this.mCountsRadio.addItemListener(this);
        this.mFileButton = new JButton(new ToggleButtonAction(this, "IDS_PARETO_FILE"));
        this.mFileButton.addActionListener(this);
        this.mFileTextField = new FileTextField();
        this.mFileTextField.setBorder(BorderFactory.createEmptyBorder());
        this.mFileTextField.setBackground(this.getBackground());
        this.mFileTextField.setOpaque(false);
        this.mFileTextField.setEditable(false);
        this.mFileTextField.setFocusable(false);
        this.mFileTextField.setAction(new TextFieldAction(this, FILE_TEXT_FIELD_KEY));
        this.mBarsRepresentGroup = new SpssButtonGroup();
        this.mBarsRepresentGroup.add(this.mCountsRadio);
        this.mBarsRepresentGroup.add(this.mSumsOfVarRadio);
        this.mSumsOfVarTargetVarList.setIdentifier(SUM_OF_VAR_TARGET_LIST_KEY);
        this.mCategoryTargetVarList.setIdentifier(CATEGORY_TARGET_LIST_KEY);
        this.mRowsTargetVarList.setIdentifier(ROWS_TARGET_LIST_KEY);
        this.mDefineStacksTargetVarList.setIdentifier(DEFINE_STACKS_BY_TARGET_LIST_KEY);
        this.mSrcVarList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefineStackedGroupOfCasesDlg.this.enableArrowButton();
            }
        });
    }

    private boolean openRemoteFile() {
        GraphsRemoteFileChooser graphsRemoteFileChooser = new GraphsRemoteFileChooser(this);
        graphsRemoteFileChooser.setDialogTitle(this.getResString("IDS_FILE_DIALOG_TITLE"));
        int n = graphsRemoteFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0) {
            this.mFileTextField.setText(graphsRemoteFileChooser.getSelectedFilePath());
            return true;
        }
        return false;
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.setEnabledOkPaste();
        this.mCountsRadio.setSelected(true);
        this.mDisplayCumulativeCheck.setSelected(true);
        this.mNestVarCheck.setEnabled(false);
        this.mFileButton.setEnabled(false);
        this.mTemplateCheck.setSelected(false);
        this.mNestVarCheck.setSelected(false);
        this.mFileTextField.setText("");
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mTemplateCheck.setEnabled(false);
        }
    }
}

