/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.quality_control.pareto_charts;

import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsRemoteFileChooser;
import com.spss.java_client.ui.dialogs.base.graphs.OptionsSubDialog;
import com.spss.java_client.ui.dialogs.base.graphs.TitlesSubDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DefineSimpleSumsOfSeparateVar
extends BaseProcedureDialog
implements ListDataListener,
ItemListener,
ActionListener {
    private static final String FILE_TEXT_FIELD_KEY = "IDS_SIMPLE_SEPARATE_FILE_TEXT_FIELD_KEY";
    private static final String ROWS_TARGET_LIST_KEY = "IDS_SIMPLE_SEPARATE_ROWS_TARGET_LIST_KEY";
    private static final String VARIABLE_TARGET_LIST_KEY = "IDS_SIMPLE_SEPARATE_VARIABLES_TARGET_LIST_KEY";
    private static final String SIMPLE_DISPLAY_CUMULATIVE_KEY = "IDS_PARETO_DISPLAY_CUMULATIVE";
    private static final String SIMPLE_NEST_VAR_KEY = "IDS_PARETO_NEST_VAR";
    private static final String SIMPLE_TEMPLATE_CHART_KEY = "IDS_PARETO_TEMPLATE_USE_CHART";
    private SrcVariableList mSrcVarList;
    private ArrowButton mRowsArrowButton;
    private TargetVariableList mRowsTargetVarList;
    private TargetVariableList mTargetVarList;
    private ArrowButton mTargetArrowButton;
    private JCheckBox mNestVarCheck;
    private JCheckBox mTemplateCheck;
    private JCheckBox mDisplayCumulativeCheck;
    private JButton mFileButton;
    private FileTextField mFileTextField;

    public DefineSimpleSumsOfSeparateVar(JFrame jFrame) throws HeadlessException {
        super(jFrame, false, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_PARETO_SIMPLE_SEPARATE_VAR_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String generateSyntax() {
        String string;
        Boolean bl;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("GRAPH"));
        stringBuffer.append("\n");
        if (this.mDisplayCumulativeCheck.isSelected()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/PARETO (CUM SIMPLE)=SUM"));
        } else {
            stringBuffer.append(SyntaxUtil.getSubCommand("/PARETO (NOCUM SIMPLE)=SUM"));
        }
        stringBuffer.append("(" + this.mTargetVarList.getVariablesStringList() + ")");
        if (this.mRowsTargetVarList.getModel().getSize() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/PANEL ROWVAR=") + this.mRowsTargetVarList.getVariablesStringList());
            if (this.mNestVarCheck.isSelected()) {
                stringBuffer.append(" ROWOP=NEST");
            } else {
                stringBuffer.append(" ROWOP=CROSS");
            }
        }
        if ((bl = dialogDataModel.getBoolean("IDS_OPT_SUBDLG_EX_CASES_LISTWISE_RADIO")) == null || bl.booleanValue()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/MISSING=LISTWISE"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_OPT_SUBDLG_EX_CASES_VAR_BY_VAR_RADIO")) != null && bl.booleanValue()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/MISSING=VARIABLEWISE"));
        }
        if (this.mTemplateCheck.isSelected()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/TEMPLATE=") + CharacterUtil.smartQuote((String)this.mFileTextField.getText()));
        }
        String string2 = dialogDataModel.getString("IDS_TITLE_LINE1_EDIT");
        String string3 = dialogDataModel.getString("IDS_TITLE_LINE2_EDIT");
        if (string2 != null && string2.length() > 0 || string3 != null && string3.length() > 0) {
            if (string2 != null && string2.length() == 0) {
                string2 = " ";
            }
            if (!(string = (CharacterUtil.smartQuote((String)string2) + " " + CharacterUtil.smartQuote((String)string3)).trim()).equals("")) {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/TITLE=") + string);
            }
        }
        if ((string2 = dialogDataModel.getString("IDS_SUBTITLE_EDIT")) != null && string2.length() > 0 && !(string = CharacterUtil.smartQuote((String)string2).trim()).equals("")) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/SUBTITLE=") + string);
        }
        string2 = dialogDataModel.getString("IDS_FOOTNOTE_LINE1_EDIT");
        string3 = dialogDataModel.getString("IDS_FOOTNOTE_LINE2_EDIT");
        if ((string2 != null && string2.length() > 0 || string3 != null && string3.length() > 0) && !(string = (CharacterUtil.smartQuote((String)string2) + " " + CharacterUtil.smartQuote((String)string3)).trim()).equals("")) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/FOOTNOTE=") + string);
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_gtsv";
    }

    @Override
    public String getIActionKey() {
        return "analyze_qlty_cont_pareto_simple_sums_of_separate_var";
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetVarList.removeAll();
        this.mRowsTargetVarList.removeAll();
        this.setDefaults();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.setEnabledOkPaste();
        this.setEnabledNestVarCheck();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.setEnabledOkPaste();
        this.setEnabledNestVarCheck();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.setEnabledOkPaste();
        this.setEnabledNestVarCheck();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mFileButton.setEnabled(this.mTemplateCheck.isSelected());
        this.mFileTextField.setEnabled(this.mTemplateCheck.isSelected());
        this.setEnabledOkPaste();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.openRemoteFile();
        this.setEnabledOkPaste();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.mFileTextField.getText() != null) {
            this.mFileTextField.setText(this.mFileTextField.getText());
        }
        super.validate();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupComponents(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefineSimpleSumsOfSeparateVar.this.runOptionsSubDialog();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction("IDS_REPORT_COMMON_TITLES_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefineSimpleSumsOfSeparateVar.this.runTitlesSubDialog();
            }
        };
        JButton jButton2 = new JButton(toggleButtonAction2);
        this.addOptionsPanelButton(jPanel, jButton2);
        this.addOptionsPanelButton(jPanel, jButton);
        return jPanel;
    }

    private void runTitlesSubDialog() {
        this.runSubDialog(new TitlesSubDialog(this, this.getResString("IDS_PARETO_TITLES_TITLE"), true));
    }

    private void runOptionsSubDialog() {
        int n = 1025;
        this.runSubDialog(new OptionsSubDialog(this, n));
    }

    private void setEnabledNestVarCheck() {
        this.mNestVarCheck.setEnabled(this.mRowsTargetVarList.getModel().getSize() > 0);
    }

    private void setEnabledOkPaste() {
        boolean bl = true;
        if (this.mTemplateCheck.isSelected()) {
            bl = this.mFileTextField.getText() != null && this.mFileTextField.getText().length() > 0;
            DialogDataModel dialogDataModel = this.getDialogDataModel();
            String string = dialogDataModel.getString(FILE_TEXT_FIELD_KEY);
            if (string != null && string.length() > 0) {
                bl = true;
            }
        }
        this.enableOkPaste(bl && this.mTargetVarList.getModel().getSize() >= 2);
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mTargetArrowButton);
        vector.add(this.mRowsArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mDisplayCumulativeCheck);
        vector.add(this.mRowsTargetVarList);
        vector.add(this.mNestVarCheck);
        vector.add(this.mTemplateCheck);
        vector.add(this.mFileButton);
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            if (!this.mOptionButtonPanel.getComponent(n).getClass().equals(JButton.class)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        n2 = this.mCmdButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setupComponents(JPanel jPanel) {
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        JScrollPane jScrollPane2 = new JScrollPane(this.mTargetVarList);
        jScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_PARETO_VARIABLES");
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_PARETO_ROWS");
        jLabel2.setLabelFor(this.mRowsTargetVarList);
        jLabel.setLabelFor(this.mTargetVarList);
        JComponent[] jComponentArray = new JComponent[]{jLabel2, this.mRowsArrowButton, this.mRowsTargetVarList, this.mNestVarCheck};
        JPanel jPanel2 = this.getGraphsPanelByPanel(jComponentArray, this.getResString("IDS_PARETO_PANEL_BY"));
        jComponentArray = new JComponent[]{this.mTemplateCheck, this.mFileButton, this.mFileTextField};
        JPanel jPanel3 = PanelFactory.getGraphsChartTemplatePanel(jComponentArray, this.getResString("IDS_PARETO_TEMPLATE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_PARETO_SIMPLE_SEPARATE_VAR_SOURCE_LABEL");
        jLabel3.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 3, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        Insets insets3 = OSCheck.getOSType() == OSInfo.OSType.MAC ? new Insets(0, insets2.left + n3 + 4, 0, insets2.right) : new Insets(0, insets2.left + n3 + 3, 0, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mTargetArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        insets.set(0, 3, 0, n3);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        insets = new Insets(0, 3, 0, n3 + 4);
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 1, n, insets);
        insets.set(n3, n2 + 13, 0, 0);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mDisplayCumulativeCheck, gridBagConstraints, 1, 2, 2, 1, n, insets);
        insets.set(n3, n2, 0, 0);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 3, 2, 1, n, insets);
        insets.set(n2, 0, 0, 0);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 4, 3, 1, n, insets);
    }

    private JPanel getGraphsPanelByPanel(JComponent[] jComponentArray, String string) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        JScrollPane jScrollPane = new JScrollPane(jComponentArray[2]);
        Dimension dimension = jComponentArray[2].getMinimumSize();
        Dimension dimension2 = new Dimension(dimension.width, dimension.height * 4);
        jScrollPane.setPreferredSize(dimension2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jComponentArray[0], gridBagConstraints, 1, 0, 1, 1, 23, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        Insets insets3 = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), insets2.bottom, insets2.right);
        DialogUtil.addUsingGBL(jPanel, jComponentArray[1], gridBagConstraints, 0, 1, 1, 1, 10, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets4 = new Insets(0, 3, 1, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, 23, insets4);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jComponentArray[3], gridBagConstraints, 1, 2, 1, 1, 23, insets);
        return jPanel;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mRowsTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mRowsTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mRowsTargetVarList.getModel().addListDataListener(this);
        this.mTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mTargetArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mTargetArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mRowsArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mRowsArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mRowsArrowButton.registerVariableList(this.mRowsTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mNestVarCheck = DialogUtil.createCheckBox(this, SIMPLE_NEST_VAR_KEY, null);
        this.mDisplayCumulativeCheck = DialogUtil.createCheckBox(this, SIMPLE_DISPLAY_CUMULATIVE_KEY, null);
        this.mTemplateCheck = DialogUtil.createCheckBox(this, SIMPLE_TEMPLATE_CHART_KEY, null);
        this.mTemplateCheck.addItemListener(this);
        this.mFileButton = new JButton(new ToggleButtonAction(this, "IDS_PARETO_FILE"));
        this.mFileButton.addActionListener(this);
        this.mFileTextField = new FileTextField();
        this.mFileTextField.setBorder(BorderFactory.createEmptyBorder());
        this.mFileTextField.setBackground(this.getBackground());
        this.mFileTextField.setOpaque(false);
        this.mFileTextField.setEditable(false);
        this.mFileTextField.setFocusable(false);
        this.mFileTextField.setAction(new TextFieldAction(this, FILE_TEXT_FIELD_KEY));
        this.mRowsTargetVarList.setIdentifier(ROWS_TARGET_LIST_KEY);
        this.mTargetVarList.setIdentifier(VARIABLE_TARGET_LIST_KEY);
    }

    private boolean openRemoteFile() {
        GraphsRemoteFileChooser graphsRemoteFileChooser = new GraphsRemoteFileChooser(this);
        graphsRemoteFileChooser.setDialogTitle(this.getResString("IDS_FILE_DIALOG_TITLE"));
        int n = graphsRemoteFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0) {
            this.mFileTextField.setText(graphsRemoteFileChooser.getSelectedFilePath());
            return true;
        }
        return false;
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.setEnabledOkPaste();
        this.mDisplayCumulativeCheck.setSelected(true);
        this.mNestVarCheck.setEnabled(false);
        this.mFileButton.setEnabled(false);
        this.mTemplateCheck.setSelected(false);
        this.mNestVarCheck.setSelected(false);
        this.mFileTextField.setText("");
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mTemplateCheck.setEnabled(false);
        }
    }
}

