/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.quality_control.improved_control_charts;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.quality_control.control_charts.ControlStatistics;
import com.spss.java_client.ui.dialogs.base.analyze.quality_control.control_charts.ControlsUtil;
import com.spss.java_client.ui.dialogs.base.analyze.quality_control.improved_control_charts.OptionSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsRemoteFileChooser;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsUtil;
import com.spss.java_client.ui.dialogs.base.graphs.TitlesSubDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ProcessCapabilityDlg
extends BaseProcedureDialog
implements ListDataListener,
ActionListener,
ItemListener,
DocumentListener {
    public static final String TARGET_FIELD_KEY = "IDS_PROCESS_CAP_TARGET_FIELD";
    private static final String UNIT_WITH_SUB_PROCESS_LIST_IDENTIFIER = "UNIT_WITH_SUB_PROCESS_LIST_IDENTIFIER";
    private static final String UNIT_WITH_SUB_DEFINE_LIST_IDENTIFIER = "UNIT_WITH_SUB_DEFINE_LIST_IDENTIFIER";
    private static final String GROUP_SAMPLE_LIST_IDENTIFIER = "GROUP_SAMPLE_LIST_IDENTIFIER";
    private static final String UNIT_PROCESS_LIST_IDENTIFIER = "UNIT_PROCESS_LIST_IDENTIFIER";
    private static final String UPPER_LIMIT_FIELED = "PROCESS_CAPABILITY_UPPER_LIMIT_FIELED";
    private static final String LOWER_LIMIT_FIELED = "PROCESS_CAPABILITY_LOWER_LIMIT_FIELED";
    private static final String TARGET_LIMIT_FIELED = "PROCESS_CAPABILITY_TARGET_LIMIT_FIELED";
    private static final String CASE_SPAN_FIELED = "PROCESS_CAPABILITY_CASE_SPAN_FIELED";
    private JLabel mSubProcessLabel;
    private TargetVariableList mSubProcessMeasList;
    private JLabel mSubGroupLabel;
    private TargetVariableList mSubgroupList;
    private JLabel mSubSampleLabel;
    private TargetVariableList mSubSampleTargetList;
    private JLabel mUnitProcessLabel;
    private TargetVariableList mUnitProcessMeasList;
    private SrcVariableList mSrcList;
    private JButton mTitleButton;
    private JButton mStatisticsButton;
    private JButton mOptionButton;
    private JButton mFileButton;
    private ArrowButton mSubProcessArrowButton;
    private ArrowButton mSubDefineArrowButton;
    private ArrowButton mSubSampleArrowButton;
    private ArrowButton mUnitProcesArrowButton;
    private JCheckBox mApplyChartCheck;
    private JLabel mUpperFieldLabel;
    private FloatTextField mUpperField;
    private JLabel mLowerFieldLabel;
    private FloatTextField mLowerField;
    private JLabel mTargetFieldLabel;
    private FloatTextField mTargetField;
    private JLabel mSpanFieldLabel;
    private IntTextField mSpanField;
    private FileTextField mFilePath;
    private JRadioButton mUnitWithGroupButton;
    private JRadioButton mGroupButton;
    private JRadioButton mUnitButton;
    private RemoteFileChooser mFileChooser;

    public ProcessCapabilityDlg(JFrame jFrame) {
        super(jFrame, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_GRAPHS_CONTROLS_PROCESS_CAPABILITY_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_gbsg";
    }

    @Override
    public String getIActionKey() {
        return "analyze_qlty_cont_process_capability";
    }

    public void paint(Graphics graphics) {
        this.mFilePath.setText(this.mFilePath.getText());
        super.paint(graphics);
        super.validate();
    }

    @Override
    public String generateSyntax() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getCommand("SPCHART", true));
        stringBuffer.append(" /CPCHART=" + this.getSyntaxForRadioButton());
        stringBuffer.append("\n /LSL=" + this.mLowerField.getText());
        stringBuffer.append("\n /USL=" + this.mUpperField.getText());
        if (this.mTargetField.getText().length() > 0) {
            stringBuffer.append("\n /TARGET=" + this.mTargetField.getText());
        }
        if (this.mApplyChartCheck.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/TEMPLATE=") + CharacterUtil.smartQuote((String)this.mFilePath.getText()));
        }
        stringBuffer.append(GraphsUtil.generateTitlesSubDialogSyntax(dialogDataModel));
        stringBuffer.append(SyntaxUtil.getSubCommand("\n /SIGMAS="));
        String string = dialogDataModel.getString("IDS_NUM_SIGMAS");
        if (string != null) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append("3");
        }
        if (this.mUnitWithGroupButton.isSelected()) {
            string = dialogDataModel.getString("IDS_MIN_SUBGROUP_SIZE");
            if (string != null) {
                stringBuffer.append("\n /MINSAMPLE=" + string);
            } else {
                stringBuffer.append("\n /MINSAMPLE=2");
            }
        }
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/NORMAL="));
        Boolean bl = dialogDataModel.getBoolean("IDS_QCONTROL_PROCESS_CAP_OPTION_SUB_CAPABILITY");
        Boolean bl2 = dialogDataModel.getBoolean("IDS_QCONTROL_PROCESS_CAP_OPTION_SUB_PERFORMANCE");
        if (bl != null && bl.booleanValue() && bl2 != null && bl2.booleanValue()) {
            stringBuffer.append("BOTH");
        } else if (bl != null && bl.booleanValue()) {
            stringBuffer.append("CAPABILITY");
        } else if (bl2 != null && bl2.booleanValue()) {
            stringBuffer.append("PERFORMANCE");
        } else {
            stringBuffer.append("NONE");
        }
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/REFERENCE="));
        bl = dialogDataModel.getBoolean("IDS_QCONTROL_PROCESS_CAP_OPTION_SUB_SPEC_LIMIT");
        bl2 = dialogDataModel.getBoolean("IDS_QCONTROL_PROCESS_CAP_OPTION_SUB_MIN_SIGMA");
        if (bl != null && bl.booleanValue() && bl2 != null && bl2.booleanValue()) {
            stringBuffer.append("SL SIGMAS");
        } else if (bl != null && bl.booleanValue()) {
            stringBuffer.append("SL");
        } else if (bl2 != null && bl2.booleanValue()) {
            stringBuffer.append("SIGMAS");
        } else {
            stringBuffer.append("NONE");
        }
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/CAPSIGMA="));
        String string2 = "";
        if (this.mUnitButton.isSelected()) {
            string2 = string2 + "MRBAR";
        } else {
            Boolean bl3 = dialogDataModel.getBoolean("IDS_GRAPHS_CONTROLS_STATS_RBAR_RADIO");
            if (bl3 != null && bl3.booleanValue()) {
                string2 = string2 + "RBAR";
            }
            if ((bl3 = dialogDataModel.getBoolean("IDS_GRAPHS_CONTROLS_STATS_SBAR_RADIO")) != null && bl3.booleanValue()) {
                string2 = string2 + "SBAR";
            }
            if ((bl3 = dialogDataModel.getBoolean("IDS_GRAPHS_CONTROLS_STATS_SUBGRP_VARIENCE_RADIO")) != null && bl3.booleanValue()) {
                string2 = string2 + "WITHIN";
            }
        }
        stringBuffer.append(string2);
        stringBuffer.append(ControlsUtil.getStatisticsDialogSyntax(dialogDataModel));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    protected boolean okPastePressed() {
        boolean bl = false;
        try {
            double d;
            double d2 = Double.POSITIVE_INFINITY;
            double d3 = Double.NEGATIVE_INFINITY;
            if (this.mUpperField.getText().length() > 0 && this.mLowerField.getText().length() > 0) {
                d2 = Double.parseDouble(this.mUpperField.getText());
                if (d2 >= (d3 = Double.parseDouble(this.mLowerField.getText()))) {
                    bl = true;
                } else {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_GRAPHS_CONTROLS_STATS_LOWER_SHOULD_BE_LESS_THAN_UPPER_MESSAGE"), VersionInfo.getAppVersionString());
                    this.mLowerField.requestFocus();
                    this.mLowerField.selectAll();
                }
            }
            if (bl && this.mTargetField.getText().length() > 0 && ((d = Double.parseDouble(this.mTargetField.getText())) > d2 || d < d3)) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_GRAPHS_CONTROLS_STATS_TARGET_INVALID_MESSAGE"), VersionInfo.getAppVersionString());
                this.mTargetField.requestFocus();
                this.mTargetField.selectAll();
                bl = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return bl && super.okPastePressed();
    }

    @Override
    public void reset() {
        super.reset();
        this.mSubProcessMeasList.removeAll();
        this.mSubgroupList.removeAll();
        this.mSubSampleTargetList.removeAll();
        this.mUnitProcessMeasList.removeAll();
        this.mSrcList.loadFromActiveDataset();
        this.mSrcList.requestFocus();
        this.setDefaults();
        this.getDialogDataModel().clear();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.checkEnableOkPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.checkEnableOkPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkEnableOkPaste();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkEnableOkPaste();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkEnableOkPaste();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mFileButton) {
            this.showOpenDialog();
        }
        if (object == this.mUnitWithGroupButton || object == this.mGroupButton || object == this.mUnitButton) {
            this.updateTargetListControls();
        }
        this.checkEnableOkPaste();
    }

    private void updateTargetListControls() {
        if (this.mUnitWithGroupButton.isSelected()) {
            this.mSubProcessLabel.setEnabled(true);
            this.mSubProcessArrowButton.setEnabled(true);
            this.mSubProcessMeasList.setEnabled(true);
            this.mSubGroupLabel.setEnabled(true);
            this.mSubDefineArrowButton.setEnabled(true);
            this.mSubgroupList.setEnabled(true);
            this.mSubSampleLabel.setEnabled(false);
            this.mSubSampleArrowButton.setEnabled(false);
            this.mSubSampleTargetList.setEnabled(false);
            this.mUnitProcesArrowButton.setEnabled(false);
            this.mUnitProcessLabel.setEnabled(false);
            this.mUnitProcessMeasList.setEnabled(false);
            this.mSpanFieldLabel.setEnabled(false);
            this.mSpanField.setEnabled(false);
        } else if (this.mGroupButton.isSelected()) {
            this.mSubSampleLabel.setEnabled(true);
            this.mSubSampleArrowButton.setEnabled(true);
            this.mSubSampleTargetList.setEnabled(true);
            this.mSubProcessLabel.setEnabled(false);
            this.mSubProcessArrowButton.setEnabled(false);
            this.mSubProcessMeasList.setEnabled(false);
            this.mSubGroupLabel.setEnabled(false);
            this.mSubDefineArrowButton.setEnabled(false);
            this.mSubgroupList.setEnabled(false);
            this.mUnitProcesArrowButton.setEnabled(false);
            this.mUnitProcessLabel.setEnabled(false);
            this.mUnitProcessMeasList.setEnabled(false);
            this.mSpanFieldLabel.setEnabled(false);
            this.mSpanField.setEnabled(false);
        } else if (this.mUnitButton.isSelected()) {
            this.mUnitProcesArrowButton.setEnabled(true);
            this.mUnitProcessLabel.setEnabled(true);
            this.mUnitProcessMeasList.setEnabled(true);
            this.mSpanFieldLabel.setEnabled(true);
            this.mSpanField.setEnabled(true);
            this.mSubProcessLabel.setEnabled(false);
            this.mSubProcessArrowButton.setEnabled(false);
            this.mSubProcessMeasList.setEnabled(false);
            this.mSubGroupLabel.setEnabled(false);
            this.mSubDefineArrowButton.setEnabled(false);
            this.mSubgroupList.setEnabled(false);
            this.mSubSampleLabel.setEnabled(false);
            this.mSubSampleArrowButton.setEnabled(false);
            this.mSubSampleTargetList.setEnabled(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mApplyChartCheck) {
            boolean bl = this.mApplyChartCheck.isSelected();
            this.mFileButton.setEnabled(bl);
            this.mFilePath.setEnabled(bl);
        }
        this.checkEnableOkPaste();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string = dialogDataModel.getString(UPPER_LIMIT_FIELED);
        if (string != null) {
            this.mUpperField.setText(string);
        }
        if ((string = dialogDataModel.getString(LOWER_LIMIT_FIELED)) != null) {
            this.mLowerField.setText(string);
        }
        if ((string = dialogDataModel.getString(TARGET_LIMIT_FIELED)) != null) {
            this.mTargetField.setText(string);
        }
        if ((string = dialogDataModel.getString(CASE_SPAN_FIELED)) != null) {
            this.mSpanField.setText(string);
        }
        this.mSrcList.setSelectedIndex(0);
        this.updateTargetListControls();
        this.checkEnableOkPaste();
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        dialogDataModel.putString(UPPER_LIMIT_FIELED, this.mUpperField.getText());
        dialogDataModel.putString(LOWER_LIMIT_FIELED, this.mLowerField.getText());
        if (this.mTargetField.getText().length() > 0) {
            dialogDataModel.putString(TARGET_LIMIT_FIELED, this.mTargetField.getText());
        }
        dialogDataModel.putString(CASE_SPAN_FIELED, this.mSpanField.getText());
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.setTabTraversalOrder();
        this.setDefaults();
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        this.mTitleButton = new JButton(new ToggleButtonAction("IDS_REPORT_COMMON_TITLES_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProcessCapabilityDlg.this.runSubDialog(new TitlesSubDialog(ProcessCapabilityDlg.this));
            }
        });
        this.addOptionsPanelButton(jPanel, this.mTitleButton);
        this.mOptionButton = new JButton(new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProcessCapabilityDlg.this.runSubDialog(new OptionSubDlg(ProcessCapabilityDlg.this, ProcessCapabilityDlg.this.getResString("IDS_QCONTROL_PROCESS_CAP_OPTION_SUB_TITLE")));
            }
        });
        this.addOptionsPanelButton(jPanel, this.mOptionButton);
        this.mStatisticsButton = new JButton(new ToggleButtonAction("IDS_COMMON_STATS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ProcessCapabilityDlg.this.mUnitButton.isSelected();
                ProcessCapabilityDlg.this.runSubDialog(new ControlStatistics(ProcessCapabilityDlg.this, ProcessCapabilityDlg.this.getResString("IDS_QCONTROL_PROCESS_CAP_STATS_SUB_TITLE"), true, false, "idh_gcxs_stat", bl));
            }
        });
        this.addOptionsPanelButton(jPanel, this.mStatisticsButton);
        return jPanel;
    }

    private void initVars() {
        this.mSrcList = new SrcVariableList();
        this.mSrcList.loadFromActiveDataset();
        this.mApplyChartCheck = DialogUtil.createCheckBox(this, "IDS_QCONTROL_PROCESS_CAP_APPLY_TEMPLATE_CHECK", null);
        this.mApplyChartCheck.addItemListener(this);
        this.mFileButton = DialogUtil.createButton(this, "IDS_QCONTROL_PROCESS_CAP_APPLY_TEMPLATE_FILE_BUTTON", null);
        this.mFileButton.setAction(new ToggleButtonAction(this, "IDS_QCONTROL_PROCESS_CAP_APPLY_TEMPLATE_FILE_BUTTON"));
        this.mFileButton.addActionListener(this);
        this.mFilePath = new FileTextField(true);
        this.mFilePath.setAction(new TextFieldAction(this, "IDS_QCONTROL_PROCESS_CAP_APPLY_TEMPLATE_FILEPATH"));
        this.mFilePath.setEditable(false);
        this.mFilePath.setOpaque(false);
        this.mFilePath.setBorder(BorderFactory.createEmptyBorder());
        this.mUpperFieldLabel = DialogUtil.createLabel(this, "IDS_QCONTROL_PROCESS_CAP_SPEC_LIMIT_UPPER");
        this.mUpperField = new FloatTextField();
        this.mUpperField.getDocument().addDocumentListener(this);
        this.mUpperFieldLabel.setLabelFor((Component)this.mUpperField);
        this.mLowerFieldLabel = DialogUtil.createLabel(this, "IDS_QCONTROL_PROCESS_CAP_SPEC_LIMIT_LOWER");
        this.mLowerField = new FloatTextField();
        this.mLowerField.getDocument().addDocumentListener(this);
        this.mLowerFieldLabel.setLabelFor((Component)this.mUpperField);
        this.mTargetFieldLabel = DialogUtil.createLabel(this, "IDS_QCONTROL_PROCESS_CAP_SPEC_LIMIT_TARGET");
        this.mTargetField = new FloatTextField();
        TextFieldAction textFieldAction = new TextFieldAction(this, TARGET_FIELD_KEY);
        this.mTargetField.setAction((Action)textFieldAction);
        this.mTargetField.getDocument().addDocumentListener(this);
        this.mTargetFieldLabel.setLabelFor((Component)this.mUpperField);
        this.mUnitWithGroupButton = DialogUtil.createRadioButton(this, "IDS_QCONTROL_PROCESS_CAP_DATA_UNIT_WITH_SUB_RADIO", null);
        this.mGroupButton = DialogUtil.createRadioButton(this, "IDS_QCONTROL_PROCESS_CAP_DATA_SUB_RADIO", null);
        this.mUnitButton = DialogUtil.createRadioButton(this, "IDS_QCONTROL_PROCESS_CAP_DATA_UNIT_RADIO", null);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mUnitWithGroupButton);
        spssButtonGroup.add(this.mGroupButton);
        spssButtonGroup.add(this.mUnitButton);
        this.mUnitWithGroupButton.addActionListener(this);
        this.mGroupButton.addActionListener(this);
        this.mUnitButton.addActionListener(this);
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, true, false);
        this.mSubProcessLabel = DialogUtil.createLabel(this, "IDS_QCONTROL_PROCESS_CAP_DATA_UNIT_WITH_SUB_PROCESS_LABEL");
        this.mSubProcessMeasList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mSubProcessMeasList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mSubProcessMeasList.setIdentifier(UNIT_WITH_SUB_PROCESS_LIST_IDENTIFIER);
        this.mSubProcessMeasList.addVarFilter(spssVarFilter);
        this.mSubProcessMeasList.getModel().addListDataListener(this);
        this.mSubProcessLabel.setLabelFor(this.mSubProcessMeasList);
        this.mSubGroupLabel = DialogUtil.createLabel(this, "IDS_QCONTROL_PROCESS_CAP_DATA_UNIT_WITH_SUB_GROUP_DEFINED_LABEL");
        this.mSubgroupList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mSubgroupList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mSubgroupList.setIdentifier(UNIT_WITH_SUB_DEFINE_LIST_IDENTIFIER);
        this.mSubgroupList.addVarFilter(spssVarFilter);
        this.mSubgroupList.getModel().addListDataListener(this);
        this.mSubGroupLabel.setLabelFor(this.mSubgroupList);
        this.mSubSampleLabel = DialogUtil.createLabel(this, "IDS_QCONTROL_PROCESS_CAP_DATA_SUB_SAMPLES_LABEL");
        this.mSubSampleTargetList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mSubSampleTargetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mSubSampleTargetList.getModel().addListDataListener(this);
        this.mSubSampleTargetList.addVarFilter(spssVarFilter);
        this.mSubSampleTargetList.setIdentifier(GROUP_SAMPLE_LIST_IDENTIFIER);
        this.mSubSampleLabel.setLabelFor(this.mSubSampleTargetList);
        this.mUnitProcessLabel = DialogUtil.createLabel(this, "IDS_QCONTROL_PROCESS_CAP_DATA_UNIT_PROCESS_LABEL");
        this.mUnitProcessMeasList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mUnitProcessMeasList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mUnitProcessMeasList.getModel().addListDataListener(this);
        this.mUnitProcessMeasList.addVarFilter(spssVarFilter);
        this.mUnitProcessMeasList.setIdentifier(UNIT_PROCESS_LIST_IDENTIFIER);
        this.mUnitProcessLabel.setLabelFor(this.mUnitProcessMeasList);
        this.mSubProcessArrowButton = new ArrowButton();
        this.mSubProcessArrowButton.registerVariableList(this.mSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mSubProcessArrowButton.registerVariableList(this.mSubProcessMeasList, SpssArrowButton.ButtonOrientation.left);
        this.mSubDefineArrowButton = new ArrowButton();
        this.mSubDefineArrowButton.registerVariableList(this.mSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mSubDefineArrowButton.registerVariableList(this.mSubgroupList, SpssArrowButton.ButtonOrientation.left);
        this.mSubSampleArrowButton = new ArrowButton();
        this.mSubSampleArrowButton.registerVariableList(this.mSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mSubSampleArrowButton.registerVariableList(this.mSubSampleTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mUnitProcesArrowButton = new ArrowButton();
        this.mUnitProcesArrowButton.registerVariableList(this.mSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mUnitProcesArrowButton.registerVariableList(this.mUnitProcessMeasList, SpssArrowButton.ButtonOrientation.left);
        this.mSpanFieldLabel = DialogUtil.createLabel(this, "IDS_QCONTROL_PROCESS_CAP_DATA_UNIT_SPAN_LABEL");
        this.mSpanField = new IntTextField(2, 100, true);
        this.mSpanField.getDocument().addDocumentListener(this);
        this.mSpanFieldLabel.setLabelFor((Component)this.mSpanField);
    }

    private void setDefaults() {
        this.mSrcList.setSelectedIndex(0);
        this.mUnitWithGroupButton.setSelected(true);
        this.updateTargetListControls();
        this.mSpanField.setText("2");
        this.mApplyChartCheck.setSelected(false);
        this.mFileButton.setEnabled(false);
        this.mFilePath.setEnabled(false);
        this.mFilePath.setText("");
    }

    private String getSyntaxForRadioButton() {
        String string = "";
        if (this.mUnitWithGroupButton.isSelected()) {
            string = this.mSubProcessMeasList.getModel().getElementAt(0).getName() + " BY " + this.mSubgroupList.getModel().getElementAt(0).getName();
        } else if (this.mGroupButton.isSelected()) {
            int n = this.mSubSampleTargetList.getModel().getSize();
            for (int i = 0; i < n; ++i) {
                string = string + this.mSubSampleTargetList.getModel().getElementAt(i).getName() + " ";
            }
        } else if (this.mUnitButton.isSelected()) {
            string = this.mUnitProcessMeasList.getModel().getElementAt(0).getName() + "\n /SPAN=" + this.mSpanField.getText();
        }
        return string;
    }

    private void setupViewPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getMainButtonGap();
        Insets insets = new Insets(4, 0, n2, n2);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcList);
        Dimension dimension = this.mSrcList.getMinimumSize();
        jScrollPane.setPreferredSize(new Dimension(dimension.width + 30, dimension.height));
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2, 0, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.setupTemplatePanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(0, n2, n2, n2);
        JPanel jPanel2 = this.setupDataOrgPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        JPanel jPanel3 = this.setupSpecificationLimitPanel();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 1, 1, 1, n, insets);
    }

    private JPanel setupSpecificationLimitPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_QCONTROL_PROCESS_CAP_SPEC_LIMIT_PANEL_TITLE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n, n, n, 2);
        int n2 = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mUpperFieldLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        insets.set(n, 2, n, n * 3);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mUpperField, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        insets.set(n, n, n, 2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mLowerFieldLabel, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        insets.set(n, 2, n, n * 3);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mLowerField, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        insets.set(n, n * 3, n, 2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mTargetFieldLabel, gridBagConstraints, 2, 0, 1, 2, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n, 2, n, n);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTargetField, gridBagConstraints, 3, 0, 1, 2, n2, insets);
        return jPanel;
    }

    private JPanel setupTemplatePanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mApplyChartCheck, this.mFileButton, this.mFilePath};
        return PanelFactory.getGraphsChartTemplatePanel(jComponentArray, this.getResString("IDS_QCONTROL_PROCESS_CAP_APPLY_TEMPLATE_PANEL_TITLE"));
    }

    private JPanel setupDataOrgPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_QCONTROL_PROCESS_CAP_DATA_ORG_PANEL_TITLE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        Insets insets = new Insets(n, 0, n, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(4, 4, 4, n);
        DialogUtil.addUsingGBL(jPanel, this.mUnitWithGroupButton, gridBagConstraints, 0, 0, 2, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(4, n * 3, 4, n);
        DialogUtil.addUsingGBL(jPanel, this.mSubProcessArrowButton, gridBagConstraints, 0, 1, 1, 2, 20, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(4, 0, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mSubProcessLabel, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(0, 0, 4, n);
        JScrollPane jScrollPane = new JScrollPane(this.mSubProcessMeasList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        Dimension dimension = this.mSubProcessMeasList.getMinimumSize();
        jScrollPane.setPreferredSize(dimension);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 2, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(4, n * 3, n, n);
        DialogUtil.addUsingGBL(jPanel, this.mSubDefineArrowButton, gridBagConstraints, 0, 3, 1, 2, 20, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(4, 0, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mSubGroupLabel, gridBagConstraints, 1, 3, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(0, 0, n, n);
        JScrollPane jScrollPane2 = new JScrollPane(this.mSubgroupList);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setVerticalScrollBarPolicy(21);
        jScrollPane2.setPreferredSize(dimension);
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 1, 4, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n, 4, 4, 0);
        DialogUtil.addUsingGBL(jPanel, this.mGroupButton, gridBagConstraints, 0, 5, 2, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(0, n * 3, n, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSubSampleArrowButton, gridBagConstraints, 0, 6, 1, 2, 10, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(0, 0, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mSubSampleLabel, gridBagConstraints, 1, 6, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(0, 0, n, n);
        JScrollPane jScrollPane3 = new JScrollPane(this.mSubSampleTargetList);
        jScrollPane3.setHorizontalScrollBarPolicy(31);
        jScrollPane3.setVerticalScrollBarPolicy(20);
        jScrollPane3.setPreferredSize(new Dimension(dimension.width, dimension.height * 3));
        DialogUtil.addUsingGBL(jPanel, jScrollPane3, gridBagConstraints, 1, 7, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(4, 4, 4, n);
        DialogUtil.addUsingGBL(jPanel, this.mUnitButton, gridBagConstraints, 0, 8, 2, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(0, n * 3, 4, n);
        DialogUtil.addUsingGBL(jPanel, this.mUnitProcesArrowButton, gridBagConstraints, 0, 9, 1, 2, 20, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(0, 0, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mUnitProcessLabel, gridBagConstraints, 1, 9, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(0, 0, 4, n);
        JScrollPane jScrollPane4 = new JScrollPane(this.mUnitProcessMeasList);
        jScrollPane4.setHorizontalScrollBarPolicy(31);
        jScrollPane4.setVerticalScrollBarPolicy(21);
        jScrollPane4.setPreferredSize(dimension);
        DialogUtil.addUsingGBL(jPanel, jScrollPane4, gridBagConstraints, 1, 10, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(4, n * 3, n, 4);
        DialogUtil.addUsingGBL(jPanel, this.mSpanFieldLabel, gridBagConstraints, 0, 11, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(4, 0, n, n);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mSpanField, gridBagConstraints, 1, 11, 1, 1, n2, insets);
        return jPanel;
    }

    private void checkEnableOkPaste() {
        boolean bl = true;
        if (this.mUnitWithGroupButton.isSelected()) {
            bl = this.mSubProcessMeasList.getModel().getSize() > 0 && this.mSubgroupList.getModel().getSize() > 0;
        } else if (this.mGroupButton.isSelected()) {
            bl = this.mSubSampleTargetList.getModel().getSize() > 1;
        } else if (this.mUnitButton.isSelected()) {
            boolean bl2 = bl = this.mUnitProcessMeasList.getModel().getSize() > 0 && this.mSpanField.getText().length() > 0;
        }
        if (bl && this.mApplyChartCheck.isSelected()) {
            boolean bl3 = bl = this.mFilePath.getText().length() > 0;
        }
        if (bl) {
            bl = this.mUpperField.getText().length() > 0 && this.mLowerField.getText().length() > 0;
        }
        this.enableOkPaste(bl);
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcList);
        vector.add(this.mUnitWithGroupButton);
        vector.add(this.mSubProcessArrowButton);
        vector.add(this.mSubProcessMeasList);
        vector.add(this.mSubDefineArrowButton);
        vector.add(this.mSubgroupList);
        vector.add(this.mGroupButton);
        vector.add(this.mSubSampleArrowButton);
        vector.add(this.mSubSampleTargetList);
        vector.add(this.mUnitButton);
        vector.add(this.mUnitProcesArrowButton);
        vector.add(this.mUnitProcessMeasList);
        vector.add(this.mSpanField);
        vector.add(this.mApplyChartCheck);
        vector.add(this.mFileButton);
        vector.add(this.mFilePath);
        vector.add(this.mUpperField);
        vector.add(this.mLowerField);
        vector.add(this.mTargetField);
        vector.add(this.mTitleButton);
        vector.add(this.mOptionButton);
        vector.add(this.mStatisticsButton);
        for (Component component : componentArray = this.mOptionButtonPanel.getComponents()) {
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        componentArray = this.mCmdButtonPanel.getComponents();
        vector.addAll(Arrays.asList(componentArray));
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void showOpenDialog() {
        GraphsRemoteFileChooser graphsRemoteFileChooser = new GraphsRemoteFileChooser(this);
        graphsRemoteFileChooser.setDialogTitle(this.getResString("IDS_GRAPHS_CONTROLS_TEMPLATE_DIALOG_TITLE"));
        int n = graphsRemoteFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0) {
            this.mFilePath.setText(graphsRemoteFileChooser.getSelectedFilePath());
            this.checkEnableOkPaste();
        }
    }

    private void enableCompOnOtherStatRadio() {
        this.mSubProcessMeasList.setEnabled(true);
    }
}

