/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.quality_control.improved_control_charts;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class OptionSubDlg
extends BaseSubDialog
implements DocumentListener {
    static final String NUM_SIGMAX = "IDS_NUM_SIGMAS";
    static final String MIN_SUBGROUP_SIZE = "IDS_MIN_SUBGROUP_SIZE";
    private JLabel mNumSigmasLabel;
    private IntTextField mNumSigmas;
    private JLabel mMinSubSizeLabel;
    private IntTextField mMinSubgroupSize;
    private JCheckBox mCapCheck;
    private JCheckBox mPerfCheck;
    private JCheckBox mSpecLimitCheck;
    private JCheckBox mMeanSigmasCheck;

    public OptionSubDlg(BaseProcedureDialog baseProcedureDialog, String string) {
        super(baseProcedureDialog, string, true);
        this.initialize();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        return "";
    }

    @Override
    public boolean continuePressed() {
        boolean bl = true;
        return bl;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateContinue();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateContinue();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateContinue();
    }

    private void updateContinue() {
        this.enableContinue(this.mNumSigmas.getText().length() > 0 && this.mMinSubgroupSize.getText().length() > 0);
    }

    private void initVars() {
        this.mNumSigmasLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_QCONTROL_PROCESS_CAP_OPTION_SUB_NUM_SIGMAS");
        this.mNumSigmas = new IntTextField(1, 10, true);
        this.mNumSigmas.setAction((Action)new TextFieldAction(this.mParentDlg, NUM_SIGMAX));
        this.mNumSigmas.getDocument().addDocumentListener(this);
        this.mNumSigmasLabel.setLabelFor((Component)this.mNumSigmas);
        this.mMinSubSizeLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_QCONTROL_PROCESS_CAP_OPTION_SUB_MIN_SUBGROUP_SIZE");
        this.mMinSubgroupSize = new IntTextField(2, 100, true);
        this.mMinSubgroupSize.setAction((Action)new TextFieldAction(this.mParentDlg, MIN_SUBGROUP_SIZE));
        this.mMinSubgroupSize.getDocument().addDocumentListener(this);
        this.mMinSubSizeLabel.setLabelFor((Component)this.mMinSubgroupSize);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_QCONTROL_PROCESS_CAP_OPTION_SUB_CAPABILITY");
        this.mCapCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_QCONTROL_PROCESS_CAP_OPTION_SUB_PERFORMANCE");
        this.mPerfCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_QCONTROL_PROCESS_CAP_OPTION_SUB_SPEC_LIMIT");
        this.mSpecLimitCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_QCONTROL_PROCESS_CAP_OPTION_SUB_MIN_SIGMA");
        this.mMeanSigmasCheck = new JCheckBox(toggleButtonAction);
    }

    private void initialize() {
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 0, 0);
        gridBagConstraints.ipadx = 50;
        JComponent[] jComponentArray = new JComponent[]{this.mNumSigmasLabel, this.mNumSigmas};
        DialogUtil.addUsingGBL(jPanel, PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(n2, n2, 0, 0);
        jComponentArray = new JComponent[]{this.mMinSubSizeLabel, this.mMinSubgroupSize};
        DialogUtil.addUsingGBL(jPanel, PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.xaxis, ""), gridBagConstraints, 0, 1, 1, 1, n, insets);
        jComponentArray = new JComponent[]{this.mCapCheck, this.mPerfCheck};
        DialogUtil.addUsingGBL(jPanel, PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.mParentDlg.getResString("IDS_QCONTROL_PROCESS_CAP_OPTION_SUPERCURVE_TITLE")), gridBagConstraints, 0, 2, 1, 1, n, insets);
        jComponentArray = new JComponent[]{this.mSpecLimitCheck, this.mMeanSigmasCheck};
        DialogUtil.addUsingGBL(jPanel, PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.mParentDlg.getResString("IDS_QCONTROL_PROCESS_CAP_OPTION_REFERENCE_TITLE")), gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.setFocusTraversalPolicy();
        this.setDefaults();
        this.pack();
    }

    private void setDefaults() {
        this.mNumSigmas.setText("3");
        this.mMinSubgroupSize.setText("2");
        this.mCapCheck.setSelected(true);
        this.mPerfCheck.setSelected(false);
        this.mSpecLimitCheck.setSelected(true);
        this.mMeanSigmasCheck.setSelected(false);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mNumSigmas);
        vector.add(this.mMinSubgroupSize);
        vector.add(this.mCapCheck);
        vector.add(this.mPerfCheck);
        vector.add(this.mSpecLimitCheck);
        vector.add(this.mMeanSigmasCheck);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }
}

