/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.quality_control.control_charts;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.quality_control.control_charts.ControlOptions;
import com.spss.java_client.ui.dialogs.base.analyze.quality_control.control_charts.ControlRules;
import com.spss.java_client.ui.dialogs.base.analyze.quality_control.control_charts.ControlStatistics;
import com.spss.java_client.ui.dialogs.base.analyze.quality_control.control_charts.ControlsUtil;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsRemoteFileChooser;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsUtil;
import com.spss.java_client.ui.dialogs.base.graphs.TitlesSubDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class XBarCasesUnitsDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener,
DocumentListener {
    static final String APPLY_CHART_TEMPLATE_FROM_CHECKBOX = "IDS_GRAPHS_CONTROLS_APPLY_TEMPLATE_CHECKBOX";
    static final String XBAR_AND_RANGE_RADIO = "IDS_GRAPHS_CONTROLS_XBAR_CASES_XBAR_AND_RANGE_RADIO";
    static final String XBAR_AND_STD_DEV_RADIO = "IDS_GRAPHS_CONTROLS_XBAR_CASES_XBAR_AND_STD_DEV_RADIO";
    static final String FILE_BUTTON = "IDS_GRAPHS_CONTROLS_FILE_BUTTON";
    static final String TITLES_BUTTON = "IDS_REPORT_COMMON_TITLES_3DOT";
    static final String OPTIONS_BUTTON = "IDS_COMMON_OPTIONS_3DOT";
    static final String STATISTICS_BUTTON = "IDS_COMMON_STATS_3DOT";
    static final String CONTROL_RULES_BUTTON = "IDS_CONTROL_RULES_BUTTON";
    static final String DISPLAY_R_CHECK = "IDS_DISPLAY_R_CHART_CHECK";
    private TargetVariableList mProcessList;
    private TargetVariableList mSubgroupsList;
    private SrcVariableList mSrcVarList;
    private ArrowButton mProcessListArrow;
    private ArrowButton mSubgroupsListArrow;
    private JCheckBox mApplyChartTemplateCheckBox;
    private JButton mFileButton;
    private FileTextField mFilePath;
    private JRadioButton mXBarRangeRadio;
    private JRadioButton mXBarStdDevRadio;
    private SpssButtonGroup mRadioGroup;
    private TargetVariableList mIdentifyList;
    private ArrowButton mIdentifyArrow;
    private JCheckBox mDisplayRChartCheck;
    private boolean[] mValuesOfCharts;

    public XBarCasesUnitsDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_GRAPHS_CONTROLS_XBAR_CASES_ARE_UNITS_DLG_TITLE"));
    }

    @Override
    public String generateSyntax() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("SPCHART"));
        if (this.mXBarRangeRadio.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/XR="));
        } else {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/XS="));
        }
        stringBuffer.append(this.mProcessList.getModel().getElementAt(0).getName() + " BY " + this.mSubgroupsList.getModel().getElementAt(0).getName());
        if (!this.mDisplayRChartCheck.isSelected()) {
            stringBuffer.append(" (XBARONLY)");
        }
        stringBuffer.append(ControlsUtil.getStatisticsDialogSyntax(dialogDataModel));
        if (!ControlsUtil.getControlRulesDialogSyntax(dialogDataModel).equals("")) {
            stringBuffer.append(ControlsUtil.getControlRulesDialogSyntax(dialogDataModel));
        }
        if (this.mIdentifyList.getModel() != null && this.mIdentifyList.getModel().getSize() > 0) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/ID=") + this.mIdentifyList.getModel().getElementAt(0).getName());
        }
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/CAPSIGMA="));
        String string = "";
        Boolean bl = dialogDataModel.getBoolean("IDS_GRAPHS_CONTROLS_STATS_RBAR_RADIO");
        if (bl != null && bl.booleanValue()) {
            string = string + "RBAR";
        }
        if ((bl = dialogDataModel.getBoolean("IDS_GRAPHS_CONTROLS_STATS_SBAR_RADIO")) != null && bl.booleanValue()) {
            string = string + "SBAR";
        }
        if ((bl = dialogDataModel.getBoolean("IDS_GRAPHS_CONTROLS_STATS_SUBGRP_VARIENCE_RADIO")) != null && bl.booleanValue()) {
            string = string + "WITHIN";
        }
        if (string.equals("")) {
            string = this.mXBarRangeRadio.isSelected() ? string + "RBAR" : string + "SBAR";
        }
        stringBuffer.append(string);
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/SIGMAS="));
        String string2 = dialogDataModel.getString("IDS_GRAPHS_CONTROLS_OPTIONS_NUMBER_OF_SIGMAS_TEXTFIELD");
        if (string2 != null) {
            stringBuffer.append(string2);
        } else {
            stringBuffer.append("3");
        }
        string2 = dialogDataModel.getString("IDS_GRAPHS_CONTROLS_STATS_UPPER_TEXTFIELD_KEY");
        if (string2 != null && !string2.equals("")) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/USL=") + string2);
        }
        if ((string2 = dialogDataModel.getString("IDS_GRAPHS_CONTROLS_STATS_LOWER_TEXTFIELD_KEY")) != null && !string2.equals("")) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/LSL=") + string2);
        }
        if ((string2 = dialogDataModel.getString("IDS_GRAPHS_CONTROLS_STATS_TARGET_TEXTFIELD_KEY")) != null && !string2.equals("")) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/TARGET=") + string2);
        }
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/MINSAMPLE="));
        string2 = dialogDataModel.getString("IDS_GRAPHS_CONTROLS_OPTIONS_MIN_SUBGROUP_SIZE");
        if (string2 != null) {
            stringBuffer.append(string2);
        } else {
            stringBuffer.append("2");
        }
        bl = dialogDataModel.getBoolean("IDS_GRAPHS_CONTROLS_OPTIONS_DISPLAY_SUBGROUPS_CHECKBOX");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/MISSING=REPORT"));
        }
        if (this.mApplyChartTemplateCheckBox.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/TEMPLATE=") + CharacterUtil.smartQuote((String)this.mFilePath.getText()));
        }
        stringBuffer.append(GraphsUtil.generateTitlesSubDialogSyntax(dialogDataModel));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return "analyze_qlty_cont_control_xbar_cases_are_units";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_gcxu";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mApplyChartTemplateCheckBox) {
            boolean bl = this.mApplyChartTemplateCheckBox.isSelected();
            this.mFileButton.setEnabled(bl);
            this.mFilePath.setEnabled(bl);
            this.enableOkPaste(this.canEnableOkPaste());
        }
        if (itemEvent.getSource() == this.mXBarStdDevRadio && this.mXBarStdDevRadio.isSelected()) {
            this.mValuesOfCharts[0] = this.mDisplayRChartCheck.isSelected();
            this.mDisplayRChartCheck.setSelected(this.mValuesOfCharts[1]);
            this.mDisplayRChartCheck.setText(this.getResString("IDS_DISPLAY_S_CHART_CHECK"));
            if (this.getDialogDataModel() != null) {
                this.getDialogDataModel().putBoolean("IDS_GRAPHS_CONTROLS_STATS_RBAR_RADIO", false);
                this.getDialogDataModel().putBoolean("IDS_GRAPHS_CONTROLS_STATS_SBAR_RADIO", true);
                this.getDialogDataModel().putBoolean("IDS_GRAPHS_CONTROLS_STATS_SUBGRP_VARIENCE_RADIO", false);
            }
        }
        if (itemEvent.getSource() == this.mXBarRangeRadio && this.mXBarRangeRadio.isSelected()) {
            this.mValuesOfCharts[1] = this.mDisplayRChartCheck.isSelected();
            this.mDisplayRChartCheck.setSelected(this.mValuesOfCharts[0]);
            this.mDisplayRChartCheck.setText(this.getResString(DISPLAY_R_CHECK));
            if (this.getDialogDataModel() != null) {
                this.getDialogDataModel().putBoolean("IDS_GRAPHS_CONTROLS_STATS_RBAR_RADIO", true);
                this.getDialogDataModel().putBoolean("IDS_GRAPHS_CONTROLS_STATS_SBAR_RADIO", false);
                this.getDialogDataModel().putBoolean("IDS_GRAPHS_CONTROLS_STATS_SUBGRP_VARIENCE_RADIO", false);
            }
        }
    }

    public boolean canEnableOkPaste() {
        if (this.mProcessList.getModel().getSize() > 0 && this.mSubgroupsList.getModel().getSize() > 0) {
            if (this.mApplyChartTemplateCheckBox.isSelected()) {
                return this.mFilePath.getText().length() > 0;
            }
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        super.reset();
        this.mProcessList.removeAll();
        this.mSubgroupsList.removeAll();
        this.mIdentifyList.removeAll();
        this.mXBarRangeRadio.setSelected(true);
        this.mApplyChartTemplateCheckBox.setSelected(false);
        this.setDefaults();
    }

    public void paint(Graphics graphics) {
        if (this.mFilePath.getText() != null) {
            this.mFilePath.setText(this.mFilePath.getText());
        }
        super.paint(graphics);
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        if (this.mXBarRangeRadio.isSelected()) {
            this.getDialogDataModel().putBoolean("IDS_RANGE_VALUE", this.mDisplayRChartCheck.isSelected());
            this.getDialogDataModel().putBoolean("IDS_STANDARD_VALUE", this.mValuesOfCharts[1]);
        } else {
            this.getDialogDataModel().putBoolean("IDS_STANDARD_VALUE", this.mDisplayRChartCheck.isSelected());
            this.getDialogDataModel().putBoolean("IDS_RANGE_VALUE", this.mValuesOfCharts[0]);
        }
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        if (this.getDialogDataModel().getBoolean("IDS_STANDARD_VALUE") != null) {
            this.mValuesOfCharts[0] = this.getDialogDataModel().getBoolean("IDS_RANGE_VALUE");
            this.mValuesOfCharts[1] = this.getDialogDataModel().getBoolean("IDS_STANDARD_VALUE");
        }
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.setupViewPanel(), gridBagConstraints, 0, 0, 1, 1, n, null);
        this.setFocusTraversalPolicy();
        this.pack();
        this.mFilePath.setMinimumSize(this.mFilePath.getSize());
        this.mFilePath.setPreferredSize(this.mFilePath.getMinimumSize());
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(TITLES_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                XBarCasesUnitsDlg.this.runSubDialog(new TitlesSubDialog(XBarCasesUnitsDlg.this));
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        toggleButtonAction = new ToggleButtonAction(OPTIONS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                XBarCasesUnitsDlg.this.runSubDialog(new ControlOptions(XBarCasesUnitsDlg.this, XBarCasesUnitsDlg.this.getResString("IDS_GRAPHS_CONTROLS_XBAR_OPTIONS_TITLE"), true, "idh_gcxu_opts"));
            }
        };
        JButton jButton2 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton2);
        toggleButtonAction = new ToggleButtonAction(CONTROL_RULES_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                XBarCasesUnitsDlg.this.runSubDialog(new ControlRules((BaseProcedureDialog)XBarCasesUnitsDlg.this, XBarCasesUnitsDlg.this.getResString("IDS_XBAR_CONTROL_RULES_TITLE"), "idh_gcxu_rule"));
            }
        };
        JButton jButton3 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton3);
        toggleButtonAction = new ToggleButtonAction(STATISTICS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                XBarCasesUnitsDlg.this.runSubDialog(new ControlStatistics((BaseProcedureDialog)XBarCasesUnitsDlg.this, XBarCasesUnitsDlg.this.getResString("IDS_GRAPHS_CONTROLS_XBAR_STATISTICS_TITLE"), true, true, "idh_gcxu_stat"));
            }
        };
        JButton jButton4 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton4);
        return jPanel;
    }

    private void initVars() {
        this.mValuesOfCharts = new boolean[2];
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mProcessListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mSubgroupsListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mProcessList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mProcessList.getModel().addListDataListener(this);
        this.mProcessList.addVarFilter(new SpssVarFilter(8, false));
        this.mProcessList.setIdentifier("IDS_GRAPH_CONTROL_XBAR_UNITS_PROCESS_LIST");
        this.mSubgroupsList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mSubgroupsList.getModel().addListDataListener(this);
        this.mSubgroupsList.setIdentifier("IDS_GRAPH_CONTROL_XBAR_UNITS_SUBGROUP_LIST");
        this.mProcessListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mProcessListArrow.registerVariableList(this.mProcessList, SpssArrowButton.ButtonOrientation.left);
        this.mSubgroupsListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mSubgroupsListArrow.registerVariableList(this.mSubgroupsList, SpssArrowButton.ButtonOrientation.left);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, APPLY_CHART_TEMPLATE_FROM_CHECKBOX);
        this.mApplyChartTemplateCheckBox = new JCheckBox(toggleButtonAction);
        this.mApplyChartTemplateCheckBox.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, XBAR_AND_RANGE_RADIO);
        this.mXBarRangeRadio = new JRadioButton(toggleButtonAction);
        this.mXBarRangeRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, XBAR_AND_STD_DEV_RADIO);
        this.mXBarStdDevRadio = new JRadioButton(toggleButtonAction);
        this.mXBarStdDevRadio.addItemListener(this);
        this.mRadioGroup = new SpssButtonGroup();
        this.mRadioGroup.add(this.mXBarRangeRadio);
        this.mRadioGroup.add(this.mXBarStdDevRadio);
        toggleButtonAction = new ToggleButtonAction(this, FILE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                XBarCasesUnitsDlg.this.showOpenDialog();
            }
        };
        this.mFileButton = new JButton(toggleButtonAction);
        this.mFilePath = new FileTextField();
        this.mFilePath.setAction(new TextFieldAction(this, "IDS_GRAPHS_CONTROL_XBAR_CASES_ARE_UNITS_TEMPLATE_FILE"));
        this.mFilePath.setEditable(false);
        this.mFilePath.setOpaque(false);
        this.mFilePath.setBorder(BorderFactory.createEmptyBorder());
        this.mFilePath.getDocument().addDocumentListener(this);
        this.mIdentifyList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mIdentifyList.getModel().addListDataListener(this);
        this.mIdentifyList.setIdentifier("IDS_GRAPH_CONTROL_IDENTIFY_LIST");
        this.mIdentifyArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mIdentifyArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mIdentifyArrow.registerVariableList(this.mIdentifyList, SpssArrowButton.ButtonOrientation.left);
        toggleButtonAction = new ToggleButtonAction(this, DISPLAY_R_CHECK);
        this.mDisplayRChartCheck = new JCheckBox(toggleButtonAction);
    }

    private void setDefaults() {
        this.mFileButton.setEnabled(false);
        this.mFilePath.setText("");
        this.mFilePath.setEnabled(false);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mXBarRangeRadio.setSelected(true);
        this.mDisplayRChartCheck.setSelected(true);
        this.mValuesOfCharts[0] = true;
        this.mValuesOfCharts[1] = true;
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mApplyChartTemplateCheckBox.setEnabled(false);
        }
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mProcessListArrow);
        vector.add(this.mProcessList);
        vector.add(this.mSubgroupsListArrow);
        vector.add(this.mSubgroupsList);
        vector.add(this.mIdentifyArrow);
        vector.add(this.mIdentifyList);
        vector.add(this.mRadioGroup);
        vector.add(this.mDisplayRChartCheck);
        vector.add(this.mApplyChartTemplateCheckBox);
        vector.add(this.mFileButton);
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void showOpenDialog() {
        GraphsRemoteFileChooser graphsRemoteFileChooser = new GraphsRemoteFileChooser(this);
        graphsRemoteFileChooser.setDialogTitle(this.getResString("IDS_GRAPHS_CONTROLS_TEMPLATE_DIALOG_TITLE"));
        int n = graphsRemoteFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0) {
            this.mFilePath.setText(graphsRemoteFileChooser.getSelectedFilePath());
            this.canEnableOkPaste();
        }
    }

    private JPanel setupViewPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_GRAPHS_CONTROLS_PROCESS_MEASUREMENT_LABEL");
        jLabel.setLabelFor(this.mProcessList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_GRAPHS_CONTROLS_SUBGROUPS_DEFINED_BY");
        jLabel2.setLabelFor(this.mSubgroupsList);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        JScrollPane jScrollPane2 = new JScrollPane(this.mProcessList);
        jScrollPane2.setPreferredSize(this.mProcessList.getMinimumSize());
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setVerticalScrollBarPolicy(21);
        JScrollPane jScrollPane3 = new JScrollPane(this.mSubgroupsList);
        jScrollPane3.setPreferredSize(this.mSubgroupsList.getMinimumSize());
        jScrollPane3.setHorizontalScrollBarPolicy(31);
        jScrollPane3.setVerticalScrollBarPolicy(21);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_GRAPHS_CONTROLS_XBAR_CASES_UNIT_SOURCE_LABEL");
        jLabel3.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 8, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(0, insets2.left, 0, insets2.right);
        n = 20;
        DialogUtil.addUsingGBL(jPanel, this.mProcessListArrow, gridBagConstraints, 1, 0, 1, 2, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(0, insets2.left, 0, insets2.right);
        n = 20;
        DialogUtil.addUsingGBL(jPanel, this.mSubgroupsListArrow, gridBagConstraints, 1, 2, 1, 2, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        insets.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jScrollPane3, gridBagConstraints, 2, 3, 1, 1, n, null);
        JScrollPane jScrollPane4 = new JScrollPane(this.mIdentifyList);
        jScrollPane4.setPreferredSize(this.mIdentifyList.getMinimumSize());
        jScrollPane4.setHorizontalScrollBarPolicy(31);
        jScrollPane4.setVerticalScrollBarPolicy(21);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(0, insets2.left, 0, insets2.right);
        n = 20;
        DialogUtil.addUsingGBL(jPanel, this.mIdentifyArrow, gridBagConstraints, 1, 4, 1, 2, n, insets);
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_GRAPHS_CONTROL_IDENTIFY_LABEL");
        jLabel4.setLabelFor(this.mIdentifyList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        insets.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 2, 4, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jScrollPane4, gridBagConstraints, 2, 5, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = this.setupChartsPanel();
        insets.set(n2, 20, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 6, 3, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.setupTemplatePanel(), gridBagConstraints, 1, 8, 2, 1, n, insets);
        return jPanel;
    }

    private JPanel setupTemplatePanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mApplyChartTemplateCheckBox, this.mFileButton, this.mFilePath};
        return PanelFactory.getGraphsChartTemplatePanel(jComponentArray, this.getResString("IDS_GRAPHS_CONTROLS_TEMPLATE"));
    }

    private JPanel setupChartsPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mXBarRangeRadio, this.mXBarStdDevRadio, this.mDisplayRChartCheck};
        return ControlsUtil.getGraphsControlsChartsPanel(jComponentArray, this.getResString("IDS_GRAPHS_CONTROLS_CHARTS"));
    }
}

