/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.quality_control.control_charts;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.quality_control.control_charts.ControlOptions;
import com.spss.java_client.ui.dialogs.base.analyze.quality_control.control_charts.ControlRules;
import com.spss.java_client.ui.dialogs.base.analyze.quality_control.control_charts.ControlsUtil;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsRemoteFileChooser;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsUtil;
import com.spss.java_client.ui.dialogs.base.graphs.TitlesSubDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class PnpCasesUnitsDlg
extends BaseProcedureDialog
implements ItemListener,
DocumentListener,
ListDataListener {
    static final String VALUE_TEXTFIELD = "IDS_GRAPHS_CONTROLS_PNP_CASES_VALUE_TEXTFIELD";
    static final String APPLY_CHART_TEMPLATE_FROM_CHECKBOX = "IDS_GRAPHS_CONTROLS_APPLY_TEMPLATE_CHECKBOX";
    static final String P_RADIO = "IDS_GRAPHS_CONTROLS_PNP_CASES_ARE_UNITS_P_RADIO";
    static final String NP_RADIO = "IDS_GRAPHS_CONTROLS_PNP_CASES_ARE_UNITS_NP_RADIO";
    static final String FILE_BUTTON = "IDS_GRAPHS_CONTROLS_FILE_BUTTON";
    static final String TITLES_BUTTON = "IDS_REPORT_COMMON_TITLES_3DOT";
    static final String OPTIONS_BUTTON = "IDS_COMMON_OPTIONS_3DOT";
    static final String NON_CONFORMING_RADIO = "IDS_GRAPHS_CONTROLS_PNP_CASES_ARE_UNITS_NONCONFORMING_RADIO";
    static final String CONFORMING_RADIO = "IDS_GRAPHS_CONTROLS_PNP_CASES_ARE_UNITS_CONFORMING_RADIO";
    static final String CONTROL_RULES_BUTTON = "IDS_CONTROL_RULES_BUTTON";
    private TargetVariableList mCharacteristicList;
    private TargetVariableList mSubgroupsList;
    private SrcVariableList mSrcVarList;
    private ArrowButton mCharacteristicListArrow;
    private ArrowButton mSubgroupsListArrow;
    private JCheckBox mApplyChartTemplateCheckBox;
    private JButton mFileButton;
    private FileTextField mFilePath;
    private SpssButtonGroup mRadioGroup;
    private SpssButtonGroup mConformingRadioGroup;
    private JTextField mValueTextField;
    private JRadioButton mPRadio;
    private JRadioButton mNpRadio;
    private JRadioButton mNonConformingRadio;
    private JRadioButton mConformingRadio;
    private TargetVariableList mIdentifyList;
    private ArrowButton mIdentifyArrow;

    public PnpCasesUnitsDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_GRAPHS_CONTROLS_PNP_CASES_ARE_UNITS_DLG_TITLE"));
    }

    @Override
    public String generateSyntax() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("SPCHART"));
        if (this.mPRadio.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/P="));
        } else {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/NP="));
        }
        ISpssVariable iSpssVariable = this.mCharacteristicList.getModel().getElementAt(0);
        stringBuffer.append(iSpssVariable.getName() + " BY " + this.mSubgroupsList.getModel().getElementAt(0).getName());
        if (!ControlsUtil.getControlRulesDialogSyntax(dialogDataModel).equals("")) {
            stringBuffer.append(ControlsUtil.getControlRulesDialogSyntax(dialogDataModel));
        }
        if (this.mIdentifyList.getModel() != null && this.mIdentifyList.getModel().getSize() > 0) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/ID=") + this.mIdentifyList.getModel().getElementAt(0).getName());
        }
        if (this.mNonConformingRadio.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/NONCONFORM="));
        } else {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/CONFORM="));
        }
        if (iSpssVariable.getType() > 0) {
            stringBuffer.append(CharacterUtil.smartQuote((String)UIToolResUtil.removeLocale((String)this.mValueTextField.getText())));
        } else {
            stringBuffer.append(UIToolResUtil.removeLocale((String)this.mValueTextField.getText()));
        }
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/SIGMAS="));
        String string = dialogDataModel.getString("IDS_GRAPHS_CONTROLS_OPTIONS_NUMBER_OF_SIGMAS_TEXTFIELD");
        if (string != null) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append("3");
        }
        Boolean bl = dialogDataModel.getBoolean("IDS_GRAPHS_CONTROLS_OPTIONS_DISPLAY_SUBGROUPS_CHECKBOX");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/MISSING=REPORT"));
        }
        if (this.mApplyChartTemplateCheckBox.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/TEMPLATE=") + CharacterUtil.smartQuote((String)this.mFilePath.getText()));
        }
        stringBuffer.append(GraphsUtil.generateTitlesSubDialogSyntax(dialogDataModel));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public boolean okPastePressed() {
        ISpssVariable iSpssVariable = this.mCharacteristicList.getModel().getElementAt(0);
        if (!iSpssVariable.getFormat().getFormatType().isStringFormat()) {
            try {
                Float.parseFloat(UIToolResUtil.removeLocale((String)this.mValueTextField.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_GRAPHS_CONTROLS_PNP_CASES_ARE_UNITS_NON_NUMERIC_VAL"), VersionInfo.getAppVersionString());
                return false;
            }
        }
        return super.okPastePressed();
    }

    @Override
    public String getIActionKey() {
        return "analyze_qlty_cont_control_pnp_cases_are_units";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_gcpu";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mApplyChartTemplateCheckBox) {
            boolean bl = this.mApplyChartTemplateCheckBox.isSelected();
            this.mFileButton.setEnabled(bl);
            this.mFilePath.setEnabled(bl);
            this.enableOkPaste(this.canEnableOkPaste());
        }
    }

    public boolean canEnableOkPaste() {
        if (this.mCharacteristicList.getModel().getSize() > 0 && this.mSubgroupsList.getModel().getSize() > 0 && this.mValueTextField.getText().length() > 0) {
            if (this.mApplyChartTemplateCheckBox.isSelected()) {
                return this.mFilePath.getText().length() > 0;
            }
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        super.reset();
        this.mCharacteristicList.removeAll();
        this.mSubgroupsList.removeAll();
        this.mIdentifyList.removeAll();
        this.mNonConformingRadio.setSelected(true);
        this.mPRadio.setSelected(true);
        this.mValueTextField.setText("");
        this.mApplyChartTemplateCheckBox.setSelected(false);
        this.setDefaults();
    }

    public void paint(Graphics graphics) {
        if (this.mFilePath.getText() != null) {
            this.mFilePath.setText(this.mFilePath.getText());
        }
        super.paint(graphics);
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.setupViewPanel(), gridBagConstraints, 0, 0, 1, 1, n, null);
        this.pack();
        this.setFocusTraversalPolicy();
        this.mFilePath.setMinimumSize(this.mFilePath.getSize());
        this.mFilePath.setPreferredSize(this.mFilePath.getMinimumSize());
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(TITLES_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PnpCasesUnitsDlg.this.runSubDialog(new TitlesSubDialog(PnpCasesUnitsDlg.this));
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        toggleButtonAction = new ToggleButtonAction(OPTIONS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PnpCasesUnitsDlg.this.runSubDialog(new ControlOptions(PnpCasesUnitsDlg.this, PnpCasesUnitsDlg.this.getResString("IDS_GRAPHS_CONTROLS_PNP_OPTIONS_TITLE"), false, "idh_gcpu_opts"));
            }
        };
        JButton jButton2 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton2);
        toggleButtonAction = new ToggleButtonAction(CONTROL_RULES_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PnpCasesUnitsDlg.this.runSubDialog(new ControlRules((BaseProcedureDialog)PnpCasesUnitsDlg.this, PnpCasesUnitsDlg.this.getResString("IDS_PNP_CONTROL_RULES_TITLE"), "idh_gcpu_rule"));
            }
        };
        JButton jButton3 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton3);
        return jPanel;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mCharacteristicListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mSubgroupsListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCharacteristicList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mCharacteristicList.getModel().addListDataListener(this);
        this.mCharacteristicList.setIdentifier("IDS_GRAPH_CONTROL_PNP_UNITS_CHARACTERISTICS_LIST");
        this.mSubgroupsList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mSubgroupsList.getModel().addListDataListener(this);
        this.mSubgroupsList.setIdentifier("IDS_GRAPH_CONTROL_PNP_UNITS_SUBGROUP_LIST");
        this.mCharacteristicListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mCharacteristicListArrow.registerVariableList(this.mCharacteristicList, SpssArrowButton.ButtonOrientation.left);
        this.mSubgroupsListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mSubgroupsListArrow.registerVariableList(this.mSubgroupsList, SpssArrowButton.ButtonOrientation.left);
        this.mValueTextField = new JTextField();
        this.mValueTextField.getDocument().addDocumentListener(this);
        this.mValueTextField.setAction(new TextFieldAction(this, VALUE_TEXTFIELD));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, APPLY_CHART_TEMPLATE_FROM_CHECKBOX);
        this.mApplyChartTemplateCheckBox = new JCheckBox(toggleButtonAction);
        this.mApplyChartTemplateCheckBox.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, P_RADIO);
        this.mPRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, NP_RADIO);
        this.mNpRadio = new JRadioButton(toggleButtonAction);
        this.mRadioGroup = new SpssButtonGroup();
        this.mRadioGroup.add(this.mPRadio);
        this.mRadioGroup.add(this.mNpRadio);
        this.mPRadio.setSelected(true);
        toggleButtonAction = new ToggleButtonAction(this, NON_CONFORMING_RADIO);
        this.mNonConformingRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, CONFORMING_RADIO);
        this.mConformingRadio = new JRadioButton(toggleButtonAction);
        this.mConformingRadioGroup = new SpssButtonGroup();
        this.mConformingRadioGroup.add(this.mNonConformingRadio);
        this.mConformingRadioGroup.add(this.mConformingRadio);
        this.mNonConformingRadio.setSelected(true);
        toggleButtonAction = new ToggleButtonAction(this, FILE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PnpCasesUnitsDlg.this.showOpenDialog();
            }
        };
        this.mFileButton = new JButton(toggleButtonAction);
        this.mFilePath = new FileTextField();
        this.mFilePath.setAction(new TextFieldAction(this, "IDS_GRAPHS_CONTROL_XBAR_CASES_ARE_SUBGROUPS_TEMPLATE_FILE"));
        this.mFilePath.setEditable(false);
        this.mFilePath.setOpaque(false);
        this.mFilePath.setBorder(BorderFactory.createEmptyBorder());
        this.mFilePath.getDocument().addDocumentListener(this);
        this.mIdentifyList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mIdentifyList.getModel().addListDataListener(this);
        this.mIdentifyList.setIdentifier("IDS_GRAPH_CONTROL_IDENTIFY_LIST");
        this.mIdentifyArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mIdentifyArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mIdentifyArrow.registerVariableList(this.mIdentifyList, SpssArrowButton.ButtonOrientation.left);
        this.mValueTextField.setColumns(3);
    }

    private void setDefaults() {
        this.mFileButton.setEnabled(false);
        this.mFilePath.setText("");
        this.mFilePath.setEnabled(false);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mApplyChartTemplateCheckBox.setEnabled(false);
        }
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mCharacteristicListArrow);
        vector.add(this.mCharacteristicList);
        vector.add(this.mConformingRadioGroup);
        vector.add(this.mValueTextField);
        vector.add(this.mSubgroupsListArrow);
        vector.add(this.mSubgroupsList);
        vector.add(this.mIdentifyArrow);
        vector.add(this.mIdentifyList);
        vector.add(this.mRadioGroup);
        vector.add(this.mApplyChartTemplateCheckBox);
        vector.add(this.mFileButton);
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void showOpenDialog() {
        GraphsRemoteFileChooser graphsRemoteFileChooser = new GraphsRemoteFileChooser(this);
        graphsRemoteFileChooser.setDialogTitle(this.getResString("IDS_GRAPHS_CONTROLS_TEMPLATE_DIALOG_TITLE"));
        int n = graphsRemoteFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0) {
            this.mFilePath.setText(graphsRemoteFileChooser.getSelectedFilePath());
            this.canEnableOkPaste();
        }
    }

    private JPanel setupViewPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_GRAPHS_CONTROLS_CHARACTERISTICS_LABEL");
        jLabel.setLabelFor(this.mCharacteristicList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_GRAPHS_CONTROLS_SUBGROUPS_DEFINED_BY");
        jLabel2.setLabelFor(this.mSubgroupsList);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        JScrollPane jScrollPane2 = new JScrollPane(this.mCharacteristicList);
        jScrollPane2.setPreferredSize(this.mCharacteristicList.getMinimumSize());
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setVerticalScrollBarPolicy(21);
        JScrollPane jScrollPane3 = new JScrollPane(this.mSubgroupsList);
        jScrollPane3.setPreferredSize(this.mSubgroupsList.getMinimumSize());
        jScrollPane3.setHorizontalScrollBarPolicy(31);
        jScrollPane3.setVerticalScrollBarPolicy(21);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_GRAPHS_CONTROLS_PNP_CASES_ARE_UNITS_SOURCE_LABEL");
        jLabel3.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 8, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(0, insets2.left, 0, insets2.right);
        n = 20;
        DialogUtil.addUsingGBL(jPanel, this.mCharacteristicListArrow, gridBagConstraints, 1, 0, 1, 2, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, 20, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupValueCountPanel(), gridBagConstraints, 1, 2, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(0, insets2.left, 0, insets2.right);
        n = 20;
        DialogUtil.addUsingGBL(jPanel, this.mSubgroupsListArrow, gridBagConstraints, 1, 3, 1, 2, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, 0, 0, 0);
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jScrollPane3, gridBagConstraints, 2, 4, 1, 1, n, null);
        JScrollPane jScrollPane4 = new JScrollPane(this.mIdentifyList);
        jScrollPane4.setPreferredSize(this.mIdentifyList.getMinimumSize());
        jScrollPane4.setHorizontalScrollBarPolicy(31);
        jScrollPane4.setVerticalScrollBarPolicy(21);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(0, insets2.left, 0, insets2.right);
        n = 20;
        DialogUtil.addUsingGBL(jPanel, this.mIdentifyArrow, gridBagConstraints, 1, 5, 1, 2, n, insets);
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_GRAPHS_CONTROL_IDENTIFY_LABEL");
        jLabel4.setLabelFor(this.mIdentifyList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        insets.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 2, 5, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jScrollPane4, gridBagConstraints, 2, 6, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n2, 20, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupChartsPanel(), gridBagConstraints, 1, 7, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.setupTemplatePanel(), gridBagConstraints, 1, 8, 2, 1, n, insets);
        return jPanel;
    }

    private JPanel setupValueCountPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_GRAPHS_CONTROLS_PNP_CASES_ARE_UNITS_VALUE_TO_COUNT_TITLE")));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        JPanel jPanel4 = new JPanel();
        DialogUtil.applyTopBorder(jPanel4);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_GRAPHS_CONTROLS_PNP_CASES_ARE_UNITS_VALUE_LABEL");
        jLabel.setLabelFor(this.mValueTextField);
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = DialogUtil.getComponentGroupGap();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(n, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel2, this.mNonConformingRadio, gridBagConstraints, 0, 0, 1, 1, 23, null);
        gridBagConstraints.weightx = 1.0;
        insets.set(n, n, n, 0);
        DialogUtil.addUsingGBL(jPanel2, this.mConformingRadio, gridBagConstraints, 1, 0, 1, 1, 23, null);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, 23, null);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 1, 1, 1, 23, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets.set(0, n, n, 0);
        DialogUtil.addUsingGBL(jPanel3, jLabel, gridBagConstraints, 0, 0, 1, 1, 23, insets);
        gridBagConstraints.weightx = 1.0;
        insets.set(0, n2, n, 0);
        DialogUtil.addUsingGBL(jPanel3, this.mValueTextField, gridBagConstraints, 1, 0, 1, 1, 23, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 2, 1, 1, 23, null);
        return jPanel;
    }

    private JPanel setupTemplatePanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mApplyChartTemplateCheckBox, this.mFileButton, this.mFilePath};
        return PanelFactory.getGraphsChartTemplatePanel(jComponentArray, this.getResString("IDS_GRAPHS_CONTROLS_TEMPLATE"));
    }

    private JPanel setupChartsPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mPRadio, this.mNpRadio};
        return ControlsUtil.getGraphsControlsChartsPanel(jComponentArray, this.getResString("IDS_GRAPHS_CONTROLS_CHART"));
    }
}

