/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.quality_control.control_charts;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.quality_control.control_charts.ControlOptions;
import com.spss.java_client.ui.dialogs.base.analyze.quality_control.control_charts.ControlRules;
import com.spss.java_client.ui.dialogs.base.analyze.quality_control.control_charts.ControlsUtil;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsRemoteFileChooser;
import com.spss.java_client.ui.dialogs.base.graphs.GraphsUtil;
import com.spss.java_client.ui.dialogs.base.graphs.TitlesSubDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.SPSSTextField;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.Document;

public class PnpCasesAreSubgroupsDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener,
DocumentListener {
    static final String IDS_CONSTANT_RADIO = "IDS_GRAPHS_CONTROLS_CONSTANT_RADIO";
    static final String IDS_VARIABLE_RADIO = "IDS_GRAPHS_CONTROLS_VARIABLE_RADIO";
    static final String IDS_SAMPLE_FIELD = "IDS_GRAPHS_CONTROLS_PNP_SAMPLE_FIELD";
    static final String APPLY_CHART_TEMPLATE_FROM_CHECKBOX = "IDS_GRAPHS_CONTROLS_APPLY_TEMPLATE_CHECKBOX";
    static final String PER_UNIT_RADIO = "IDS_GRAPHS_CONTROLS_PNP_CASES_ARE_UNITS_P_RADIO";
    static final String NUMBER_OF_RADIO = "IDS_GRAPHS_CONTROLS_PNP_CASES_ARE_UNITS_NP_RADIO";
    static final String CONTROL_RULES_BUTTON = "IDS_CONTROL_RULES_BUTTON";
    static final String FILE_BUTTON = "IDS_GRAPHS_CONTROLS_FILE_BUTTON";
    static final String TITLES_BUTTON = "IDS_REPORT_COMMON_TITLES_3DOT";
    static final String OPTIONS_BUTTON = "IDS_COMMON_OPTIONS_3DOT";
    private TargetVariableList mNonConformList;
    private TargetVariableList mSubgroupsList;
    private SrcVariableList mSrcVarList;
    private ArrowButton mNonConformArrow;
    private ArrowButton mSubgroupsListArrow;
    private JCheckBox mApplyChartTemplateCheckBox;
    private JButton mFileButton;
    private FileTextField mFilePath;
    private JRadioButton mPRadioButton;
    private JRadioButton mNpRadioButton;
    private TargetVariableList mSampleList;
    private ArrowButton mSampleArrowButton;
    private JRadioButton mConstantRadio;
    private JRadioButton mVariableRadio;
    private IntTextField mSampleTextField;
    private SpssButtonGroup mNonConformRadioGroup;
    private SpssButtonGroup mSampleRadiogroup;
    private TargetVariableList mIdentifyList;
    private ArrowButton mIdentifyArrow;

    public PnpCasesAreSubgroupsDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_GRAPHS_CONTROLS_PNP_CASES_ARE_SUBGROUPS_DLG_TITLE"));
    }

    @Override
    public String generateSyntax() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("SPCHART"));
        if (this.mPRadioButton.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/P="));
        } else {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/NP="));
        }
        stringBuffer.append("COUNT(" + this.mNonConformList.getModel().getElementAt(0).getName() + ") ");
        stringBuffer.append("N(");
        if (this.mConstantRadio.isSelected()) {
            stringBuffer.append(this.mSampleTextField.getText() + ")");
        } else {
            stringBuffer.append(this.mSampleList.getModel().getElementAt(0).getName() + ")");
        }
        if (this.mSubgroupsList.getModel().getSize() > 0) {
            stringBuffer.append(" BY " + this.mSubgroupsList.getModel().getElementAt(0).getName());
        }
        if (!ControlsUtil.getControlRulesDialogSyntax(dialogDataModel).equals("")) {
            stringBuffer.append(ControlsUtil.getControlRulesDialogSyntax(dialogDataModel));
        }
        if (this.mIdentifyList.getModel() != null && this.mIdentifyList.getModel().getSize() > 0) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/ID=") + this.mIdentifyList.getModel().getElementAt(0).getName());
        }
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/SIGMAS="));
        String string = dialogDataModel.getString("IDS_GRAPHS_CONTROLS_OPTIONS_NUMBER_OF_SIGMAS_TEXTFIELD");
        if (string != null) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append("3");
        }
        Boolean bl = dialogDataModel.getBoolean("IDS_GRAPHS_CONTROLS_OPTIONS_DISPLAY_SUBGROUPS_CHECKBOX");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/MISSING=REPORT"));
        }
        if (this.mApplyChartTemplateCheckBox.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/TEMPLATE=") + CharacterUtil.smartQuote((String)this.mFilePath.getText()));
        }
        stringBuffer.append(GraphsUtil.generateTitlesSubDialogSyntax(dialogDataModel));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return "analyze_qlty_cont_control_pnp_cases_are_subgroups";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_gcps";
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        if (this.getDialogDataModel() != null) {
            this.enableOkPaste(this.canEnableOkPaste());
        }
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mApplyChartTemplateCheckBox) {
            boolean bl = this.mApplyChartTemplateCheckBox.isSelected();
            this.mFileButton.setEnabled(bl);
            this.mFilePath.setEnabled(bl);
            this.enableOkPaste(this.canEnableOkPaste());
        }
        if (itemEvent.getSource() == this.mConstantRadio || itemEvent.getSource() == this.mVariableRadio) {
            this.mSampleTextField.setEditable(!this.mVariableRadio.isSelected());
            this.mSampleTextField.setEnabled(!this.mVariableRadio.isSelected());
            this.enableSampleArrowButton();
            this.enableOkPaste(this.canEnableOkPaste());
        }
    }

    public void enableSampleArrowButton() {
        boolean bl = true;
        if (!this.mVariableRadio.isSelected()) {
            bl = false;
        } else {
            boolean bl2;
            boolean bl3 = this.mSrcVarList.getSelectedValues() != null && this.mSrcVarList.getSelectedValues().length == 1;
            boolean bl4 = bl2 = this.mSampleList.getSelectedValues() != null && this.mSampleList.getSelectedValues().length > 0;
            if (this.mSampleArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.right && (!bl3 || bl2)) {
                bl = false;
            }
            if (!bl2 && this.mSampleArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.left) {
                bl = false;
            }
        }
        this.mSampleArrowButton.setEnabled(bl);
        this.mSampleList.setEnabled(this.mVariableRadio.isSelected());
        this.mSampleList.setOpaque(this.mVariableRadio.isSelected());
    }

    public boolean canEnableOkPaste() {
        if (this.mNonConformList.getModel().getSize() > 0) {
            if (this.mConstantRadio.isSelected()) {
                if (this.mSampleTextField.getText().length() > 0) {
                    if (this.mApplyChartTemplateCheckBox.isSelected()) {
                        return this.mFilePath.getText().length() > 0;
                    }
                    return true;
                }
            } else if (this.mSampleList.getModel().getSize() > 0) {
                if (this.mApplyChartTemplateCheckBox.isSelected()) {
                    return this.mFilePath.getText().length() > 0;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void reset() {
        super.reset();
        this.mNonConformList.getModel().removeAll();
        this.mSubgroupsList.getModel().removeAll();
        this.mIdentifyList.removeAll();
        this.mSampleList.getModel().removeAll();
        this.setDefaults();
    }

    @Override
    protected boolean okPastePressed() {
        int n;
        String string = this.mSampleTextField.getText();
        if (string.length() > 0 && ((n = Integer.parseInt(string)) < 1 || n > 99999)) {
            String string2 = MessageFormat.format(UIToolResUtil.getString((String)"ERR_WARNING_MESSAGE"), "1", "99999");
            SPSSTextField.showWarningDialog((JComponent)this.mSampleTextField, (String)string2, (String)UIToolResUtil.getString((String)"IDS_WARNING_TITLE"));
            this.setSelectionText((JTextField)this.mSampleTextField, 0);
            return false;
        }
        return true;
    }

    private void setSelectionText(final JTextField jTextField, int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jTextField.requestFocusInWindow();
            }
        });
        jTextField.setSelectionStart(n);
        jTextField.setSelectionEnd(jTextField.getText().length());
    }

    public void paint(Graphics graphics) {
        if (this.mFilePath.getText() != null) {
            this.mFilePath.setText(this.mFilePath.getText());
        }
        super.paint(graphics);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.setupViewPanel(), gridBagConstraints, 0, 0, 1, 1, n, null);
        this.pack();
        this.setFocusTraversalPolicy();
        this.mFilePath.setMinimumSize(this.mFilePath.getSize());
        this.mFilePath.setPreferredSize(this.mFilePath.getMinimumSize());
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(TITLES_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PnpCasesAreSubgroupsDlg.this.runSubDialog(new TitlesSubDialog(PnpCasesAreSubgroupsDlg.this));
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        toggleButtonAction = new ToggleButtonAction(OPTIONS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PnpCasesAreSubgroupsDlg.this.runSubDialog(new ControlOptions(PnpCasesAreSubgroupsDlg.this, PnpCasesAreSubgroupsDlg.this.getResString("IDS_GRAPHS_CONTROLS_PNP_OPTIONS_TITLE"), false, "idh_gcps_opts"));
            }
        };
        JButton jButton2 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton2);
        toggleButtonAction = new ToggleButtonAction(CONTROL_RULES_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PnpCasesAreSubgroupsDlg.this.runSubDialog(new ControlRules((BaseProcedureDialog)PnpCasesAreSubgroupsDlg.this, PnpCasesAreSubgroupsDlg.this.getResString("IDS_PNP_CONTROL_RULES_TITLE"), "idh_gcps_rule"));
            }
        };
        JButton jButton3 = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton3);
        return jPanel;
    }

    private void initVars() {
        FocusListener[] focusListenerArray;
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mNonConformArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mSubgroupsListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mSampleList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mSampleList.setIdentifier("IDS_PNP_SAMPLE_LIST");
        this.mSampleArrowButton = new SampleArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mSampleArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mSampleArrowButton.registerVariableList(this.mSampleList, SpssArrowButton.ButtonOrientation.left);
        this.mSampleList.getModel().addListDataListener(this);
        this.mNonConformList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mNonConformList.setIdentifier("IDS_PNP_NON_CONFORM_LIST");
        this.mNonConformList.getModel().addListDataListener(this);
        this.mSubgroupsList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mSubgroupsList.setIdentifier("IDS_PNP_SUBGROUP_LIST");
        this.mSubgroupsList.getModel().addListDataListener(this);
        this.mNonConformArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mNonConformArrow.registerVariableList(this.mNonConformList, SpssArrowButton.ButtonOrientation.left);
        this.mSubgroupsListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mSubgroupsListArrow.registerVariableList(this.mSubgroupsList, SpssArrowButton.ButtonOrientation.left);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, APPLY_CHART_TEMPLATE_FROM_CHECKBOX);
        this.mApplyChartTemplateCheckBox = new JCheckBox(toggleButtonAction);
        this.mApplyChartTemplateCheckBox.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, PER_UNIT_RADIO);
        this.mPRadioButton = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, NUMBER_OF_RADIO);
        this.mNpRadioButton = new JRadioButton(toggleButtonAction);
        this.mNonConformRadioGroup = new SpssButtonGroup();
        this.mNonConformRadioGroup.add(this.mPRadioButton);
        this.mNonConformRadioGroup.add(this.mNpRadioButton);
        this.mPRadioButton.setSelected(true);
        toggleButtonAction = new ToggleButtonAction(this, FILE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PnpCasesAreSubgroupsDlg.this.showOpenDialog();
            }
        };
        this.mFileButton = new JButton(toggleButtonAction);
        this.mFilePath = new FileTextField();
        this.mFilePath.setAction(new TextFieldAction(this, "IDS_GRAPHS_CONTROL_PNP_CASES_ARE_UNITS_TEMPLATE_FILE"));
        this.mFilePath.setEditable(false);
        this.mFilePath.setOpaque(false);
        this.mFilePath.setBorder(BorderFactory.createEmptyBorder());
        this.mFilePath.getDocument().addDocumentListener(this);
        toggleButtonAction = new ToggleButtonAction(this, IDS_CONSTANT_RADIO);
        this.mConstantRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, IDS_VARIABLE_RADIO);
        this.mVariableRadio = new JRadioButton(toggleButtonAction);
        this.mSampleRadiogroup = new SpssButtonGroup();
        this.mSampleRadiogroup.add(this.mConstantRadio);
        this.mSampleRadiogroup.add(this.mVariableRadio);
        this.mConstantRadio.addItemListener(this);
        this.mVariableRadio.addItemListener(this);
        this.mSampleTextField = new IntTextField(1, 99999, true);
        this.mSampleTextField.setAction((Action)new TextFieldAction(this, IDS_SAMPLE_FIELD));
        this.mSampleTextField.setDocument((Document)new FixedLengthNumericDocument(5, true, false));
        for (FocusListener focusListener : focusListenerArray = this.mSampleTextField.getFocusListeners()) {
            if (!(focusListener instanceof IntTextField)) continue;
            this.mSampleTextField.removeFocusListener(focusListener);
            break;
        }
        MyKeyAdapter myKeyAdapter = new MyKeyAdapter();
        this.mSampleTextField.addKeyListener((KeyListener)myKeyAdapter);
        this.mNonConformList.addVarFilter(new SpssVarFilter(8, false));
        this.mSampleList.addVarFilter(new SpssVarFilter(8, false));
        this.mIdentifyList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mIdentifyList.getModel().addListDataListener(this);
        this.mIdentifyList.setIdentifier("IDS_GRAPH_CONTROL_IDENTIFY_LIST");
        this.mIdentifyArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mIdentifyArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mIdentifyArrow.registerVariableList(this.mIdentifyList, SpssArrowButton.ButtonOrientation.left);
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mFileButton.setEnabled(false);
        this.mFilePath.setText("");
        this.mFilePath.setEnabled(false);
        this.mApplyChartTemplateCheckBox.setSelected(false);
        this.mSampleTextField.setEnabled(true);
        this.mSampleTextField.setText("");
        this.mConstantRadio.setSelected(true);
        this.mSampleArrowButton.setEnabled(false);
        this.mSampleList.setOpaque(false);
        this.mPRadioButton.setSelected(true);
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mApplyChartTemplateCheckBox.setEnabled(false);
        }
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mNonConformArrow);
        vector.add(this.mNonConformList);
        vector.add(this.mSubgroupsListArrow);
        vector.add(this.mSubgroupsList);
        vector.add(this.mIdentifyArrow);
        vector.add(this.mIdentifyList);
        vector.add(this.mSampleRadiogroup);
        vector.add(this.mSampleTextField);
        vector.add(this.mSampleArrowButton);
        vector.add(this.mSampleList);
        vector.add(this.mNonConformRadioGroup);
        vector.add(this.mApplyChartTemplateCheckBox);
        vector.add(this.mFileButton);
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void showOpenDialog() {
        GraphsRemoteFileChooser graphsRemoteFileChooser = new GraphsRemoteFileChooser(this);
        graphsRemoteFileChooser.setDialogTitle(this.getResString("IDS_GRAPHS_CONTROLS_TEMPLATE_DIALOG_TITLE"));
        int n = graphsRemoteFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0) {
            this.mFilePath.setText(graphsRemoteFileChooser.getSelectedFilePath());
            this.canEnableOkPaste();
        }
    }

    private JPanel setupViewPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_GRAPHS_CONTROLS_PNP_CASES_SUBGROUPS_NONCONFORM_LABEL");
        jLabel.setLabelFor(this.mNonConformList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_GRAPHS_CONTROLS_SUBGROUPS_LABEL_BY");
        jLabel2.setLabelFor(this.mSubgroupsList);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        JScrollPane jScrollPane2 = new JScrollPane(this.mNonConformList);
        jScrollPane2.setPreferredSize(this.mNonConformList.getMinimumSize());
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setVerticalScrollBarPolicy(21);
        JScrollPane jScrollPane3 = new JScrollPane(this.mSubgroupsList);
        jScrollPane3.setPreferredSize(this.mSubgroupsList.getMinimumSize());
        jScrollPane3.setHorizontalScrollBarPolicy(31);
        jScrollPane3.setVerticalScrollBarPolicy(21);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_GRAPHS_CONTROLS_PNP_CASES_ARE_SUBGROUP_SOURCE_LABEL");
        jLabel3.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 8, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(0, insets2.left + 10, 0, insets2.right);
        n = 20;
        DialogUtil.addUsingGBL(jPanel, this.mNonConformArrow, gridBagConstraints, 1, 0, 1, 2, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(0, insets2.left + 10, 0, insets2.right);
        n = 20;
        DialogUtil.addUsingGBL(jPanel, this.mSubgroupsListArrow, gridBagConstraints, 1, 2, 1, 2, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        insets.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jScrollPane3, gridBagConstraints, 2, 3, 1, 1, n, null);
        JScrollPane jScrollPane4 = new JScrollPane(this.mIdentifyList);
        jScrollPane4.setPreferredSize(this.mIdentifyList.getMinimumSize());
        jScrollPane4.setHorizontalScrollBarPolicy(31);
        jScrollPane4.setVerticalScrollBarPolicy(21);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(0, insets2.left + 10, 0, insets2.right);
        n = 20;
        DialogUtil.addUsingGBL(jPanel, this.mIdentifyArrow, gridBagConstraints, 1, 4, 1, 2, n, insets);
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_GRAPHS_CONTROL_IDENTIFY_LABEL");
        jLabel4.setLabelFor(this.mIdentifyList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        insets.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 2, 4, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jScrollPane4, gridBagConstraints, 2, 5, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = this.setupChartsPanel();
        insets.set(n2, 20, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupSampleSizePanel(), gridBagConstraints, 1, 6, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 7, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.setupTemplatePanel(), gridBagConstraints, 1, 8, 2, 1, n, insets);
        return jPanel;
    }

    private JPanel setupSampleSizePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_GRAPHS_CONTROLS_CU_CASES_SAMPLE_PANEL_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mConstantRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets = new Insets(insets.top, insets.left, 0, insets.right + 10);
        DialogUtil.addUsingGBL(jPanel, this.mVariableRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mSampleTextField.setPreferredSize(new Dimension(40, 20));
        gridBagConstraints.weightx = 1.0;
        insets = new Insets(5, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mSampleTextField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.setupSampleListPanel(), gridBagConstraints, 0, 2, 2, 1, n, insets);
        return jPanel;
    }

    private JPanel setupSampleListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 10;
        insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 10, 20);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSampleArrowButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mSampleList);
        jScrollPane.setPreferredSize(this.mSampleList.getMinimumSize());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        insets = new Insets(0, 0, 0, insets.right + 10);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupTemplatePanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mApplyChartTemplateCheckBox, this.mFileButton, this.mFilePath};
        return PanelFactory.getGraphsChartTemplatePanel(jComponentArray, this.getResString("IDS_GRAPHS_CONTROLS_TEMPLATE"));
    }

    private JPanel setupChartsPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mPRadioButton, this.mNpRadioButton};
        return ControlsUtil.getGraphsControlsChartsPanel(jComponentArray, this.getResString("IDS_GRAPHS_CONTROLS_CHART"));
    }

    class SampleArrowButton
    extends ArrowButton {
        public SampleArrowButton(SpssArrowButton.ButtonOrientation buttonOrientation) {
            super(buttonOrientation);
        }

        @Override
        protected void updateEnable(SpssArrowButton.SrcDestHolder srcDestHolder) {
            if (PnpCasesAreSubgroupsDlg.this.mVariableRadio != null && !PnpCasesAreSubgroupsDlg.this.mVariableRadio.isSelected()) {
                this.setEnabled(false);
            } else {
                super.updateEnable(srcDestHolder);
            }
        }
    }

    class MyKeyAdapter
    extends KeyAdapter {
        MyKeyAdapter() {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getSource() == PnpCasesAreSubgroupsDlg.this.mSampleTextField) {
                if (PnpCasesAreSubgroupsDlg.this.mSampleTextField.getText().length() > 0) {
                    PnpCasesAreSubgroupsDlg.this.enableOkPaste(PnpCasesAreSubgroupsDlg.this.canEnableOkPaste());
                } else {
                    PnpCasesAreSubgroupsDlg.this.enableOkPaste(false);
                }
            }
        }
    }
}

