/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.quality_control.control_charts;

import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ControlOptions
extends BaseSubDialog
implements DocumentListener {
    static final String NUMBER_OF_SIGMAS_TEXTFIELD = "IDS_GRAPHS_CONTROLS_OPTIONS_NUMBER_OF_SIGMAS_TEXTFIELD";
    static final String MIN_SUBGROUP_SIZE_TEXTFIELD = "IDS_GRAPHS_CONTROLS_OPTIONS_MIN_SUBGROUP_SIZE";
    static final String NUMBER_OF_SIGMAS_TEXTFIELD_DEFAULT_VALUE = "3";
    static final String MIN_SUBGROUP_SIZE_TEXTFIELD_DEFAULT_VALUE = "2";
    static final String DISPLAY_SUBGROUPS_CHECKBOX = "IDS_GRAPHS_CONTROLS_OPTIONS_DISPLAY_SUBGROUPS_CHECKBOX";
    private boolean mShowMinSubGrpSize;
    private FloatTextField mSigmasTextField;
    private IntTextField mSubgrpTextField;
    private JCheckBox mDisplayCheck;
    private String mDialogHelpId;
    private JLabel mSubgroupLabel;

    public ControlOptions(BaseProcedureDialog baseProcedureDialog, String string, boolean bl, String string2) {
        super(baseProcedureDialog, string, true);
        this.mShowMinSubGrpSize = bl;
        this.mDialogHelpId = string2;
        this.initialize();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinueButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinueButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinueButton();
    }

    @Override
    public String getDialogHelpID() {
        return this.mDialogHelpId;
    }

    public void setMinSubGroupLabelText(String string) {
        this.mSubgroupLabel.setText(string);
    }

    private void enableContinueButton() {
        if (this.mSubgrpTextField != null) {
            this.enableContinue(this.mSigmasTextField.getText().length() > 0 && this.mSubgrpTextField.getText().length() > 0);
        } else {
            this.enableContinue(this.mSigmasTextField.getText().length() > 0);
        }
    }

    private void initialize() {
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.setupViewPanel(), gridBagConstraints, 0, 0, 1, 1, n, null);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSigmasTextField);
        if (this.mSubgrpTextField != null) {
            vector.add(this.mSubgrpTextField);
        }
        vector.add(this.mDisplayCheck);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void initVars() {
        this.mSigmasTextField = new FloatTextField(1.0, 9.0, 3, true);
        this.mSigmasTextField.setText(NUMBER_OF_SIGMAS_TEXTFIELD_DEFAULT_VALUE);
        this.mSigmasTextField.setColumns(3);
        this.mSigmasTextField.getDocument().addDocumentListener(this);
        this.mSigmasTextField.setAction((Action)new TextFieldAction(this, NUMBER_OF_SIGMAS_TEXTFIELD));
        this.mSigmasTextField.setCaretPosition(0);
        if (this.mShowMinSubGrpSize) {
            this.mSubgrpTextField = new IntTextField(2, 100, true);
            this.mSubgrpTextField.setText(MIN_SUBGROUP_SIZE_TEXTFIELD_DEFAULT_VALUE);
            this.mSubgrpTextField.setColumns(2);
            this.mSubgrpTextField.getDocument().addDocumentListener(this);
            this.mSubgrpTextField.setAction((Action)new TextFieldAction(this, MIN_SUBGROUP_SIZE_TEXTFIELD));
            this.mSubgrpTextField.setCaretPosition(0);
            this.mSubgroupLabel = DialogUtil.createLabel(this, "IDS_GRAPHS_CONTROLS_OPTIONS_MIN_SUBGROUP_SIZE_LABEL");
            this.mSubgroupLabel.setLabelFor((Component)this.mSubgrpTextField);
        }
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, DISPLAY_SUBGROUPS_CHECKBOX);
        this.mDisplayCheck = new JCheckBox(toggleButtonAction);
    }

    private JPanel setupViewPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_GRAPHS_CONTROLS_OPTIONS_NUMBER_OF_SIGMAS_LABEL");
        jLabel.setLabelFor((Component)this.mSigmasTextField);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(0, n2, 3, 0);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mSigmasTextField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        if (this.mShowMinSubGrpSize) {
            gridBagConstraints.weighty = 1.0;
            insets.set(2, 0, 0, 0);
            DialogUtil.addUsingGBL(jPanel3, this.mSubgroupLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
            insets.set(2, n2, 3, 0);
            DialogUtil.addUsingGBL(jPanel3, (JComponent)this.mSubgrpTextField, gridBagConstraints, 1, 0, 1, 1, n, insets);
            gridBagConstraints.weighty = 0.0;
            DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, null);
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(jPanel, this.mDisplayCheck, gridBagConstraints, 0, 2, 1, 1, n, null);
        } else {
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(jPanel, this.mDisplayCheck, gridBagConstraints, 0, 1, 1, 1, n, null);
        }
        return jPanel;
    }
}

