/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.quality_control.control_charts;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.base.graphs.ImageLabelKeyListener;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImage;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImagesGroup;
import com.spss.java_client.ui.dialogs.common.BaseGatingDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class ControlChartsDlg
extends BaseGatingDialog
implements MouseListener {
    private JLabel mXBarLabel;
    private JLabel mIndividualLabel;
    private JLabel mPnpLabel;
    private JLabel mCuLabel;
    private MatrixImagesGroup mControlChartsImageGroup;
    private MatrixImage mXBarImage;
    private MatrixImage mIndividualImage;
    private MatrixImage mPnpImage;
    private MatrixImage mCuImage;
    private JRadioButton mCasesAreUnitsRadio;
    private JRadioButton mCasesAreSubgroupsRadio;

    public ControlChartsDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_GRAPHS_CONTROLS_DLG_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_gctl";
    }

    @Override
    public String getIActionKey() {
        return "analyze_qlty_cont_control";
    }

    @Override
    public boolean continuePressed() {
        return true;
    }

    @Override
    public String getNextProcDlgActionKey() {
        String string = null;
        if (this.mXBarImage.isSelected()) {
            if (this.mCasesAreUnitsRadio.isSelected()) {
                string = "analyze_qlty_cont_control_xbar_cases_are_units";
            } else if (this.mCasesAreSubgroupsRadio.isSelected()) {
                string = "analyze_qlty_cont_control_xbar_cases_are_subgroups";
            }
        } else if (this.mIndividualImage.isSelected()) {
            if (this.mCasesAreUnitsRadio.isSelected()) {
                string = "analyze_qlty_cont_control_individuals_and_moving_range";
            }
        } else if (this.mPnpImage.isSelected()) {
            if (this.mCasesAreUnitsRadio.isSelected()) {
                string = "analyze_qlty_cont_control_pnp_cases_are_units";
            } else if (this.mCasesAreSubgroupsRadio.isSelected()) {
                string = "analyze_qlty_cont_control_pnp_cases_are_subgroups";
            }
        } else if (this.mCuImage.isSelected()) {
            if (this.mCasesAreUnitsRadio.isSelected()) {
                string = "analyze_qlty_cont_control_cu_cases_are_units";
            } else if (this.mCasesAreSubgroupsRadio.isSelected()) {
                string = "analyze_qlty_cont_control_cu_cases_are_subgroups";
            }
        }
        return string;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.mIndividualImage) {
            this.mCasesAreSubgroupsRadio.setEnabled(false);
            this.mCasesAreUnitsRadio.setSelected(true);
        } else {
            this.mCasesAreSubgroupsRadio.setEnabled(true);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void loadDialogState() {
        Integer n = this.mDialogDataModel.getInteger("IDS_SCATTER_DOT_SELECTED_IMAGE");
        if (n != null) {
            this.setImageSelected(n);
            if (n == 1) {
                this.mCasesAreSubgroupsRadio.setEnabled(false);
            }
        }
        super.loadDialogState();
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
        this.mDialogDataModel.putInteger("IDS_SCATTER_DOT_SELECTED_IMAGE", this.getSelectedImageIndex());
    }

    @Override
    protected void init() {
        super.init();
        this.renameContinueAction("IDS_DEFINE");
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.createVariablePanel();
        JPanel jPanel3 = this.createAttributePanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        JLabel jLabel = new JLabel(this.getResString("IDS_VARIABLE_CHART_LABEL"));
        JLabel jLabel2 = new JLabel(this.getResString("IDS_ATTRIBUTE_CHART_LABEL"));
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, null);
        insets = new Insets(DialogUtil.getComponentGroupGap(), 3, 1, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 3, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.setupRadioButtonPanel(), gridBagConstraints, 0, 4, 1, 1, n, null);
        this.setDefaults();
        this.setTabPolicy();
        this.pack();
    }

    private void initVars() {
        this.mCasesAreUnitsRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_GRAPHS_CONTROLS_CASES_ARE_UNITS_RADIO"));
        this.mCasesAreSubgroupsRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_GRAPHS_CONTROLS_CASES_ARE_SUBGROUPS_RADIO"));
        this.mXBarLabel = new JLabel(this.getResStringArray("IDS_GRAPHS_CONTROLS_CHARTS_TYPE")[0]);
        this.mIndividualLabel = new JLabel(this.getResStringArray("IDS_GRAPHS_CONTROLS_CHARTS_TYPE")[1]);
        this.mPnpLabel = new JLabel(this.getResStringArray("IDS_GRAPHS_CONTROLS_CHARTS_TYPE")[2]);
        this.mCuLabel = new JLabel(this.getResStringArray("IDS_GRAPHS_CONTROLS_CHARTS_TYPE")[3]);
        this.mControlChartsImageGroup = new MatrixImagesGroup();
        this.mXBarImage = new MatrixImage(this.getResImageURL("IDS_GRAPHS_CONTROLS_XBAR_IMAGE"));
        this.mXBarImage.setImageLabelGroup(this.mControlChartsImageGroup);
        this.mIndividualImage = new MatrixImage(this.getResImageURL("IDS_GRAPHS_CONTROLS_INDIVIDUALS_IMAGE"));
        this.mIndividualImage.setImageLabelGroup(this.mControlChartsImageGroup);
        this.mPnpImage = new MatrixImage(this.getResImageURL("IDS_GRAPHS_CONTROLS_PNP_IMAGE"));
        this.mPnpImage.setImageLabelGroup(this.mControlChartsImageGroup);
        this.mCuImage = new MatrixImage(this.getResImageURL("IDS_GRAPHS_CONTROLS_CU_IMAGE"));
        this.mCuImage.setImageLabelGroup(this.mControlChartsImageGroup);
        Vector<MatrixImage> vector = new Vector<MatrixImage>();
        vector.add(this.mXBarImage);
        vector.add(this.mIndividualImage);
        vector.add(this.mPnpImage);
        vector.add(this.mCuImage);
        this.mXBarImage.addKeyListener(new ControlImageLabelKeyListener(vector, this.mControlChartsImageGroup));
        this.mIndividualImage.addKeyListener(new ControlImageLabelKeyListener(vector, this.mControlChartsImageGroup));
        this.mPnpImage.addKeyListener(new ControlImageLabelKeyListener(vector, this.mControlChartsImageGroup));
        this.mCuImage.addKeyListener(new ControlImageLabelKeyListener(vector, this.mControlChartsImageGroup));
        this.mIndividualImage.addMouseListener(this);
        this.mXBarImage.addMouseListener(this);
        this.mPnpImage.addMouseListener(this);
        this.mCuImage.addMouseListener(this);
    }

    private void setTabPolicy() {
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mCasesAreUnitsRadio);
        spssButtonGroup.add(this.mCasesAreSubgroupsRadio);
        Vector<Object> vector = new Vector<Object>();
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            vector.add(this.mDefineButton);
            vector.add(this.mXBarImage);
            vector.add(spssButtonGroup);
            vector.add(this.mHelpButton);
            vector.add(this.mCancelButton);
        } else {
            vector.add(this.mDefineButton);
            vector.add(this.mCancelButton);
            vector.add(this.mHelpButton);
            vector.add(this.mXBarImage);
            vector.add(spssButtonGroup);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setDefaults() {
        this.mCasesAreUnitsRadio.setSelected(true);
        this.mXBarImage.setDefaultSelectedImage(true);
        this.mPnpImage.setDefaultSelectedImage(false);
        this.mCuImage.setDefaultSelectedImage(false);
        this.mIndividualImage.setDefaultSelectedImage(false);
    }

    private JPanel createVariablePanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mXBarImage, this.mIndividualImage, this.mXBarLabel, this.mIndividualLabel};
        this.mXBarLabel.setLabelFor(this.mXBarImage);
        this.mXBarImage.setToolTipText(this.mXBarLabel.getText());
        this.mIndividualLabel.setLabelFor(this.mIndividualImage);
        this.mIndividualImage.setToolTipText(this.mIndividualLabel.getText());
        return PanelFactory.getPanelForImageLabels(jComponentArray, "", 2);
    }

    private JPanel createAttributePanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mPnpImage, this.mCuImage, this.mPnpLabel, this.mCuLabel};
        this.mPnpLabel.setLabelFor(this.mPnpImage);
        this.mPnpImage.setToolTipText(this.mPnpLabel.getText());
        this.mCuLabel.setLabelFor(this.mCuImage);
        this.mCuImage.setToolTipText(this.mCuLabel.getText());
        return PanelFactory.getPanelForImageLabels(jComponentArray, "", 2);
    }

    private JPanel setupRadioButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_GRAPHS_CONTROLS_DATA_ORGANIZATION_PANEL_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mCasesAreUnitsRadio, gridBagConstraints, 0, 0, 1, 1, 23, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mCasesAreSubgroupsRadio, gridBagConstraints, 0, 1, 1, 1, 23, insets);
        return jPanel;
    }

    private int getSelectedImageIndex() {
        int n = -1;
        if (this.mControlChartsImageGroup.isSelected(this.mXBarImage)) {
            n = 0;
        } else if (this.mControlChartsImageGroup.isSelected(this.mIndividualImage)) {
            n = 1;
        } else if (this.mControlChartsImageGroup.isSelected(this.mPnpImage)) {
            n = 2;
        } else if (this.mControlChartsImageGroup.isSelected(this.mCuImage)) {
            n = 3;
        }
        return n;
    }

    private void setImageSelected(int n) {
        switch (n) {
            case 0: {
                this.mXBarImage.setDefaultSelectedImage(true);
                break;
            }
            case 1: {
                this.mIndividualImage.setDefaultSelectedImage(true);
                break;
            }
            case 2: {
                this.mPnpImage.setDefaultSelectedImage(true);
                break;
            }
            case 3: {
                this.mCuImage.setDefaultSelectedImage(true);
            }
        }
    }

    class ControlImageLabelKeyListener
    extends ImageLabelKeyListener {
        public ControlImageLabelKeyListener(Vector<MatrixImage> vector, MatrixImagesGroup matrixImagesGroup) {
            super(vector, matrixImagesGroup);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            super.keyPressed(keyEvent);
            if (ControlChartsDlg.this.mIndividualImage.isSelected()) {
                ControlChartsDlg.this.mCasesAreSubgroupsRadio.setEnabled(false);
                ControlChartsDlg.this.mCasesAreUnitsRadio.setSelected(true);
            } else {
                ControlChartsDlg.this.mCasesAreSubgroupsRadio.setEnabled(true);
            }
        }
    }
}

