/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.power_analysis.one_sample;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PowerAnalysisOneSampleCriteriaSubDlg
extends BaseSubDialog
implements DocumentListener {
    public static final String POWER_ANALYSIS_ANOVA_CRITERIA_SIG_LEVEL = "IDS_POWER_ANALYSIS_COMMON_CRITERIA_SIG_LEVEL";
    private static final Insets BASE_INSETS = (Insets)DialogUtil.getStandardControlInsets().clone();
    private static final Insets LEVEL_ONE__INSETS = new Insets(PowerAnalysisOneSampleCriteriaSubDlg.BASE_INSETS.top, PowerAnalysisOneSampleCriteriaSubDlg.BASE_INSETS.left + 20, PowerAnalysisOneSampleCriteriaSubDlg.BASE_INSETS.bottom, PowerAnalysisOneSampleCriteriaSubDlg.BASE_INSETS.right);
    private static final Insets LEVEL_TWO_INSETS = new Insets(PowerAnalysisOneSampleCriteriaSubDlg.LEVEL_ONE__INSETS.top, PowerAnalysisOneSampleCriteriaSubDlg.LEVEL_ONE__INSETS.left + 20, PowerAnalysisOneSampleCriteriaSubDlg.LEVEL_ONE__INSETS.bottom, PowerAnalysisOneSampleCriteriaSubDlg.LEVEL_ONE__INSETS.right);
    private FloatTextField mSignificanceLevelField;
    private SpssButtonGroup mTestDirectionRBGroup;
    private JRadioButton mTestDirectionNonDirectionalRB;
    private JRadioButton mTestDirectionDirectionalRB;

    public PowerAnalysisOneSampleCriteriaSubDlg(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, true);
        this.setDefaults();
        this.addListeners();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
        this.setSize(new Dimension(400, 200));
    }

    public static boolean isTestDirectionDirectional(DialogDataModel dialogDataModel) {
        Boolean bl = dialogDataModel.containsBooleanKey("IDS_POWER_ANALYSIS_COMMON_DIRECTIONAL_RADIO") ? dialogDataModel.getBoolean("IDS_POWER_ANALYSIS_COMMON_DIRECTIONAL_RADIO") : false;
        return bl;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_power_onesample_criteria";
    }

    public static String getSubDialogSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    protected void initVars() {
        this.mSignificanceLevelField = new FloatTextField(0.0, 1.0, 5, true);
        this.mSignificanceLevelField.setAllowMinMax(false, false);
        this.mSignificanceLevelField.setColumns(8);
        this.mSignificanceLevelField.setAction((Action)new TextFieldAction(this.mParentDlg, POWER_ANALYSIS_ANOVA_CRITERIA_SIG_LEVEL));
        this.mTestDirectionNonDirectionalRB = new JRadioButton(new ToggleButtonAction(this, "IDS_POWER_ANALYSIS_COMMON_NONDIRECTIONAL_RADIO"));
        this.mTestDirectionDirectionalRB = new JRadioButton(new ToggleButtonAction(this, "IDS_POWER_ANALYSIS_COMMON_DIRECTIONAL_RADIO"));
        this.mTestDirectionRBGroup = new SpssButtonGroup();
        this.mTestDirectionRBGroup.add(this.mTestDirectionNonDirectionalRB);
        this.mTestDirectionRBGroup.add(this.mTestDirectionDirectionalRB);
    }

    private void addListeners() {
        this.mSignificanceLevelField.getDocument().addDocumentListener(this);
    }

    private void setDefaults() {
        this.mSignificanceLevelField.setText("0.05");
        this.mTestDirectionNonDirectionalRB.setSelected(true);
    }

    private void setupPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n / 2, 0, n / 2, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n2 = 23;
        this.mSignificanceLevelField.setPreferredSize(new Dimension(100, 26));
        this.mSignificanceLevelField.setMinimumSize(new Dimension(70, 26));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, POWER_ANALYSIS_ANOVA_CRITERIA_SIG_LEVEL);
        jLabel.setLabelFor((Component)this.mSignificanceLevelField);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(jLabel);
        jPanel3.add((Component)this.mSignificanceLevelField);
        DialogUtil.addUsingGBL(jPanel2, jPanel3, gridBagConstraints, 0, 0, 1, 1, n2, BASE_INSETS);
        DialogUtil.addUsingGBL(jPanel2, this.createTestDirectionPanel(), gridBagConstraints, 0, 1, 1, 1, n2, BASE_INSETS);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel2, new JPanel(), gridBagConstraints, 2, 0, 1, 1, n2, BASE_INSETS);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n2, BASE_INSETS);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 0, 1, 1, 1, n2, BASE_INSETS);
    }

    private JPanel createTestDirectionPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_POWER_ANALYSIS_COMMON_TEST_DIRECTION_LABEL"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mTestDirectionNonDirectionalRB, gridBagConstraints, 0, 0, 1, 1, n, BASE_INSETS);
        DialogUtil.addUsingGBL(jPanel, this.mTestDirectionDirectionalRB, gridBagConstraints, 0, 1, 1, 1, n, BASE_INSETS);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSignificanceLevelField);
        vector.add(this.mTestDirectionNonDirectionalRB);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private boolean canEnableContinue() {
        boolean bl = this.mSignificanceLevelField.getText().length() > 0;
        return bl;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }
}

