/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.power_analysis.one_sample;

import com.spss.java_client.ui.dialogs.adv_stats.res.AdvStatsResBundle;
import com.spss.java_client.ui.dialogs.base.analyze.power_analysis.PlotTypeEnum;
import com.spss.java_client.ui.dialogs.base.analyze.power_analysis.PowerAnalysisCommonPlotSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.power_analysis.one_sample.PowerAnalysisOneSampleCriteriaSubDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PowerAnalysisCompareMeansOneSampleDlg
extends BaseProcedureDialog {
    private static final Insets BASE_INSETS = (Insets)DialogUtil.getStandardControlInsets().clone();
    private JLabel mSampleSizeLabel;
    private IntTextField mSampleSizeIntField;
    private JLabel mPopulationStdDeviationLabel;
    private FloatTextField mPopulationStdDeviationEdit;
    private JLabel mPopulationMeanLabel;
    private FloatTextField mPopulationMeanEdit;
    private JLabel mHypothesizedValueLabel;
    private FloatTextField mHypothesizedValueEdit;
    boolean mLoadingDialogState = false;

    public PowerAnalysisCompareMeansOneSampleDlg(JFrame jFrame) {
        super(jFrame, false, AdvStatsResBundle.getDefaultResourceBundleName(), AdvStatsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_POWER_ANALYSIS_ONE_SAMPLE_TTTEST_TITLE"));
        this.setLocationRelativeTo(this.getParent());
        this.setDefaults();
    }

    private void setDefaults() {
        this.mLoadingDialogState = true;
        this.mSampleSizeIntField.setText("");
        this.mPopulationStdDeviationEdit.setText("");
        this.mPopulationMeanEdit.setText("");
        this.mHypothesizedValueEdit.setText("0");
        this.mLoadingDialogState = false;
    }

    @Override
    protected void loadDialogState() {
        this.mLoadingDialogState = true;
        super.loadDialogState();
        this.mLoadingDialogState = false;
        this.processControlStates();
    }

    public void processControlStates() {
        boolean bl = this.isValidMainPage();
        boolean bl2 = this.isValidCriteriaPage();
        boolean bl3 = this.isValidContrastPage();
        boolean bl4 = this.isValidPlotPage();
        this.enableOkPaste(bl && bl2 && bl3 && bl4);
    }

    public boolean isValidMainPage() {
        boolean bl = this.mSampleSizeIntField.getText().trim().length() == 0 || this.mPopulationStdDeviationEdit.getText().trim().length() == 0 || this.mPopulationMeanEdit.getText().trim().length() == 0 || this.mHypothesizedValueEdit.getText().trim().length() == 0;
        return !bl;
    }

    public boolean isValidCriteriaPage() {
        return true;
    }

    public boolean isValidContrastPage() {
        return true;
    }

    public boolean isValidPlotPage() {
        return true;
    }

    @Override
    public boolean okPastePressed() {
        boolean bl = PowerAnalysisCommonPlotSubDlg.doesModelChangeRequireReselections(this.getDialogDataModel(), PlotTypeEnum.ONE_TTEST);
        if (bl) {
            SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), this.getResString("IDS_POWER_ANALYSIS_MODEL_RESET_EFFECTS_PLOT"), "");
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
        this.enableOkPaste(false);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_power_onesample";
    }

    @Override
    public String getIActionKey() {
        return "analyze_power_analysys_compare_means_one_ttest";
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        return stringBuffer.toString();
    }

    public static String getMainDialogSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_POWER_ANALYSIS_COMMON_CRITERIA"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PowerAnalysisCompareMeansOneSampleDlg.this.runCriteriaSubDialog();
            }
        };
        this.addOptionsPanelButton(jPanel, new JButton(toggleButtonAction));
        toggleButtonAction = new ToggleButtonAction(this, "IDS_POWER_ANALYSIS_COMMON_PLOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PowerAnalysisCompareMeansOneSampleDlg.this.runPlotSubDialog();
            }
        };
        this.addOptionsPanelButton(jPanel, new JButton(toggleButtonAction));
        return jPanel;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        JPanel jPanel = this.getViewPanel();
        this.setupMainPanel(jPanel);
        this.pack();
        this.processControlStates();
    }

    private void initVars() {
        this.mSampleSizeLabel = DialogUtil.createLabel(this, "IDS_POWER_ANALYSIS_ONE_SAMPLE_SAMPLE_SIZE");
        this.mSampleSizeIntField = this.getSampleSizeIntField(this.mSampleSizeLabel);
        this.mPopulationStdDeviationLabel = DialogUtil.createLabel(this, "IDS_POWER_ANALYSIS_ONE_SAMPLE_POPULATION_STD_DEV");
        this.mPopulationStdDeviationEdit = this.getPopulationStdDevEdit("IDS_POWER_ANALYSIS_ONE_SAMPLE_POPULATION_STD_DEV_EDIT", this.mPopulationStdDeviationLabel);
        this.mPopulationMeanLabel = DialogUtil.createLabel(this, "IDS_POWER_ANALYSIS_ONE_SAMPLE_POPULATION_MEAN");
        this.mPopulationMeanEdit = this.getMaxRangeFloatEdit("IDS_POWER_ANALYSIS_ONE_SAMPLE_POPULATION_MEAN_EDIT", this.mPopulationMeanLabel);
        this.mHypothesizedValueLabel = DialogUtil.createLabel(this, "IDS_POWER_ANALYSIS_ONE_SAMPLE_HYPOTHESIZED_VALUE");
        this.mHypothesizedValueEdit = this.getMaxRangeFloatEdit("IDS_POWER_ANALYSIS_ONE_SAMPLE_HYPOTHESIZED_VALUE_EDIT", this.mHypothesizedValueLabel);
    }

    private FloatTextField getPopulationStdDevEdit(String string, JLabel jLabel) {
        FloatTextField floatTextField = new FloatTextField(0.0, Double.NaN, 5, true);
        floatTextField.setIncludeMinRange(false);
        floatTextField.setIncludeMaxRange(false);
        floatTextField.setAction((Action)new TextFieldAction(this, string));
        floatTextField.setPreferredSize(new Dimension(50, 25));
        floatTextField.getDocument().addDocumentListener(new MyDocumentListener());
        if (jLabel != null) {
            jLabel.setLabelFor((Component)floatTextField);
        }
        return floatTextField;
    }

    private FloatTextField getMaxRangeFloatEdit(String string, JLabel jLabel) {
        FloatTextField floatTextField = new FloatTextField(-1.7976931348623157E308, Double.MAX_VALUE, 5, false);
        floatTextField.setAllowMinMax(true, true);
        floatTextField.setAction((Action)new TextFieldAction(this, string));
        floatTextField.setPreferredSize(new Dimension(50, 25));
        floatTextField.getDocument().addDocumentListener(new MyDocumentListener());
        if (jLabel != null) {
            jLabel.setLabelFor((Component)floatTextField);
        }
        return floatTextField;
    }

    private IntTextField getSampleSizeIntField(JLabel jLabel) {
        IntTextField intTextField = new IntTextField(1, Integer.MAX_VALUE, true);
        intTextField.setAllowMinMax(false, true);
        intTextField.setAction((Action)new TextFieldAction(this, "IDS_POWER_ANALYSIS_ONE_SAMPLE_SAMPLE_SIZE_EDIT"));
        intTextField.setPreferredSize(new Dimension(50, 25));
        jLabel.setLabelFor((Component)intTextField);
        intTextField.getDocument().addDocumentListener(new MyDocumentListener());
        return intTextField;
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSampleSizeIntField);
        vector.add(this.mPopulationStdDeviationEdit);
        vector.add(this.mPopulationMeanEdit);
        vector.add(this.mHypothesizedValueEdit);
        for (n = 0; n < this.mOptionButtonPanel.getComponentCount(); ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        return vector;
    }

    private void setupMainPanel(JPanel jPanel) {
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_POWER_ANALYSIS_COMMON_TEST_ASSUMPTIONS_GRPBOX"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(this.mSampleSizeLabel);
        jPanel2.add((Component)this.mSampleSizeIntField);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(this.mPopulationStdDeviationLabel);
        jPanel3.add((Component)this.mPopulationStdDeviationEdit);
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel4.add(this.mPopulationMeanLabel);
        jPanel4.add((Component)this.mPopulationMeanEdit);
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        jPanel5.add(this.mHypothesizedValueLabel);
        jPanel5.add((Component)this.mHypothesizedValueEdit);
        Insets insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, BASE_INSETS);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 0, 1, 1, n, BASE_INSETS);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 1, 1, 1, n, BASE_INSETS);
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 1, 1, 1, 1, n, BASE_INSETS);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 2, 0, 1, 4, n, BASE_INSETS);
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 0, 2, 1, 1, n, BASE_INSETS);
    }

    private String getSubDialogTitle(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.getResString("IDS_POWER_ANALYSIS_ONE_SAMPLE_TTTEST_TITLE"));
        stringBuffer.append(": ");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private void runCriteriaSubDialog() {
        String string = this.getSubDialogTitle(this.getResString("IDS_POWER_ANALYSIS_COMMON_CRITERIA"));
        boolean bl = this.getTestDirection();
        this.runSubDialog(new PowerAnalysisOneSampleCriteriaSubDlg(this, string, false));
        if (bl != this.getTestDirection()) {
            PowerAnalysisCommonPlotSubDlg.resetPlotModelDependentFields(this.getDialogDataModel(), PlotTypeEnum.ONE_TTEST);
        }
    }

    private void runPlotSubDialog() {
        String string = this.getSubDialogTitle(this.getResString("IDS_POWER_ANALYSIS_COMMON_PLOT"));
        boolean bl = this.getTestDirection();
        this.runSubDialog(new PowerAnalysisCommonPlotSubDlg((BaseProcedureDialog)this, string, PlotTypeEnum.ONE_TTEST, bl, false));
    }

    private boolean getTestDirection() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        boolean bl = PowerAnalysisOneSampleCriteriaSubDlg.isTestDirectionDirectional(dialogDataModel);
        return bl;
    }

    class MyDocumentListener
    implements DocumentListener {
        MyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            PowerAnalysisCompareMeansOneSampleDlg.this.processControlStates();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            PowerAnalysisCompareMeansOneSampleDlg.this.processControlStates();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            PowerAnalysisCompareMeansOneSampleDlg.this.processControlStates();
        }
    }
}

