/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.power_analysis.anova;

import com.spss.java_client.ui.dialogs.adv_stats.res.AdvStatsResBundle;
import com.spss.java_client.ui.dialogs.base.analyze.power_analysis.GroupTableInfo;
import com.spss.java_client.ui.dialogs.base.analyze.power_analysis.PlotTypeEnum;
import com.spss.java_client.ui.dialogs.base.analyze.power_analysis.PowerAnalysisCommonPlotSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.power_analysis.anova.GroupTable;
import com.spss.java_client.ui.dialogs.base.analyze.power_analysis.anova.GroupTableModel;
import com.spss.java_client.ui.dialogs.base.analyze.power_analysis.anova.PowerAnalysisAnovaContrastSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.power_analysis.anova.PowerAnalysisAnovaCriteriaSubDlg;
import com.spss.java_client.ui.dialogs.base.analyze.power_analysis.anova.TableCallback;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;

public class PowerAnalysisCompareMeansAnovaDlg
extends BaseProcedureDialog
implements TableCallback {
    private static String GROUP_TABLE_KEY = "GROUP_TABLE_KEY";
    private static String POOLED_POPULATION_KEY = "POOLED_POPULATION_KEY";
    static final String IDS_CRITERIA_KEY = "IDS_CRITERIA_KEY";
    static final String IDS_CONTRAST_KEY = "IDS_CONTRAST_KEY";
    static final String IDS_PLOT_KEY = "IDS_PLOT_KEY";
    private JLabel mPooledPopStdDeviationLabel;
    private FloatTextField mPooledPopStdDeviationIntField;
    private JButton mAddButton;
    private JButton mDeleteButton;
    private JLabel mTableLabel;
    private GroupTable mGroupTable;
    private GroupTableModel mGroupTableModel;
    private JScrollPane mTableScrollPane;
    JLabel mTotalSampleSizelabel;
    JButton mPlotButton;
    boolean mLoadingDialogState = false;

    public PowerAnalysisCompareMeansAnovaDlg(JFrame jFrame) {
        super(jFrame, false, AdvStatsResBundle.getDefaultResourceBundleName(), AdvStatsResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_POWER_ANALYSIS_ANOVA_TITLE"));
        this.setLocationRelativeTo(this.getParent());
        this.setDefaults();
        this.pack();
    }

    private void setDefaults() {
        this.mPooledPopStdDeviationIntField.setText("");
        this.mGroupTable.resetToDefault();
        this.updateTotalsLabel();
    }

    @Override
    public void processTableChange() {
        this.processControlStates();
        this.updateTotalsLabel();
        if (!this.mLoadingDialogState) {
            PowerAnalysisCommonPlotSubDlg.resetPlotModelDependentFields(this.getDialogDataModel(), PlotTypeEnum.ANOVA);
        }
    }

    @Override
    public void processInvalidCellValue(final int n, final int n2) {
        if (n2 == 1) {
            SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), this.getResString("IDS_POWER_ANALYSIS_ANOVA_GROUP_SIZE_ERROR"), "");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PowerAnalysisCompareMeansAnovaDlg.this.mGroupTable.requestFocusInWindow();
                    PowerAnalysisCompareMeansAnovaDlg.this.mGroupTable.changeSelection(n, n2, true, false);
                }
            });
        }
    }

    public double calculateTotalSampleSize() {
        double d = 0.0;
        for (int i = 0; i < this.mGroupTable.getRowCount(); ++i) {
            GroupTableModel.RowData rowData = this.mGroupTable.getRowDataAt(i);
            String string = rowData.getGroupSizeValue();
            if (string == null || string.trim().length() <= 0) continue;
            Double d2 = Double.parseDouble(string);
            d += d2.doubleValue();
        }
        return d;
    }

    public void updateTotalsLabel() {
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < this.mGroupTable.getRowCount(); ++i) {
            GroupTableModel.RowData rowData = this.mGroupTable.getRowDataAt(i);
            String string = rowData.getGroupSizeValue();
            if (string == null || string.trim().length() <= 0) continue;
            Double d2 = Double.parseDouble(string);
            d += d2.doubleValue();
            ++n;
        }
        String string = MessageFormat.format(this.getResString("IDS_POWER_ANALYSIS_ANOVA_TOTAL_SAMPLE_SIZE"), n < 2 ? this.getResString("IDS_POWER_ANALYSIS_ANOVA_TOTAL_SAMPLE_SIZE_WARNING") : Integer.valueOf((int)d));
        if (d > 2.147483647E9) {
            string = MessageFormat.format(this.getResString("IDS_POWER_ANALYSIS_ANOVA_TOTAL_SAMPLE_SIZE_EXCEED_MAX"), (int)d);
        }
        this.mTotalSampleSizelabel.setText(string);
    }

    @Override
    public void processSelectionChange() {
        this.processControlStates();
    }

    private int getNumCheckedInTable() {
        int n = 0;
        for (int i = 0; i < this.mGroupTable.getRowCount(); ++i) {
            GroupTableModel.RowData rowData = this.mGroupTable.getRowDataAt(i);
            if (!rowData.isChecked()) continue;
            ++n;
        }
        return n;
    }

    public void processControlStates() {
        this.mDeleteButton.setEnabled(this.getNumCheckedInTable() > 0);
        boolean bl = this.mPooledPopStdDeviationIntField.getText().trim().length() > 0;
        boolean bl2 = this.isValidMainPage();
        boolean bl3 = this.isValidCriteriaPage();
        boolean bl4 = this.isValidContrastPage();
        boolean bl5 = this.isValidPlotPage();
        this.mPlotButton.setEnabled(this.isValidGroupSizesColumn());
        this.enableOkPaste(bl && bl2 && bl3 && bl4 && bl5);
    }

    public boolean isValidGroupSizesColumn() {
        boolean bl = true;
        for (int i = 0; i < this.mGroupTable.getRowCount(); ++i) {
            GroupTableModel.RowData rowData = this.mGroupTable.getRowDataAt(i);
            String string = rowData.getGroupSizeValue();
            if (string != null && string.trim().length() != 0) continue;
            bl = false;
            break;
        }
        double d = this.calculateTotalSampleSize();
        return bl && d <= 2.147483647E9;
    }

    public boolean isValidMainPage() {
        Object object;
        int n;
        boolean bl = true;
        for (n = 0; n < this.mGroupTable.getRowCount(); ++n) {
            object = this.mGroupTable.getRowDataAt(n);
            String string = ((GroupTableModel.RowData)object).getGroupSizeValue();
            String string2 = ((GroupTableModel.RowData)object).getGroupMeansValue();
            if (string != null && string2 != null && string.trim().length() != 0 && string2.trim().length() != 0) continue;
            bl = false;
            break;
        }
        n = this.isValidGroupSizesColumn() ? 1 : 0;
        object = this.mPooledPopStdDeviationIntField.getText();
        int n2 = ((String)object).trim().length() != 0 ? Integer.parseInt(this.mPooledPopStdDeviationIntField.getText()) : -1;
        return bl && n != 0 && n2 > 0;
    }

    public boolean isValidCriteriaPage() {
        return true;
    }

    public boolean isValidContrastPage() {
        return true;
    }

    public boolean isValidPlotPage() {
        return true;
    }

    @Override
    public boolean okPastePressed() {
        boolean bl = true;
        boolean bl2 = PowerAnalysisCommonPlotSubDlg.doesModelChangeRequireReselections(this.getDialogDataModel(), PlotTypeEnum.ANOVA);
        boolean bl3 = PowerAnalysisAnovaContrastSubDlg.modelChangeRequiresReselections(this.getDialogDataModel());
        if (bl2 || bl3) {
            String string = null;
            string = bl2 && bl3 ? "IDS_POWER_ANALYSIS_MODEL_RESET_EFFECTS_BOTH" : (bl2 ? "IDS_POWER_ANALYSIS_MODEL_RESET_EFFECTS_PLOT" : "IDS_POWER_ANALYSIS_MODEL_RESET_EFFECTS_CONTRAST");
            SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), this.getResString(string), "");
            return false;
        }
        for (int i = 0; i < this.mGroupTable.getRowCount(); ++i) {
            GroupTableModel.RowData rowData = this.mGroupTable.getRowDataAt(i);
            int n = rowData.getGroupSizeAsInt();
            if (n >= 2) continue;
            SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), this.getResString("IDS_POWER_ANALYSIS_ANOVA_GROUP_SIZES_ERROR"), "");
            this.mGroupTable.changeSelection(i, 1, false, false);
            this.mGroupTable.requestFocusInWindow();
            bl = false;
            break;
        }
        return super.okPastePressed() && bl;
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
        this.enableOkPaste(false);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_power_anova";
    }

    @Override
    public String getIActionKey() {
        return "analyze_power_analysys_compare_means_one_way";
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        return stringBuffer.toString();
    }

    @Override
    protected void loadDialogState() {
        this.mLoadingDialogState = true;
        super.loadDialogState();
        ArrayList arrayList = (ArrayList)this.getDialogDataModel().getObject(GROUP_TABLE_KEY);
        if (arrayList != null) {
            ((GroupTableModel)this.mGroupTable.getModel()).setRowDatas(arrayList);
        }
        this.mLoadingDialogState = false;
        this.processControlStates();
    }

    @Override
    protected void saveDialogState() {
        if (this.mGroupTable != null) {
            ArrayList<GroupTableModel.RowData> arrayList = ((GroupTableModel)this.mGroupTable.getModel()).getRowDatas();
            this.getDialogDataModel().putObject(GROUP_TABLE_KEY, arrayList);
        }
        super.saveDialogState();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_POWER_ANALYSIS_COMMON_CRITERIA"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PowerAnalysisCompareMeansAnovaDlg.this.runCriteriaSubDialog();
            }
        };
        this.addOptionsPanelButton(jPanel, new JButton(toggleButtonAction));
        toggleButtonAction = new ToggleButtonAction(this, "IDS_POWER_ANALYSIS_COMMON_CONTRAST"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PowerAnalysisCompareMeansAnovaDlg.this.runContrastSubDialog();
            }
        };
        this.addOptionsPanelButton(jPanel, new JButton(toggleButtonAction));
        toggleButtonAction = new ToggleButtonAction(this, "IDS_POWER_ANALYSIS_COMMON_PLOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PowerAnalysisCompareMeansAnovaDlg.this.runPlotSubDialog();
            }
        };
        this.mPlotButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mPlotButton);
        return jPanel;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        JPanel jPanel = this.getViewPanel();
        this.setupMainPanel(jPanel);
        this.pack();
        this.processControlStates();
        this.updateTotalsLabel();
    }

    private void initVars() {
        this.mPooledPopStdDeviationLabel = DialogUtil.createLabel(this, "IDS_POWER_ANALYSIS_ANOVA_POOLED_POP_STDDEV_LABEL");
        this.mPooledPopStdDeviationIntField = new FloatTextField(0.0, Double.MAX_VALUE, 5, true);
        this.mPooledPopStdDeviationIntField.setAllowMinMax(false, true);
        this.mPooledPopStdDeviationIntField.setAction((Action)new TextFieldAction(this, POOLED_POPULATION_KEY));
        this.mPooledPopStdDeviationIntField.setColumns(6);
        this.mPooledPopStdDeviationIntField.setHorizontalAlignment(4);
        this.mPooledPopStdDeviationLabel.setLabelFor((Component)this.mPooledPopStdDeviationIntField);
        this.mPooledPopStdDeviationIntField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                PowerAnalysisCompareMeansAnovaDlg.this.processControlStates();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                PowerAnalysisCompareMeansAnovaDlg.this.processControlStates();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                PowerAnalysisCompareMeansAnovaDlg.this.processControlStates();
            }
        });
        this.mGroupTableModel = new GroupTableModel(this, this.getResString("IDS_POWER_ANALYSIS_ANOVA_GROUP_SIZES"), this.getResString("IDS_POWER_ANALYSIS_ANOVA_GROUP_MEANS"));
        this.mGroupTable = new GroupTable(this.mGroupTableModel, this);
        this.mTableScrollPane = new JScrollPane(this.mGroupTable);
        this.mTableScrollPane.setPreferredSize(new Dimension(275, 175));
        this.mTotalSampleSizelabel = new JLabel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_POWER_ANALYSIS_ANOVA_GROUP_ADD"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PowerAnalysisCompareMeansAnovaDlg.this.addRowToTable();
            }
        };
        this.mAddButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_POWER_ANALYSIS_ANOVA_GROUP_DELETE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PowerAnalysisCompareMeansAnovaDlg.this.doRemove();
                PowerAnalysisCompareMeansAnovaDlg.this.processControlStates();
                if (PowerAnalysisCompareMeansAnovaDlg.this.mGroupTable.getRowCount() == 2) {
                    PowerAnalysisCompareMeansAnovaDlg.this.mAddButton.requestFocusInWindow();
                }
            }
        };
        this.mDeleteButton = new JButton(toggleButtonAction);
    }

    private void stopCellEditing() {
        if (this.mGroupTable.getCellEditor() != null) {
            this.mGroupTable.getCellEditor().stopCellEditing();
        }
    }

    private void addRowToTable() {
        this.stopCellEditing();
        this.mGroupTable.addNewEntry();
        PowerAnalysisAnovaContrastSubDlg.clearCoefficientsTable(this.getDialogDataModel());
        PowerAnalysisCommonPlotSubDlg.resetPlotModelDependentFields(this.getDialogDataModel(), PlotTypeEnum.ANOVA);
    }

    protected void doRemove() {
        this.stopCellEditing();
        Integer[] integerArray = this.mGroupTable.getCheckedRows();
        if (integerArray != null && integerArray.length > 0) {
            int n = integerArray[0];
            this.mGroupTable.removeRows(integerArray);
            n = n >= this.mGroupTable.getRowCount() ? n - 1 : n;
            ListSelectionModel listSelectionModel = this.mGroupTable.getSelectionModel();
            listSelectionModel.setSelectionInterval(n, n);
            this.processControlStates();
            PowerAnalysisAnovaContrastSubDlg.clearCoefficientsTable(this.getDialogDataModel());
            PowerAnalysisCommonPlotSubDlg.resetPlotModelDependentFields(this.getDialogDataModel(), PlotTypeEnum.ANOVA);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void cancelEditingInSelectedRows() {
        int n;
        if (this.mGroupTable != null && this.mGroupTable.isEditing() && this.mGroupTable.isRowSelected(n = this.mGroupTable.getEditingRow())) {
            TableCellEditor tableCellEditor = this.mGroupTable.getCellEditor(this.mGroupTable.getEditingRow(), this.mGroupTable.getEditingColumn());
            tableCellEditor.cancelCellEditing();
        }
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mPooledPopStdDeviationIntField);
        vector.add(this.mGroupTable);
        vector.add(this.mAddButton);
        vector.add(this.mDeleteButton);
        for (n = 0; n < this.mOptionButtonPanel.getComponentCount(); ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        return vector;
    }

    private void setupMainPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(true);
        jPanel2.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_POWER_ANALYSIS_COMMON_TEST_ASSUMPTIONS_GRPBOX"));
        jPanel2.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, 20, insets.bottom, insets.right);
        Insets insets3 = new Insets(insets.top, insets.left, insets.bottom, 20);
        Insets insets4 = new Insets(insets.top, 20, insets.bottom, 20);
        int n = 23;
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(this.mPooledPopStdDeviationLabel);
        jPanel3.add((Component)this.mPooledPopStdDeviationIntField);
        DialogUtil.addUsingGBL(jPanel2, jPanel3, gridBagConstraints, 0, 0, 2, 1, n, insets4);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, this.mTableScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        JPanel jPanel4 = this.getTableButtonsPanel();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, jPanel4, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, this.mTotalSampleSizelabel, gridBagConstraints, 0, 2, 2, 1, n, insets2);
        Insets insets5 = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
    }

    private JPanel getTableButtonsPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mAddButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mDeleteButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.normalizeButtonWidths((JPanel)jPanel);
        return jPanel;
    }

    private String getSubDialogTitle(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.getResString("IDS_POWER_ANALYSIS_ANOVA_TITLE"));
        stringBuffer.append(": ");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private void runCriteriaSubDialog() {
        String string = this.getSubDialogTitle(this.getResString("IDS_POWER_ANALYSIS_COMMON_CRITERIA"));
        this.runSubDialog(new PowerAnalysisAnovaCriteriaSubDlg(this, string, false));
    }

    private void runContrastSubDialog() {
        String string = this.getSubDialogTitle(this.getResString("IDS_POWER_ANALYSIS_COMMON_CONTRAST"));
        this.runSubDialog(new PowerAnalysisAnovaContrastSubDlg((BaseProcedureDialog)this, string, this.mGroupTable.getModel().getRowCount()));
    }

    private void runPlotSubDialog() {
        String string = this.getSubDialogTitle(this.getResString("IDS_POWER_ANALYSIS_COMMON_PLOT"));
        GroupTableInfo groupTableInfo = this.mGroupTable.getGroupTableInfo();
        this.runSubDialog(new PowerAnalysisCommonPlotSubDlg(this, string, PlotTypeEnum.ANOVA, groupTableInfo));
    }
}

