/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.power_analysis.anova;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.power_analysis.anova.CoefficientsTable;
import com.spss.java_client.ui.dialogs.base.analyze.power_analysis.anova.CoefficientsTableModel;
import com.spss.java_client.ui.dialogs.base.analyze.power_analysis.anova.TableCallback;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;

public class PowerAnalysisAnovaContrastSubDlg
extends BaseSubDialog
implements TableCallback {
    private static final Insets BASE_INSETS = (Insets)DialogUtil.getStandardControlInsets().clone();
    private static final Insets LEVEL_ONE__INSETS = new Insets(PowerAnalysisAnovaContrastSubDlg.BASE_INSETS.top, PowerAnalysisAnovaContrastSubDlg.BASE_INSETS.left + 20, PowerAnalysisAnovaContrastSubDlg.BASE_INSETS.bottom, PowerAnalysisAnovaContrastSubDlg.BASE_INSETS.right);
    private static final Insets LEVEL_TWO_INSETS = new Insets(PowerAnalysisAnovaContrastSubDlg.LEVEL_ONE__INSETS.top, PowerAnalysisAnovaContrastSubDlg.LEVEL_ONE__INSETS.left + 20, PowerAnalysisAnovaContrastSubDlg.LEVEL_ONE__INSETS.bottom, PowerAnalysisAnovaContrastSubDlg.LEVEL_ONE__INSETS.right);
    public static final String COEFFICIENTS_TABLE_KEY = "COEFFICIENTS_TABLE_KEY";
    public static final String TEST_WITH_LINEAR_CONTRAST = "IDS_POWER_ANALYSIS_ANOVA_CONTRAST_TEST_LINEAR_CHECK";
    public static final String DIRECTIONAL_RADIO = "IDS_POWER_ANALYSIS_COMMON_DIRECTIONAL_RADIO";
    public static final String NONDIRECTIONAL_RADIO = "IDS_POWER_ANALYSIS_COMMON_NONDIRECTIONAL_RADIO";
    public static final String MAX_ITERATIONS = "IDS_MAX_ITERATIONS_LABEL";
    public static final String POWER_ANALYSIS_ANOVA_CONTRAST_ESTIMATE_POWER_CHECK = "IDS_POWER_ANALYSIS_ANOVA_CONTRAST_ESTIMATE_POWER_CHECK";
    public static final String BONFERRONI_RADIO = "IDS_POWER_ANALYSIS_ANOVA_CONTRAST_BONFFERONI_RADIO";
    public static final String SIDAK_RADIO = "IDS_POWER_ANALYSIS_ANOVA_CONTRAST_SIDAK_RADIO";
    public static final String LDS_RADIO = "IDS_POWER_ANALYSIS_ANOVA_CONTRAST_LSD_RADIO";
    private JCheckBox mTestWithLinearContrastCheck;
    private SpssButtonGroup mTestDirectionRBGroup;
    private JRadioButton mDirectionalRadio;
    private JRadioButton mNonDirectionalRadio;
    private ArrayList<String> mContrastCoefficientsList;
    private JLabel mCoefficientsTableLabel;
    private CoefficientsTable mCoefficientsTable;
    private CoefficientsTableModel mCoefficientsTableModel;
    private JScrollPane mTableScrollPane;
    JLabel mTotalCoefficientsLabel = new JLabel();
    private JCheckBox mEstimatePowerOfTestingCheck;
    private SpssButtonGroup mEstimatePowerOfTestingRBGroup;
    private JRadioButton mBonferroniRadio;
    private JRadioButton mSidakRadio;
    private JRadioButton mLSDRadio;
    private JLabel mTestDirectionLabel;
    private JLabel mAdjustSignificanceLabel;

    public PowerAnalysisAnovaContrastSubDlg(BaseProcedureDialog baseProcedureDialog, String string, int n) {
        super(baseProcedureDialog, string, true);
        this.mContrastCoefficientsList = this.getDefaultCoefficients(n);
        this.myInit();
        this.setDefaults();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
        this.pack();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_power_anova_contrast";
    }

    @Override
    public void processTableChange() {
        this.updateTotalsLabel();
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void processInvalidCellValue(int n, int n2) {
    }

    @Override
    public void processSelectionChange() {
        this.updateTotalsLabel();
    }

    public ArrayList<String> getDefaultCoefficients(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(new String());
        }
        return arrayList;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        ArrayList arrayList = (ArrayList)dialogDataModel.getObject(COEFFICIENTS_TABLE_KEY);
        if (arrayList != null && arrayList.size() == this.mCoefficientsTable.getRowCount()) {
            this.mCoefficientsTable.setCoefficients(arrayList);
        }
        this.enableControls();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        if (this.mCoefficientsTable != null) {
            ArrayList<String> arrayList = ((CoefficientsTableModel)this.mCoefficientsTable.getModel()).getRowDatas();
            dialogDataModel.putObject(COEFFICIENTS_TABLE_KEY, arrayList);
        }
        return super.saveState(dialogDataModel);
    }

    public static void clearCoefficientsTable(DialogDataModel dialogDataModel) {
        dialogDataModel.putObject(COEFFICIENTS_TABLE_KEY, null);
    }

    public static boolean modelChangeRequiresReselections(DialogDataModel dialogDataModel) {
        Boolean bl = dialogDataModel.getBoolean(TEST_WITH_LINEAR_CONTRAST);
        ArrayList arrayList = (ArrayList)dialogDataModel.getObject(COEFFICIENTS_TABLE_KEY);
        return bl != null && bl != false && (arrayList == null || arrayList.size() == 0);
    }

    public static String getSubDialogSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    public static String getCoefficientsSyntax(DialogDataModel dialogDataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    static String getAdjustSignificanceLevelBySyntax(DialogDataModel dialogDataModel) {
        String string = "";
        return string;
    }

    protected void myInit() {
        this.myInitVars();
        this.enableControls();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    protected void myInitVars() {
        this.mTestWithLinearContrastCheck = new JCheckBox(new ToggleButtonAction(this, TEST_WITH_LINEAR_CONTRAST));
        this.mTestWithLinearContrastCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PowerAnalysisAnovaContrastSubDlg.this.enableControls();
            }
        });
        this.mTestDirectionLabel = new JLabel(this.getResString("IDS_POWER_ANALYSIS_COMMON_TEST_DIRECTION_LABEL"));
        this.mDirectionalRadio = new JRadioButton(new ToggleButtonAction(this, DIRECTIONAL_RADIO));
        this.mNonDirectionalRadio = new JRadioButton(new ToggleButtonAction(this, NONDIRECTIONAL_RADIO));
        this.mTestDirectionRBGroup = new SpssButtonGroup();
        this.mTestDirectionRBGroup.add(this.mDirectionalRadio);
        this.mTestDirectionRBGroup.add(this.mNonDirectionalRadio);
        this.mCoefficientsTableModel = new CoefficientsTableModel(this, this.getResString("IDS_POWER_ANALYSIS_ANOVA_CONTRAST_VALUES"), this.mContrastCoefficientsList);
        this.mCoefficientsTableLabel = new JLabel(this.getResString("IDS_POWER_ANALYSIS_ANOVA_TABLE_LABEL"));
        this.mCoefficientsTable = new CoefficientsTable(this.mCoefficientsTableModel, this);
        this.mTableScrollPane = new JScrollPane(this.mCoefficientsTable);
        this.mTableScrollPane.setPreferredSize(new Dimension(125, 125));
        this.mEstimatePowerOfTestingCheck = new JCheckBox(new ToggleButtonAction(this, POWER_ANALYSIS_ANOVA_CONTRAST_ESTIMATE_POWER_CHECK));
        this.mEstimatePowerOfTestingCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PowerAnalysisAnovaContrastSubDlg.this.enableControls();
            }
        });
        this.mAdjustSignificanceLabel = new JLabel(this.getResString("IDS_POWER_ANALYSIS_ANOVA_CONTRAST_ADJUST_SIGNIFICANCE_LABEL"));
        this.mBonferroniRadio = new JRadioButton(new ToggleButtonAction(this, BONFERRONI_RADIO));
        this.mSidakRadio = new JRadioButton(new ToggleButtonAction(this, SIDAK_RADIO));
        this.mLSDRadio = new JRadioButton(new ToggleButtonAction(this, LDS_RADIO));
        this.mEstimatePowerOfTestingRBGroup = new SpssButtonGroup();
        this.mEstimatePowerOfTestingRBGroup.add(this.mBonferroniRadio);
        this.mEstimatePowerOfTestingRBGroup.add(this.mSidakRadio);
        this.mEstimatePowerOfTestingRBGroup.add(this.mLSDRadio);
    }

    private void enableControls() {
        boolean bl = this.mTestWithLinearContrastCheck.isSelected();
        this.mTestDirectionLabel.setEnabled(bl);
        this.mDirectionalRadio.setEnabled(bl);
        this.mNonDirectionalRadio.setEnabled(bl);
        this.mCoefficientsTableLabel.setEnabled(bl);
        this.mTableScrollPane.setEnabled(bl);
        this.mCoefficientsTable.setEnabled(bl);
        this.mTotalCoefficientsLabel.setEnabled(bl);
        bl = this.mEstimatePowerOfTestingCheck.isSelected();
        this.mAdjustSignificanceLabel.setEnabled(bl);
        this.mBonferroniRadio.setEnabled(bl);
        this.mSidakRadio.setEnabled(bl);
        this.mLSDRadio.setEnabled(bl);
        this.enableContinue(this.canEnableContinue());
    }

    private void setDefaults() {
        this.mTestWithLinearContrastCheck.setSelected(false);
        this.mNonDirectionalRadio.setSelected(true);
        this.mEstimatePowerOfTestingCheck.setSelected(false);
        this.mBonferroniRadio.setSelected(true);
        this.updateTotalsLabel();
    }

    double calculateCoefficientsTotal() {
        double d = 0.0;
        boolean bl = true;
        for (int i = 0; i < this.mCoefficientsTable.getRowCount(); ++i) {
            String string = this.mCoefficientsTable.getRowDataAt(i);
            if (string == null || string.trim().length() <= 0) continue;
            Double d2 = Double.parseDouble(string);
            d += d2.doubleValue();
            bl = false;
        }
        if (d >= 0.0 && d < 1.0E-11) {
            d = 0.0;
        }
        return bl ? -1.0 : d;
    }

    public void updateTotalsLabel() {
        double d = this.calculateCoefficientsTotal();
        String string = MessageFormat.format(this.getResString("IDS_POWER_ANALYSIS_ANOVA_CONTRAST_COEFFICIENT_TOTAL"), d != -1.0 ? Double.valueOf(d) : this.getResString("IDS_POWER_ANALYSIS_ANOVA_CONTRAST_COEFFICIENT_TOTAL_WARNING"));
        this.mTotalCoefficientsLabel.setText(string);
    }

    private void setupPanel(JPanel jPanel) {
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(n / 2, 0, n / 2, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n2 = 23;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel2, this.createContrastTestPanel(), gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel2, this.createPairwiseDifferencePanel(), gridBagConstraints, 1, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel2, new JPanel(), gridBagConstraints, 2, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n2, insets2);
    }

    private JPanel createContrastTestPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_POWER_ANALYSIS_ANOVA_CONTRAST_CONTRAST_TEST_GRPBOX")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mTestWithLinearContrastCheck, gridBagConstraints, 0, 0, 1, 1, n, BASE_INSETS);
        DialogUtil.addUsingGBL(jPanel, this.mTestDirectionLabel, gridBagConstraints, 0, 1, 1, 1, n, LEVEL_ONE__INSETS);
        DialogUtil.addUsingGBL(jPanel, this.mNonDirectionalRadio, gridBagConstraints, 0, 2, 1, 1, n, LEVEL_TWO_INSETS);
        DialogUtil.addUsingGBL(jPanel, this.mDirectionalRadio, gridBagConstraints, 0, 3, 1, 1, n, LEVEL_TWO_INSETS);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mCoefficientsTableLabel, gridBagConstraints, 0, 4, 1, 1, n, LEVEL_ONE__INSETS);
        DialogUtil.addUsingGBL(jPanel, this.mTableScrollPane, gridBagConstraints, 0, 5, 1, 1, n, LEVEL_TWO_INSETS);
        DialogUtil.addUsingGBL(jPanel, this.mTotalCoefficientsLabel, gridBagConstraints, 0, 6, 1, 1, n, LEVEL_ONE__INSETS);
        return jPanel;
    }

    private JPanel createPairwiseDifferencePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_POWER_ANALYSIS_ANOVA_CONTRAST_PAIRWISE_GRPBOX")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mEstimatePowerOfTestingCheck, gridBagConstraints, 0, 0, 1, 1, n, BASE_INSETS);
        DialogUtil.addUsingGBL(jPanel, this.mAdjustSignificanceLabel, gridBagConstraints, 0, 1, 1, 1, n, LEVEL_ONE__INSETS);
        DialogUtil.addUsingGBL(jPanel, this.mBonferroniRadio, gridBagConstraints, 0, 2, 1, 1, n, LEVEL_TWO_INSETS);
        DialogUtil.addUsingGBL(jPanel, this.mSidakRadio, gridBagConstraints, 0, 3, 1, 1, n, LEVEL_TWO_INSETS);
        DialogUtil.addUsingGBL(jPanel, this.mLSDRadio, gridBagConstraints, 0, 4, 1, 1, n, LEVEL_TWO_INSETS);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mTestWithLinearContrastCheck);
        vector.add(this.mNonDirectionalRadio);
        vector.add(this.mDirectionalRadio);
        vector.add(this.mCoefficientsTable);
        vector.add(this.mEstimatePowerOfTestingCheck);
        vector.add(this.mBonferroniRadio);
        vector.add(this.mSidakRadio);
        vector.add(this.mLSDRadio);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    public boolean isFullCoeficientsTable() {
        boolean bl = true;
        for (int i = 0; i < this.mCoefficientsTable.getRowCount(); ++i) {
            String string = this.mCoefficientsTable.getRowDataAt(i);
            if (string != null && string.trim().length() != 0) continue;
            bl = false;
        }
        return bl;
    }

    public boolean areAllTableEntriesZero() {
        boolean bl = true;
        for (int i = 0; i < this.mCoefficientsTable.getRowCount(); ++i) {
            Double d;
            String string = this.mCoefficientsTable.getRowDataAt(i);
            if (string == null || string.trim().length() <= 0 || (d = Double.valueOf(Double.parseDouble(string))) == 0.0) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean canEnableContinue() {
        return true;
    }

    @Override
    public boolean continuePressed() {
        double d = this.calculateCoefficientsTotal();
        boolean bl = this.isFullCoeficientsTable();
        boolean bl2 = this.areAllTableEntriesZero();
        boolean bl3 = false;
        if (this.mTestWithLinearContrastCheck.isSelected()) {
            if (d != 0.0 || !bl) {
                SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), this.getResString("IDS_POWER_ANALYSIS_ANOVA_CONTRAST_COEFFICIENT_TOTAL_ERROR"), "");
                this.mCoefficientsTable.changeSelection(0, 0, false, false);
                this.mCoefficientsTable.requestFocusInWindow();
                bl3 = true;
            } else if (bl && bl2) {
                SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), this.getResString("IDS_POWER_ANALYSIS_ANOVA_CONTRAST_COEFFICIENT_ALL_ZERO_WARNING"), "");
                this.mCoefficientsTable.changeSelection(0, 0, false, false);
                this.mCoefficientsTable.requestFocusInWindow();
                bl3 = true;
            }
        }
        return super.continuePressed() && !bl3;
    }

    public boolean isValidContrastModel(DialogDataModel dialogDataModel) {
        ArrayList arrayList = (ArrayList)dialogDataModel.getObject(COEFFICIENTS_TABLE_KEY);
        if (arrayList != null && arrayList.size() == this.mCoefficientsTable.getRowCount()) {
            this.mCoefficientsTable.setCoefficients(arrayList);
        }
        return true;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }
}

