/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.power_analysis.anova;

import com.spss.java_client.ui.dialogs.base.analyze.power_analysis.anova.TableCallback;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.table.DefaultTableModel;

public class GroupTableModel
extends DefaultTableModel {
    private TableCallback mTableCallback;
    private String mGroupSizeLabel;
    private String mGroupMeansLabel;
    ArrayList<String> mTableColNames = new ArrayList();
    public ArrayList<RowData> mRowData = new ArrayList();
    public static final int CHECKBOCK_COL = 0;
    public static final int GROUP_SIZE_COL = 1;
    public static final int GROUP_MEANS_COL = 2;

    public GroupTableModel(TableCallback tableCallback, String string, String string2) {
        this.mTableCallback = tableCallback;
        this.mGroupSizeLabel = string;
        this.mGroupMeansLabel = string2;
        this.setDefaultRowDatas();
        this.initTableColumnNames();
    }

    public void setDefaultRowDatas() {
        this.mRowData = new ArrayList();
        this.mRowData.add(new RowData("", null));
        this.mRowData.add(new RowData("", null));
        this.fireTableDataChanged();
    }

    protected String[] createDefaultColumnNames() {
        if (this.mTableColNames == null) {
            this.initTableColumnNames();
        }
        return this.mTableColNames.toArray(new String[this.mTableColNames.size()]);
    }

    protected RowData createDefaultEntry() {
        RowData rowData = new RowData("", "");
        return rowData;
    }

    private void initTableColumnNames() {
        this.mTableColNames = new ArrayList();
        this.mTableColNames.add("");
        this.mTableColNames.add(this.mGroupSizeLabel);
        this.mTableColNames.add(this.mGroupMeansLabel);
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return n == 0 ? Boolean.class : String.class;
    }

    @Override
    public int getRowCount() {
        return this.mRowData != null ? this.mRowData.size() : 0;
    }

    @Override
    public String getColumnName(int n) {
        return this.mTableColNames.get(n);
    }

    public ArrayList<RowData> getRowDatas() {
        return this.mRowData;
    }

    public Integer[] getCheckedRows() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.mRowData.size(); ++i) {
            if (!this.mRowData.get(i).isChecked()) continue;
            arrayList.add(i);
        }
        return arrayList.toArray(new Integer[arrayList.size()]);
    }

    public void addNewEntry() {
        this.insertNewEntryAt(this.mRowData.size());
    }

    public void insertNewEntryAt(int n) {
        this.mRowData.add(n, this.createDefaultEntry());
        this.fireTableRowsInserted(n, n);
    }

    public void insertNewEntriesAt(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.mRowData.add(n + i, this.createDefaultEntry());
        }
        this.fireTableRowsInserted(n, n + n2 - 1);
    }

    public boolean removeGroupRow(int n) {
        if (n >= 0 && n < this.mRowData.size()) {
            this.mRowData.remove(n);
            this.fireTableRowsDeleted(n, n);
        }
        this.forceAtLeastTwoRows();
        return true;
    }

    public void removeGroupRows(Integer[] integerArray) {
        int n = this.mRowData.size();
        Arrays.sort((Object[])integerArray);
        for (int i = integerArray.length - 1; i >= 0; --i) {
            if (this.removeGroupRow(integerArray[i])) continue;
            return;
        }
        this.forceAtLeastTwoRows();
        this.fireTableDataChanged();
    }

    private void forceAtLeastTwoRows() {
        while (this.mRowData.size() < 2) {
            this.addNewEntry();
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        boolean bl = false;
        RowData rowData = this.getRowDataAt(n);
        if (rowData != null) {
            if (n2 == 0) {
                rowData.setIsChecked((Boolean)object);
                bl = true;
            } else if (n2 == 1) {
                if (this.testInteger((String)object)) {
                    bl = rowData.setGroupSizeValue((String)object);
                } else {
                    this.mTableCallback.processInvalidCellValue(n, n2);
                }
            } else if (n2 == 2) {
                bl = rowData.setGroupMeansValue((String)object);
            }
            this.fireTableCellUpdated(n, n2);
        }
        if (bl) {
            this.mTableCallback.processTableChange();
        }
    }

    private boolean testInteger(String string) {
        boolean bl = true;
        try {
            int n = Integer.parseInt(string);
            if (n <= 1 || n > Integer.MAX_VALUE) {
                bl = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = "";
        RowData rowData = this.getRowDataAt(n);
        if (rowData != null) {
            switch (n2) {
                case 0: {
                    object = rowData.isChecked();
                    break;
                }
                case 1: {
                    object = rowData.getGroupSizeValue();
                    break;
                }
                case 2: {
                    object = rowData.getGroupMeansValue();
                }
            }
        }
        return object;
    }

    public String getGroupSizeValue(int n) {
        String string = "";
        RowData rowData = this.getRowDataAt(n);
        if (rowData != null) {
            string = rowData.getGroupSizeValue();
        }
        return string;
    }

    public void setGroupSizeValue(int n, String string) {
        RowData rowData = this.getRowDataAt(n);
        rowData.setGroupSizeValue(string);
        this.fireTableRowsUpdated(n, n);
    }

    public String getGroupMeansValue(int n) {
        String string = "";
        RowData rowData = this.getRowDataAt(n);
        if (rowData != null) {
            string = rowData.getGroupMeansValue();
        }
        return string;
    }

    public void setGroupMeansValue(int n, String string) {
        RowData rowData = this.getRowDataAt(n);
        rowData.setGroupMeansValue(string);
        this.fireTableRowsUpdated(n, n);
    }

    public RowData getRowDataAt(int n) {
        RowData rowData = null;
        if (this.mRowData != null && n >= 0 && n < this.mRowData.size()) {
            rowData = this.mRowData.get(n);
        }
        return rowData;
    }

    public void setRowDatas(ArrayList<RowData> arrayList) {
        if (this.mRowData != null) {
            this.mRowData = arrayList;
        }
        this.fireTableDataChanged();
    }

    public static class RowData {
        private String mGroupSizeValue = "";
        private String mGroupMeansValue = "";
        private boolean mIsChecked;

        public RowData(String string, String string2) {
            this.mGroupSizeValue = string;
            this.mGroupMeansValue = string2;
            this.mIsChecked = false;
        }

        public String getGroupSizeValue() {
            return this.mGroupSizeValue;
        }

        public int getGroupSizeAsInt() {
            return Integer.parseInt(this.mGroupSizeValue);
        }

        public String getGroupMeansValue() {
            return this.mGroupMeansValue;
        }

        public boolean isChecked() {
            return this.mIsChecked;
        }

        public boolean setGroupSizeValue(String string) {
            boolean bl = false;
            if (!string.trim().equalsIgnoreCase(this.mGroupSizeValue)) {
                this.mGroupSizeValue = string;
                bl = true;
            }
            return bl;
        }

        public boolean setGroupMeansValue(String string) {
            boolean bl = false;
            if (!string.trim().equalsIgnoreCase(this.mGroupMeansValue)) {
                this.mGroupMeansValue = string;
                bl = true;
            }
            return bl;
        }

        public void setIsChecked(boolean bl) {
            this.mIsChecked = bl;
        }
    }
}

