/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.power_analysis.anova;

import com.spss.java_client.ui.dialogs.base.analyze.power_analysis.GroupTableInfo;
import com.spss.java_client.ui.dialogs.base.analyze.power_analysis.anova.GroupTableModel;
import com.spss.java_client.ui.dialogs.base.analyze.power_analysis.anova.TableCallback;
import com.spss.java_client.ui.dialogs.common.SpssFocusCellRenderer;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public class GroupTable
extends JTable {
    Border mEmptyBorder = BorderFactory.createEmptyBorder();
    Border mHighLightBorder = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
    private GroupTableModel mGroupTableModel;
    private TableCallback mTableCallback;

    public GroupTable(GroupTableModel groupTableModel, TableCallback tableCallback) {
        super(groupTableModel);
        this.mGroupTableModel = groupTableModel;
        this.mTableCallback = tableCallback;
        this.initTable();
        this.updateListeners();
        this.setupColumns();
        this.setupHeader();
    }

    void initTable() {
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.setSelectionMode(0);
        this.setRowSelectionAllowed(true);
        this.setCellSelectionEnabled(true);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        };
        this.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        this.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        this.getActionMap().put("tabIn", abstractAction2);
        this.getActionMap().put("tabOut", abstractAction);
        this.setShowGrid(true);
    }

    void setupHeader() {
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setResizingAllowed(true);
        jTableHeader.setDefaultRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                jLabel.setHorizontalAlignment(0);
                jLabel.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                jLabel.setBackground(jTable.getTableHeader().getBackground());
                jLabel.setForeground(jTable.getTableHeader().getForeground());
                jLabel.setFont(jTable.getTableHeader().getFont().deriveFont(1));
                return jLabel;
            }
        });
    }

    private void updateListeners() {
        this.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                int n;
                if (tableModelEvent.getType() == 1 && (n = tableModelEvent.getFirstRow()) >= 0 && n < GroupTable.this.getModel().getRowCount()) {
                    GroupTable.this.selectRow(n);
                }
            }
        });
    }

    private void setupColumns() {
        SpssFocusCellRenderer spssFocusCellRenderer = new SpssFocusCellRenderer();
        spssFocusCellRenderer.setOpaque(true);
        this.setDefaultRenderer(Object.class, spssFocusCellRenderer);
        TableColumn tableColumn = this.columnModel.getColumn(0);
        tableColumn.setCellRenderer(new CheckBoxRenderer());
        tableColumn.setWidth(40);
        tableColumn.setPreferredWidth(40);
        tableColumn.setMaxWidth(40);
        tableColumn = this.columnModel.getColumn(1);
        tableColumn.setCellEditor(new SizeValueCellEditor());
        tableColumn = this.columnModel.getColumn(2);
        tableColumn.setCellEditor(new MeanValueCellEditor());
    }

    public void resetToDefault() {
        this.mGroupTableModel.setDefaultRowDatas();
    }

    protected void addNewEntry() {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.clearSelection();
        this.mGroupTableModel.addNewEntry();
    }

    protected void doInsert(int n, int n2) {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        if (n >= 0) {
            listSelectionModel.clearSelection();
            this.mGroupTableModel.insertNewEntriesAt(n, n2);
        }
    }

    public void removeRow(int n) {
        this.mGroupTableModel.removeGroupRow(n);
    }

    public Integer[] getCheckedRows() {
        return this.mGroupTableModel.getCheckedRows();
    }

    public void removeRows(Integer[] integerArray) {
        this.mGroupTableModel.removeGroupRows(integerArray);
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        boolean bl = super.editCellAt(n, n2, eventObject);
        Component component = this.getEditorComponent();
        if (component != null && component instanceof JTextComponent) {
            ((JTextComponent)component).selectAll();
        }
        return bl;
    }

    @Override
    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        this.updateListeners();
    }

    protected void initSelectionListener() {
        if (this.getSelectionModel() != null) {
            this.getSelectionModel().addListSelectionListener(this);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.mTableCallback.processSelectionChange();
        this.repaint();
    }

    private void selectRow(final int n) {
        this.setColumnSelectionInterval(0, this.getColumnCount() - 1);
        this.setRowSelectionInterval(n, n);
        this.getColumnModel().getSelectionModel().setAnchorSelectionIndex(-1);
        this.getColumnModel().getSelectionModel().setLeadSelectionIndex(-1);
        this.getSelectionModel().setAnchorSelectionIndex(-1);
        this.getSelectionModel().setLeadSelectionIndex(-1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GroupTable.this.getColumnModel().getSelectionModel().setAnchorSelectionIndex(0);
                GroupTable.this.getSelectionModel().setAnchorSelectionIndex(n);
                GroupTable.this.getColumnModel().getSelectionModel().setLeadSelectionIndex(0);
                GroupTable.this.getSelectionModel().setLeadSelectionIndex(n);
            }
        });
    }

    public GroupTableModel.RowData getRowDataAt(int n) {
        return this.mGroupTableModel.getRowDataAt(n);
    }

    public String getGroupText(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < this.getRowCount(); ++i) {
            String string;
            GroupTableModel.RowData rowData = this.getRowDataAt(i);
            String string2 = string = bl ? rowData.getGroupSizeValue() : rowData.getGroupMeansValue();
            if (string == null || string.trim().length() <= 0) continue;
            stringBuffer.append(string);
            if (i + 1 >= this.getRowCount()) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public int calculateGroupSizeTotal() {
        int n = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            GroupTableModel.RowData rowData = this.getRowDataAt(i);
            String string = rowData.getGroupSizeValue();
            if (string == null || string.trim().length() <= 0) continue;
            Integer n2 = Integer.parseInt(string);
            n += n2.intValue();
        }
        return n;
    }

    public double calculateSmallestProportion() {
        double d = -1.0;
        int n = this.calculateGroupSizeTotal();
        for (int i = 0; i < this.getRowCount(); ++i) {
            GroupTableModel.RowData rowData = this.getRowDataAt(i);
            String string = rowData.getGroupSizeValue();
            d = string != null && d == -1.0 ? (double)Integer.parseInt(string) / (double)n : Math.min(d, (double)Integer.parseInt(string) / (double)n);
        }
        return d;
    }

    public double calculateLargestProportion() {
        double d = -1.0;
        int n = this.calculateGroupSizeTotal();
        for (int i = 0; i < this.getRowCount(); ++i) {
            GroupTableModel.RowData rowData = this.getRowDataAt(i);
            String string = rowData.getGroupSizeValue();
            d = string != null && d == -1.0 ? (double)Integer.parseInt(string) / (double)n : Math.max(d, (double)Integer.parseInt(string) / (double)n);
        }
        return d;
    }

    public GroupTableInfo getGroupTableInfo() {
        return new GroupTableInfo(this.getRowCount(), this.calculateGroupSizeTotal(), this.calculateSmallestProportion(), this.calculateLargestProportion());
    }

    class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public CheckBoxRenderer() {
            this.setBorder(null);
            this.setLayout(new FlowLayout(1, 0, 0));
            this.setBorder(GroupTable.this.mHighLightBorder);
            this.setBorderPainted(true);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setHorizontalAlignment(0);
            this.setBorder(bl2 ? GroupTable.this.mHighLightBorder : GroupTable.this.mEmptyBorder);
            this.setSelected(object != null && (Boolean)object != false);
            return this;
        }
    }

    public static class BaseValueCellEditor
    extends DefaultCellEditor {
        public BaseValueCellEditor(ContextEnabledTextField contextEnabledTextField) {
            super((JTextField)contextEnabledTextField);
            final ContextEnabledTextField contextEnabledTextField2 = (ContextEnabledTextField)this.getComponent();
            this.setClickCountToStart(1);
            contextEnabledTextField2.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    contextEnabledTextField2.selectAll();
                }
            });
        }
    }

    public static class FloatValueCellEditor
    extends BaseValueCellEditor {
        public FloatValueCellEditor(double d, double d2, boolean bl) {
            this(d, d2, bl, false);
        }

        public FloatValueCellEditor(double d, double d2, boolean bl, boolean bl2) {
            super((ContextEnabledTextField)new FloatTextField(d, d2, 5, d == 0.0));
            FloatTextField floatTextField = (FloatTextField)this.getComponent();
            floatTextField.setIncludeMinRange(bl);
            floatTextField.setIncludeMaxRange(bl2);
        }
    }

    public static class MeanValueCellEditor
    extends BaseValueCellEditor {
        public MeanValueCellEditor() {
            super((ContextEnabledTextField)new FloatTextField(false));
            FloatTextField floatTextField = (FloatTextField)this.getComponent();
            floatTextField.setIncludeMinRange(true);
            floatTextField.setIncludeMaxRange(false);
        }
    }

    public static class SizeValueCellEditor
    extends BaseValueCellEditor {
        public SizeValueCellEditor() {
            super((ContextEnabledTextField)new IntTextField(1, Integer.MAX_VALUE, false));
            IntTextField intTextField = (IntTextField)this.getComponent();
            intTextField.setAllowMinMax(false, true);
            intTextField.setSkipValidationOnFocusLost(true);
        }
    }
}

