/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.power_analysis;

import com.spss.java_client.ui.dialogs.base.analyze.power_analysis.GroupTableInfo;
import com.spss.java_client.ui.dialogs.base.analyze.power_analysis.PlotTypeEnum;

public class PowerAnalysisPlotRangeMaster {
    public static MinMaxInfo getSampleLowerUpperBounds(PlotTypeEnum plotTypeEnum, GroupTableInfo groupTableInfo) {
        MinMaxInfo minMaxInfo = null;
        switch (plotTypeEnum) {
            case ANOVA: {
                double d = 2.0 / groupTableInfo.getSmallestProportion();
                Double d2 = Math.max((double)(groupTableInfo.getNumGoups() * 2), d);
                d2 = (int)(d2 + 0.5);
                Double d3 = Math.min(Integer.MAX_VALUE, (int)(5000.0 / groupTableInfo.getLargestProportion() + 0.5));
                minMaxInfo = new MinMaxInfo(d2, true, d3, true);
                break;
            }
            case ONE_TTEST: 
            case RELATED_TTEST: {
                minMaxInfo = new MinMaxInfo(1.0, false, 5000.0, false);
                break;
            }
            case INDEPENDENT_TTEST: {
                minMaxInfo = new MinMaxInfo(0.2, true, 5.0, true);
            }
        }
        return minMaxInfo;
    }

    public static MinMaxInfo getEffectsLowerUpperBounds(PlotTypeEnum plotTypeEnum, boolean bl, boolean bl2) {
        MinMaxInfo minMaxInfo = null;
        switch (plotTypeEnum) {
            case ANOVA: {
                minMaxInfo = new MinMaxInfo(0.0, false, Double.MAX_VALUE, true);
                break;
            }
            case ONE_TTEST: 
            case RELATED_TTEST: {
                double d = bl ? -5.0 : 0.0;
                minMaxInfo = new MinMaxInfo(d, true, 5.0, true);
                break;
            }
            case INDEPENDENT_TTEST: {
                double d = bl2 && bl ? -5.0 : 0.0;
                double d2 = bl2 ? 5.0 : 5000.0;
                minMaxInfo = new MinMaxInfo(d, true, d2, true);
            }
        }
        return minMaxInfo;
    }

    public static MinMaxInfo get3DVerticalHorizontalRotationDegrees(boolean bl) {
        MinMaxInfo minMaxInfo = bl ? new MinMaxInfo(0.0, true, 359.0, true, new Double(10.0)) : new MinMaxInfo(0.0, true, 359.0, true, new Double(325.0));
        return minMaxInfo;
    }

    static class MinMaxInfo {
        public double mMinValue;
        boolean mMinInclusive = false;
        public double mMaxValue;
        boolean mMaxInclusive = false;
        Double mDefaultValue;

        MinMaxInfo(double d, double d2) {
            this(d, false, d2, false, null);
        }

        MinMaxInfo(double d, boolean bl, double d2, boolean bl2) {
            this(d, bl, d2, bl2, null);
        }

        MinMaxInfo(double d, boolean bl, double d2, boolean bl2, Double d3) {
            this.mMinValue = d;
            this.mMinInclusive = bl;
            this.mMaxValue = d2;
            this.mMaxInclusive = bl2;
            this.mDefaultValue = d3;
        }
    }
}

